/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.platform;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.CompanionObjectMapping;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.functions.FunctionClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.platform.PlatformToKotlinClassMap;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001<B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u001c\u0010\u0019\u001a\u00020\u00112\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\u001c\u001a\u00020\u000eH\u0002J\u001c\u0010\u0019\u001a\u00020\u00112\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u0014\u0010\u001d\u001a\u00020\u00062\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0002J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 J\u000e\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020 J,\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020 2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0'2\u0006\u0010(\u001a\u00020)H\u0002J\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u000eJ\u000e\u0010-\u001a\u00020+2\u0006\u0010!\u001a\u00020 J\u000e\u0010-\u001a\u00020+2\u0006\u0010.\u001a\u00020/J\u000e\u00100\u001a\u00020+2\u0006\u0010#\u001a\u00020 J\u000e\u00100\u001a\u00020+2\u0006\u0010.\u001a\u00020/J\u0010\u00101\u001a\u0004\u0018\u00010\u00062\u0006\u0010,\u001a\u00020\u000eJ\u0018\u00101\u001a\u0004\u0018\u00010 2\u0006\u0010,\u001a\u00020\u000e2\u0006\u00102\u001a\u000203J\u0010\u00104\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001c\u001a\u00020\u0005J\u0016\u00105\u001a\b\u0012\u0004\u0012\u00020 062\u0006\u00107\u001a\u00020 H\u0016J\u001c\u00105\u001a\b\u0012\u0004\u0012\u00020 062\u0006\u0010,\u001a\u00020\u000e2\u0006\u00102\u001a\u000203J!\u00108\u001a\u00020\n\"\u0006\b\u0000\u00109\u0018\u00012\u0006\u0010:\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\u000eH\u0082\bR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/jetbrains/kotlin/platform/JavaToKotlinClassMap;", "Lorg/jetbrains/kotlin/platform/PlatformToKotlinClassMap;", "()V", "javaToKotlin", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "Lorg/jetbrains/kotlin/name/ClassId;", "kotlinToJava", "mutabilityMappings", "", "Lorg/jetbrains/kotlin/platform/JavaToKotlinClassMap$PlatformMutabilityMapping;", "getMutabilityMappings", "()Ljava/util/List;", "mutableToReadOnly", "Lorg/jetbrains/kotlin/name/FqName;", "readOnlyToMutable", "add", "", "javaClassId", "kotlinClassId", "addJavaToKotlin", "addKotlinToJava", "kotlinFqNameUnsafe", "addMapping", "platformMutabilityMapping", "addTopLevel", "javaClass", "Ljava/lang/Class;", "kotlinFqName", "classId", "clazz", "convertMutableToReadOnly", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "mutable", "convertReadOnlyToMutable", "readOnly", "convertToOppositeMutability", "descriptor", "map", "", "mutabilityKindName", "", "isJavaPlatformClass", "", "fqName", "isMutable", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "isReadOnly", "mapJavaToKotlin", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "mapKotlinToJava", "mapPlatformClass", "", "classDescriptor", "mutabilityMapping", "T", "kotlinReadOnly", "kotlinMutable", "PlatformMutabilityMapping", "kotlin-compiler"})
public final class JavaToKotlinClassMap
implements PlatformToKotlinClassMap {
    private static final HashMap<FqNameUnsafe, ClassId> javaToKotlin;
    private static final HashMap<FqNameUnsafe, ClassId> kotlinToJava;
    private static final HashMap<FqNameUnsafe, FqName> mutableToReadOnly;
    private static final HashMap<FqNameUnsafe, FqName> readOnlyToMutable;
    @NotNull
    private static final List<PlatformMutabilityMapping> mutabilityMappings;
    public static final JavaToKotlinClassMap INSTANCE;

    @NotNull
    public final List<PlatformMutabilityMapping> getMutabilityMappings() {
        return mutabilityMappings;
    }

    @Nullable
    public final ClassId mapJavaToKotlin(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        return javaToKotlin.get(fqName2.toUnsafe());
    }

    @Nullable
    public final ClassDescriptor mapJavaToKotlin(@NotNull FqName fqName2, @NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
        ClassId kotlinClassId = this.mapJavaToKotlin(fqName2);
        return kotlinClassId != null ? builtIns.getBuiltInClassByFqName(kotlinClassId.asSingleFqName()) : null;
    }

    @Nullable
    public final ClassId mapKotlinToJava(@NotNull FqNameUnsafe kotlinFqName) {
        Intrinsics.checkParameterIsNotNull(kotlinFqName, "kotlinFqName");
        return kotlinToJava.get(kotlinFqName);
    }

    /*
     * WARNING - void declaration
     */
    private final void addMapping(PlatformMutabilityMapping platformMutabilityMapping) {
        void mutableClassId;
        void readOnlyClassId;
        void javaClassId;
        PlatformMutabilityMapping platformMutabilityMapping2 = platformMutabilityMapping;
        ClassId classId = platformMutabilityMapping2.component1();
        ClassId classId2 = platformMutabilityMapping2.component2();
        ClassId classId3 = platformMutabilityMapping2.component3();
        platformMutabilityMapping2 = null;
        this.add((ClassId)javaClassId, (ClassId)readOnlyClassId);
        FqName fqName2 = mutableClassId.asSingleFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "mutableClassId.asSingleFqName()");
        this.addKotlinToJava(fqName2, (ClassId)javaClassId);
        FqName readOnlyFqName = readOnlyClassId.asSingleFqName();
        FqName mutableFqName = mutableClassId.asSingleFqName();
        mutableToReadOnly.put(mutableClassId.asSingleFqName().toUnsafe(), readOnlyFqName);
        readOnlyToMutable.put(readOnlyFqName.toUnsafe(), mutableFqName);
    }

    private final void add(ClassId javaClassId, ClassId kotlinClassId) {
        this.addJavaToKotlin(javaClassId, kotlinClassId);
        FqName fqName2 = kotlinClassId.asSingleFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "kotlinClassId.asSingleFqName()");
        this.addKotlinToJava(fqName2, javaClassId);
    }

    private final void addTopLevel(Class<?> javaClass, FqNameUnsafe kotlinFqName) {
        FqName fqName2 = kotlinFqName.toSafe();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "kotlinFqName.toSafe()");
        this.addTopLevel(javaClass, fqName2);
    }

    private final void addTopLevel(Class<?> javaClass, FqName kotlinFqName) {
        ClassId classId = this.classId(javaClass);
        ClassId classId2 = ClassId.topLevel(kotlinFqName);
        Intrinsics.checkExpressionValueIsNotNull(classId2, "ClassId.topLevel(kotlinFqName)");
        this.add(classId, classId2);
    }

    private final void addJavaToKotlin(ClassId javaClassId, ClassId kotlinClassId) {
        javaToKotlin.put(javaClassId.asSingleFqName().toUnsafe(), kotlinClassId);
    }

    private final void addKotlinToJava(FqName kotlinFqNameUnsafe, ClassId javaClassId) {
        kotlinToJava.put(kotlinFqNameUnsafe.toUnsafe(), javaClassId);
    }

    public final boolean isJavaPlatformClass(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        return this.mapJavaToKotlin(fqName2) != null;
    }

    @NotNull
    public final Collection<ClassDescriptor> mapPlatformClass(@NotNull FqName fqName2, @NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
        ClassDescriptor classDescriptor = this.mapJavaToKotlin(fqName2, builtIns);
        if (classDescriptor == null) {
            return SetsKt.emptySet();
        }
        ClassDescriptor kotlinAnalog = classDescriptor;
        FqName fqName3 = readOnlyToMutable.get(DescriptorUtilsKt.getFqNameUnsafe(kotlinAnalog));
        if (fqName3 == null) {
            return SetsKt.setOf(kotlinAnalog);
        }
        FqName kotlinMutableAnalogFqName = fqName3;
        List<ClassDescriptor> list2 = Arrays.asList(kotlinAnalog, builtIns.getBuiltInClassByFqName(kotlinMutableAnalogFqName));
        Intrinsics.checkExpressionValueIsNotNull(list2, "Arrays.asList(kotlinAnal\u2026tlinMutableAnalogFqName))");
        return list2;
    }

    @Override
    @NotNull
    public Collection<ClassDescriptor> mapPlatformClass(@NotNull ClassDescriptor classDescriptor) {
        Collection<ClassDescriptor> collection;
        Intrinsics.checkParameterIsNotNull(classDescriptor, "classDescriptor");
        FqNameUnsafe className2 = DescriptorUtils.getFqName(classDescriptor);
        if (className2.isSafe()) {
            FqName fqName2 = className2.toSafe();
            Intrinsics.checkExpressionValueIsNotNull(fqName2, "className.toSafe()");
            collection = this.mapPlatformClass(fqName2, DescriptorUtilsKt.getBuiltIns(classDescriptor));
        } else {
            collection = SetsKt.emptySet();
        }
        return collection;
    }

    public final boolean isMutable(@NotNull ClassDescriptor mutable) {
        Intrinsics.checkParameterIsNotNull(mutable, "mutable");
        return mutableToReadOnly.containsKey(DescriptorUtils.getFqName(mutable));
    }

    public final boolean isMutable(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(type2);
        return classDescriptor != null && this.isMutable(classDescriptor);
    }

    public final boolean isReadOnly(@NotNull ClassDescriptor readOnly) {
        Intrinsics.checkParameterIsNotNull(readOnly, "readOnly");
        return readOnlyToMutable.containsKey(DescriptorUtils.getFqName(readOnly));
    }

    public final boolean isReadOnly(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(type2);
        return classDescriptor != null && this.isReadOnly(classDescriptor);
    }

    @NotNull
    public final ClassDescriptor convertMutableToReadOnly(@NotNull ClassDescriptor mutable) {
        Intrinsics.checkParameterIsNotNull(mutable, "mutable");
        return this.convertToOppositeMutability(mutable, (Map<FqNameUnsafe, FqName>)mutableToReadOnly, "mutable");
    }

    @NotNull
    public final ClassDescriptor convertReadOnlyToMutable(@NotNull ClassDescriptor readOnly) {
        Intrinsics.checkParameterIsNotNull(readOnly, "readOnly");
        return this.convertToOppositeMutability(readOnly, (Map<FqNameUnsafe, FqName>)readOnlyToMutable, "read-only");
    }

    private final ClassId classId(Class<?> clazz) {
        ClassId classId;
        boolean bl;
        boolean bl2 = bl = !clazz.isPrimitive() && !clazz.isArray();
        if (_Assertions.ENABLED && !bl) {
            String string = "Invalid class: " + clazz;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Class<?> outer = clazz.getDeclaringClass();
        if (outer == null) {
            ClassId classId2 = ClassId.topLevel(new FqName(clazz.getCanonicalName()));
            classId = classId2;
            Intrinsics.checkExpressionValueIsNotNull(classId2, "ClassId.topLevel(FqName(clazz.canonicalName))");
        } else {
            ClassId classId3 = this.classId(outer).createNestedClassId(Name.identifier(clazz.getSimpleName()));
            classId = classId3;
            Intrinsics.checkExpressionValueIsNotNull(classId3, "classId(outer).createNes\u2026tifier(clazz.simpleName))");
        }
        return classId;
    }

    private final ClassDescriptor convertToOppositeMutability(ClassDescriptor descriptor2, Map<FqNameUnsafe, FqName> map2, String mutabilityKindName) {
        FqName fqName2 = map2.get(DescriptorUtils.getFqName(descriptor2));
        if (fqName2 == null) {
            throw (Throwable)new IllegalArgumentException("Given class " + descriptor2 + " is not a " + mutabilityKindName + " collection");
        }
        FqName oppositeClassFqName = fqName2;
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getBuiltIns(descriptor2).getBuiltInClassByFqName(oppositeClassFqName);
        Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "descriptor.builtIns.getB\u2026Name(oppositeClassFqName)");
        return classDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    private JavaToKotlinClassMap() {
        JavaToKotlinClassMap this_$iv;
        PlatformMutabilityMapping platformMutabilityMapping;
        JvmPrimitiveType[] kotlinMutable$iv;
        ClassId kotlinReadOnly$iv;
        INSTANCE = this;
        javaToKotlin = new HashMap();
        kotlinToJava = new HashMap();
        mutableToReadOnly = new HashMap();
        readOnlyToMutable = new HashMap();
        PlatformMutabilityMapping[] platformMutabilityMappingArray = new PlatformMutabilityMapping[8];
        JavaToKotlinClassMap javaToKotlinClassMap = this;
        ClassId classId = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.iterable);
        Intrinsics.checkExpressionValueIsNotNull(classId, "ClassId.topLevel(FQ_NAMES.iterable)");
        ClassId classId2 = classId;
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.mutableIterable;
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "FQ_NAMES.mutableIterable");
        FqName fqName3 = fqName2;
        int n = 0;
        PlatformMutabilityMapping[] platformMutabilityMappingArray2 = platformMutabilityMappingArray;
        PlatformMutabilityMapping[] platformMutabilityMappingArray3 = platformMutabilityMappingArray;
        FqName fqName4 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName5 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName5, "kotlinReadOnly.packageFqName");
        ClassId mutableClassId$iv = new ClassId(fqName4, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName5), false);
        platformMutabilityMappingArray2[n] = platformMutabilityMapping = new PlatformMutabilityMapping(this_$iv.classId(Iterable.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = this;
        ClassId classId3 = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.iterator);
        Intrinsics.checkExpressionValueIsNotNull(classId3, "ClassId.topLevel(FQ_NAMES.iterator)");
        kotlinReadOnly$iv = classId3;
        Intrinsics.checkExpressionValueIsNotNull(KotlinBuiltIns.FQ_NAMES.mutableIterator, "FQ_NAMES.mutableIterator");
        kotlinMutable$iv = KotlinBuiltIns.FQ_NAMES.mutableIterator;
        n = 1;
        platformMutabilityMappingArray2 = platformMutabilityMappingArray3;
        FqName fqName6 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName7 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName7, "kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName6, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName7), false);
        platformMutabilityMappingArray2[n] = platformMutabilityMapping = new PlatformMutabilityMapping(this_$iv.classId(Iterator.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = this;
        ClassId classId4 = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.collection);
        Intrinsics.checkExpressionValueIsNotNull(classId4, "ClassId.topLevel(FQ_NAMES.collection)");
        kotlinReadOnly$iv = classId4;
        FqName fqName8 = KotlinBuiltIns.FQ_NAMES.mutableCollection;
        Intrinsics.checkExpressionValueIsNotNull(fqName8, "FQ_NAMES.mutableCollection");
        kotlinMutable$iv = fqName8;
        n = 2;
        platformMutabilityMappingArray2 = platformMutabilityMappingArray3;
        FqName fqName9 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName10 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName10, "kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName9, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName10), false);
        platformMutabilityMappingArray2[n] = platformMutabilityMapping = new PlatformMutabilityMapping(this_$iv.classId(Collection.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = this;
        ClassId classId5 = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.list);
        Intrinsics.checkExpressionValueIsNotNull(classId5, "ClassId.topLevel(FQ_NAMES.list)");
        kotlinReadOnly$iv = classId5;
        FqName fqName11 = KotlinBuiltIns.FQ_NAMES.mutableList;
        Intrinsics.checkExpressionValueIsNotNull(fqName11, "FQ_NAMES.mutableList");
        kotlinMutable$iv = fqName11;
        n = 3;
        platformMutabilityMappingArray2 = platformMutabilityMappingArray3;
        FqName fqName12 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName13 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName13, "kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName12, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName13), false);
        platformMutabilityMappingArray2[n] = platformMutabilityMapping = new PlatformMutabilityMapping(this_$iv.classId(List.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = this;
        ClassId classId6 = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.set);
        Intrinsics.checkExpressionValueIsNotNull(classId6, "ClassId.topLevel(FQ_NAMES.set)");
        kotlinReadOnly$iv = classId6;
        FqName fqName14 = KotlinBuiltIns.FQ_NAMES.mutableSet;
        Intrinsics.checkExpressionValueIsNotNull(fqName14, "FQ_NAMES.mutableSet");
        kotlinMutable$iv = fqName14;
        n = 4;
        platformMutabilityMappingArray2 = platformMutabilityMappingArray3;
        FqName fqName15 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName16 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName16, "kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName15, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName16), false);
        platformMutabilityMappingArray2[n] = platformMutabilityMapping = new PlatformMutabilityMapping(this_$iv.classId(Set.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = this;
        ClassId classId7 = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.listIterator);
        Intrinsics.checkExpressionValueIsNotNull(classId7, "ClassId.topLevel(FQ_NAMES.listIterator)");
        kotlinReadOnly$iv = classId7;
        FqName fqName17 = KotlinBuiltIns.FQ_NAMES.mutableListIterator;
        Intrinsics.checkExpressionValueIsNotNull(fqName17, "FQ_NAMES.mutableListIterator");
        kotlinMutable$iv = fqName17;
        n = 5;
        platformMutabilityMappingArray2 = platformMutabilityMappingArray3;
        FqName fqName18 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName19 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName19, "kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName18, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName19), false);
        platformMutabilityMappingArray2[n] = platformMutabilityMapping = new PlatformMutabilityMapping(this_$iv.classId(ListIterator.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = this;
        ClassId classId8 = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.map);
        Intrinsics.checkExpressionValueIsNotNull(classId8, "ClassId.topLevel(FQ_NAMES.map)");
        kotlinReadOnly$iv = classId8;
        FqName fqName20 = KotlinBuiltIns.FQ_NAMES.mutableMap;
        Intrinsics.checkExpressionValueIsNotNull(fqName20, "FQ_NAMES.mutableMap");
        kotlinMutable$iv = fqName20;
        n = 6;
        platformMutabilityMappingArray2 = platformMutabilityMappingArray3;
        FqName fqName21 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName22 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName22, "kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName21, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName22), false);
        platformMutabilityMappingArray2[n] = platformMutabilityMapping = new PlatformMutabilityMapping(this_$iv.classId(Map.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = this;
        ClassId classId9 = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.map).createNestedClassId(KotlinBuiltIns.FQ_NAMES.mapEntry.shortName());
        Intrinsics.checkExpressionValueIsNotNull(classId9, "ClassId.topLevel(FQ_NAME\u2026MES.mapEntry.shortName())");
        kotlinReadOnly$iv = classId9;
        FqName fqName23 = KotlinBuiltIns.FQ_NAMES.mutableMapEntry;
        Intrinsics.checkExpressionValueIsNotNull(fqName23, "FQ_NAMES.mutableMapEntry");
        kotlinMutable$iv = fqName23;
        n = 7;
        platformMutabilityMappingArray2 = platformMutabilityMappingArray3;
        FqName fqName24 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName25 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName25, "kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName24, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName25), false);
        platformMutabilityMappingArray2[n] = platformMutabilityMapping = new PlatformMutabilityMapping(this_$iv.classId(Map.Entry.class), kotlinReadOnly$iv, mutableClassId$iv);
        mutabilityMappings = CollectionsKt.listOf(platformMutabilityMappingArray3);
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES.any;
        Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe, "FQ_NAMES.any");
        this.addTopLevel(Object.class, fqNameUnsafe);
        FqNameUnsafe fqNameUnsafe2 = KotlinBuiltIns.FQ_NAMES.string;
        Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe2, "FQ_NAMES.string");
        this.addTopLevel(String.class, fqNameUnsafe2);
        FqNameUnsafe fqNameUnsafe3 = KotlinBuiltIns.FQ_NAMES.charSequence;
        Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe3, "FQ_NAMES.charSequence");
        this.addTopLevel(CharSequence.class, fqNameUnsafe3);
        FqName fqName26 = KotlinBuiltIns.FQ_NAMES.throwable;
        Intrinsics.checkExpressionValueIsNotNull(fqName26, "FQ_NAMES.throwable");
        this.addTopLevel(Throwable.class, fqName26);
        FqNameUnsafe fqNameUnsafe4 = KotlinBuiltIns.FQ_NAMES.cloneable;
        Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe4, "FQ_NAMES.cloneable");
        this.addTopLevel(Cloneable.class, fqNameUnsafe4);
        FqNameUnsafe fqNameUnsafe5 = KotlinBuiltIns.FQ_NAMES.number;
        Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe5, "FQ_NAMES.number");
        this.addTopLevel(Number.class, fqNameUnsafe5);
        FqName fqName27 = KotlinBuiltIns.FQ_NAMES.comparable;
        Intrinsics.checkExpressionValueIsNotNull(fqName27, "FQ_NAMES.comparable");
        this.addTopLevel(Comparable.class, fqName27);
        FqNameUnsafe fqNameUnsafe6 = KotlinBuiltIns.FQ_NAMES._enum;
        Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe6, "FQ_NAMES._enum");
        this.addTopLevel(Enum.class, fqNameUnsafe6);
        FqName fqName28 = KotlinBuiltIns.FQ_NAMES.annotation;
        Intrinsics.checkExpressionValueIsNotNull(fqName28, "FQ_NAMES.annotation");
        this.addTopLevel(Annotation.class, fqName28);
        for (PlatformMutabilityMapping platformCollection : mutabilityMappings) {
            this.addMapping(platformCollection);
        }
        kotlinMutable$iv = JvmPrimitiveType.values();
        for (int i = 0; i < kotlinMutable$iv.length; ++i) {
            JvmPrimitiveType jvmType = kotlinMutable$iv[i];
            ClassId classId10 = ClassId.topLevel(jvmType.getWrapperFqName());
            Intrinsics.checkExpressionValueIsNotNull(classId10, "ClassId.topLevel(jvmType.wrapperFqName)");
            ClassId classId11 = ClassId.topLevel(KotlinBuiltIns.getPrimitiveFqName(jvmType.getPrimitiveType()));
            Intrinsics.checkExpressionValueIsNotNull(classId11, "ClassId.topLevel(KotlinB\u2026e(jvmType.primitiveType))");
            this.add(classId10, classId11);
        }
        for (ClassId classId12 : CompanionObjectMapping.INSTANCE.allClassesWithIntrinsicCompanions()) {
            ClassId classId13 = ClassId.topLevel(new FqName("kotlin.jvm.internal." + classId12.getShortClassName().asString() + "CompanionObject"));
            Intrinsics.checkExpressionValueIsNotNull(classId13, "ClassId.topLevel(FqName(\u2026g() + \"CompanionObject\"))");
            ClassId classId14 = classId12.createNestedClassId(SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT);
            Intrinsics.checkExpressionValueIsNotNull(classId14, "classId.createNestedClas\u2026AME_FOR_COMPANION_OBJECT)");
            this.add(classId13, classId14);
        }
        int classId12 = 0;
        int n2 = 22;
        if (classId12 <= n2) {
            while (true) {
                void i;
                ClassId classId15 = ClassId.topLevel(new FqName("kotlin.jvm.functions.Function" + (int)i));
                Intrinsics.checkExpressionValueIsNotNull(classId15, "ClassId.topLevel(FqName(\u2026functions.Function\" + i))");
                ClassId classId16 = KotlinBuiltIns.getFunctionClassId((int)i);
                Intrinsics.checkExpressionValueIsNotNull(classId16, "KotlinBuiltIns.getFunctionClassId(i)");
                this.add(classId15, classId16);
                FunctionClassDescriptor.Kind kFunction = FunctionClassDescriptor.Kind.KFunction;
                String kFun = kFunction.getPackageFqName().toString() + "." + kFunction.getClassNamePrefix();
                FqName fqName29 = new FqName(kFun + (int)i);
                ClassId classId17 = ClassId.topLevel(new FqName(kFun));
                Intrinsics.checkExpressionValueIsNotNull(classId17, "ClassId.topLevel(FqName(kFun))");
                this.addKotlinToJava(fqName29, classId17);
                if (i == n2) break;
                ++i;
            }
        }
        FqName fqName30 = KotlinBuiltIns.FQ_NAMES.nothing.toSafe();
        Intrinsics.checkExpressionValueIsNotNull(fqName30, "FQ_NAMES.nothing.toSafe()");
        this.addKotlinToJava(fqName30, this.classId(Void.class));
    }

    static {
        new JavaToKotlinClassMap();
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/platform/JavaToKotlinClassMap$PlatformMutabilityMapping;", "", "javaClass", "Lorg/jetbrains/kotlin/name/ClassId;", "kotlinReadOnly", "kotlinMutable", "(Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/name/ClassId;)V", "getJavaClass", "()Lorg/jetbrains/kotlin/name/ClassId;", "getKotlinMutable", "getKotlinReadOnly", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin-compiler"})
    public static final class PlatformMutabilityMapping {
        @NotNull
        private final ClassId javaClass;
        @NotNull
        private final ClassId kotlinReadOnly;
        @NotNull
        private final ClassId kotlinMutable;

        @NotNull
        public final ClassId getJavaClass() {
            return this.javaClass;
        }

        @NotNull
        public final ClassId getKotlinReadOnly() {
            return this.kotlinReadOnly;
        }

        @NotNull
        public final ClassId getKotlinMutable() {
            return this.kotlinMutable;
        }

        public PlatformMutabilityMapping(@NotNull ClassId javaClass, @NotNull ClassId kotlinReadOnly, @NotNull ClassId kotlinMutable) {
            Intrinsics.checkParameterIsNotNull(javaClass, "javaClass");
            Intrinsics.checkParameterIsNotNull(kotlinReadOnly, "kotlinReadOnly");
            Intrinsics.checkParameterIsNotNull(kotlinMutable, "kotlinMutable");
            this.javaClass = javaClass;
            this.kotlinReadOnly = kotlinReadOnly;
            this.kotlinMutable = kotlinMutable;
        }

        @NotNull
        public final ClassId component1() {
            return this.javaClass;
        }

        @NotNull
        public final ClassId component2() {
            return this.kotlinReadOnly;
        }

        @NotNull
        public final ClassId component3() {
            return this.kotlinMutable;
        }

        @NotNull
        public final PlatformMutabilityMapping copy(@NotNull ClassId javaClass, @NotNull ClassId kotlinReadOnly, @NotNull ClassId kotlinMutable) {
            Intrinsics.checkParameterIsNotNull(javaClass, "javaClass");
            Intrinsics.checkParameterIsNotNull(kotlinReadOnly, "kotlinReadOnly");
            Intrinsics.checkParameterIsNotNull(kotlinMutable, "kotlinMutable");
            return new PlatformMutabilityMapping(javaClass, kotlinReadOnly, kotlinMutable);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ PlatformMutabilityMapping copy$default(PlatformMutabilityMapping platformMutabilityMapping, ClassId classId, ClassId classId2, ClassId classId3, int n, Object object) {
            if ((n & 1) != 0) {
                classId = platformMutabilityMapping.javaClass;
            }
            if ((n & 2) != 0) {
                classId2 = platformMutabilityMapping.kotlinReadOnly;
            }
            if ((n & 4) != 0) {
                classId3 = platformMutabilityMapping.kotlinMutable;
            }
            return platformMutabilityMapping.copy(classId, classId2, classId3);
        }

        public String toString() {
            return "PlatformMutabilityMapping(javaClass=" + this.javaClass + ", kotlinReadOnly=" + this.kotlinReadOnly + ", kotlinMutable=" + this.kotlinMutable + ")";
        }

        public int hashCode() {
            ClassId classId = this.javaClass;
            ClassId classId2 = this.kotlinReadOnly;
            ClassId classId3 = this.kotlinMutable;
            return ((classId != null ? ((Object)classId).hashCode() : 0) * 31 + (classId2 != null ? ((Object)classId2).hashCode() : 0)) * 31 + (classId3 != null ? ((Object)classId3).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PlatformMutabilityMapping)) break block3;
                    PlatformMutabilityMapping platformMutabilityMapping = (PlatformMutabilityMapping)object;
                    if (!Intrinsics.areEqual(this.javaClass, platformMutabilityMapping.javaClass) || !Intrinsics.areEqual(this.kotlinReadOnly, platformMutabilityMapping.kotlinReadOnly) || !Intrinsics.areEqual(this.kotlinMutable, platformMutabilityMapping.kotlinMutable)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

