/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationsImpl;
import org.jetbrains.kotlin.descriptors.impl.ClassConstructorDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtPureElement;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.FunctionDescriptorResolver;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.OverloadChecker;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.util.FunctionTypeResolveUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.TraceBasedLocalRedeclarationChecker;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u00ce\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJH\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J6\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001c2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)H\u0002J6\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)J0\u0010.\u001a\u00020+2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020/2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00100\u001a\u000201H\u0002Jd\u00102\u001a\u0002032*\u00104\u001a&\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020%052\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020/2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00100\u001a\u0002012\u0006\u0010(\u001a\u00020)H\u0002J.\u00102\u001a\u0002032\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020/2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00100\u001a\u000201J6\u0010:\u001a\u0002032\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020/2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00100\u001a\u0002012\u0006\u0010(\u001a\u00020)J(\u0010;\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010<\u001a\u00020=2\u0006\u0010\u001e\u001a\u00020\u001fJ&\u0010>\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010?\u001a\u00020@2\u0006\u0010\u001e\u001a\u00020\u001fJD\u0010A\u001a\b\u0012\u0004\u0012\u00020!0\u001c2\u0006\u0010$\u001a\u00020B2\u0006\u0010C\u001a\u00020'2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u000e\u0010D\u001a\n\u0012\u0004\u0012\u00020)\u0018\u00010\u001cH\u0002J\f\u0010E\u001a\u00020\u0016*\u00020)H\u0002J\u000e\u0010F\u001a\u0004\u0018\u00010)*\u00020)H\u0002J\u001c\u0010G\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010\u001c*\u00020)2\u0006\u0010H\u001a\u00020BH\u0002J\f\u0010I\u001a\u00020)*\u00020)H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lorg/jetbrains/kotlin/resolve/FunctionDescriptorResolver;", "", "typeResolver", "Lorg/jetbrains/kotlin/resolve/TypeResolver;", "descriptorResolver", "Lorg/jetbrains/kotlin/resolve/DescriptorResolver;", "annotationResolver", "Lorg/jetbrains/kotlin/resolve/AnnotationResolver;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "modifiersChecker", "Lorg/jetbrains/kotlin/resolve/ModifiersChecker;", "overloadChecker", "Lorg/jetbrains/kotlin/resolve/OverloadChecker;", "(Lorg/jetbrains/kotlin/resolve/TypeResolver;Lorg/jetbrains/kotlin/resolve/DescriptorResolver;Lorg/jetbrains/kotlin/resolve/AnnotationResolver;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Lorg/jetbrains/kotlin/resolve/ModifiersChecker;Lorg/jetbrains/kotlin/resolve/OverloadChecker;)V", "createConstructorDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/ClassConstructorDescriptorImpl;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "isPrimary", "", "modifierList", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "declarationToTrace", "Lorg/jetbrains/kotlin/psi/KtPureElement;", "valueParameters", "", "Lorg/jetbrains/kotlin/psi/KtParameter;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "createValueParameterDescriptors", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/SimpleFunctionDescriptorImpl;", "innerScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalWritableScope;", "expectedFunctionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "initializeFunctionDescriptorAndExplicitReturnType", "", "containingDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "initializeFunctionReturnTypeBasedOnFunctionBody", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "resolveFunctionDescriptor", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "functionConstructor", "Lkotlin/Function5;", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor$Kind;", "Lorg/jetbrains/kotlin/descriptors/SourceElement;", "resolveFunctionExpressionDescriptor", "resolvePrimaryConstructorDescriptor", "classElement", "Lorg/jetbrains/kotlin/psi/KtPureClassOrObject;", "resolveSecondaryConstructorDescriptor", "constructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "resolveValueParameters", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "parameterScope", "expectedParameterTypes", "functionTypeExpected", "getReceiverType", "getValueParameters", "owner", "removeParameterNameAnnotation", "kotlin-compiler"})
public final class FunctionDescriptorResolver {
    private final TypeResolver typeResolver;
    private final DescriptorResolver descriptorResolver;
    private final AnnotationResolver annotationResolver;
    private final KotlinBuiltIns builtIns;
    private final ModifiersChecker modifiersChecker;
    private final OverloadChecker overloadChecker;

    @NotNull
    public final SimpleFunctionDescriptor resolveFunctionDescriptor(@NotNull DeclarationDescriptor containingDescriptor, @NotNull LexicalScope scope, @NotNull KtNamedFunction function2, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo) {
        Intrinsics.checkParameterIsNotNull(containingDescriptor, "containingDescriptor");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        Intrinsics.checkParameterIsNotNull(function2, "function");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(dataFlowInfo, "dataFlowInfo");
        if (function2.getName() == null) {
            trace.report(Errors.FUNCTION_DECLARATION_WITH_NO_NAME.on((KtFunction)((PsiElement)function2)));
        }
        Function5 function5 = resolveFunctionDescriptor.1.INSTANCE;
        SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
        Intrinsics.checkExpressionValueIsNotNull(simpleType2, "TypeUtils.NO_EXPECTED_TYPE");
        return this.resolveFunctionDescriptor(function5, containingDescriptor, scope, function2, trace, dataFlowInfo, simpleType2);
    }

    @NotNull
    public final SimpleFunctionDescriptor resolveFunctionExpressionDescriptor(@NotNull DeclarationDescriptor containingDescriptor, @NotNull LexicalScope scope, @NotNull KtNamedFunction function2, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo, @NotNull KotlinType expectedFunctionType) {
        Intrinsics.checkParameterIsNotNull(containingDescriptor, "containingDescriptor");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        Intrinsics.checkParameterIsNotNull(function2, "function");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(dataFlowInfo, "dataFlowInfo");
        Intrinsics.checkParameterIsNotNull(expectedFunctionType, "expectedFunctionType");
        return this.resolveFunctionDescriptor(resolveFunctionExpressionDescriptor.1.INSTANCE, containingDescriptor, scope, function2, trace, dataFlowInfo, expectedFunctionType);
    }

    private final SimpleFunctionDescriptor resolveFunctionDescriptor(Function5<? super DeclarationDescriptor, ? super Annotations, ? super Name, ? super CallableMemberDescriptor.Kind, ? super SourceElement, ? extends SimpleFunctionDescriptorImpl> functionConstructor, DeclarationDescriptor containingDescriptor, LexicalScope scope, KtNamedFunction function2, BindingTrace trace, DataFlowInfo dataFlowInfo, KotlinType expectedFunctionType) {
        Annotations annotations2 = this.annotationResolver.resolveAnnotationsWithoutArguments(scope, function2.getModifierList(), trace);
        Name name = function2.getNameAsSafeName();
        Intrinsics.checkExpressionValueIsNotNull(name, "function.nameAsSafeName");
        SimpleFunctionDescriptorImpl functionDescriptor = functionConstructor.invoke(containingDescriptor, annotations2, name, CallableMemberDescriptor.Kind.DECLARATION, KotlinSourceElementKt.toSourceElement(function2));
        this.initializeFunctionDescriptorAndExplicitReturnType(containingDescriptor, scope, function2, functionDescriptor, trace, expectedFunctionType);
        this.initializeFunctionReturnTypeBasedOnFunctionBody(scope, function2, functionDescriptor, trace, dataFlowInfo);
        BindingContextUtils.recordFunctionDeclarationToDescriptor(trace, function2, functionDescriptor);
        return functionDescriptor;
    }

    private final void initializeFunctionReturnTypeBasedOnFunctionBody(LexicalScope scope, KtNamedFunction function2, SimpleFunctionDescriptorImpl functionDescriptor, BindingTrace trace, DataFlowInfo dataFlowInfo) {
        KotlinType kotlinType;
        boolean bl;
        if (functionDescriptor.getReturnType() != null) {
            return;
        }
        boolean bl2 = bl = function2.getTypeReference() == null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Return type must be initialized early for function: " + function2.getText() + ", at: " + DiagnosticUtils.atLocation(function2);
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (function2.hasBlockBody()) {
            SimpleType simpleType2 = this.builtIns.getUnitType();
            Intrinsics.checkExpressionValueIsNotNull(simpleType2, "builtIns.unitType");
            kotlinType = simpleType2;
        } else if (function2.hasBody()) {
            KotlinType kotlinType2 = this.descriptorResolver.inferReturnTypeFromExpressionBody(trace, scope, dataFlowInfo, function2, functionDescriptor);
            kotlinType = kotlinType2;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "descriptorResolver.infer\u2026tion, functionDescriptor)");
        } else {
            SimpleType simpleType3 = ErrorUtils.createErrorType("No type, no body");
            Intrinsics.checkExpressionValueIsNotNull(simpleType3, "ErrorUtils.createErrorType(\"No type, no body\")");
            kotlinType = simpleType3;
        }
        KotlinType returnType = kotlinType;
        functionDescriptor.setReturnType(returnType);
    }

    public final void initializeFunctionDescriptorAndExplicitReturnType(@NotNull DeclarationDescriptor containingDescriptor, @NotNull LexicalScope scope, @NotNull KtFunction function2, @NotNull SimpleFunctionDescriptorImpl functionDescriptor, @NotNull BindingTrace trace, @NotNull KotlinType expectedFunctionType) {
        KotlinType kotlinType;
        Intrinsics.checkParameterIsNotNull(containingDescriptor, "containingDescriptor");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        Intrinsics.checkParameterIsNotNull(function2, "function");
        Intrinsics.checkParameterIsNotNull(functionDescriptor, "functionDescriptor");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(expectedFunctionType, "expectedFunctionType");
        LexicalWritableScope headerScope = new LexicalWritableScope(scope, functionDescriptor, true, new TraceBasedLocalRedeclarationChecker(trace, this.overloadChecker), LexicalScopeKind.FUNCTION_HEADER);
        List<TypeParameterDescriptorImpl> typeParameterDescriptors = this.descriptorResolver.resolveTypeParametersForDescriptor(functionDescriptor, headerScope, scope, function2.getTypeParameters(), trace);
        this.descriptorResolver.resolveGenericBounds(function2, functionDescriptor, headerScope, typeParameterDescriptors, trace);
        KtTypeReference receiverTypeRef = function2.getReceiverTypeReference();
        KotlinType receiverType = receiverTypeRef != null ? this.typeResolver.resolveType(headerScope, receiverTypeRef, trace, true) : (function2 instanceof KtFunctionLiteral ? this.getReceiverType(expectedFunctionType) : null);
        List<ValueParameterDescriptor> valueParameterDescriptors = this.createValueParameterDescriptors(function2, functionDescriptor, headerScope, trace, expectedFunctionType);
        headerScope.freeze();
        KtTypeReference ktTypeReference = function2.getTypeReference();
        if (ktTypeReference != null) {
            KtTypeReference ktTypeReference2;
            KtTypeReference it = ktTypeReference2 = ktTypeReference;
            LexicalScope lexicalScope = headerScope;
            KtTypeReference ktTypeReference3 = it;
            Intrinsics.checkExpressionValueIsNotNull(ktTypeReference3, "it");
            kotlinType = this.typeResolver.resolveType(lexicalScope, ktTypeReference3, trace, true);
        } else {
            kotlinType = null;
        }
        KotlinType returnType = kotlinType;
        Visibility visibility = ModifiersChecker.resolveVisibilityFromModifiers(function2, DescriptorResolver.getDefaultVisibility(function2, containingDescriptor));
        Modality modality = ModifiersChecker.resolveMemberModalityFromModifiers(function2, DescriptorResolver.getDefaultModality(containingDescriptor, visibility, function2.hasBody()), trace.getBindingContext(), containingDescriptor);
        functionDescriptor.initialize(receiverType, DescriptorUtils.getDispatchReceiverParameterIfNeeded(containingDescriptor), typeParameterDescriptors, (List)valueParameterDescriptors, returnType, modality, visibility);
        functionDescriptor.setOperator(function2.hasModifier(KtTokens.OPERATOR_KEYWORD));
        functionDescriptor.setInfix(function2.hasModifier(KtTokens.INFIX_KEYWORD));
        functionDescriptor.setExternal(function2.hasModifier(KtTokens.EXTERNAL_KEYWORD));
        functionDescriptor.setInline(function2.hasModifier(KtTokens.INLINE_KEYWORD));
        functionDescriptor.setTailrec(function2.hasModifier(KtTokens.TAILREC_KEYWORD));
        functionDescriptor.setSuspend(function2.hasModifier(KtTokens.SUSPEND_KEYWORD));
        functionDescriptor.setHeader(function2.hasModifier(KtTokens.HEADER_KEYWORD) || containingDescriptor instanceof ClassDescriptor && ((ClassDescriptor)containingDescriptor).isHeader());
        functionDescriptor.setImpl(function2.hasModifier(KtTokens.IMPL_KEYWORD));
        KotlinType kotlinType2 = receiverType;
        if (kotlinType2 != null) {
            KotlinType $i$a$1$let;
            KotlinType it = $i$a$1$let = kotlinType2;
            ForceResolveUtil.forceResolveAllContents(it.getAnnotations());
        }
        for (ValueParameterDescriptor valueParameterDescriptor : valueParameterDescriptors) {
            ForceResolveUtil.forceResolveAllContents(valueParameterDescriptor.getType().getAnnotations());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<ValueParameterDescriptor> createValueParameterDescriptors(KtFunction function2, SimpleFunctionDescriptorImpl functionDescriptor, LexicalWritableScope innerScope, BindingTrace trace, KotlinType expectedFunctionType) {
        List expectedParameterTypes;
        List list2;
        List<ValueParameterDescriptor> expectedValueParameters;
        List<ValueParameterDescriptor> list3 = expectedValueParameters = this.getValueParameters(expectedFunctionType, functionDescriptor);
        if (list3 != null) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)list3;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
                Collection collection = destination$iv$iv;
                KotlinType kotlinType = this.removeParameterNameAnnotation(it.getType());
                collection.add(kotlinType);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = expectedParameterTypes = null;
        }
        if (expectedValueParameters != null) {
            if (expectedValueParameters.size() == 1 && function2 instanceof KtFunctionLiteral && function2.getValueParameterList() == null) {
                ValueParameterDescriptor valueParameterDescriptor = CollectionsKt.single(expectedValueParameters);
                CallableDescriptor callableDescriptor = functionDescriptor;
                Annotations annotations2 = Annotations.Companion.getEMPTY();
                Name name = Name.identifier("it");
                Intrinsics.checkExpressionValueIsNotNull(name, "Name.identifier(\"it\")");
                List list4 = expectedParameterTypes;
                if (list4 == null) {
                    Intrinsics.throwNpe();
                }
                KotlinType kotlinType = (KotlinType)CollectionsKt.single(list4);
                boolean bl = valueParameterDescriptor.declaresDefaultValue();
                boolean bl2 = valueParameterDescriptor.isCrossinline();
                boolean bl3 = valueParameterDescriptor.isNoinline();
                KotlinType kotlinType2 = valueParameterDescriptor.getVarargElementType();
                SourceElement sourceElement = SourceElement.NO_SOURCE;
                Intrinsics.checkExpressionValueIsNotNull(sourceElement, "SourceElement.NO_SOURCE");
                ValueParameterDescriptorImpl it = new ValueParameterDescriptorImpl(callableDescriptor, null, 0, annotations2, name, kotlinType, bl, bl2, bl3, kotlinType2, sourceElement);
                trace.record(BindingContext.AUTO_CREATED_IT, it);
                return CollectionsKt.listOf(it);
            }
            if (function2.getValueParameters().size() != expectedValueParameters.size()) {
                PsiElement psiElement = function2;
                List list5 = expectedParameterTypes;
                if (list5 == null) {
                    Intrinsics.throwNpe();
                }
                trace.report(Errors.EXPECTED_PARAMETERS_NUMBER_MISMATCH.on((KtFunction)psiElement, list5.size(), expectedParameterTypes));
            }
        }
        BindingContextUtilsKt.recordScope(trace, innerScope, function2.getValueParameterList());
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        List<KtParameter> list6 = function2.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list6, "function.valueParameters");
        return this.resolveValueParameters(functionDescriptor2, innerScope, list6, trace, expectedParameterTypes);
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinType removeParameterNameAnnotation(@NotNull KotlinType $receiver) {
        void $receiver$iv$iv;
        void $receiver$iv;
        AnnotationsImpl annotationsImpl;
        if ($receiver instanceof TypeUtils.SpecialType) {
            return $receiver;
        }
        Annotations annotations2 = $receiver.getAnnotations();
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.parameterName;
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "KotlinBuiltIns.FQ_NAMES.parameterName");
        AnnotationDescriptor annotationDescriptor = annotations2.findAnnotation(fqName2);
        if (annotationDescriptor == null) {
            return $receiver;
        }
        AnnotationDescriptor parameterNameAnnotation = annotationDescriptor;
        Iterable iterable = $receiver.getAnnotations();
        AnnotationsImpl annotationsImpl2 = annotationsImpl;
        AnnotationsImpl annotationsImpl3 = annotationsImpl;
        KotlinType kotlinType = $receiver;
        void var4_7 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            AnnotationDescriptor it = (AnnotationDescriptor)element$iv$iv;
            if (!(Intrinsics.areEqual(it, parameterNameAnnotation) ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        annotationsImpl2(list2);
        return TypeUtilsKt.replaceAnnotations(kotlinType, annotationsImpl3);
    }

    private final boolean functionTypeExpected(@NotNull KotlinType $receiver) {
        return !TypeUtils.noExpectedType($receiver) && FunctionTypesKt.isBuiltinFunctionalType($receiver);
    }

    private final KotlinType getReceiverType(@NotNull KotlinType $receiver) {
        return this.functionTypeExpected($receiver) ? FunctionTypesKt.getReceiverTypeFromFunctionType($receiver) : null;
    }

    private final List<ValueParameterDescriptor> getValueParameters(@NotNull KotlinType $receiver, FunctionDescriptor owner) {
        return this.functionTypeExpected($receiver) ? FunctionTypeResolveUtilsKt.createValueParametersForInvokeInFunctionType(owner, FunctionTypesKt.getValueParameterTypesFromFunctionType($receiver)) : null;
    }

    @Nullable
    public final ClassConstructorDescriptorImpl resolvePrimaryConstructorDescriptor(@NotNull LexicalScope scope, @NotNull ClassDescriptor classDescriptor, @NotNull KtPureClassOrObject classElement, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        Intrinsics.checkParameterIsNotNull(classDescriptor, "classDescriptor");
        Intrinsics.checkParameterIsNotNull(classElement, "classElement");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        if (Intrinsics.areEqual((Object)classDescriptor.getKind(), (Object)ClassKind.ENUM_ENTRY) || !classElement.hasPrimaryConstructor()) {
            return null;
        }
        KtModifierList ktModifierList = classElement.getPrimaryConstructorModifierList();
        KtPrimaryConstructor ktPrimaryConstructor = classElement.getPrimaryConstructor();
        KtPureElement ktPureElement = ktPrimaryConstructor != null ? (KtPureElement)ktPrimaryConstructor : (KtPureElement)classElement;
        List<KtParameter> list2 = classElement.getPrimaryConstructorParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "classElement.primaryConstructorParameters");
        return this.createConstructorDescriptor(scope, classDescriptor, true, ktModifierList, ktPureElement, list2, trace);
    }

    @NotNull
    public final ClassConstructorDescriptorImpl resolveSecondaryConstructorDescriptor(@NotNull LexicalScope scope, @NotNull ClassDescriptor classDescriptor, @NotNull KtSecondaryConstructor constructor, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        Intrinsics.checkParameterIsNotNull(classDescriptor, "classDescriptor");
        Intrinsics.checkParameterIsNotNull(constructor, "constructor");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        KtModifierList ktModifierList = constructor.getModifierList();
        KtPureElement ktPureElement = constructor;
        List<KtParameter> list2 = constructor.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "constructor.valueParameters");
        return this.createConstructorDescriptor(scope, classDescriptor, false, ktModifierList, ktPureElement, list2, trace);
    }

    private final ClassConstructorDescriptorImpl createConstructorDescriptor(LexicalScope scope, ClassDescriptor classDescriptor, boolean isPrimary, KtModifierList modifierList, KtPureElement declarationToTrace, List<? extends KtParameter> valueParameters, BindingTrace trace) {
        ClassConstructorDescriptorImpl constructorDescriptor = ClassConstructorDescriptorImpl.create(classDescriptor, this.annotationResolver.resolveAnnotationsWithoutArguments(scope, modifierList, trace), isPrimary, KotlinSourceElementKt.toSourceElement(declarationToTrace));
        if (classDescriptor.isHeader()) {
            constructorDescriptor.setHeader(true);
        }
        if (classDescriptor.isImpl()) {
            constructorDescriptor.setImpl(true);
        }
        if (declarationToTrace instanceof PsiElement) {
            trace.record(BindingContext.CONSTRUCTOR, declarationToTrace, constructorDescriptor);
        }
        ClassConstructorDescriptorImpl classConstructorDescriptorImpl = constructorDescriptor;
        Intrinsics.checkExpressionValueIsNotNull(classConstructorDescriptorImpl, "constructorDescriptor");
        LexicalWritableScope parameterScope = new LexicalWritableScope(scope, classConstructorDescriptorImpl, false, new TraceBasedLocalRedeclarationChecker(trace, this.overloadChecker), LexicalScopeKind.CONSTRUCTOR_HEADER);
        ClassConstructorDescriptorImpl classConstructorDescriptorImpl2 = constructorDescriptor;
        Intrinsics.checkExpressionValueIsNotNull(classConstructorDescriptorImpl2, "constructorDescriptor");
        ClassConstructorDescriptorImpl constructor = constructorDescriptor.initialize(this.resolveValueParameters(classConstructorDescriptorImpl2, parameterScope, valueParameters, trace, null), ModifiersChecker.resolveVisibilityFromModifiers(modifierList, DescriptorUtils.getDefaultConstructorVisibility(classDescriptor)));
        constructor.setReturnType(classDescriptor.getDefaultType());
        if (DescriptorUtils.isAnnotationClass(classDescriptor)) {
            CompileTimeConstantUtils.checkConstructorParametersType(valueParameters, trace);
        }
        ClassConstructorDescriptorImpl classConstructorDescriptorImpl3 = constructor;
        Intrinsics.checkExpressionValueIsNotNull(classConstructorDescriptorImpl3, "constructor");
        return classConstructorDescriptorImpl3;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ValueParameterDescriptor> resolveValueParameters(FunctionDescriptor functionDescriptor, LexicalWritableScope parameterScope, List<? extends KtParameter> valueParameters, BindingTrace trace, List<? extends KotlinType> expectedParameterTypes) {
        ArrayList<ValueParameterDescriptorImpl> result2 = new ArrayList<ValueParameterDescriptorImpl>();
        int n = 0;
        int n2 = ((Collection)valueParameters).size() - 1;
        if (n <= n2) {
            while (true) {
                KotlinType type2;
                KotlinType expectedType;
                List<? extends KotlinType> list2;
                List<? extends KotlinType> it;
                void i;
                KtParameter valueParameter = valueParameters.get((int)i);
                KtTypeReference typeReference = valueParameter.getTypeReference();
                KotlinType kotlinType = expectedParameterTypes != null ? (i < (it = list2).size() ? it.get((int)i) : null) : (expectedType = null);
                if (typeReference != null) {
                    type2 = this.typeResolver.resolveType(parameterScope, typeReference, trace, true);
                    if (expectedType != null && !TypeUtils.noExpectedType(expectedType) && !KotlinTypeChecker.DEFAULT.isSubtypeOf(expectedType, type2)) {
                        trace.report(Errors.EXPECTED_PARAMETER_TYPE_MISMATCH.on((KtParameter)((PsiElement)valueParameter), expectedType));
                    }
                } else if (ExpressionTypingUtils.isFunctionLiteral(functionDescriptor) || ExpressionTypingUtils.isFunctionExpression(functionDescriptor)) {
                    KotlinType kotlinType2;
                    boolean containsUninferredParameter2 = TypeUtils.contains(expectedType, resolveValueParameters.containsUninferredParameter.1.INSTANCE);
                    if (expectedType == null || containsUninferredParameter2) {
                        trace.report(Errors.CANNOT_INFER_PARAMETER_TYPE.on((KtParameter)((PsiElement)valueParameter)));
                    }
                    if ((kotlinType2 = expectedType) == null) {
                        SimpleType simpleType2 = TypeUtils.CANT_INFER_FUNCTION_PARAM_TYPE;
                        Intrinsics.checkExpressionValueIsNotNull(simpleType2, "TypeUtils.CANT_INFER_FUNCTION_PARAM_TYPE");
                        kotlinType2 = simpleType2;
                    }
                    type2 = kotlinType2;
                } else {
                    trace.report(Errors.VALUE_PARAMETER_WITH_NO_TYPE_ANNOTATION.on((KtParameter)((PsiElement)valueParameter)));
                    SimpleType simpleType3 = ErrorUtils.createErrorType("Type annotation was missing for parameter " + valueParameter.getNameAsSafeName());
                    Intrinsics.checkExpressionValueIsNotNull(simpleType3, "ErrorUtils.createErrorTy\u2026rameter.nameAsSafeName}\")");
                    type2 = simpleType3;
                }
                if (!(functionDescriptor instanceof ConstructorDescriptor) || !((ConstructorDescriptor)functionDescriptor).isPrimary()) {
                    ModifiersChecker.ModifiersCheckingProcedure modifiersCheckingProcedure;
                    boolean isConstructor = functionDescriptor instanceof ConstructorDescriptor;
                    ModifiersChecker.ModifiersCheckingProcedure $receiver = modifiersCheckingProcedure = this.modifiersChecker.withTrace(trace);
                    $receiver.checkParameterHasNoValOrVar(valueParameter, isConstructor ? Errors.VAL_OR_VAR_ON_SECONDARY_CONSTRUCTOR_PARAMETER : Errors.VAL_OR_VAR_ON_FUN_PARAMETER);
                }
                ValueParameterDescriptorImpl valueParameterDescriptor = this.descriptorResolver.resolveValueParameterDescriptor(parameterScope, functionDescriptor, valueParameter, (int)i, type2, trace);
                ExpressionTypingUtils.checkVariableShadowing(parameterScope, trace, valueParameterDescriptor);
                ValueParameterDescriptorImpl valueParameterDescriptorImpl = valueParameterDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptorImpl, "valueParameterDescriptor");
                parameterScope.addVariableDescriptor(valueParameterDescriptorImpl);
                result2.add(valueParameterDescriptor);
                if (i == n2) break;
                ++i;
            }
        }
        return result2;
    }

    public FunctionDescriptorResolver(@NotNull TypeResolver typeResolver, @NotNull DescriptorResolver descriptorResolver, @NotNull AnnotationResolver annotationResolver, @NotNull KotlinBuiltIns builtIns, @NotNull ModifiersChecker modifiersChecker, @NotNull OverloadChecker overloadChecker) {
        Intrinsics.checkParameterIsNotNull(typeResolver, "typeResolver");
        Intrinsics.checkParameterIsNotNull(descriptorResolver, "descriptorResolver");
        Intrinsics.checkParameterIsNotNull(annotationResolver, "annotationResolver");
        Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
        Intrinsics.checkParameterIsNotNull(modifiersChecker, "modifiersChecker");
        Intrinsics.checkParameterIsNotNull(overloadChecker, "overloadChecker");
        this.typeResolver = typeResolver;
        this.descriptorResolver = descriptorResolver;
        this.annotationResolver = annotationResolver;
        this.builtIns = builtIns;
        this.modifiersChecker = modifiersChecker;
        this.overloadChecker = overloadChecker;
    }
}

