/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import org.fibs.geotag.Settings;
import org.fibs.geotag.util.Proxies;

public final class Version {
    public static final int MAJOR = 0;
    public static final int MINOR = 102;
    public static final String BUILD_DATE;
    public static final String BUILD_TIME;
    public static final String BUILD_NUMBER;
    public static final String VERSION;

    static {
        Properties properties = new Properties();
        InputStream propertiesStream = Version.class.getClassLoader().getResourceAsStream("build.info");
        if (propertiesStream != null) {
            try {
                properties.load(propertiesStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        BUILD_DATE = properties.getProperty("build.date", "");
        BUILD_TIME = properties.getProperty("build.time", "");
        String buildNumber = properties.getProperty("build.number", "");
        while (buildNumber.length() > 1 && buildNumber.charAt(0) == '0') {
            buildNumber = buildNumber.substring(1);
        }
        BUILD_NUMBER = buildNumber;
        try {
            if (propertiesStream != null) {
                propertiesStream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        VERSION = String.format("%d.%03d", 0, 102);
    }

    private Version() {
    }

    public static String updateAvaiable() {
        if (Settings.get(Settings.SETTING.CHECK_FOR_NEW_VERSION, true)) {
            try {
                URL versionFile = new URL("http://geotag.sourceforge.net/version.txt");
                URLConnection connection = versionFile.openConnection(Proxies.getProxy());
                InputStream inputStream = connection.getInputStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String versionLine = bufferedReader.readLine();
                bufferedReader.close();
                if (versionLine != null && VERSION.compareTo(versionLine) < 0) {
                    return versionLine;
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

