/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentRegistry;
import org.gradle.api.internal.composite.CompositeBuildContext;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.composite.internal.CompositeProjectComponentArtifactMetadata;
import org.gradle.composite.internal.IncludedBuildInternal;
import org.gradle.internal.component.local.model.DefaultLocalComponentMetadata;
import org.gradle.internal.component.local.model.DefaultProjectComponentIdentifier;
import org.gradle.internal.component.local.model.DefaultProjectComponentSelector;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.local.model.LocalComponentMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.LocalOriginDependencyMetadata;

public class IncludedBuildDependencyMetadataBuilder {
    private final CompositeBuildContext context;

    public IncludedBuildDependencyMetadataBuilder(CompositeBuildContext context) {
        this.context = context;
    }

    public void build(IncludedBuildInternal build) {
        GradleInternal gradle = build.getConfiguredBuild();
        for (Project project : gradle.getRootProject().getAllprojects()) {
            this.registerProject((IncludedBuild)build, (ProjectInternal)project);
        }
    }

    private void registerProject(IncludedBuild build, ProjectInternal project) {
        LocalComponentRegistry localComponentRegistry = (LocalComponentRegistry)project.getServices().get(LocalComponentRegistry.class);
        ProjectComponentIdentifier originalIdentifier = DefaultProjectComponentIdentifier.newProjectId((Project)project);
        DefaultLocalComponentMetadata originalComponent = (DefaultLocalComponentMetadata)localComponentRegistry.getComponent(originalIdentifier);
        ProjectComponentIdentifier componentIdentifier = DefaultProjectComponentIdentifier.newProjectId((IncludedBuild)build, (String)project.getPath());
        LocalComponentMetadata compositeComponent = this.createCompositeCopy(build, componentIdentifier, originalComponent);
        this.context.register(componentIdentifier, compositeComponent);
        for (LocalComponentArtifactMetadata artifactMetaData : localComponentRegistry.getAdditionalArtifacts(originalIdentifier)) {
            this.context.registerAdditionalArtifact(componentIdentifier, this.createCompositeCopy(componentIdentifier, artifactMetaData));
        }
    }

    private LocalComponentMetadata createCompositeCopy(final IncludedBuild build, final ProjectComponentIdentifier componentIdentifier, DefaultLocalComponentMetadata originalComponentMetadata) {
        return originalComponentMetadata.copy((ComponentIdentifier)componentIdentifier, (Transformer)new Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata>(){

            public LocalComponentArtifactMetadata transform(LocalComponentArtifactMetadata originalArtifact) {
                File artifactFile = originalArtifact.getFile();
                Set targetTasks = IncludedBuildDependencyMetadataBuilder.this.getArtifactTasks((ComponentArtifactMetadata)originalArtifact);
                return new CompositeProjectComponentArtifactMetadata(componentIdentifier, originalArtifact.getName(), artifactFile, targetTasks);
            }
        }, (Transformer)new Transformer<LocalOriginDependencyMetadata, LocalOriginDependencyMetadata>(){

            public LocalOriginDependencyMetadata transform(LocalOriginDependencyMetadata originalDependency) {
                if (originalDependency.getSelector() instanceof ProjectComponentSelector) {
                    ProjectComponentSelector requested = (ProjectComponentSelector)originalDependency.getSelector();
                    return originalDependency.withTarget((ComponentSelector)DefaultProjectComponentSelector.newSelector((IncludedBuild)build, (ProjectComponentSelector)requested));
                }
                return originalDependency;
            }
        });
    }

    private LocalComponentArtifactMetadata createCompositeCopy(ProjectComponentIdentifier project, LocalComponentArtifactMetadata artifactMetaData) {
        File artifactFile = artifactMetaData.getFile();
        return new CompositeProjectComponentArtifactMetadata(project, artifactMetaData.getName(), artifactFile, this.getArtifactTasks((ComponentArtifactMetadata)artifactMetaData));
    }

    private Set<String> getArtifactTasks(ComponentArtifactMetadata artifactMetaData) {
        LinkedHashSet taskPaths = Sets.newLinkedHashSet();
        Set tasks = artifactMetaData.getBuildDependencies().getDependencies(null);
        for (Task task : tasks) {
            taskPaths.add(task.getPath());
        }
        return taskPaths;
    }
}

