/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.NotNullLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionManager;

public abstract class AtomicNotNullLazyValue<T>
extends NotNullLazyValue<T> {
    private static final RecursionGuard ourGuard = RecursionManager.createGuard("AtomicNotNullLazyValue");
    private volatile T myValue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public final T getValue() {
        T value = this.myValue;
        if (value != null) {
            T t = value;
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/AtomicNotNullLazyValue", "getValue"));
            }
            return t;
        }
        AtomicNotNullLazyValue atomicNotNullLazyValue = this;
        synchronized (atomicNotNullLazyValue) {
            value = this.myValue;
            if (value == null) {
                RecursionGuard.StackStamp stamp = ourGuard.markStack();
                value = this.compute();
                if (stamp.mayCacheNow()) {
                    this.myValue = value;
                }
            }
        }
        T t = value;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/AtomicNotNullLazyValue", "getValue"));
        }
        return t;
    }
}

