/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Iconable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiInvalidElementAccessException;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.SearchScope;
import org.jetbrains.kotlin.com.intellij.util.ArrayFactory;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public interface PsiElement
extends Iconable,
UserDataHolder {
    public static final PsiElement[] EMPTY_ARRAY = new PsiElement[0];
    public static final ArrayFactory<PsiElement> ARRAY_FACTORY = new ArrayFactory<PsiElement>(){

        @NotNull
        public PsiElement[] create(int count) {
            PsiElement[] psiElementArray = count == 0 ? EMPTY_ARRAY : new PsiElement[count];
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiElement$1", "create"));
            }
            return psiElementArray;
        }
    };

    @NotNull
    @Contract(pure=true)
    public Project getProject() throws PsiInvalidElementAccessException;

    @NotNull
    @Contract(pure=true)
    public Language getLanguage();

    @Contract(pure=true)
    public PsiManager getManager();

    @NotNull
    @Contract(pure=true)
    public PsiElement[] getChildren();

    @Contract(pure=true)
    public PsiElement getParent();

    @Contract(pure=true)
    public PsiElement getFirstChild();

    @Contract(pure=true)
    public PsiElement getLastChild();

    @Contract(pure=true)
    public PsiElement getNextSibling();

    @Contract(pure=true)
    public PsiElement getPrevSibling();

    @Contract(pure=true)
    public PsiFile getContainingFile() throws PsiInvalidElementAccessException;

    @Contract(pure=true)
    public TextRange getTextRange();

    @Contract(pure=true)
    public int getStartOffsetInParent();

    @Contract(pure=true)
    public int getTextLength();

    @Nullable
    @Contract(pure=true)
    public PsiElement findElementAt(int var1);

    @Nullable
    @Contract(pure=true)
    public PsiReference findReferenceAt(int var1);

    @Contract(pure=true)
    public int getTextOffset();

    @NonNls
    @Contract(pure=true)
    public String getText();

    @NotNull
    @Contract(pure=true)
    public char[] textToCharArray();

    @Contract(pure=true)
    public PsiElement getNavigationElement();

    @Contract(pure=true)
    public PsiElement getOriginalElement();

    @Contract(pure=true)
    public boolean textMatches(@NotNull @NonNls CharSequence var1);

    @Contract(pure=true)
    public boolean textMatches(@NotNull PsiElement var1);

    @Contract(pure=true)
    public boolean textContains(char var1);

    public void accept(@NotNull PsiElementVisitor var1);

    public void acceptChildren(@NotNull PsiElementVisitor var1);

    public PsiElement copy();

    public PsiElement add(@NotNull PsiElement var1) throws IncorrectOperationException;

    public PsiElement addBefore(@NotNull PsiElement var1, @Nullable PsiElement var2) throws IncorrectOperationException;

    public PsiElement addAfter(@NotNull PsiElement var1, @Nullable PsiElement var2) throws IncorrectOperationException;

    public void checkAdd(@NotNull PsiElement var1) throws IncorrectOperationException;

    public PsiElement addRange(PsiElement var1, PsiElement var2) throws IncorrectOperationException;

    public PsiElement addRangeBefore(@NotNull PsiElement var1, @NotNull PsiElement var2, PsiElement var3) throws IncorrectOperationException;

    public PsiElement addRangeAfter(PsiElement var1, PsiElement var2, PsiElement var3) throws IncorrectOperationException;

    public void delete() throws IncorrectOperationException;

    public void checkDelete() throws IncorrectOperationException;

    public void deleteChildRange(PsiElement var1, PsiElement var2) throws IncorrectOperationException;

    public PsiElement replace(@NotNull PsiElement var1) throws IncorrectOperationException;

    @Contract(pure=true)
    public boolean isValid();

    @Contract(pure=true)
    public boolean isWritable();

    @Nullable
    @Contract(pure=true)
    public PsiReference getReference();

    @NotNull
    @Contract(pure=true)
    public PsiReference[] getReferences();

    @Nullable
    @Contract(pure=true)
    public <T> T getCopyableUserData(Key<T> var1);

    public <T> void putCopyableUserData(Key<T> var1, @Nullable T var2);

    public boolean processDeclarations(@NotNull PsiScopeProcessor var1, @NotNull ResolveState var2, @Nullable PsiElement var3, @NotNull PsiElement var4);

    @Nullable
    @Contract(pure=true)
    public PsiElement getContext();

    @Contract(pure=true)
    public boolean isPhysical();

    @NotNull
    @Contract(pure=true)
    public GlobalSearchScope getResolveScope();

    @NotNull
    @Contract(pure=true)
    public SearchScope getUseScope();

    @Contract(pure=true)
    public ASTNode getNode();

    @NonNls
    @Contract(pure=true)
    public String toString();

    @Contract(pure=true)
    public boolean isEquivalentTo(PsiElement var1);
}

