/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.util.Vector;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.textarea.ColumnBlockLine;
import org.gjt.sp.jedit.textarea.Node;
import org.gjt.sp.jedit.textarea.Selection;

public class ColumnBlock
extends Selection.Rect
implements Node {
    private Node parent;
    private Vector<Node> children = new Vector();
    private Vector<ColumnBlockLine> lines = new Vector();
    float columnBlockWidth;
    private boolean tabSizesDirty = true;
    private JEditBuffer buffer;
    private boolean isDirty;

    @Override
    public void addChild(Node node) {
        ColumnBlock columnBlock = (ColumnBlock)node;
        ColumnBlock columnBlock2 = this.searchChildren(columnBlock.startLine);
        if (columnBlock2 != null) {
            if (columnBlock2.isLineWithinThisBlock(columnBlock.endLine) >= 0) {
                throw new IllegalArgumentException("Overlapping column blocks: " + columnBlock + " \n&\n" + columnBlock2);
            }
            int n = this.children.indexOf(columnBlock2);
            this.children.add(n, node);
        } else {
            this.children.add(node);
        }
    }

    @Override
    public Vector<Node> getChildren() {
        return this.children;
    }

    @Override
    public Node getParent() {
        return this.parent;
    }

    public void setWidth(int n) {
        this.columnBlockWidth = n;
    }

    public void setParent(Node node) {
        this.parent = node;
    }

    public void setLines(Vector<ColumnBlockLine> vector) {
        this.lines = vector;
    }

    public Vector<ColumnBlockLine> getLines() {
        return this.lines;
    }

    public ColumnBlock() {
    }

    public ColumnBlock(JEditBuffer jEditBuffer, int n, int n2, int n3, int n4) {
        super(jEditBuffer, n, n2, n3, n4);
        this.buffer = jEditBuffer;
    }

    public ColumnBlock(JEditBuffer jEditBuffer, int n, int n2) {
        this.startLine = n;
        this.endLine = n2;
        this.buffer = jEditBuffer;
    }

    @Override
    public int getStartLine() {
        return this.startLine;
    }

    @Override
    public int getEndLine() {
        return this.endLine;
    }

    public int getColumnWidth() {
        return (int)this.columnBlockWidth;
    }

    public int isLineWithinThisBlock(int n) {
        if (n < this.startLine) {
            return n - this.startLine;
        }
        if (n > this.endLine) {
            return n - this.endLine;
        }
        return 0;
    }

    public ColumnBlock getContainingBlock(int n, int n2) {
        ColumnBlock columnBlock = null;
        if (n >= this.startLine && n <= this.endLine) {
            Object object;
            int n3 = n2 - this.buffer.getLineStartOffset(n);
            if (this.lines != null && !this.lines.isEmpty() && ((ColumnBlockLine)(object = this.lines.get(n - this.startLine))).getColumnEndIndex() >= n3 && ((ColumnBlockLine)object).getColumnStartIndex() <= n3) {
                columnBlock = this;
            }
            if (columnBlock == null && this.children != null && !this.children.isEmpty() && (object = this.searchChildren(n)) != null && ((ColumnBlock)object).isLineWithinThisBlock(n) == 0) {
                columnBlock = ((ColumnBlock)object).getContainingBlock(n, n2);
            }
        }
        return columnBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnBlock getColumnBlock(int n, int n2) {
        if (this.isDirty) {
            return null;
        }
        Object object = this.buffer.columnBlockLock;
        synchronized (object) {
            ColumnBlock columnBlock = null;
            if (n >= this.startLine && n <= this.endLine) {
                Object object2;
                if (this.lines != null && !this.lines.isEmpty() && ((ColumnBlockLine)(object2 = this.lines.get(n - this.startLine))).getColumnEndIndex() + this.buffer.getLineStartOffset(n) == n2) {
                    columnBlock = this;
                }
                if (columnBlock == null && this.children != null && !this.children.isEmpty()) {
                    object2 = this.searchChildren(n, 0, this.children.size() - 1);
                    if (object2 == null || ((ColumnBlock)object2).isLineWithinThisBlock(n) != 0) {
                        this.throwException(n2, n);
                    }
                    columnBlock = ((ColumnBlock)object2).getColumnBlock(n, n2);
                }
            }
            if (columnBlock == null) {
                this.throwException(n2, n);
            }
            return columnBlock;
        }
    }

    public ColumnBlock searchChildren(int n) {
        if (this.children != null && !this.children.isEmpty()) {
            return this.searchChildren(n, 0, this.children.size() - 1);
        }
        return null;
    }

    private ColumnBlock searchChildren(int n, int n2, int n3) {
        if (this.children != null) {
            if (n2 > n3) {
                return (ColumnBlock)this.children.get(n2);
            }
            int n4 = (n2 + n3) / 2;
            int n5 = ((ColumnBlock)this.children.get(n4)).isLineWithinThisBlock(n);
            if (n5 == 0) {
                return (ColumnBlock)this.children.get(n4);
            }
            if (n5 > 0) {
                if (this.children.size() - 1 > n4) {
                    return this.searchChildren(n, n4 + 1, n3);
                }
                return null;
            }
            if (n5 < 0) {
                if (n4 > 0) {
                    return this.searchChildren(n, n2, n4 - 1);
                }
                return (ColumnBlock)this.children.get(0);
            }
        }
        return null;
    }

    @Override
    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ColumnBlock[startLine : ").append(this.startLine).append(" ,endLine : ").append(this.endLine).append(" ,columnBlockWidth : ").append(this.columnBlockWidth).append("] LINES:");
        for (n = 0; n < this.lines.size(); ++n) {
            stringBuilder.append('\n');
            stringBuilder.append("LINE ").append(n).append(':').append(this.lines.elementAt(n));
        }
        for (n = 0; n < this.children.size(); ++n) {
            stringBuilder.append('\n');
            stringBuilder.append("CHILD ").append(n).append(':').append(this.children.elementAt(n));
        }
        return stringBuilder.toString();
    }

    private void throwException(int n, int n2) {
        throw new IllegalArgumentException("{ELASTIC TABSTOP}CORRUPT DATA@{" + System.currentTimeMillis() + "} & Thread : " + Thread.currentThread().getName() + " :Cannot find the size for tab at offset " + (n - this.buffer.getLineStartOffset(n2)) + "in line " + n2 + "while searching in \n " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDirtyStatus(boolean bl) {
        Object object = this.buffer.columnBlockLock;
        synchronized (object) {
            this.isDirty = bl;
        }
    }

    public void updateLineNo(int n) {
        int n2;
        this.startLine += n;
        this.endLine += n;
        for (n2 = 0; n2 < this.lines.size(); ++n2) {
            this.lines.elementAt(n2).updateLineNo(n);
        }
        for (n2 = 0; n2 < this.children.size(); ++n2) {
            ((ColumnBlock)this.children.elementAt(n2)).updateLineNo(n);
        }
    }

    public void updateColumnBlockLineOffset(int n, int n2, boolean bl) {
        if (n >= this.startLine && n <= this.endLine) {
            Object object;
            if (this.lines != null && !this.lines.isEmpty()) {
                object = this.lines.get(n - this.startLine);
                if (bl) {
                    ((ColumnBlockLine)object).colStartIndex += n2;
                }
                ((ColumnBlockLine)object).colEndIndex += n2;
            }
            if (this.children != null && !this.children.isEmpty() && (object = this.searchChildren(n)) != null && ((ColumnBlock)object).isLineWithinThisBlock(n) == 0) {
                ((ColumnBlock)object).updateColumnBlockLineOffset(n, n2, true);
            }
        }
    }

    public void setTabSizeDirtyStatus(boolean bl, boolean bl2) {
        this.tabSizesDirty = bl;
        if (bl2 && this.children != null && !this.children.isEmpty()) {
            for (int i = 0; i < this.children.size(); ++i) {
                ((ColumnBlock)this.children.elementAt(i)).setTabSizeDirtyStatus(true, true);
            }
        }
    }

    public boolean areTabSizesDirty() {
        return this.tabSizesDirty;
    }
}

