/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.version;

import java.util.Comparator;
import java.util.List;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.module.status.Status;
import org.apache.ivy.core.module.status.StatusManager;
import org.apache.ivy.plugins.version.AbstractVersionMatcher;

public final class LatestVersionMatcher
extends AbstractVersionMatcher {
    public LatestVersionMatcher() {
        super("latest");
    }

    @Override
    public final boolean isDynamic(ModuleRevisionId moduleRevisionId) {
        return moduleRevisionId.getRevision().startsWith("latest.");
    }

    @Override
    public final boolean accept(ModuleRevisionId moduleRevisionId, ModuleRevisionId moduleRevisionId2) {
        return true;
    }

    @Override
    public final boolean needModuleDescriptor(ModuleRevisionId moduleRevisionId, ModuleRevisionId moduleRevisionId2) {
        List list = StatusManager.getCurrent().getStatuses();
        Status status = (Status)list.get(list.size() - 1);
        return !("latest." + status.getName()).equals(moduleRevisionId.getRevision());
    }

    @Override
    public final boolean accept(ModuleRevisionId moduleRevisionId, ModuleDescriptor moduleDescriptor) {
        String string = moduleRevisionId.getRevision().substring(7);
        return StatusManager.getCurrent().getPriority(string) >= StatusManager.getCurrent().getPriority(moduleDescriptor.getStatus());
    }

    @Override
    public final int compare(ModuleRevisionId moduleRevisionId, ModuleRevisionId moduleRevisionId2, Comparator comparator) {
        if (this.needModuleDescriptor(moduleRevisionId, moduleRevisionId2)) {
            return 0;
        }
        return 1;
    }
}

