/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStream;
import org.freehep.graphicsio.emf.EMFHandleManager;
import org.freehep.graphicsio.emf.EMFHeader;
import org.freehep.graphicsio.emf.EMFTagSet;
import org.freehep.util.io.ActionHeader;
import org.freehep.util.io.Tag;
import org.freehep.util.io.TagHeader;
import org.freehep.util.io.TaggedOutputStream;

public class EMFOutputStream
extends TaggedOutputStream {
    private String application;
    private String name;
    private int recordCount = 0;
    private Rectangle imageBounds;
    private int version;
    private EMFHandleManager handles;
    private Dimension device;

    public EMFOutputStream(OutputStream os, Rectangle imageBounds, EMFHandleManager handles, String application, String name, Dimension device, int version) throws IOException {
        super(os, new EMFTagSet(version), null, true);
        this.version = version;
        this.imageBounds = imageBounds;
        this.handles = handles;
        this.application = application;
        this.name = name;
        this.device = device;
        this.pushBuffer();
    }

    public EMFOutputStream(OutputStream os, Rectangle imageBounds, EMFHandleManager handles, String application, String name, Dimension device) throws IOException {
        this(os, imageBounds, handles, application, name, device, 1);
    }

    public void close() throws IOException {
        int len = this.popBuffer();
        ++this.recordCount;
        EMFHeader header = new EMFHeader(this.imageBounds, this.getVersion(), 0, len, this.recordCount, this.handles.maxHandlesUsed(), this.application, this.name, this.device);
        this.writeHeader(header);
        this.append();
        super.close();
    }

    public void writeDWORD(int i) throws IOException {
        this.writeUnsignedInt(i);
    }

    public void writeDWORD(int[] w) throws IOException {
        for (int i = 0; i < w.length; ++i) {
            this.writeDWORD(w[i]);
        }
    }

    public void writeWORD(int s) throws IOException {
        this.writeUnsignedShort(s);
    }

    public void writeFLOAT(float f) throws IOException {
        this.writeFloat(f);
    }

    public void writeCOLORREF(Color c) throws IOException {
        this.writeByte(c.getRed());
        this.writeByte(c.getGreen());
        this.writeByte(c.getBlue());
        this.writeByte(0);
    }

    public void writeCOLOR16(Color c) throws IOException {
        this.writeShort(c.getRed() << 8);
        this.writeShort(c.getGreen() << 8);
        this.writeShort(c.getBlue() << 8);
        this.writeShort(c.getAlpha() << 8);
    }

    public void writeXFORM(AffineTransform t) throws IOException {
        this.writeFLOAT((float)t.getScaleX());
        this.writeFLOAT((float)t.getShearY());
        this.writeFLOAT((float)t.getShearX());
        this.writeFLOAT((float)t.getScaleY());
        this.writeFLOAT((float)t.getTranslateX());
        this.writeFLOAT((float)t.getTranslateY());
    }

    public void writePOINTS(Point[] p) throws IOException {
        this.writePOINTS(p.length, p);
    }

    public void writePOINTS(int n, Point[] p) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.writePOINTS(p[i]);
        }
    }

    public void writePOINTS(Point p) throws IOException {
        this.writeSHORT((short)p.x);
        this.writeSHORT((short)p.y);
    }

    public void writePOINTL(Point[] p) throws IOException {
        this.writePOINTL(p.length, p);
    }

    public void writePOINTL(int n, Point[] p) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.writePOINTL(p[i]);
        }
    }

    public void writePOINTL(Point p) throws IOException {
        this.writeLONG(p.x);
        this.writeLONG(p.y);
    }

    public void writeRECTL(Rectangle r) throws IOException {
        this.writeLONG(r.x);
        this.writeLONG(r.y);
        this.writeLONG(r.x + r.width);
        this.writeLONG(r.y + r.height);
    }

    public void writeSIZEL(Dimension d) throws IOException {
        this.writeLONG(d.width);
        this.writeLONG(d.height);
    }

    public void writeUINT(int i) throws IOException {
        this.writeUnsignedInt(i);
    }

    public void writeULONG(int i) throws IOException {
        this.writeUnsignedInt(i);
    }

    public void writeLONG(int i) throws IOException {
        this.writeInt(i);
    }

    public void writeSHORT(short i) throws IOException {
        this.writeShort(i);
    }

    public void writeBYTE(byte[] b) throws IOException {
        this.writeByte(b);
    }

    public void writeBYTE(byte b) throws IOException {
        this.writeByte(b);
    }

    public void writeBYTE(int b) throws IOException {
        this.writeByte(b);
    }

    public void writeBYTE(boolean b) throws IOException {
        this.writeBYTE(b ? 1 : 0);
    }

    public void writeWORD(boolean b) throws IOException {
        this.writeWORD(b ? 1 : 0);
    }

    public void writeDWORD(boolean b) throws IOException {
        this.writeDWORD(b ? 1 : 0);
    }

    public void writeWCHAR(String s) throws IOException {
        this.writeByte(s.getBytes("UTF-16LE"));
    }

    public void writeWCHAR(String s, int size) throws IOException {
        this.writeWCHAR(s);
        for (int i = size - s.length(); i > 0; --i) {
            this.writeWORD(0);
        }
    }

    protected int getTagAlignment() {
        return 4;
    }

    protected void writeTagHeader(TagHeader header) throws IOException {
        int tagID = header.getTag();
        long length = header.getLength();
        this.writeUnsignedInt(tagID);
        this.writeUnsignedInt(length + 8L);
    }

    public void writeTag(Tag tag) throws IOException {
        ++this.recordCount;
        super.writeTag(tag);
    }

    protected void writeActionHeader(ActionHeader header) throws IOException {
    }

    public void writeHeader(EMFHeader header) throws IOException {
        header.write(this);
    }

    public int getVersion() {
        return this.version;
    }
}

