/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.gui.menu;

import com.baselet.control.Main;
import com.baselet.control.constants.MenuConstants;
import com.baselet.control.enums.Program;
import com.baselet.diagram.CurrentDiagram;
import com.baselet.diagram.DiagramHandler;
import com.baselet.diagram.DrawPanel;
import com.baselet.diagram.SelectorOld;
import com.baselet.diagram.io.ClassChooser;
import com.baselet.element.interfaces.GridElement;
import com.baselet.element.old.custom.CustomElement;
import com.baselet.generator.ClassDiagramConverter;
import com.baselet.gui.BaseGUI;
import com.baselet.gui.BrowserLauncher;
import com.baselet.gui.CurrentGui;
import com.baselet.gui.OptionPanel;
import com.baselet.gui.command.Align;
import com.baselet.gui.command.ChangeElementSetting;
import com.baselet.gui.command.Copy;
import com.baselet.gui.command.Cut;
import com.baselet.gui.command.Paste;
import com.baselet.gui.command.RemoveElement;
import com.baselet.gui.menu.AboutDialog;
import com.baselet.gui.menu.GenerateOptionPanel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class MenuFactory {
    protected List<JComponent> diagramDependendComponents = new ArrayList<JComponent>();

    public void doAction(final String menuItem, final Object param) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SelectorOld actualSelector;
                Main main = Main.getInstance();
                BaseGUI gui = CurrentGui.getInstance().getGui();
                DiagramHandler diagramHandler = gui.getCurrentDiagram().getHandler();
                DiagramHandler actualHandler = CurrentDiagram.getInstance().getDiagramHandler();
                SelectorOld selectorOld = actualSelector = actualHandler == null ? null : actualHandler.getDrawPanel().getSelector();
                if (menuItem.equals("New")) {
                    main.doNew();
                } else if (menuItem.equals("Open...")) {
                    main.doOpenFromFileChooser();
                } else if (menuItem.equals("Recent files")) {
                    main.doOpen((String)param);
                } else if (menuItem.equals("Generate Class Elements from Files or Directory...")) {
                    new ClassDiagramConverter().createClassDiagrams(ClassChooser.getFilesToOpen());
                } else if (menuItem.equals("Generate Class Element Options...")) {
                    GenerateOptionPanel.getInstance().showPanel();
                } else if (menuItem.equals("Save") && diagramHandler != null) {
                    diagramHandler.doSave();
                } else if (menuItem.equals("Save as...") && diagramHandler != null) {
                    diagramHandler.doSaveAs(Program.getInstance().getExtension());
                } else if (menuItem.equals("Export as...") && diagramHandler != null) {
                    diagramHandler.doSaveAs((String)param);
                } else if (menuItem.equals("Mail to...")) {
                    gui.setMailPanelEnabled(!gui.isMailPanelVisible());
                } else if (menuItem.equals("Edit Current Palette")) {
                    main.doOpen(main.getPalette().getFileHandler().getFullPathName());
                } else if (menuItem.equals("Options...")) {
                    OptionPanel.getInstance().showOptionPanel();
                } else if (menuItem.equals("Print...") && diagramHandler != null) {
                    diagramHandler.doPrint();
                } else if (menuItem.equals("Exit")) {
                    CurrentGui.getInstance().getGui().closeWindow();
                } else if (menuItem.equals("Undo") && actualHandler != null && actualSelector != null) {
                    actualHandler.getController().undo();
                } else if (menuItem.equals("Redo") && actualHandler != null) {
                    actualHandler.getController().redo();
                } else if (menuItem.equals("Delete") && actualHandler != null && actualSelector != null) {
                    List<GridElement> v = actualSelector.getSelectedElements();
                    if (v.size() > 0) {
                        actualHandler.getController().executeCommand(new RemoveElement(v));
                    }
                } else if (menuItem.equals("Select All") && actualHandler != null && actualSelector != null) {
                    actualSelector.selectAll();
                } else if (menuItem.equals("Group") && actualHandler != null && actualSelector != null) {
                    actualHandler.getController().executeCommand(new ChangeElementSetting("group", actualSelector.getUnusedGroup().toString(), actualSelector.getSelectedElements()));
                } else if (menuItem.equals("Ungroup") && actualHandler != null && actualSelector != null) {
                    actualHandler.getController().executeCommand(new ChangeElementSetting("group", null, actualSelector.getSelectedElements()));
                } else if (menuItem.equals("Cut") && actualHandler != null) {
                    if (!actualHandler.getDrawPanel().getGridElements().isEmpty()) {
                        actualHandler.getController().executeCommand(new Cut());
                    }
                } else if (menuItem.equals("Copy") && actualHandler != null) {
                    if (!actualHandler.getDrawPanel().getGridElements().isEmpty()) {
                        actualHandler.getController().executeCommand(new Copy());
                    }
                } else if (menuItem.equals("Paste") && actualHandler != null) {
                    actualHandler.getController().executeCommand(new Paste());
                } else if (menuItem.equals("New...")) {
                    if (gui.getCurrentCustomHandler().closeEntity()) {
                        gui.setCustomPanelEnabled(true);
                        gui.getCurrentCustomHandler().getPanel().setCustomElementIsNew(true);
                        gui.getCurrentCustomHandler().newEntity();
                    }
                } else if (menuItem.equals("New from Template")) {
                    if (gui.getCurrentCustomHandler().closeEntity()) {
                        gui.setCustomPanelEnabled(true);
                        gui.getCurrentCustomHandler().getPanel().setCustomElementIsNew(true);
                        gui.getCurrentCustomHandler().newEntity((String)param);
                    }
                } else if (menuItem.equals("Edit Selected...")) {
                    GridElement entity = main.getEditedGridElement();
                    if (entity != null && entity instanceof CustomElement && gui.getCurrentCustomHandler().closeEntity()) {
                        gui.setCustomPanelEnabled(true);
                        gui.getCurrentCustomHandler().getPanel().setCustomElementIsNew(false);
                        gui.getCurrentCustomHandler().editEntity((CustomElement)entity);
                    }
                } else if (menuItem.equals("Custom Elements Tutorial...")) {
                    BrowserLauncher.openURL("http://www.umlet.com/ce/ce.htm");
                } else if (menuItem.equals("Online Help...")) {
                    BrowserLauncher.openURL(Program.getInstance().getWebsite() + "/faq.htm");
                } else if (menuItem.equals("Online Sample Diagrams...")) {
                    BrowserLauncher.openURL("http://www.itmeyer.at/umlet/uml2/");
                } else if (menuItem.equals("Video Tutorial: Basic Use and Custom Elements...")) {
                    BrowserLauncher.openURL("http://www.youtube.com/watch?v=3UHZedDtr28");
                } else if (menuItem.equals(MenuConstants.PROGRAM_HOMEPAGE)) {
                    BrowserLauncher.openURL(Program.getInstance().getWebsite());
                } else if (menuItem.equals(MenuConstants.RATE_PROGRAM)) {
                    BrowserLauncher.openURL("http://marketplace.eclipse.org/content/umlet-uml-tool-fast-uml-diagrams");
                } else if (menuItem.equals(MenuConstants.ABOUT_PROGRAM)) {
                    AboutDialog.show();
                } else if (menuItem.equals("Set foreground color") && actualHandler != null && actualSelector != null) {
                    actualHandler.getController().executeCommand(new ChangeElementSetting("fg", (String)param, actualSelector.getSelectedElements()));
                } else if (menuItem.equals("Set background color") && actualHandler != null && actualSelector != null) {
                    actualHandler.getController().executeCommand(new ChangeElementSetting("bg", (String)param, actualSelector.getSelectedElements()));
                } else if (menuItem.equals("Align") && actualHandler != null && actualSelector != null) {
                    List<GridElement> v = actualSelector.getSelectedElements();
                    if (v.size() > 0) {
                        actualHandler.getController().executeCommand(new Align(v, actualSelector.getDominantEntity(), (String)param));
                    }
                } else if (menuItem.equals("Layer") && actualHandler != null && actualSelector != null) {
                    int change = param.equals("to back (layer -1)") ? -1 : 1;
                    HashMap<GridElement, String> valueMap = new HashMap<GridElement, String>();
                    for (GridElement e : actualSelector.getSelectedElements()) {
                        valueMap.put(e, Integer.toString(e.getLayer() + change));
                    }
                    actualHandler.getController().executeCommand(new ChangeElementSetting("layer", valueMap));
                }
            }
        });
    }

    public void updateDiagramDependendComponents() {
        DrawPanel currentDiagram = CurrentGui.getInstance().getGui().getCurrentDiagram();
        if (currentDiagram == null) {
            return;
        }
        DiagramHandler handler = currentDiagram.getHandler();
        boolean enable = handler != null && !handler.getDrawPanel().getGridElements().isEmpty();
        for (JComponent component : this.diagramDependendComponents) {
            component.setEnabled(enable);
        }
    }
}

