/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser.stylehandler.border;

import java.util.HashMap;
import java.util.Map;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.border.BorderStyleKeys;
import org.jfree.layouting.input.style.parser.CSSValueFactory;
import org.jfree.layouting.input.style.parser.stylehandler.border.BorderStyleReadHandler;
import org.jfree.layouting.input.style.parser.stylehandler.color.ColorReadHandler;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.w3c.css.sac.LexicalUnit;

public class BorderReadHandler
extends BorderStyleReadHandler {
    public Map createValues(LexicalUnit lexicalUnit) {
        CSSConstant cSSConstant;
        CSSNumericValue cSSNumericValue = CSSValueFactory.createLengthValue(lexicalUnit);
        if (cSSNumericValue != null) {
            lexicalUnit = lexicalUnit.getNextLexicalUnit();
        }
        if (lexicalUnit != null) {
            cSSConstant = (CSSConstant)this.lookupValue(lexicalUnit);
            if (cSSConstant != null) {
                lexicalUnit = lexicalUnit.getNextLexicalUnit();
            }
        } else {
            cSSConstant = null;
        }
        CSSValue cSSValue = lexicalUnit != null ? ColorReadHandler.createColorValue(lexicalUnit) : null;
        HashMap<StyleKey, CSSValue> hashMap = new HashMap<StyleKey, CSSValue>();
        if (cSSNumericValue != null) {
            hashMap.put(BorderStyleKeys.BORDER_TOP_WIDTH, cSSNumericValue);
            hashMap.put(BorderStyleKeys.BORDER_LEFT_WIDTH, cSSNumericValue);
            hashMap.put(BorderStyleKeys.BORDER_BOTTOM_WIDTH, cSSNumericValue);
            hashMap.put(BorderStyleKeys.BORDER_RIGHT_WIDTH, cSSNumericValue);
        }
        if (cSSConstant != null) {
            hashMap.put(BorderStyleKeys.BORDER_TOP_STYLE, cSSConstant);
            hashMap.put(BorderStyleKeys.BORDER_LEFT_STYLE, cSSConstant);
            hashMap.put(BorderStyleKeys.BORDER_BOTTOM_STYLE, cSSConstant);
            hashMap.put(BorderStyleKeys.BORDER_RIGHT_STYLE, cSSConstant);
        }
        if (cSSValue != null) {
            hashMap.put(BorderStyleKeys.BORDER_TOP_COLOR, cSSValue);
            hashMap.put(BorderStyleKeys.BORDER_LEFT_COLOR, cSSValue);
            hashMap.put(BorderStyleKeys.BORDER_BOTTOM_COLOR, cSSValue);
            hashMap.put(BorderStyleKeys.BORDER_RIGHT_COLOR, cSSValue);
        }
        return hashMap;
    }
}

