/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.ActionConfiguration;
import org.gradle.api.attributes.AttributeCompatibilityRule;
import org.gradle.api.attributes.CompatibilityCheckDetails;
import org.gradle.api.attributes.CompatibilityRuleChain;
import org.gradle.api.internal.DefaultActionConfiguration;
import org.gradle.api.internal.attributes.AttributeMatchException;
import org.gradle.api.internal.attributes.AttributeMatchingRules;
import org.gradle.api.internal.attributes.CompatibilityCheckResult;
import org.gradle.api.internal.attributes.CompatibilityRule;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.model.internal.type.ModelType;

public class DefaultCompatibilityRuleChain<T>
implements CompatibilityRuleChain<T>,
CompatibilityRule<T> {
    private static final Object[] NO_PARAMS = new Object[0];
    private final List<Action<? super CompatibilityCheckDetails<T>>> rules = Lists.newArrayList();
    private final Instantiator instantiator;

    public DefaultCompatibilityRuleChain(Instantiator instantiator) {
        this.instantiator = instantiator;
    }

    public void ordered(Comparator<? super T> comparator) {
        Action<CompatibilityCheckDetails<? super T>> rule = AttributeMatchingRules.orderedCompatibility(comparator, false);
        this.rules.add(rule);
    }

    public void reverseOrdered(Comparator<? super T> comparator) {
        Action<CompatibilityCheckDetails<? super T>> rule = AttributeMatchingRules.orderedCompatibility(comparator, true);
        this.rules.add(rule);
    }

    public void add(Class<? extends AttributeCompatibilityRule<T>> rule, Action<? super ActionConfiguration> configureAction) {
        DefaultActionConfiguration configuration = new DefaultActionConfiguration();
        configureAction.execute((Object)configuration);
        this.rules.add(new InstantiatingAction(rule, configuration.getParams(), this.instantiator));
    }

    public void add(Class<? extends AttributeCompatibilityRule<T>> rule) {
        this.rules.add(new InstantiatingAction(rule, NO_PARAMS, this.instantiator));
    }

    public void assumeCompatibleWhenMissing() {
    }

    public void execute(CompatibilityCheckResult<T> result) {
        for (Action<? super CompatibilityCheckDetails<T>> action : this.rules) {
            action.execute(result);
            if (!result.hasResult()) continue;
            return;
        }
    }

    private static class InstantiatingAction<T>
    implements Action<CompatibilityCheckDetails<T>> {
        private final Class<? extends AttributeCompatibilityRule<T>> rule;
        private final Object[] params;
        private final Instantiator instantiator;

        InstantiatingAction(Class<? extends AttributeCompatibilityRule<T>> rule, Object[] params, Instantiator instantiator) {
            this.rule = rule;
            this.params = params;
            this.instantiator = instantiator;
        }

        public void execute(CompatibilityCheckDetails<T> details) {
            try {
                AttributeCompatibilityRule instance = (AttributeCompatibilityRule)this.instantiator.newInstance(this.rule, this.params);
                instance.execute(details);
            }
            catch (Throwable t) {
                throw new AttributeMatchException(String.format("Could not determine whether value %s is compatible with value %s using %s.", details.getProducerValue(), details.getConsumerValue(), ModelType.of(this.rule).getDisplayName()), t);
            }
        }
    }
}

