/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.compiled;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.diagnostic.PluginException;
import org.jetbrains.kotlin.com.intellij.ide.highlighter.JavaClassFileType;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginManagerCore;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.FileASTNode;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginId;
import org.jetbrains.kotlin.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressManager;
import org.jetbrains.kotlin.com.intellij.openapi.project.DefaultProjectFactory;
import org.jetbrains.kotlin.com.intellij.openapi.project.IndexNotReadyException;
import org.jetbrains.kotlin.com.intellij.openapi.roots.FileIndexFacade;
import org.jetbrains.kotlin.com.intellij.openapi.ui.Queryable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Computable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.ModificationTracker;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.ClassFileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassOwnerEx;
import org.jetbrains.kotlin.com.intellij.psi.PsiCompiledFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFileFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiFileSystemItem;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportList;
import org.jetbrains.kotlin.com.intellij.psi.PsiInvalidElementAccessException;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackageStatement;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.compiled.ClassFileDecompilers;
import org.jetbrains.kotlin.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.JavaPsiImplementationHelper;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiFileEx;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsCustomNavigationPolicy;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsCustomNavigationPolicyEx;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsElementImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsPackageStatementImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.InnerClassSourceStrategy;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.OutOfOrderInnerClassException;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.StubBuildingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiClassStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileWithStubSupport;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.FileContextUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.scope.ElementClassHint;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.search.PsiElementProcessor;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiClassHolderFileStub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubTree;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubTreeLoader;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.reference.SoftReference;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.cls.ClsFormatException;
import org.jetbrains.org.objectweb.asm.Attribute;
import org.jetbrains.org.objectweb.asm.ClassReader;

public class ClsFileImpl
extends ClsRepositoryPsiElement<PsiClassHolderFileStub>
implements Queryable,
PsiClassOwnerEx,
PsiCompiledFile,
PsiJavaFile,
PsiFileEx,
PsiFileWithStubSupport {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.compiled.ClsFileImpl");
    private static final Key<Document> CLS_DOCUMENT_LINK_KEY = Key.create("cls.document.link");
    private final Object myMirrorLock;
    private final Object myStubLock;
    private final FileViewProvider myViewProvider;
    private final boolean myIsForDecompiling;
    private volatile SoftReference<StubTree> myStub;
    private volatile TreeElement myMirrorFileElement;
    private volatile ClsPackageStatementImpl myPackageStatement;
    private volatile LanguageLevel myLanguageLevel;
    private boolean myIsPhysical;
    private boolean myInvalidated;
    private static final InnerClassSourceStrategy<VirtualFile> STRATEGY = new InnerClassSourceStrategy<VirtualFile>(){

        @Override
        @Nullable
        public VirtualFile findInnerClass(String innerName2, VirtualFile outerClass) {
            String baseName = outerClass.getNameWithoutExtension();
            VirtualFile dir = outerClass.getParent();
            assert (dir != null) : outerClass;
            return dir.findChild(baseName + '$' + innerName2 + ".class");
        }

        @Override
        public void accept(VirtualFile innerClass, StubBuildingVisitor<VirtualFile> visitor2) {
            try {
                byte[] bytes = innerClass.contentsToByteArray(false);
                new ClassReader(bytes).accept(visitor2, EMPTY_ATTRIBUTES, 4);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    };
    public static final Attribute[] EMPTY_ATTRIBUTES = new Attribute[0];

    public ClsFileImpl(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl", "<init>"));
        }
        this(viewProvider, false);
    }

    private ClsFileImpl(@NotNull FileViewProvider viewProvider, boolean forDecompiling) {
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl", "<init>"));
        }
        super(null);
        this.myMirrorLock = new Object();
        this.myStubLock = new Object();
        this.myIsPhysical = true;
        this.myViewProvider = viewProvider;
        this.myIsForDecompiling = forDecompiling;
        JavaElementType.CLASS.getIndex();
    }

    @Override
    public PsiManager getManager() {
        return this.myViewProvider.getManager();
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myViewProvider.getVirtualFile();
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl", "getVirtualFile"));
        }
        return virtualFile;
    }

    @Override
    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor) {
        return true;
    }

    @Override
    public PsiDirectory getParent() {
        return this.getContainingDirectory();
    }

    @Override
    public PsiDirectory getContainingDirectory() {
        VirtualFile parentFile = this.getVirtualFile().getParent();
        if (parentFile == null) {
            return null;
        }
        return this.getManager().findDirectory(parentFile);
    }

    @Override
    public PsiFile getContainingFile() {
        if (!this.isValid()) {
            throw new PsiInvalidElementAccessException(this);
        }
        return this;
    }

    @Override
    public boolean isValid() {
        return !this.myInvalidated && (this.myIsForDecompiling || this.getVirtualFile().isValid());
    }

    boolean isForDecompiling() {
        return this.myIsForDecompiling;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.getVirtualFile().getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = this.getClasses();
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl", "getChildren"));
        }
        return psiElementArray;
    }

    @Override
    @NotNull
    public PsiClass[] getClasses() {
        PsiClass[] psiClassArray = this.getStub().getClasses();
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl", "getClasses"));
        }
        return psiClassArray;
    }

    @Override
    public PsiPackageStatement getPackageStatement() {
        this.getStub();
        ClsPackageStatementImpl statement = this.myPackageStatement;
        if (statement == null) {
            statement = new ClsPackageStatementImpl(this);
        }
        return statement.getPackageName() != null ? statement : null;
    }

    @Override
    @NotNull
    public String getPackageName() {
        PsiPackageStatement statement = this.getPackageStatement();
        String string = statement == null ? "" : statement.getPackageName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl", "getPackageName"));
        }
        return string;
    }

    @Override
    public void setPackageName(String packageName) throws IncorrectOperationException {
        throw new IncorrectOperationException("Cannot set package name for compiled files");
    }

    @Override
    public PsiImportList getImportList() {
        return null;
    }

    @Override
    public boolean importClass(PsiClass aClass2) {
        throw new UnsupportedOperationException("Cannot add imports to compiled classes");
    }

    @Override
    @NotNull
    public PsiElement[] getOnDemandImports(boolean includeImplicit, boolean checkIncludes) {
        if (PsiJavaCodeReferenceElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl", "getOnDemandImports"));
        }
        return PsiJavaCodeReferenceElement.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public PsiClass[] getSingleClassImports(boolean checkIncludes) {
        if (PsiClass.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl", "getSingleClassImports"));
        }
        return PsiClass.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public String[] getImplicitlyImportedPackages() {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl", "getImplicitlyImportedPackages"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    public Set<String> getClassNames() {
        return Collections.singleton(this.getVirtualFile().getNameWithoutExtension());
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement[] getImplicitlyImportedPackageReferences() {
        if (PsiJavaCodeReferenceElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl", "getImplicitlyImportedPackageReferences"));
        }
        return PsiJavaCodeReferenceElement.EMPTY_ARRAY;
    }

    @Override
    public PsiJavaCodeReferenceElement findImportReferenceTo(PsiClass aClass2) {
        return null;
    }

    @Override
    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel level = this.myLanguageLevel;
        if (level == null) {
            List classes2 = ApplicationManager.getApplication().runReadAction(new Computable<List>(){

                @Override
                public List compute() {
                    return ClsFileImpl.this.getStub().getChildrenStubs();
                }
            });
            level = !classes2.isEmpty() ? ((PsiClassStub)classes2.get(0)).getLanguageLevel() : LanguageLevel.HIGHEST;
            this.myLanguageLevel = level;
        }
        LanguageLevel languageLevel = level;
        if (languageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl", "getLanguageLevel"));
        }
        return languageLevel;
    }

    @Override
    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl", "setName"));
        }
        throw ClsFileImpl.cannotModifyException(this);
    }

    @Override
    public void checkSetName(String name2) throws IncorrectOperationException {
        throw ClsFileImpl.cannotModifyException(this);
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl", "appendMirrorText"));
        }
        buffer.append("\n  // IntelliJ API Decompiler stub source generated from a class file\n  // Implementation of methods is not available\n\n");
        ClsFileImpl.appendText(this.getPackageStatement(), 0, buffer, "\n\n");
        PsiClass[] classes2 = this.getClasses();
        if (classes2.length > 0) {
            ClsFileImpl.appendText(classes2[0], 0, buffer);
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl", "setMirror"));
        }
        Object mirrorElement = SourceTreeToPsiMap.treeToPsiNotNull(element);
        if (!(mirrorElement instanceof PsiJavaFile)) {
            throw new ClsElementImpl.InvalidMirrorException("Unexpected mirror file: " + mirrorElement);
        }
        PsiJavaFile mirrorFile = (PsiJavaFile)mirrorElement;
        ClsFileImpl.setMirrorIfPresent(this.getPackageStatement(), mirrorFile.getPackageStatement());
        ClsFileImpl.setMirrors((PsiElement[])this.getClasses(), (PsiElement[])mirrorFile.getClasses());
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        for (ClsCustomNavigationPolicy customNavigationPolicy : Extensions.getExtensions(ClsCustomNavigationPolicy.EP_NAME)) {
            PsiFile psiFile;
            if (!(customNavigationPolicy instanceof ClsCustomNavigationPolicyEx)) continue;
            try {
                PsiFile navigationElement = ((ClsCustomNavigationPolicyEx)customNavigationPolicy).getFileNavigationElement(this);
                if (navigationElement == null) continue;
                psiFile = navigationElement;
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            if (psiFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl", "getNavigationElement"));
            }
            return psiFile;
        }
        PsiElement psiElement = CachedValuesManager.getCachedValue(this, new CachedValueProvider<PsiElement>(){

            @Override
            @Nullable
            public CachedValueProvider.Result<PsiElement> compute() {
                PsiElement target = JavaPsiImplementationHelper.getInstance(ClsFileImpl.this.getProject()).getClsFileNavigationElement(ClsFileImpl.this);
                ModificationTracker tracker = FileIndexFacade.getInstance(ClsFileImpl.this.getProject()).getRootModificationTracker();
                return CachedValueProvider.Result.create(target, ClsFileImpl.this, target.getContainingFile(), tracker);
            }
        });
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl", "getNavigationElement"));
        }
        return psiElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PsiElement getMirror() {
        TreeElement mirrorTreeElement = this.myMirrorFileElement;
        if (mirrorTreeElement == null) {
            Object object = this.myMirrorLock;
            synchronized (object) {
                mirrorTreeElement = this.myMirrorFileElement;
                if (mirrorTreeElement == null) {
                    VirtualFile file2 = this.getVirtualFile();
                    PsiClass[] classes2 = this.getClasses();
                    String fileName = (classes2.length > 0 ? classes2[0].getName() : file2.getNameWithoutExtension()) + ".java";
                    final Document document = FileDocumentManager.getInstance().getDocument(file2);
                    assert (document != null) : file2.getUrl();
                    CharSequence mirrorText = document.getImmutableCharSequence();
                    boolean internalDecompiler = StringUtil.startsWith(mirrorText, "\n  // IntelliJ API Decompiler stub source generated from a class file\n  // Implementation of methods is not available\n\n");
                    PsiFileFactory factory2 = PsiFileFactory.getInstance(this.getManager().getProject());
                    PsiFile mirror = factory2.createFileFromText(fileName, JavaLanguage.INSTANCE, mirrorText, false, false);
                    mirror.putUserData(PsiUtil.FILE_LANGUAGE_LEVEL_KEY, this.getLanguageLevel());
                    mirrorTreeElement = SourceTreeToPsiMap.psiToTreeNotNull(mirror);
                    try {
                        final TreeElement finalMirrorTreeElement = mirrorTreeElement;
                        ProgressManager.getInstance().executeNonCancelableSection(new Runnable(){

                            @Override
                            public void run() {
                                ClsFileImpl.this.setMirror(finalMirrorTreeElement);
                                ClsFileImpl.this.putUserData(CLS_DOCUMENT_LINK_KEY, document);
                            }
                        });
                    }
                    catch (ClsElementImpl.InvalidMirrorException e) {
                        LOG.error(file2.getUrl(), internalDecompiler ? e : ClsFileImpl.wrapException(e, file2));
                    }
                    ((PsiFileImpl)mirror).setOriginalFile(this);
                    this.myMirrorFileElement = mirrorTreeElement;
                }
            }
        }
        return mirrorTreeElement.getPsi();
    }

    @Override
    public String getText() {
        VirtualFile file2 = this.getVirtualFile();
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        assert (document != null) : file2.getUrl();
        return document.getText();
    }

    @Override
    public int getTextLength() {
        VirtualFile file2 = this.getVirtualFile();
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        assert (document != null) : file2.getUrl();
        return document.getTextLength();
    }

    private static Exception wrapException(ClsElementImpl.InvalidMirrorException e, VirtualFile file2) {
        PluginId pluginId;
        ClassFileDecompilers.Decompiler decompiler = ClassFileDecompilers.find(file2);
        if (decompiler instanceof ClassFileDecompilers.Light && (pluginId = PluginManagerCore.getPluginByClassName(decompiler.getClass().getName())) != null) {
            return new PluginException(e, pluginId);
        }
        return e;
    }

    @Override
    public PsiFile getDecompiledPsiFile() {
        return (PsiFile)this.getMirror();
    }

    @Override
    public long getModificationStamp() {
        return this.getVirtualFile().getModificationStamp();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitJavaFile(this);
        } else {
            visitor2.visitFile(this);
        }
    }

    @Override
    @NonNls
    public String toString() {
        return "PsiFile:" + this.getName();
    }

    @Override
    @NotNull
    public PsiFile getOriginalFile() {
        ClsFileImpl clsFileImpl = this;
        if (clsFileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl", "getOriginalFile"));
        }
        return clsFileImpl;
    }

    @Override
    @NotNull
    public FileType getFileType() {
        JavaClassFileType javaClassFileType = JavaClassFileType.INSTANCE;
        if (javaClassFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl", "getFileType"));
        }
        return javaClassFileType;
    }

    @Override
    @NotNull
    public PsiFile[] getPsiRoots() {
        PsiFile[] psiFileArray = new PsiFile[]{this};
        if (psiFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl", "getPsiRoots"));
        }
        return psiFileArray;
    }

    @Override
    @NotNull
    public FileViewProvider getViewProvider() {
        FileViewProvider fileViewProvider = this.myViewProvider;
        if (fileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl", "getViewProvider"));
        }
        return fileViewProvider;
    }

    @Override
    public void subtreeChanged() {
    }

    @Override
    public PsiElement getContext() {
        return FileContextUtil.getFileContext(this);
    }

    @Override
    @NotNull
    public PsiClassHolderFileStub<?> getStub() {
        PsiClassHolderFileStub psiClassHolderFileStub = (PsiClassHolderFileStub)this.getStubTree().getRoot();
        if (psiClassHolderFileStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl", "getStub"));
        }
        return psiClassHolderFileStub;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl", "processDeclarations"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl", "processDeclarations"));
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        ElementClassHint classHint = processor.getHint(ElementClassHint.KEY);
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            PsiClass[] classes2;
            for (PsiClass aClass2 : classes2 = this.getClasses()) {
                if (processor.execute(aClass2, state2)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public StubTree getStubTree() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        StubTree stubTree = SoftReference.dereference(this.myStub);
        if (stubTree != null) {
            StubTree stubTree2 = stubTree;
            if (stubTree2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl", "getStubTree"));
            }
            return stubTree2;
        }
        StubTree newStubTree = (StubTree)StubTreeLoader.getInstance().readOrBuild(this.getProject(), this.getVirtualFile(), this);
        if (newStubTree == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No stub for class file in index: " + this.getVirtualFile().getPresentableUrl());
            }
            newStubTree = new StubTree(new PsiJavaFileStubImpl("corrupted_class_files", true));
        }
        Object object = this.myStubLock;
        synchronized (object) {
            stubTree = SoftReference.dereference(this.myStub);
            if (stubTree != null) {
                StubTree stubTree3 = stubTree;
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl18 : MonitorExitStatement: MONITOREXIT : var3_3
                if (stubTree3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl", "getStubTree"));
                }
                return stubTree3;
            }
            stubTree = newStubTree;
            PsiFileStubImpl fileStub = (PsiFileStubImpl)stubTree.getRoot();
            fileStub.setPsi(this);
            this.myStub = new SoftReference<StubTree>(stubTree);
        }
        StubTree stubTree4 = stubTree;
        if (stubTree4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl", "getStubTree"));
        }
        return stubTree4;
    }

    @Override
    public ASTNode findTreeForStub(StubTree tree, StubElement<?> stub) {
        return null;
    }

    @Override
    public boolean isContentsLoaded() {
        return this.myStub != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onContentReload() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Object object = this.myStubLock;
        synchronized (object) {
            StubTree stubTree = SoftReference.dereference(this.myStub);
            this.myStub = null;
            if (stubTree != null) {
                ((PsiFileStubImpl)stubTree.getRoot()).clearPsi("cls onContentReload");
            }
        }
        ClsPackageStatementImpl packageStatement = new ClsPackageStatementImpl(this);
        Object object2 = this.myMirrorLock;
        synchronized (object2) {
            this.putUserData(CLS_DOCUMENT_LINK_KEY, null);
            this.myMirrorFileElement = null;
            this.myPackageStatement = packageStatement;
        }
        this.myLanguageLevel = null;
    }

    @Override
    public void markInvalidated() {
        this.myInvalidated = true;
        DebugUtil.onInvalidated(this);
    }

    @Override
    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl", "putInfo"));
        }
        PsiFileImpl.putInfo(this, info);
    }

    @Override
    public FileASTNode getNode() {
        return null;
    }

    @Override
    public boolean isPhysical() {
        return this.myIsPhysical;
    }

    public void setPhysical(boolean isPhysical) {
        this.myIsPhysical = isPhysical;
    }

    @NotNull
    public static CharSequence decompile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl", "decompile"));
        }
        PsiManager manager = PsiManager.getInstance(DefaultProjectFactory.getInstance().getDefaultProject());
        final ClsFileImpl clsFile = new ClsFileImpl(new ClassFileViewProvider(manager, file2), true);
        final StringBuilder buffer = new StringBuilder();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                clsFile.appendMirrorText(0, buffer);
            }
        });
        StringBuilder stringBuilder = buffer;
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl", "decompile"));
        }
        return stringBuilder;
    }

    @Nullable
    public static PsiJavaFileStub buildFileStub(@NotNull VirtualFile file2, @NotNull byte[] bytes) throws ClsFormatException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl", "buildFileStub"));
        }
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl", "buildFileStub"));
        }
        try {
            if (ClassFileViewProvider.isInnerClass(file2, bytes)) {
                return null;
            }
            ClassReader reader = new ClassReader(bytes);
            String className2 = file2.getNameWithoutExtension();
            String packageName = ClsFileImpl.getPackageName(reader.getClassName());
            PsiJavaFileStubImpl stub = new PsiJavaFileStubImpl(packageName, true);
            try {
                StubBuildingVisitor<VirtualFile> visitor2 = new StubBuildingVisitor<VirtualFile>(file2, STRATEGY, stub, 0, className2);
                reader.accept(visitor2, EMPTY_ATTRIBUTES, 4);
                PsiClassStub<?> result2 = visitor2.getResult();
                if (result2 == null) {
                    return null;
                }
            }
            catch (OutOfOrderInnerClassException e) {
                return null;
            }
            return stub;
        }
        catch (Exception e) {
            throw new ClsFormatException(file2.getPath() + ": " + e.getMessage(), e);
        }
    }

    private static String getPackageName(String internalName) {
        int p = internalName.lastIndexOf(47);
        return p > 0 ? internalName.substring(0, p).replace('/', '.') : "";
    }
}

