/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceList;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsJavaCodeReferenceElementImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaClassReferenceListElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiClassReferenceListStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiClassStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiClassImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiClassReferenceType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubBase;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.io.StringRef;

public class PsiClassReferenceListStubImpl
extends StubBase<PsiReferenceList>
implements PsiClassReferenceListStub {
    @NotNull
    private final PsiReferenceList.Role myRole;
    private final StringRef[] myNames;
    private PsiClassType[] myTypes;

    public PsiClassReferenceListStubImpl(@NotNull JavaClassReferenceListElementType type2, StubElement parent2, @NotNull String[] names2, @NotNull PsiReferenceList.Role role) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/impl/PsiClassReferenceListStubImpl", "<init>"));
        }
        if (names2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/impl/PsiClassReferenceListStubImpl", "<init>"));
        }
        if (role == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "role", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/impl/PsiClassReferenceListStubImpl", "<init>"));
        }
        this(type2, parent2, PsiClassReferenceListStubImpl.toStringRefs(names2), role);
    }

    @NotNull
    private static StringRef[] toStringRefs(String[] names2) {
        StringRef[] myNames = StringRef.createArray(names2.length);
        for (int i = 0; i < names2.length; ++i) {
            myNames[i] = StringRef.fromString(names2[i]);
        }
        if (myNames == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/impl/PsiClassReferenceListStubImpl", "toStringRefs"));
        }
        return myNames;
    }

    public PsiClassReferenceListStubImpl(@NotNull JavaClassReferenceListElementType type2, StubElement parent2, @NotNull StringRef[] names2, @NotNull PsiReferenceList.Role role) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/impl/PsiClassReferenceListStubImpl", "<init>"));
        }
        if (names2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/impl/PsiClassReferenceListStubImpl", "<init>"));
        }
        if (role == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "role", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/impl/PsiClassReferenceListStubImpl", "<init>"));
        }
        super(parent2, type2);
        this.myNames = names2;
        this.myRole = role;
    }

    @Override
    @NotNull
    public PsiClassType[] getReferencedTypes() {
        if (this.myTypes != null) {
            if (this.myTypes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/impl/PsiClassReferenceListStubImpl", "getReferencedTypes"));
            }
            return this.myTypes;
        }
        if (this.myNames.length == 0) {
            this.myTypes = PsiClassType.EMPTY_ARRAY;
            if (this.myTypes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/impl/PsiClassReferenceListStubImpl", "getReferencedTypes"));
            }
            return this.myTypes;
        }
        PsiClassType[] types = new PsiClassType[this.myNames.length];
        boolean compiled = ((JavaClassReferenceListElementType)this.getStubType()).isCompiled(this);
        if (compiled) {
            for (int i = 0; i < types.length; ++i) {
                types[i] = new PsiClassReferenceType(new ClsJavaCodeReferenceElementImpl((PsiElement)this.getPsi(), StringRef.toString(this.myNames[i])), null);
            }
        } else {
            PsiElementFactory factory2 = JavaPsiFacade.getInstance(this.getProject()).getElementFactory();
            int nullCount = 0;
            PsiReferenceList psi = (PsiReferenceList)this.getPsi();
            for (int i = 0; i < types.length; ++i) {
                PsiElement context = psi;
                if (this.getParentStub() instanceof PsiClassStub) {
                    context = ((PsiClassImpl)this.getParentStub().getPsi()).calcBasesResolveContext(PsiNameHelper.getShortClassName(StringRef.toString(this.myNames[i])), psi);
                }
                try {
                    PsiJavaCodeReferenceElement ref = factory2.createReferenceFromText(StringRef.toString(this.myNames[i]), context);
                    ((PsiJavaCodeReferenceElementImpl)ref).setKindWhenDummy(1);
                    types[i] = factory2.createType(ref);
                    continue;
                }
                catch (IncorrectOperationException e) {
                    types[i] = null;
                    ++nullCount;
                }
            }
            if (nullCount > 0) {
                PsiClassType[] newTypes = new PsiClassType[types.length - nullCount];
                int cnt = 0;
                for (PsiClassType type2 : types) {
                    if (type2 == null) continue;
                    newTypes[cnt++] = type2;
                }
                types = newTypes;
            }
        }
        this.myTypes = types;
        if (types == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/impl/PsiClassReferenceListStubImpl", "getReferencedTypes"));
        }
        return types;
    }

    @Override
    @NotNull
    public String[] getReferencedNames() {
        String[] names2 = ArrayUtil.newStringArray(this.myNames.length);
        for (int i = 0; i < names2.length; ++i) {
            names2[i] = StringRef.toString(this.myNames[i]);
        }
        if (names2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/impl/PsiClassReferenceListStubImpl", "getReferencedNames"));
        }
        return names2;
    }

    @Override
    @NotNull
    public PsiReferenceList.Role getRole() {
        PsiReferenceList.Role role = this.myRole;
        if (role == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/impl/PsiClassReferenceListStubImpl", "getRole"));
        }
        return role;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PsiRefListStub[").append(this.myRole.name()).append(":");
        for (int i = 0; i < this.myNames.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(this.myNames[i]);
        }
        builder.append("]");
        return builder.toString();
    }
}

