/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.container;

import java.io.Closeable;
import java.util.ArrayList;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.container.ComponentContainer;
import org.jetbrains.kotlin.container.ComponentDescriptor;
import org.jetbrains.kotlin.container.ComponentState;
import org.jetbrains.kotlin.container.ContainerConsistencyException;
import org.jetbrains.kotlin.container.SingletonDescriptor;
import org.jetbrains.kotlin.container.SingletonDescriptor$WhenMappings;
import org.jetbrains.kotlin.container.ValueResolveContext;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH$J\b\u0010\u001f\u001a\u00020\u001bH\u0002J\b\u0010 \u001a\u00020\u000fH\u0016J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u0002H\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R!\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/container/SingletonDescriptor;", "Lorg/jetbrains/kotlin/container/ComponentDescriptor;", "Ljava/io/Closeable;", "container", "Lorg/jetbrains/kotlin/container/ComponentContainer;", "(Lorg/jetbrains/kotlin/container/ComponentContainer;)V", "getContainer", "()Lorg/jetbrains/kotlin/container/ComponentContainer;", "disposableObjects", "Ljava/util/ArrayList;", "getDisposableObjects", "()Ljava/util/ArrayList;", "disposableObjects$delegate", "Lkotlin/Lazy;", "instance", "", "shouldInjectProperties", "", "getShouldInjectProperties", "()Z", "state", "Lorg/jetbrains/kotlin/container/ComponentState;", "getState", "()Lorg/jetbrains/kotlin/container/ComponentState;", "setState", "(Lorg/jetbrains/kotlin/container/ComponentState;)V", "close", "", "createInstance", "context", "Lorg/jetbrains/kotlin/container/ValueResolveContext;", "disposeImpl", "getValue", "registerDisposableObject", "ownedObject", "kotlin-compiler"})
public abstract class SingletonDescriptor
implements Closeable,
ComponentDescriptor {
    private Object instance;
    @NotNull
    private ComponentState state;
    private final Lazy disposableObjects$delegate;
    @NotNull
    private final ComponentContainer container;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;

    @NotNull
    protected final ComponentState getState() {
        return this.state;
    }

    protected final void setState(@NotNull ComponentState componentState) {
        Intrinsics.checkParameterIsNotNull((Object)componentState, "<set-?>");
        this.state = componentState;
    }

    private final ArrayList<Closeable> getDisposableObjects() {
        Lazy lazy = this.disposableObjects$delegate;
        SingletonDescriptor singletonDescriptor = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (ArrayList)lazy.getValue();
    }

    @Override
    @NotNull
    public Object getValue() {
        if (Intrinsics.areEqual((Object)this.state, (Object)ComponentState.Corrupted)) {
            throw (Throwable)new ContainerConsistencyException("Component descriptor " + this + " is corrupted and cannot be accessed");
        }
        if (Intrinsics.areEqual((Object)this.state, (Object)ComponentState.Disposed)) {
            throw (Throwable)new ContainerConsistencyException("Component descriptor " + this + " is disposed and cannot be accessed");
        }
        if (this.instance == null) {
            this.createInstance(this.container);
        }
        Object object = this.instance;
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return object;
    }

    protected final void registerDisposableObject(@NotNull Closeable ownedObject) {
        Intrinsics.checkParameterIsNotNull(ownedObject, "ownedObject");
        this.getDisposableObjects().add(ownedObject);
    }

    @NotNull
    protected abstract Object createInstance(@NotNull ValueResolveContext var1);

    private final void createInstance(ComponentContainer container2) {
        switch (SingletonDescriptor$WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                try {
                    this.instance = this.createInstance(container2.createResolveContext(this));
                    return;
                }
                catch (Throwable ex) {
                    this.state = ComponentState.Corrupted;
                    for (Closeable disposable : this.getDisposableObjects()) {
                        disposable.close();
                    }
                    throw ex;
                }
            }
            case 2: {
                throw (Throwable)new ContainerConsistencyException("Could not create the component " + this + " because it is being initialized. Do we have undetected circular dependency?");
            }
            case 3: {
                throw (Throwable)new ContainerConsistencyException("Could not get the component " + this + ". Instance is null in Initialized state");
            }
            case 4: {
                throw (Throwable)new ContainerConsistencyException("Could not get the component " + this + " because it is corrupted");
            }
            case 5: {
                throw (Throwable)new ContainerConsistencyException("Could not get the component " + this + " because it is being disposed");
            }
            case 6: {
                throw (Throwable)new ContainerConsistencyException("Could not get the component " + this + " because it is already disposed");
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private final void disposeImpl() {
        Object wereInstance = this.instance;
        this.state = ComponentState.Disposing;
        this.instance = null;
        try {
            if (wereInstance instanceof Closeable) {
                ((Closeable)wereInstance).close();
            }
            for (Closeable disposable : this.getDisposableObjects()) {
                disposable.close();
            }
        }
        catch (Throwable ex) {
            this.state = ComponentState.Corrupted;
            throw ex;
        }
        this.state = ComponentState.Disposed;
    }

    @Override
    public void close() {
        switch (SingletonDescriptor$WhenMappings.$EnumSwitchMapping$1[this.state.ordinal()]) {
            case 1: {
                this.disposeImpl();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                throw (Throwable)new ContainerConsistencyException("The component is being initialized and cannot be disposed.");
            }
            case 5: {
                throw (Throwable)new ContainerConsistencyException("The component is already in disposing state.");
            }
            case 6: {
                throw (Throwable)new ContainerConsistencyException("The component has already been destroyed.");
            }
        }
    }

    @Override
    public boolean getShouldInjectProperties() {
        return true;
    }

    @NotNull
    public final ComponentContainer getContainer() {
        return this.container;
    }

    public SingletonDescriptor(@NotNull ComponentContainer container2) {
        Intrinsics.checkParameterIsNotNull(container2, "container");
        this.container = container2;
        this.state = ComponentState.Null;
        this.disposableObjects$delegate = LazyKt.lazy(disposableObjects.2.INSTANCE);
    }

    static {
        $$delegatedProperties = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(SingletonDescriptor.class), "disposableObjects", "getDisposableObjects()Ljava/util/ArrayList;"))};
    }
}

