/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics.rendering;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticWithParameters1Renderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticWithParameters2Renderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticWithParameters3Renderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticWithParametersMultiRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.MultiRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.SimpleDiagnosticRenderer;

public final class DiagnosticFactoryToRendererMap {
    private final Map<DiagnosticFactory<?>, DiagnosticRenderer<?>> map = new HashMap();
    private boolean immutable = false;
    private final String name;

    public DiagnosticFactoryToRendererMap(String name2) {
        this.name = name2;
    }

    public DiagnosticFactoryToRendererMap() {
        this("<unnamed>");
    }

    public String toString() {
        return "DiagnosticFactory#" + this.name;
    }

    private void checkMutability() {
        if (this.immutable) {
            throw new IllegalStateException("factory to renderer map is already immutable");
        }
    }

    public <E extends PsiElement> void put(@NotNull DiagnosticFactory0<E> factory2, @NotNull String message) {
        if (factory2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/diagnostics/rendering/DiagnosticFactoryToRendererMap", "put"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/diagnostics/rendering/DiagnosticFactoryToRendererMap", "put"));
        }
        this.checkMutability();
        this.map.put(factory2, new SimpleDiagnosticRenderer(message));
    }

    public <E extends PsiElement, A> void put(@NotNull DiagnosticFactory1<E, A> factory2, @NotNull String message, @Nullable DiagnosticParameterRenderer<? super A> rendererA) {
        if (factory2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/diagnostics/rendering/DiagnosticFactoryToRendererMap", "put"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/diagnostics/rendering/DiagnosticFactoryToRendererMap", "put"));
        }
        this.checkMutability();
        this.map.put(factory2, new DiagnosticWithParameters1Renderer<A>(message, rendererA));
    }

    public <E extends PsiElement, A> void put(@NotNull DiagnosticFactory1<E, A> factory2, @NotNull String message, @NotNull MultiRenderer<? super A> rendererA) {
        if (factory2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/diagnostics/rendering/DiagnosticFactoryToRendererMap", "put"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/diagnostics/rendering/DiagnosticFactoryToRendererMap", "put"));
        }
        if (rendererA == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rendererA", "org/jetbrains/kotlin/diagnostics/rendering/DiagnosticFactoryToRendererMap", "put"));
        }
        this.checkMutability();
        this.map.put(factory2, new DiagnosticWithParametersMultiRenderer<A>(message, rendererA));
    }

    public <E extends PsiElement, A, B> void put(@NotNull DiagnosticFactory2<E, A, B> factory2, @NotNull String message, @Nullable DiagnosticParameterRenderer<? super A> rendererA, @Nullable DiagnosticParameterRenderer<? super B> rendererB) {
        if (factory2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/diagnostics/rendering/DiagnosticFactoryToRendererMap", "put"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/diagnostics/rendering/DiagnosticFactoryToRendererMap", "put"));
        }
        this.checkMutability();
        this.map.put(factory2, new DiagnosticWithParameters2Renderer<A, B>(message, rendererA, rendererB));
    }

    public <E extends PsiElement, A, B, C> void put(@NotNull DiagnosticFactory3<E, A, B, C> factory2, @NotNull String message, @Nullable DiagnosticParameterRenderer<? super A> rendererA, @Nullable DiagnosticParameterRenderer<? super B> rendererB, @Nullable DiagnosticParameterRenderer<? super C> rendererC) {
        if (factory2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/diagnostics/rendering/DiagnosticFactoryToRendererMap", "put"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/diagnostics/rendering/DiagnosticFactoryToRendererMap", "put"));
        }
        this.checkMutability();
        this.map.put(factory2, new DiagnosticWithParameters3Renderer<A, B, C>(message, rendererA, rendererB, rendererC));
    }

    @Nullable
    public DiagnosticRenderer<?> get(@NotNull DiagnosticFactory<?> factory2) {
        if (factory2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/diagnostics/rendering/DiagnosticFactoryToRendererMap", "get"));
        }
        return this.map.get(factory2);
    }

    public void setImmutable() {
        this.immutable = false;
    }
}

