/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import com.google.common.collect.Sets;
import java.util.Set;
import org.gradle.cache.internal.ProducerGuard;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProducerGuard<T>
implements ProducerGuard<T> {
    private final Set<T> producing = Sets.newHashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> V guardByKey(T key, Factory<V> factory) {
        Object object = this.producing;
        synchronized (object) {
            while (!this.producing.add(key)) {
                try {
                    this.producing.wait();
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
        }
        try {
            object = factory.create();
            return (V)object;
        }
        finally {
            Set<T> set = this.producing;
            synchronized (set) {
                this.producing.remove(key);
                this.producing.notifyAll();
            }
        }
    }
}

