/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.local.internal;

import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.gradle.api.UncheckedIOException;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.FixedSizeOldestCacheCleanup;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheEntryWriter;
import org.gradle.caching.BuildCacheException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.BuildCacheService;
import org.gradle.internal.Factory;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.internal.resource.local.PathKeyFileStore;
import org.gradle.util.GFileUtils;

public class DirectoryBuildCacheService
implements BuildCacheService {
    private final PathKeyFileStore fileStore;
    private final PersistentCache persistentCache;

    public DirectoryBuildCacheService(CacheRepository cacheRepository, BuildOperationExecutor buildOperationExecutor, File baseDir, long targetCacheSize) {
        this.fileStore = new PathKeyFileStore(baseDir);
        this.persistentCache = cacheRepository.cache(DirectoryBuildCacheService.checkDirectory(baseDir)).withCleanup(new FixedSizeOldestCacheCleanup(buildOperationExecutor, targetCacheSize)).withDisplayName("Build cache").withLockOptions(LockOptionsBuilder.mode(FileLockManager.LockMode.None)).withCrossVersionCache(CacheBuilder.LockTarget.DefaultTarget).open();
    }

    private static File checkDirectory(File directory) {
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                throw new IllegalArgumentException(String.format("Cache directory %s must be a directory", directory));
            }
            if (!directory.canRead()) {
                throw new IllegalArgumentException(String.format("Cache directory %s must be readable", directory));
            }
            if (!directory.canWrite()) {
                throw new IllegalArgumentException(String.format("Cache directory %s must be writable", directory));
            }
        } else if (!directory.mkdirs()) {
            throw new UncheckedIOException(String.format("Could not create cache directory: %s", directory));
        }
        return directory;
    }

    public boolean load(final BuildCacheKey key, final BuildCacheEntryReader reader) throws BuildCacheException {
        return this.persistentCache.withFileLock(new Factory<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean create() {
                Boolean bl;
                LocallyAvailableResource resource = DirectoryBuildCacheService.this.fileStore.get(key.getHashCode());
                if (resource == null) {
                    return false;
                }
                GFileUtils.touch(resource.getFile());
                Closer closer = Closer.create();
                FileInputStream stream = (FileInputStream)closer.register((Closeable)new FileInputStream(resource.getFile()));
                try {
                    reader.readFrom(stream);
                    bl = true;
                }
                catch (Throwable throwable) {
                    try {
                        closer.close();
                        throw throwable;
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException((Throwable)ex);
                    }
                }
                closer.close();
                return bl;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(BuildCacheKey key, BuildCacheEntryWriter result) throws BuildCacheException {
        File tempFile;
        final String hashCode = key.getHashCode();
        try {
            tempFile = File.createTempFile(hashCode, ".part", this.persistentCache.getBaseDir());
        }
        catch (IOException ex) {
            throw new UncheckedIOException((Throwable)ex);
        }
        try {
            try {
                Closer closer = Closer.create();
                OutputStream output = (OutputStream)closer.register((Closeable)new FileOutputStream(tempFile));
                try {
                    result.writeTo(output);
                }
                finally {
                    closer.close();
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException((Throwable)ex);
            }
            this.persistentCache.useCache(new Runnable(){

                public void run() {
                    DirectoryBuildCacheService.this.fileStore.move(hashCode, tempFile);
                }
            });
        }
        finally {
            FileUtils.deleteQuietly((File)tempFile);
        }
    }

    public void close() throws IOException {
        this.persistentCache.close();
    }
}

