/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskgraph;

import java.util.TreeSet;
import org.gradle.api.internal.TaskInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskInfo
implements Comparable<TaskInfo> {
    private final TaskInternal task;
    private TaskExecutionState state;
    private Throwable executionFailure;
    private boolean dependenciesProcessed;
    private final TreeSet<TaskInfo> dependencyPredecessors = new TreeSet();
    private final TreeSet<TaskInfo> dependencySuccessors = new TreeSet();
    private final TreeSet<TaskInfo> mustSuccessors = new TreeSet();
    private final TreeSet<TaskInfo> shouldSuccessors = new TreeSet();
    private final TreeSet<TaskInfo> finalizers = new TreeSet();

    public TaskInfo(TaskInternal task) {
        this.task = task;
        this.state = TaskExecutionState.UNKNOWN;
    }

    public TaskInternal getTask() {
        return this.task;
    }

    public boolean isRequired() {
        return this.state == TaskExecutionState.SHOULD_RUN;
    }

    public boolean isMustNotRun() {
        return this.state == TaskExecutionState.MUST_NOT_RUN;
    }

    public boolean isIncludeInGraph() {
        return this.state == TaskExecutionState.NOT_REQUIRED || this.state == TaskExecutionState.UNKNOWN;
    }

    public boolean isReady() {
        return this.state == TaskExecutionState.SHOULD_RUN || this.state == TaskExecutionState.MUST_RUN;
    }

    public boolean isInKnownState() {
        return this.state != TaskExecutionState.UNKNOWN;
    }

    public boolean isComplete() {
        return this.state == TaskExecutionState.EXECUTED || this.state == TaskExecutionState.SKIPPED || this.state == TaskExecutionState.UNKNOWN || this.state == TaskExecutionState.NOT_REQUIRED || this.state == TaskExecutionState.MUST_NOT_RUN;
    }

    public boolean isSuccessful() {
        return this.state == TaskExecutionState.EXECUTED && !this.isFailed() || this.state == TaskExecutionState.NOT_REQUIRED || this.state == TaskExecutionState.MUST_NOT_RUN;
    }

    public boolean isFailed() {
        return this.getTaskFailure() != null || this.getExecutionFailure() != null;
    }

    public void startExecution() {
        assert (this.isReady());
        this.state = TaskExecutionState.EXECUTING;
    }

    public void finishExecution() {
        assert (this.state == TaskExecutionState.EXECUTING);
        this.state = TaskExecutionState.EXECUTED;
    }

    public void skipExecution() {
        assert (this.state == TaskExecutionState.SHOULD_RUN);
        this.state = TaskExecutionState.SKIPPED;
    }

    public void require() {
        this.state = TaskExecutionState.SHOULD_RUN;
    }

    public void doNotRequire() {
        this.state = TaskExecutionState.NOT_REQUIRED;
    }

    public void mustNotRun() {
        this.state = TaskExecutionState.MUST_NOT_RUN;
    }

    public void enforceRun() {
        assert (this.state == TaskExecutionState.SHOULD_RUN || this.state == TaskExecutionState.MUST_NOT_RUN || this.state == TaskExecutionState.MUST_RUN);
        this.state = TaskExecutionState.MUST_RUN;
    }

    public void setExecutionFailure(Throwable failure) {
        assert (this.state == TaskExecutionState.EXECUTING);
        this.executionFailure = failure;
    }

    public Throwable getExecutionFailure() {
        return this.executionFailure;
    }

    public Throwable getTaskFailure() {
        return this.getTask().getState().getFailure();
    }

    public boolean allDependenciesComplete() {
        for (TaskInfo dependency : this.mustSuccessors) {
            if (dependency.isComplete()) continue;
            return false;
        }
        for (TaskInfo dependency : this.dependencySuccessors) {
            if (dependency.isComplete()) continue;
            return false;
        }
        return true;
    }

    public boolean allDependenciesSuccessful() {
        for (TaskInfo dependency : this.dependencySuccessors) {
            if (dependency.isSuccessful()) continue;
            return false;
        }
        return true;
    }

    public TreeSet<TaskInfo> getDependencyPredecessors() {
        return this.dependencyPredecessors;
    }

    public TreeSet<TaskInfo> getDependencySuccessors() {
        return this.dependencySuccessors;
    }

    public TreeSet<TaskInfo> getMustSuccessors() {
        return this.mustSuccessors;
    }

    public TreeSet<TaskInfo> getFinalizers() {
        return this.finalizers;
    }

    public TreeSet<TaskInfo> getShouldSuccessors() {
        return this.shouldSuccessors;
    }

    public boolean getDependenciesProcessed() {
        return this.dependenciesProcessed;
    }

    public void dependenciesProcessed() {
        this.dependenciesProcessed = true;
    }

    public void addDependencySuccessor(TaskInfo toNode) {
        this.dependencySuccessors.add(toNode);
        toNode.dependencyPredecessors.add(this);
    }

    public void addMustSuccessor(TaskInfo toNode) {
        this.mustSuccessors.add(toNode);
    }

    public void addFinalizer(TaskInfo finalizerNode) {
        this.finalizers.add(finalizerNode);
    }

    public void addShouldSuccessor(TaskInfo toNode) {
        this.shouldSuccessors.add(toNode);
    }

    public void removeShouldRunAfterSuccessor(TaskInfo toNode) {
        this.shouldSuccessors.remove(toNode);
    }

    @Override
    public int compareTo(TaskInfo otherInfo) {
        return this.task.compareTo(otherInfo.getTask());
    }

    public String toString() {
        return this.task.getPath();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TaskExecutionState {
        UNKNOWN,
        NOT_REQUIRED,
        SHOULD_RUN,
        MUST_RUN,
        MUST_NOT_RUN,
        EXECUTING,
        EXECUTED,
        SKIPPED;

    }
}

