/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.metaobject;

import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingMethodException;
import org.gradle.api.internal.DynamicObjectUtil;
import org.gradle.internal.metaobject.DynamicInvokeResult;
import org.gradle.internal.metaobject.DynamicObject;

public class ConfigureDelegate
extends GroovyObjectSupport {
    protected final DynamicObject _owner;
    protected final DynamicObject _delegate;
    private final ThreadLocal<Boolean> _configuring = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public ConfigureDelegate(Closure configureClosure, Object delegate) {
        this._owner = DynamicObjectUtil.asDynamicObject(configureClosure.getOwner());
        this._delegate = DynamicObjectUtil.asDynamicObject(delegate);
    }

    public String toString() {
        return this._delegate.toString();
    }

    protected DynamicInvokeResult _configure(String name, Object[] params) {
        return DynamicInvokeResult.notFound();
    }

    protected DynamicInvokeResult _configure(String name) {
        return DynamicInvokeResult.notFound();
    }

    public Object invokeMethod(String name, Object paramsObj) {
        Object[] params = (Object[])paramsObj;
        boolean isAlreadyConfiguring = this._configuring.get();
        this._configuring.set(true);
        try {
            DynamicInvokeResult result = this._delegate.tryInvokeMethod(name, params);
            if (result.isFound()) {
                Object object = result.getValue();
                return object;
            }
            MissingMethodException failure = null;
            if (!isAlreadyConfiguring) {
                try {
                    result = this._configure(name, params);
                }
                catch (MissingMethodException e) {
                    failure = e;
                }
                if (result.isFound()) {
                    Object object = result.getValue();
                    return object;
                }
            }
            if ((result = this._owner.tryInvokeMethod(name, params)).isFound()) {
                Object object = result.getValue();
                return object;
            }
            if (failure != null) {
                throw failure;
            }
            throw this._delegate.methodMissingException(name, params);
        }
        finally {
            this._configuring.set(isAlreadyConfiguring);
        }
    }

    public void setProperty(String property, Object newValue) {
        DynamicInvokeResult result = this._delegate.trySetProperty(property, newValue);
        if (result.isFound()) {
            return;
        }
        result = this._owner.trySetProperty(property, newValue);
        if (result.isFound()) {
            return;
        }
        throw this._delegate.setMissingProperty(property);
    }

    public Object getProperty(String name) {
        boolean isAlreadyConfiguring = this._configuring.get();
        this._configuring.set(true);
        try {
            DynamicInvokeResult result = this._delegate.tryGetProperty(name);
            if (result.isFound()) {
                Object object = result.getValue();
                return object;
            }
            result = this._owner.tryGetProperty(name);
            if (result.isFound()) {
                Object object = result.getValue();
                return object;
            }
            if (!isAlreadyConfiguring && (result = this._configure(name)).isFound()) {
                Object object = result.getValue();
                return object;
            }
            throw this._delegate.getMissingProperty(name);
        }
        finally {
            this._configuring.set(isAlreadyConfiguring);
        }
    }
}

