/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rdr.InStream;
import com.tigervnc.rdr.MemInStream;
import com.tigervnc.rdr.OutStream;
import com.tigervnc.rfb.ConnParams;
import com.tigervnc.rfb.Decoder;
import com.tigervnc.rfb.ModifiablePixelBuffer;
import com.tigervnc.rfb.PixelFormat;
import com.tigervnc.rfb.Rect;
import java.nio.ByteBuffer;

public class HextileDecoder
extends Decoder {
    public static final int hextileRaw = 1;
    public static final int hextileBgSpecified = 2;
    public static final int hextileFgSpecified = 4;
    public static final int hextileAnySubrects = 8;
    public static final int hextileSubrectsColoured = 16;

    public HextileDecoder() {
        super(Decoder.DecoderFlags.DecoderPlain);
    }

    @Override
    public void readRect(Rect rect, InStream inStream, ConnParams connParams, OutStream outStream) {
        Rect rect2 = new Rect();
        int n = connParams.pf().bpp / 8;
        rect2.tl.y = rect.tl.y;
        while (rect2.tl.y < rect.br.y) {
            rect2.br.y = Math.min(rect.br.y, rect2.tl.y + 16);
            rect2.tl.x = rect.tl.x;
            while (rect2.tl.x < rect.br.x) {
                rect2.br.x = Math.min(rect.br.x, rect2.tl.x + 16);
                int n2 = inStream.readU8() & 0xFF;
                outStream.writeU32(n2);
                if ((n2 & 1) != 0) {
                    outStream.copyBytes(inStream, rect2.area() * n);
                } else {
                    if ((n2 & 2) != 0) {
                        outStream.copyBytes(inStream, n);
                    }
                    if ((n2 & 4) != 0) {
                        outStream.copyBytes(inStream, n);
                    }
                    if ((n2 & 8) != 0) {
                        int n3 = inStream.readU8() & 0xFF;
                        outStream.writeU32(n3);
                        if ((n2 & 0x10) != 0) {
                            outStream.copyBytes(inStream, n3 * (n + 2));
                        } else {
                            outStream.copyBytes(inStream, n3 * 2);
                        }
                    }
                }
                rect2.tl.x += 16;
            }
            rect2.tl.y += 16;
        }
    }

    @Override
    public void decodeRect(Rect rect, Object object, int n, ConnParams connParams, ModifiablePixelBuffer modifiablePixelBuffer) {
        MemInStream memInStream = new MemInStream((byte[])object, 0, n);
        PixelFormat pixelFormat = connParams.pf();
        switch (pixelFormat.bpp) {
            case 8: {
                this.hextileDecode8(rect, memInStream, pixelFormat, modifiablePixelBuffer);
                break;
            }
            case 16: {
                this.hextileDecode16(rect, memInStream, pixelFormat, modifiablePixelBuffer);
                break;
            }
            case 32: {
                this.hextileDecode32(rect, memInStream, pixelFormat, modifiablePixelBuffer);
            }
        }
    }

    private void hextileDecode8(Rect rect, InStream inStream, PixelFormat pixelFormat, ModifiablePixelBuffer modifiablePixelBuffer) {
        this.HEXTILE_DECODE(rect, inStream, pixelFormat, modifiablePixelBuffer);
    }

    private void hextileDecode16(Rect rect, InStream inStream, PixelFormat pixelFormat, ModifiablePixelBuffer modifiablePixelBuffer) {
        this.HEXTILE_DECODE(rect, inStream, pixelFormat, modifiablePixelBuffer);
    }

    private void hextileDecode32(Rect rect, InStream inStream, PixelFormat pixelFormat, ModifiablePixelBuffer modifiablePixelBuffer) {
        this.HEXTILE_DECODE(rect, inStream, pixelFormat, modifiablePixelBuffer);
    }

    private static ByteBuffer READ_PIXEL(InStream inStream, PixelFormat pixelFormat) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        switch (pixelFormat.bpp) {
            case 8: {
                byteBuffer.putInt(inStream.readOpaque8());
                return ByteBuffer.allocate(1).put(byteBuffer.get(3));
            }
            case 16: {
                byteBuffer.putInt(inStream.readOpaque16());
                return ByteBuffer.allocate(2).put(byteBuffer.array(), 2, 2);
            }
        }
        byteBuffer.putInt(inStream.readOpaque32());
        return byteBuffer;
    }

    private void HEXTILE_DECODE(Rect rect, InStream inStream, PixelFormat pixelFormat, ModifiablePixelBuffer modifiablePixelBuffer) {
        Rect rect2 = new Rect();
        ByteBuffer byteBuffer = ByteBuffer.allocate(pixelFormat.bpp / 8);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(pixelFormat.bpp / 8);
        ByteBuffer byteBuffer3 = ByteBuffer.allocate(1024);
        rect2.tl.y = rect.tl.y;
        while (rect2.tl.y < rect.br.y) {
            rect2.br.y = Math.min(rect.br.y, rect2.tl.y + 16);
            rect2.tl.x = rect.tl.x;
            while (rect2.tl.x < rect.br.x) {
                rect2.br.x = Math.min(rect.br.x, rect2.tl.x + 16);
                int n = inStream.readU32();
                if ((n & 1) != 0) {
                    inStream.readBytes(byteBuffer3, rect2.area() * (pixelFormat.bpp / 8));
                    modifiablePixelBuffer.imageRect(pixelFormat, rect2, byteBuffer3.array());
                } else {
                    if ((n & 2) != 0) {
                        byteBuffer = HextileDecoder.READ_PIXEL(inStream, pixelFormat);
                    }
                    int n2 = rect2.area();
                    ByteBuffer byteBuffer4 = byteBuffer3.duplicate();
                    while (n2-- > 0) {
                        byteBuffer4.put(byteBuffer.array());
                    }
                    if ((n & 4) != 0) {
                        byteBuffer2 = HextileDecoder.READ_PIXEL(inStream, pixelFormat);
                    }
                    if ((n & 8) != 0) {
                        int n3 = inStream.readU32();
                        for (int i = 0; i < n3; ++i) {
                            if ((n & 0x10) != 0) {
                                byteBuffer2 = HextileDecoder.READ_PIXEL(inStream, pixelFormat);
                            }
                            int n4 = inStream.readU8();
                            int n5 = inStream.readU8();
                            int n6 = n4 >> 4 & 0xF;
                            int n7 = n4 & 0xF;
                            int n8 = (n5 >> 4 & 0xF) + 1;
                            int n9 = (n5 & 0xF) + 1;
                            byteBuffer4 = byteBuffer3.duplicate();
                            byteBuffer4.position((n7 * rect2.width() + n6) * pixelFormat.bpp / 8);
                            int n10 = (rect2.width() - n8) * pixelFormat.bpp / 8;
                            while (n9-- > 0) {
                                n2 = n8;
                                while (n2-- > 0) {
                                    byteBuffer4.put(byteBuffer2.array());
                                }
                                byteBuffer4.position(byteBuffer4.position() + Math.min(n10, byteBuffer4.remaining()));
                            }
                        }
                    }
                    modifiablePixelBuffer.imageRect(pixelFormat, rect2, byteBuffer3.array());
                }
                rect2.tl.x += 16;
            }
            rect2.tl.y += 16;
        }
    }
}

