/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Arrays;
import org.mozilla.javascript.Wrapper;

class ResolvedOverload {
    final Class<?>[] types;
    final int index;

    ResolvedOverload(Object[] objectArray, int n) {
        this.index = n;
        this.types = new Class[objectArray.length];
        for (Object object : objectArray) {
            if (object instanceof Wrapper) {
                object = ((Wrapper)object).unwrap();
            }
            this.types[var3_3] = object == null ? null : object.getClass();
        }
    }

    boolean matches(Object[] objectArray) {
        if (objectArray.length != this.types.length) {
            return false;
        }
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            if (object instanceof Wrapper) {
                object = ((Wrapper)object).unwrap();
            }
            if (!(object == null ? this.types[i] != null : object.getClass() != this.types[i])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ResolvedOverload)) {
            return false;
        }
        ResolvedOverload resolvedOverload = (ResolvedOverload)object;
        return Arrays.equals(this.types, resolvedOverload.types) && this.index == resolvedOverload.index;
    }

    public int hashCode() {
        return Arrays.hashCode(this.types);
    }
}

