/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.basics.settings;

import ch.ehi.basics.tools.StringUtility;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class Settings {
    private HashMap<String, String> values = new HashMap();
    private ArrayList<String> orderedKeys = null;
    private HashMap transientValues = new HashMap();

    public Settings() {
        this(false);
    }

    public Settings(boolean bl) {
        if (bl) {
            this.orderedKeys = new ArrayList();
        }
    }

    public Settings(Settings settings) {
        if (settings != null) {
            String string;
            Iterator<String> iterator = settings.getValuesIterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                string = settings.values.get(string2);
                this.setValue(string2, string);
            }
            for (String string2 : this.transientValues.keySet()) {
                string = settings.transientValues.get(string2);
                this.transientValues.put(string2, string);
            }
        }
    }

    public String getValue(String string) {
        String string2 = this.values.get(string);
        return StringUtility.purge(string2);
    }

    public void setValue(String string, String string2) {
        if ((string2 = StringUtility.purge(string2)) == null) {
            if (this.orderedKeys != null && this.orderedKeys.contains(string)) {
                this.orderedKeys.remove(string);
            }
            this.values.remove(string);
        } else {
            if (this.orderedKeys != null && !this.orderedKeys.contains(string)) {
                this.orderedKeys.add(string);
            }
            this.values.put(string, string2);
        }
    }

    public Object getTransientObject(String string) {
        Object v = this.transientValues.get(string);
        if (v != null && v instanceof String) {
            return StringUtility.purge((String)v);
        }
        return v;
    }

    public void setTransientObject(String string, Object object) {
        if (object != null && object instanceof String) {
            object = StringUtility.purge((String)object);
        }
        if (object == null) {
            this.transientValues.remove(string);
        } else {
            this.transientValues.put(string, object);
        }
    }

    public String getTransientValue(String string) {
        return (String)this.getTransientObject(string);
    }

    public void setTransientValue(String string, String string2) {
        this.setTransientObject(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(File file, String string) throws IOException {
        OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            this.store(outputStream, string);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
                outputStream = null;
            }
        }
    }

    public void store(OutputStream outputStream, String string) throws IOException {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.values);
        properties.store(outputStream, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            this.load(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
                inputStream = null;
            }
        }
    }

    public void load(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        for (String string : properties.stringPropertyNames()) {
            this.setValue(string, properties.getProperty(string));
        }
    }

    public Set getValues() {
        return this.values.keySet();
    }

    public Iterator<String> getValuesIterator() {
        if (this.orderedKeys != null) {
            return this.orderedKeys.iterator();
        }
        return this.values.keySet().iterator();
    }

    public Set getTransientValues() {
        return this.transientValues.keySet();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<String> iterator = this.getValuesIterator();
        Iterator iterator2 = this.transientValues.keySet().iterator();
        if (iterator.hasNext() || iterator2.hasNext()) {
            String string;
            String string2;
            String string3 = "";
            stringBuffer.append("Settings{");
            while (iterator.hasNext()) {
                string2 = iterator.next();
                string = this.values.get(string2);
                stringBuffer.append(string3 + string2 + "=" + string.toString());
                string3 = ";";
            }
            while (iterator2.hasNext()) {
                string2 = (String)iterator2.next();
                string = this.transientValues.get(string2);
                stringBuffer.append(string3 + string2 + "=" + string.toString());
                string3 = ";";
            }
            stringBuffer.append("}");
        }
        return stringBuffer.toString();
    }
}

