#ifndef _EFL_EVENT_TYPES_EOT_H_
#define _EFL_EVENT_TYPES_EOT_H_

#ifndef _EFL_EVENT_TYPES_EOT_TYPES
#define _EFL_EVENT_TYPES_EOT_TYPES

/** Pointer event type.
 *
 * @since 1.18
 *
 * @ingroup Efl_Pointer
 */
typedef enum
{
  EFL_POINTER_ACTION_NONE = 0, /** Not a valid event. */
  EFL_POINTER_ACTION_MOVE, /** Mouse or equivalent pointer moved. */
  EFL_POINTER_ACTION_DOWN, /** Mouse button or equivalent pointer pressed down.
                            * Always followed by up or cancel. */
  EFL_POINTER_ACTION_UP, /** Mouse button or equivalent pointer released. See
                          * also cancel. */
  EFL_POINTER_ACTION_CANCEL, /** Special event happening after a down if the up
                              * counterpart can not happen (eg. another window
                              * forcibly stole the focus). */
  EFL_POINTER_ACTION_IN, /** Mouse or pointer entered the object. */
  EFL_POINTER_ACTION_OUT, /** Mouse or pointer exited the object. */
  EFL_POINTER_ACTION_WHEEL, /** Mouse wheel scroll, horizontally or vertically.
                             */
  EFL_POINTER_ACTION_AXIS /** Axis event (pen, stick, ...). */
} Efl_Pointer_Action;

typedef enum
{
  EFL_POINTER_FLAGS_NONE = 0, /** No extra mouse button data */
  EFL_POINTER_FLAGS_DOUBLE_CLICK = 1 /* 1 << 0 */, /** This mouse button press
                                                    * was the 2nd press of a
                                                    * double click */
  EFL_POINTER_FLAGS_TRIPLE_CLICK = 2 /* 1 << 1 */ /** This mouse button press
                                                   * was the 3rd press of a
                                                   * triple click */
} Efl_Pointer_Flags;

typedef enum
{
  EFL_EVENT_FLAGS_NONE = 0, /** No fancy flags set */
  EFL_EVENT_FLAGS_PROCESSED = 1 /* 1 << 0 */, /** This event is being delivered
                                               * and has been processed, so it
                                               * should be put "on hold" until
                                               * the flag is unset. The event
                                               * should be used for
                                               * informational purposes and
                                               * maybe some indications
                                               * visually, but not actually
                                               * perform anything. */
  EFL_EVENT_FLAGS_SCROLLING = 2 /* 1 << 1 */ /** This event flag indicates the
                                              * event occurs while scrolling;
                                              * for example, DOWN event occurs
                                              * during scrolling. The event
                                              * should be used for
                                              * informational purposes and
                                              * maybe some indications
                                              * visually, but not actually
                                              * perform anything. */
} Efl_Event_Flags;

/**
 * @brief How the mouse pointer should be handled by EFL.
 *
 * In the mode @c autograb, when a mouse button is pressed down over an object
 * and held down, with the mouse pointer being moved outside of it, the pointer
 * still behaves as being bound to that object, albeit out of its drawing
 * region. When the button is released, the event will be fed to the object,
 * that may check if the final position is over it or not and do something
 * about it.
 *
 * In the mode @c nograb, the pointer will always be bound to the object right
 * below it.
 *
 * @ingroup Efl_Event
 */
typedef enum
{
  EFL_EVENT_OBJECT_POINTER_MODE_AUTO_GRAB = 0, /** Default, X11-like. */
  EFL_EVENT_OBJECT_POINTER_MODE_NO_GRAB, /** Pointer always bound to the object
                                          * right below it. */
  EFL_EVENT_OBJECT_POINTER_MODE_NO_GRAB_NO_REPEAT_UPDOWN /** Useful on object
                                                          * with "repeat
                                                          * events" enabled,
                                                          * where mouse/touch
                                                          * up and down events
                                                          * WON'T be repeated
                                                          * to objects and
                                                          * these objects wont
                                                          * be auto-grabbed.
                                                          *
                                                          * @since 1.2 */
} Efl_Event_Object_Pointer_Mode;


#endif

#endif
