#ifndef _EFL_INPUT_DEVICE_EO_LEGACY_H_
#define _EFL_INPUT_DEVICE_EO_LEGACY_H_

#ifndef _EFL_INPUT_DEVICE_EO_CLASS_TYPE
#define _EFL_INPUT_DEVICE_EO_CLASS_TYPE

typedef Eo Efl_Input_Device;

#endif

#ifndef _EFL_INPUT_DEVICE_EO_TYPES
#define _EFL_INPUT_DEVICE_EO_TYPES

/**
 * @brief General type of input device.
 *
 * Legacy support since 1.8.
 *
 * @since 1.18
 *
 * @ingroup Efl_Input_Device
 */
typedef enum
{
  EFL_INPUT_DEVICE_CLASS_NONE = 0, /** Not a device. */
  EFL_INPUT_DEVICE_CLASS_SEAT, /** The user/seat (the user themselves). */
  EFL_INPUT_DEVICE_CLASS_KEYBOARD, /** A regular keyboard, numberpad or
                                    * attached buttons. */
  EFL_INPUT_DEVICE_CLASS_MOUSE, /** A mouse, trackball or touchpad relative
                                 * motion device. */
  EFL_INPUT_DEVICE_CLASS_TOUCH, /** A touchscreen with fingers or stylus. */
  EFL_INPUT_DEVICE_CLASS_PEN, /** A special pen device. */
  EFL_INPUT_DEVICE_CLASS_WAND, /** A laser pointer, wii-style or "minority
                                * report" pointing device. */
  EFL_INPUT_DEVICE_CLASS_GAMEPAD /** A gamepad controller or joystick. */
} Efl_Input_Device_Class;

/**
 * @brief Specific type of input device.
 *
 * Legacy support since 1.8.
 *
 * @since 1.18
 *
 * @ingroup Efl_Input_Device
 */
typedef enum
{
  EFL_INPUT_DEVICE_SUB_CLASS_NONE = 0, /** Not a device. */
  EFL_INPUT_DEVICE_SUB_CLASS_FINGER, /** The normal flat of your finger. */
  EFL_INPUT_DEVICE_SUB_CLASS_FINGERNAIL, /** A fingernail. */
  EFL_INPUT_DEVICE_SUB_CLASS_KNUCKLE, /** A Knuckle. */
  EFL_INPUT_DEVICE_SUB_CLASS_PALM, /** The palm of a users hand. */
  EFL_INPUT_DEVICE_SUB_CLASS_HAND_SIZE, /** The side of your hand. */
  EFL_INPUT_DEVICE_SUB_CLASS_HAND_FLAT, /** The flat of your hand. */
  EFL_INPUT_DEVICE_SUB_CLASS_PEN_TIP, /** The tip of a pen. */
  EFL_INPUT_DEVICE_SUB_CLASS_TRACKPAD, /** A trackpad style mouse. */
  EFL_INPUT_DEVICE_SUB_CLASS_TRACKPOINT, /** A trackpoint style mouse. */
  EFL_INPUT_DEVICE_SUB_CLASS_TRACKBALL /** A trackball style mouse. */
} Efl_Input_Device_Sub_Class;


#endif
/** Represents a pointing device, such as a touch finger, a pen or a mouse.
 *
 * @since 1.18
 *
 * @ingroup Efl_Input_Device
 */
EAPI void null_device_type_set(Efl_Input_Device *obj, Efl_Input_Device_Class klass);
EAPI Efl_Input_Device_Class null_device_type_get(const Efl_Input_Device *obj);
EAPI void null_device_subtype_set(Efl_Input_Device *obj, Efl_Input_Device_Sub_Class klass);
EAPI Efl_Input_Device_Sub_Class null_device_subtype_get(const Efl_Input_Device *obj);
EAPI void null_source_set(Efl_Input_Device *obj, Efl_Input_Device *src);
EAPI Efl_Input_Device *null_source_get(const Efl_Input_Device *obj);
EAPI void null_name_set(Efl_Input_Device *obj, const char *name);
EAPI const char *null_name_get(const Efl_Input_Device *obj);
EAPI void null_description_set(Efl_Input_Device *obj, const char *desc);
EAPI const char *null_description_get(const Efl_Input_Device *obj);
EAPI Efl_Input_Device *null_parent_get(const Efl_Input_Device *obj);

#endif
