#ifndef _EFL_INPUT_STATE_EO_H_
#define _EFL_INPUT_STATE_EO_H_

#ifndef _EFL_INPUT_STATE_EO_CLASS_TYPE
#define _EFL_INPUT_STATE_EO_CLASS_TYPE

typedef Eo Efl_Input_State;

#endif

#ifndef _EFL_INPUT_STATE_EO_TYPES
#define _EFL_INPUT_STATE_EO_TYPES


#endif
#define EFL_INPUT_STATE_INTERFACE efl_input_state_interface_get()

EWAPI const Eo_Class *efl_input_state_interface_get(void);

/**
 * @brief Indicates whether a key modifier is on, such as Ctrl, Shift,...
 *
 * @param[in] name
 *
 * @return @c true if the key modifier is pressed.
 *
 * @ingroup Efl_Input_State
 */
EOAPI Eina_Bool efl_input_modifier_enabled_get(const Eo *obj, const char * name);

/**
 * @brief Indicates whether a key lock is on, such as NumLock, CapsLock, ...
 *
 * @param[in] name
 *
 * @return @c true if the key lock is on.
 *
 * @ingroup Efl_Input_State
 */
EOAPI Eina_Bool efl_input_lock_enabled_get(const Eo *obj, const char * name);


#endif
