#ifndef _ELM_PROGRESSBAR_EO_LEGACY_H_
#define _ELM_PROGRESSBAR_EO_LEGACY_H_

#ifndef _ELM_PROGRESSBAR_EO_CLASS_TYPE
#define _ELM_PROGRESSBAR_EO_CLASS_TYPE

typedef Eo Elm_Progressbar;

#endif

#ifndef _ELM_PROGRESSBAR_EO_TYPES
#define _ELM_PROGRESSBAR_EO_TYPES


#endif

/**
 * @brief Control whether a given progress bar widget is at "pulsing mode" or
 * not.
 *
 * By default, progress bars will display values from the low to high value
 * boundaries. There are, though, contexts in which the progress of a given
 * task is unknown. For such cases, one can set a progress bar widget to a
 * "pulsing state", to give the user an idea that some computation is being
 * held, but without exact progress values. In the default theme, it will
 * animate its bar with the contents filling in constantly and back to
 * non-filled, in a loop. To start and stop this pulsing animation, one has to
 * explicitly call elm_progressbar_pulse().
 *
 * @param[in] pulse @c true to put @c obj in pulsing mode, @c false to put it
 * back to its default one
 *
 * @ingroup Elm_Progressbar
 */
EAPI void elm_progressbar_pulse_set(Elm_Progressbar *obj, Eina_Bool pulse);

/**
 * @brief Control whether a given progress bar widget is at "pulsing mode" or
 * not.
 *
 * By default, progress bars will display values from the low to high value
 * boundaries. There are, though, contexts in which the progress of a given
 * task is unknown. For such cases, one can set a progress bar widget to a
 * "pulsing state", to give the user an idea that some computation is being
 * held, but without exact progress values. In the default theme, it will
 * animate its bar with the contents filling in constantly and back to
 * non-filled, in a loop. To start and stop this pulsing animation, one has to
 * explicitly call elm_progressbar_pulse().
 *
 * @return @c true to put @c obj in pulsing mode, @c false to put it back to
 * its default one
 *
 * @ingroup Elm_Progressbar
 */
EAPI Eina_Bool elm_progressbar_pulse_get(const Elm_Progressbar *obj);

/**
 * @brief Set the progress value (in percentage) on a given progress bar widget
 * for the given part name
 *
 * Use this call to set progress bar status for more than one progress status .
 *
 * @param[in] part The partname to which val have to set
 * @param[in] val The progress value (must be between $0.0 and 1.0)
 *
 * @since 1.8
 *
 * @ingroup Elm_Progressbar
 */
EAPI void elm_progressbar_part_value_set(Elm_Progressbar *obj, const char *part, double val);

/**
 * @brief Get the progress value (in percentage) on a given progress bar widget
 * for a particular part
 *
 * @param[in] part The part name of the progress bar
 *
 * @return The value of the progressbar
 *
 * @since 1.8
 *
 * @ingroup Elm_Progressbar
 */
EAPI double elm_progressbar_part_value_get(const Elm_Progressbar *obj, const char *part);

/**
 * @brief Start/stop a given progress bar "pulsing" animation, if its under
 * that mode
 *
 * @note This call won't do anything if @c obj is not under "pulsing mode".
 *
 * @param[in] state @c true, to start the pulsing animation, @c false to stop
 * it
 *
 * @ingroup Elm_Progressbar
 */
EAPI void elm_progressbar_pulse(Elm_Progressbar *obj, Eina_Bool state);

#endif
