#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.16';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo750D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo80D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DJI::Main',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::MacOS::MDItem',
	'Image::ExifTool::MacOS::XAttr',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0107',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD500',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD810',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD610',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AFPointInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::OrientationInfo',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag2010i',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050a',
	'Image::ExifTool::Sony::Tag9050b',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GAudio',
	'Image::ExifTool::XMP::GImage',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GSpherical',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 100 => 0x69 },
	'about' => { 438 => 'about' },
	'aboutcvterm' => { 430 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 430 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 430 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 430 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 430 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'abspeakaudiofilepath' => { 444 => 'absPeakAudioFilePath' },
	'acceleration' => { 109 => 0x9404 },
	'accelerationtracking' => { 75 => 0x518 },
	'accelerationvector' => { 1 => 0x8 },
	'accelerometer' => { 344 => 0x3 },
	'accelerometerx' => { 282 => 0x8d },
	'accelerometery' => { 282 => 0x8e },
	'accelerometerz' => { 282 => 0x8c },
	'accessoryserialnumber' => { 282 => 0x54 },
	'accessorytype' => { 282 => 0x53 },
	'acedemicfield' => { 434 => 'acedemicField' },
	'actionadvised' => { 117 => 0x2a },
	'activearea' => { 109 => 0xc68d },
	'actived-lighting' => { 200 => 0x22, 236 => 0x24 },
	'actived-lightingmode' => { 236 => 0x25 },
	'adaptervoltage' => { 123 => 0x407 },
	'addaspectratioinfo' => { 75 => 0x80e },
	'additionalmodelinformation' => { 430 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 75 => 0x80f, 76 => 0x11, 77 => 0x13, 80 => 0x14 },
	'address' => { 144 => 'Address' },
	'adjustmentmode' => { 351 => 0x15 },
	'adlbracketingstep' => { 218 => 0x883 },
	'adlbracketingtype' => { 218 => 0x884 },
	'adobe' => { 110 => 'Adobe' },
	'adultcontentwarning' => { 271 => 'AdultContentWarning', 437 => 'adultContentWarning' },
	'advancedfilter' => { 114 => 0x1201 },
	'advancedraw' => { 238 => 0x76a43203 },
	'advancedscenetype' => { 282 => 0x3d },
	'advisory' => { 442 => 'Advisory' },
	'ae_iso' => { 289 => 0x2, 290 => 0x4, 291 => 0x12 },
	'aeaperture' => { 289 => 0x1, 290 => 0x3, 291 => 0x11 },
	'aeaperturesteps' => { 289 => 0x8, 290 => 0xb },
	'aebautocancel' => { 75 => 0x104 },
	'aebbracketvalue' => { 69 => 0x11 },
	'aebracketingsteps' => { 217 => 0x174c, 218 => 0x87b, 226 => 0x1756 },
	'aebsequence' => { 75 => 0x105 },
	'aebsequenceautocancel' => { 73 => 0x9, 74 => 0x9, 76 => 0x8, 77 => 0x9, 80 => 0x9, 81 => 0x7 },
	'aebshotcount' => { 75 => 0x106 },
	'aebxv' => { 289 => 0x4, 290 => 0x6 },
	'aeerror' => { 290 => 0x8 },
	'aeexposuretime' => { 289 => 0x0, 290 => 0x2, 291 => 0x10 },
	'aelbutton' => { 166 => 0x45 },
	'aelexposureindicator' => { 166 => 0x51 },
	'aelock' => { 166 => 0x5b, 247 => '4.2', 256 => '4.2', 261 => 0x201, 316 => 0x48, 359 => 0x40, 360 => 0x40, 361 => [0x86,0x286] },
	'aelockbutton' => { 245 => '16.1', 247 => '4.1', 250 => '15.1', 251 => '16.1', 252 => '16.1', 254 => '30.1', 255 => '16.1', 256 => '4.1', 258 => '17.1', 259 => '17.1' },
	'aelockbuttonplusdials' => { 245 => '16.2', 254 => '32.1', 258 => '44.1' },
	'aelockformb-d80' => { 259 => '3.1' },
	'aemaxaperture' => { 289 => 0x9, 290 => 0x10, 291 => 0x1c },
	'aemaxaperture2' => { 289 => 0xa, 290 => 0x11, 291 => 0x1d },
	'aemeteringmode' => { 289 => 0xc },
	'aemeteringmode2' => { 289 => '13.1' },
	'aemeteringsegments' => { 169 => 0x628, 316 => 0x209 },
	'aemicroadjustment' => { 75 => 0x110 },
	'aeminaperture' => { 289 => 0xb, 290 => 0x12, 291 => 0x1e },
	'aeminexposuretime' => { 289 => 0x5, 290 => 0x13, 291 => 0x1f },
	'aeprogrammode' => { 289 => 0x6 },
	'aeprojectlink' => { 419 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 419 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 419 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 419 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 419 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 419 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 33 => 0x21 },
	'aewhitebalance' => { 289 => 0xd },
	'aexv' => { 289 => 0x3, 290 => 0x5 },
	'af-cpriorityselection' => { 245 => '1.1', 246 => '1.1', 248 => '1.1', 249 => '1.1', 251 => '0.1', 252 => '0.1', 253 => '0.1', 254 => '1.1', 255 => '0.1', 258 => '1.1' },
	'af-onbutton' => { 248 => '70.1', 249 => '70.1' },
	'af-onformb-d10' => { 245 => '3.3', 254 => '3.2' },
	'af-onformb-d11' => { 255 => '2.2' },
	'af-onformb-d12' => { 258 => '50.1' },
	'af-spriorityselection' => { 245 => '1.2', 246 => '1.2', 248 => '1.4', 249 => '1.4', 253 => '0.2', 254 => '1.2', 255 => '0.2', 258 => '1.2' },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 245 => '2.1', 246 => '2.1', 248 => '78.3', 249 => '78.3', 254 => '2.1', 258 => '2.1' },
	'afadjustment' => { 316 => 0x72, 325 => 0x267 },
	'afandmeteringbuttons' => { 75 => 0x701 },
	'afaperture' => { 196 => 0x5, 197 => 0x5 },
	'afareaheight' => { 175 => 0x1a },
	'afareaillumination' => { 166 => 0x4b, 256 => '15.3' },
	'afareamode' => { 162 => 0x33, 166 => 0xe, 174 => 0x0, 175 => 0x5, 282 => 0xf, 341 => 0x1205, 352 => [0xa,0x3a], 359 => 0x11, 360 => 0x10, 361 => 0x24, 371 => 0xb043, 393 => 0x17 },
	'afareamodesetting' => { 247 => '11.1', 250 => '0.1', 256 => '16.1', 259 => '2.1', 371 => 0x201c },
	'afareas' => { 261 => 0x304 },
	'afareaselectionmethod' => { 2 => 0xd },
	'afareaselectmethod' => { 75 => 0x51b },
	'afareawidth' => { 175 => 0x18 },
	'afareaxposition' => { 175 => 0x14, 341 => 0x1203 },
	'afareaxposition1' => { 341 => 0x1201 },
	'afareayposition' => { 175 => 0x16, 341 => 0x1204 },
	'afareayposition1' => { 341 => 0x1202 },
	'afassist' => { 73 => 0x5, 81 => 0x5, 166 => 0x48, 245 => '2.5', 247 => '0.2', 250 => '0.2', 251 => '1.1', 252 => '1.1', 253 => '1.3', 254 => '2.4', 255 => '1.3', 256 => '0.2', 258 => '2.4', 259 => '2.3' },
	'afassistbeam' => { 2 => 0x8, 75 => 0x50e, 76 => 0x4, 77 => 0x5, 78 => 0x4, 79 => 0x4, 80 => 0x5 },
	'afassistlamp' => { 282 => 0x31 },
	'afbuttonpressed' => { 361 => [0x83,0x283] },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 292 => 0x6 },
	'afduringliveview' => { 75 => 0x511 },
	'affinea' => { 413 => 'AffineA' },
	'affineb' => { 413 => 'AffineB' },
	'affinec' => { 413 => 'AffineC' },
	'affined' => { 413 => 'AffineD' },
	'affinetune' => { 176 => 0x0, 261 => 0x306 },
	'affinetuneadj' => { 176 => 0x2, 210 => 0x2d1, 211 => 0x2dc, 261 => 0x307 },
	'affinetuneindex' => { 176 => 0x1 },
	'affinex' => { 413 => 'AffineX' },
	'affiney' => { 413 => 'AffineY' },
	'afhold' => { 292 => 0x1fd },
	'afilluminator' => { 359 => 0x29, 371 => 0xb044 },
	'afimageheight' => { 175 => 0x12 },
	'afimagewidth' => { 175 => 0x10 },
	'afintegrationtime' => { 292 => 0x7 },
	'afmicroadj' => { 352 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 356 => 0x131 },
	'afmicroadjregisteredlenses' => { 356 => '305.1' },
	'afmicroadjustment' => { 75 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 356 => 0x130 },
	'afmode' => { 104 => 0x3009, 114 => 0x1022, 162 => 0x16, 351 => 0x5 },
	'afmoderestrictions' => { 246 => '50.3', 248 => '48.3', 249 => '48.3', 258 => '48.3' },
	'afonaelockbuttonswitch' => { 75 => 0x702 },
	'afonbutton' => { 245 => '3.1', 246 => '47.1' },
	'afpoint' => { 33 => 0x13, 103 => 0x18, 162 => 0x15, 174 => 0x1, 264 => 0x308, 351 => 0x1f, 352 => [0x37,0x7], 356 => 0x19, 357 => 0x18, 358 => [0x18,0x20] },
	'afpointactivationarea' => { 74 => 0x11, 80 => 0x11 },
	'afpointareaexpansion' => { 75 => 0x508 },
	'afpointatshutterrelease' => { 352 => [0x39,0x9] },
	'afpointautoselection' => { 75 => 0x50b },
	'afpointbrightness' => { 75 => 0x50d, 245 => '2.4', 246 => '46.5', 248 => '2.2', 249 => '2.2', 258 => '2.3' },
	'afpointdisplayduringfocus' => { 2 => 0x10, 75 => 0x50c },
	'afpointillumination' => { 74 => 0xa, 245 => '2.3', 246 => '46.2', 248 => '47.2', 249 => '47.2', 253 => '1.2', 254 => '2.3', 255 => '1.2', 258 => '47.2', 259 => '2.4' },
	'afpointinfocus' => { 352 => [0x38,0x8] },
	'afpointmode' => { 297 => 0x3 },
	'afpointposition' => { 104 => 0x2021, 282 => 0x4d },
	'afpointregistration' => { 73 => 0x7 },
	'afpoints' => { 165 => 0x10 },
	'afpointselected' => { 166 => 0xd, 261 => 0x305, 316 => 0xe, 356 => 0x15, 357 => 0x14, 358 => [0x14,0x1c], 371 => 0x201e },
	'afpointselected2' => { 297 => 0x4 },
	'afpointselection' => { 74 => 0xb, 245 => '1.3', 246 => '1.3', 254 => '1.3', 258 => '1.3' },
	'afpointselectionmethod' => { 75 => 0x50f, 76 => 0xc, 77 => 0xd, 80 => 0xd },
	'afpointsetting' => { 359 => 0x12, 360 => 0x11 },
	'afpointsinfocus' => { 69 => 0xe, 174 => 0x2, 292 => 0xb, 293 => 0x4, 316 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 18 => 0x38 },
	'afpointspotmetering' => { 74 => 0xd },
	'afpointsselected' => { 293 => '4.1', 400 => 0x4 },
	'afpointsspecial' => { 293 => '4.2' },
	'afpointsunknown1' => { 292 => 0x0 },
	'afpointsunknown2' => { 292 => 0x2 },
	'afpointsused' => { 175 => 0x8, 352 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 292 => 0x4 },
	'afresponse' => { 200 => 0xad },
	'afresult' => { 266 => 0x1038 },
	'afsearch' => { 261 => 0x303 },
	'afsensoractive' => { 162 => 0x1 },
	'afstatus' => { 341 => 0x1200 },
	'afstatus_00_b4' => { 355 => 0x0 },
	'afstatus_01_c4' => { 355 => 0x2 },
	'afstatus_02_d4' => { 355 => 0x4 },
	'afstatus_03_e4' => { 355 => 0x6 },
	'afstatus_04_f4' => { 355 => 0x8 },
	'afstatus_05_g4' => { 355 => 0xa },
	'afstatus_06_h4' => { 355 => 0xc },
	'afstatus_07_b3' => { 355 => 0xe },
	'afstatus_08_c3' => { 355 => 0x10 },
	'afstatus_09_d3' => { 355 => 0x12 },
	'afstatus_10_e3' => { 355 => 0x14 },
	'afstatus_11_f3' => { 355 => 0x16 },
	'afstatus_12_g3' => { 355 => 0x18 },
	'afstatus_13_h3' => { 355 => 0x1a },
	'afstatus_14_b2' => { 355 => 0x1c },
	'afstatus_15_c2' => { 355 => 0x1e },
	'afstatus_16_d2' => { 355 => 0x20 },
	'afstatus_17_e2' => { 355 => 0x22 },
	'afstatus_18_f2' => { 355 => 0x24 },
	'afstatus_19_g2' => { 355 => 0x26 },
	'afstatus_20_h2' => { 355 => 0x28 },
	'afstatus_21_c1' => { 355 => 0x2a },
	'afstatus_22_d1' => { 355 => 0x2c },
	'afstatus_23_e1' => { 355 => 0x2e },
	'afstatus_24_f1' => { 355 => 0x30 },
	'afstatus_25_g1' => { 355 => 0x32 },
	'afstatus_26_a7_vertical' => { 355 => 0x34 },
	'afstatus_27_a6_vertical' => { 355 => 0x36 },
	'afstatus_28_a5_vertical' => { 355 => 0x38 },
	'afstatus_29_c7_vertical' => { 355 => 0x3a },
	'afstatus_30_c6_vertical' => { 355 => 0x3c },
	'afstatus_31_c5_vertical' => { 355 => 0x3e },
	'afstatus_32_e7_vertical' => { 355 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 355 => 0x42 },
	'afstatus_34_e5_vertical' => { 355 => 0x44 },
	'afstatus_35_g7_vertical' => { 355 => 0x46 },
	'afstatus_36_g6_vertical' => { 355 => 0x48 },
	'afstatus_37_g5_vertical' => { 355 => 0x4a },
	'afstatus_38_i7_vertical' => { 355 => 0x4c },
	'afstatus_39_i6_vertical' => { 355 => 0x4e },
	'afstatus_40_i5_vertical' => { 355 => 0x50 },
	'afstatus_41_a7' => { 355 => 0x52 },
	'afstatus_42_b7' => { 355 => 0x54 },
	'afstatus_43_c7' => { 355 => 0x56 },
	'afstatus_44_d7' => { 355 => 0x58 },
	'afstatus_45_e7' => { 355 => 0x5a },
	'afstatus_46_f7' => { 355 => 0x5c },
	'afstatus_47_g7' => { 355 => 0x5e },
	'afstatus_48_h7' => { 355 => 0x60 },
	'afstatus_49_i7' => { 355 => 0x62 },
	'afstatus_50_a6' => { 355 => 0x64 },
	'afstatus_51_b6' => { 355 => 0x66 },
	'afstatus_52_c6' => { 355 => 0x68 },
	'afstatus_53_d6' => { 355 => 0x6a },
	'afstatus_54_e6_center' => { 355 => 0x6c },
	'afstatus_55_f6' => { 355 => 0x6e },
	'afstatus_56_g6' => { 355 => 0x70 },
	'afstatus_57_h6' => { 355 => 0x72 },
	'afstatus_58_i6' => { 355 => 0x74 },
	'afstatus_59_a5' => { 355 => 0x76 },
	'afstatus_60_b5' => { 355 => 0x78 },
	'afstatus_61_c5' => { 355 => 0x7a },
	'afstatus_62_d5' => { 355 => 0x7c },
	'afstatus_63_e5' => { 355 => 0x7e },
	'afstatus_64_f5' => { 355 => 0x80 },
	'afstatus_65_g5' => { 355 => 0x82 },
	'afstatus_66_h5' => { 355 => 0x84 },
	'afstatus_67_i5' => { 355 => 0x86 },
	'afstatus_68_c11' => { 355 => 0x88 },
	'afstatus_69_d11' => { 355 => 0x8a },
	'afstatus_70_e11' => { 355 => 0x8c },
	'afstatus_71_f11' => { 355 => 0x8e },
	'afstatus_72_g11' => { 355 => 0x90 },
	'afstatus_73_b10' => { 355 => 0x92 },
	'afstatus_74_c10' => { 355 => 0x94 },
	'afstatus_75_d10' => { 355 => 0x96 },
	'afstatus_76_e10' => { 355 => 0x98 },
	'afstatus_77_f10' => { 355 => 0x9a },
	'afstatus_78_g10' => { 355 => 0x9c },
	'afstatus_79_h10' => { 355 => 0x9e },
	'afstatus_80_b9' => { 355 => 0xa0 },
	'afstatus_81_c9' => { 355 => 0xa2 },
	'afstatus_82_d9' => { 355 => 0xa4 },
	'afstatus_83_e9' => { 355 => 0xa6 },
	'afstatus_84_f9' => { 355 => 0xa8 },
	'afstatus_85_g9' => { 355 => 0xaa },
	'afstatus_86_h9' => { 355 => 0xac },
	'afstatus_87_b8' => { 355 => 0xae },
	'afstatus_88_c8' => { 355 => 0xb0 },
	'afstatus_89_d8' => { 355 => 0xb2 },
	'afstatus_90_e8' => { 355 => 0xb4 },
	'afstatus_91_f8' => { 355 => 0xb6 },
	'afstatus_92_g8' => { 355 => 0xb8 },
	'afstatus_93_h8' => { 355 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 355 => 0xbc },
	'afstatusactivesensor' => { 162 => 0x2, 352 => [0x4,0x3b], 356 => 0x1e, 357 => 0x1b, 358 => [0x1b,0x21] },
	'afstatusbottom' => { 162 => 0x8, 356 => 0x2a, 357 => 0x21, 358 => 0x21 },
	'afstatusbottom-left' => { 162 => 0x12, 357 => 0x2b, 358 => 0x2b },
	'afstatusbottom-right' => { 162 => 0x6, 357 => 0x1f, 358 => 0x1f },
	'afstatusbottomassist-left' => { 356 => 0x28 },
	'afstatusbottomassist-right' => { 356 => 0x2c },
	'afstatusbottomhorizontal' => { 353 => 0x10, 354 => 0x1c },
	'afstatusbottomvertical' => { 353 => 0x16, 354 => 0x26 },
	'afstatuscenter-10' => { 356 => 0x34 },
	'afstatuscenter-11' => { 356 => 0x36 },
	'afstatuscenter-12' => { 356 => 0x38 },
	'afstatuscenter-14' => { 356 => 0x3c },
	'afstatuscenter-7' => { 356 => 0x2e },
	'afstatuscenter-9' => { 356 => 0x32 },
	'afstatuscenter-horizontal' => { 356 => 0x30 },
	'afstatuscenter-vertical' => { 356 => 0x3a },
	'afstatuscenterf2-8' => { 356 => 0x4c },
	'afstatuscenterhorizontal' => { 162 => 0x2f, 353 => 0xc, 354 => 0x18, 357 => 0x2f, 358 => 0x2f },
	'afstatuscentervertical' => { 162 => 0xc, 353 => 0x14, 354 => 0x22, 357 => 0x25, 358 => 0x25 },
	'afstatusfarleft' => { 353 => 0x6, 356 => 0x26 },
	'afstatusfarlefthorizontal' => { 354 => 0x4 },
	'afstatusfarleftvertical' => { 354 => 0x12 },
	'afstatusfarright' => { 353 => 0x18, 356 => 0x44 },
	'afstatusfarrighthorizontal' => { 354 => 0x2c },
	'afstatusfarrightvertical' => { 354 => 0x34 },
	'afstatusleft' => { 162 => 0x2d, 353 => 0x2, 356 => 0x22, 357 => 0x2d, 358 => 0x2d },
	'afstatuslefthorizontal' => { 354 => 0x6 },
	'afstatusleftvertical' => { 354 => 0xe },
	'afstatuslower-left' => { 353 => 0x4, 356 => 0x24 },
	'afstatuslower-lefthorizontal' => { 354 => 0xa },
	'afstatuslower-leftvertical' => { 354 => 0x10 },
	'afstatuslower-middle' => { 353 => 0x22, 354 => 0x24 },
	'afstatuslower-right' => { 353 => 0x1e, 356 => 0x4a },
	'afstatuslower-righthorizontal' => { 354 => 0x32 },
	'afstatuslower-rightvertical' => { 354 => 0x3a },
	'afstatuslowerfarleft' => { 354 => 0x8 },
	'afstatuslowerfarright' => { 354 => 0x30 },
	'afstatusmiddlehorizontal' => { 162 => 0xa, 357 => 0x23, 358 => 0x23 },
	'afstatusnearleft' => { 353 => 0xe, 354 => 0x1a },
	'afstatusnearright' => { 353 => 0xa, 354 => 0x16 },
	'afstatusright' => { 162 => 0x31, 353 => 0x1c, 356 => 0x48, 357 => 0x31, 358 => 0x31 },
	'afstatusrighthorizontal' => { 354 => 0x2e },
	'afstatusrightvertical' => { 354 => 0x38 },
	'afstatustop' => { 162 => 0xe, 356 => 0x40, 357 => 0x27, 358 => 0x27 },
	'afstatustop-left' => { 162 => 0x10, 357 => 0x29, 358 => 0x29 },
	'afstatustop-right' => { 162 => 0x4, 357 => 0x1d, 358 => 0x1d },
	'afstatustopassist-left' => { 356 => 0x3e },
	'afstatustopassist-right' => { 356 => 0x42 },
	'afstatustophorizontal' => { 353 => 0x8, 354 => 0x14 },
	'afstatustopvertical' => { 353 => 0x12, 354 => 0x1e },
	'afstatusupper-left' => { 353 => 0x0, 356 => 0x20 },
	'afstatusupper-lefthorizontal' => { 354 => 0x2 },
	'afstatusupper-leftvertical' => { 354 => 0xc },
	'afstatusupper-middle' => { 353 => 0x20, 354 => 0x20 },
	'afstatusupper-right' => { 353 => 0x1a, 356 => 0x46 },
	'afstatusupper-righthorizontal' => { 354 => 0x2a },
	'afstatusupper-rightvertical' => { 354 => 0x36 },
	'afstatusupperfarleft' => { 354 => 0x0 },
	'afstatusupperfarright' => { 354 => 0x28 },
	'afstatusviewfinder' => { 2 => 0x12 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 352 => 0x2 },
	'afwithshutter' => { 359 => 0x2a },
	'afzoneselected' => { 371 => 0x201e },
	'aggregateissuenumber' => { 434 => 'aggregateIssueNumber' },
	'aggregationtype' => { 434 => 'aggregationType' },
	'agreement' => { 437 => 'agreement' },
	'aiservocontinuousshooting' => { 74 => 0x15 },
	'aiservofirstimage' => { 2 => 0x5 },
	'aiservofirstimagepriority' => { 75 => 0x519 },
	'aiservoimagepriority' => { 75 => 0x503 },
	'aiservosecondimage' => { 2 => 0x6 },
	'aiservosecondimagepriority' => { 75 => 0x51a },
	'aiservotrackingmethod' => { 75 => 0x504 },
	'aiservotrackingsensitivity' => { 74 => 0x14, 75 => 0x502 },
	'album' => { 444 => 'album' },
	'alreadyapplied' => { 420 => 'AlreadyApplied' },
	'alternatetitle' => { 434 => 'alternateTitle' },
	'alternatetitlea-lang' => { 434 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 434 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 434 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 177 => 0x6 },
	'alttapename' => { 444 => 'altTapeName' },
	'alttimecode' => { 444 => 'altTimecode' },
	'alttimecodetimeformat' => { 444 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 444 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 444 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambienttemperature' => { 109 => 0x9400, 337 => 0x14, 393 => 0x4 },
	'ambienttemperaturefahrenheit' => { 337 => 0x13 },
	'analogbalance' => { 109 => 0xc627 },
	'angleadj' => { 94 => 0x10003, 100 => 0x8b },
	'angleinforoll' => { 415 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 415 => 'AngleInfoYaw' },
	'anti-blur' => { 371 => 0xb04b },
	'antialiasstrength' => { 109 => 0xc632 },
	'aperturelock' => { 246 => '38.2', 248 => '38.2', 249 => '38.2', 258 => '38.2' },
	'aperturerange' => { 75 => 0x10d },
	'apertureringuse' => { 297 => '1.4' },
	'aperturesetting' => { 166 => 0x7, 359 => 0x30, 360 => 0x29, 361 => 0x1 },
	'aperturevalue' => { 84 => 0x2, 109 => 0x9202, 266 => 0x1002, 325 => 0x401, 424 => 'ApertureValue' },
	'applekeywords' => { 270 => 'AAPL:Keywords' },
	'applicationnotes' => { 109 => 0x2bc, 286 => 0x2bc },
	'applicationrecordversion' => { 117 => 0x0 },
	'applyshootingmeteringmode' => { 75 => 0x10e },
	'approved' => { 426 => 'Approved' },
	'approvedby' => { 426 => 'ApprovedBy' },
	'approximatefnumber' => { 278 => 0x313, 284 => 0x3406 },
	'approximatefocusdistance' => { 416 => 'ApproximateFocusDistance' },
	'appversion' => { 428 => 'AppVersion' },
	'aquahsl' => { 94 => 0x20913 },
	'armidentifier' => { 118 => 0x78 },
	'armversion' => { 118 => 0x7a },
	'artfilter' => { 261 => 0x529 },
	'artfiltereffect' => { 261 => 0x52f },
	'artist' => { 109 => 0x13b, 274 => 'Artist', 316 => 0x22e, 440 => 'Artist', 444 => 'artist' },
	'artmode' => { 104 => 0x301b },
	'artmodeparameters' => { 104 => 0x310b },
	'artworkcircadatecreated' => { 430 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontentdescription' => { 430 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworkcontributiondescription' => { 430 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 430 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 430 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 430 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 430 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 430 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 430 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 430 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 430 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 430 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 430 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworksource' => { 430 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 430 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 430 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 430 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 430 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 265 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 265 => 0x1112, 316 => 0x80, 359 => 0x55, 360 => 0x55, 361 => 0xa },
	'assetid' => { 410 => 'AssetID' },
	'asshoticcprofile' => { 109 => 0xc68f },
	'asshotneutral' => { 109 => 0xc628 },
	'asshotpreprofilematrix' => { 109 => 0xc690 },
	'asshotprofilename' => { 109 => 0xc6f6 },
	'asshotwhitexy' => { 109 => 0xc629 },
	'assignbktbutton' => { 245 => '4.2', 246 => '16.1', 248 => '16.1', 249 => '16.1', 258 => '16.1' },
	'assignfuncbutton' => { 75 => 0x70b },
	'assignmb-d17af-onbutton' => { 249 => '79.1' },
	'assignmb-d17funcbutton' => { 249 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 249 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 248 => '75.1', 249 => '75.1' },
	'assignmoviefunc2button' => { 248 => '82.1', 249 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 248 => '75.2', 249 => '75.2' },
	'assignmovierecordbutton' => { 246 => '43.2', 258 => '45.1' },
	'assignmovierecordbuttonplusdials' => { 248 => '45.1', 249 => '45.1' },
	'assignmoviesubselector' => { 248 => '74.1', 249 => '74.1' },
	'assignmoviesubselectorplusdials' => { 248 => '76.1', 249 => '76.1' },
	'assignremotefnbutton' => { 246 => '54.1', 258 => '51.1' },
	'assistbuttonfunction' => { 73 => 0xd },
	'attributionname' => { 417 => 'attributionName' },
	'attributionurl' => { 417 => 'attributionURL' },
	'audio' => { 282 => 0x20 },
	'audiobitrate' => { 60 => 0x6c, 430 => 'audioBitRate' },
	'audiobitratemode' => { 430 => 'audioBitRateMode' },
	'audiochannelcount' => { 430 => 'audioChannelCount' },
	'audiochannels' => { 60 => 0x70 },
	'audiochanneltype' => { 444 => 'audioChannelType' },
	'audiocompression' => { 138 => 'Compression' },
	'audiocompressor' => { 444 => 'audioCompressor' },
	'audiodata' => { 406 => 'Data' },
	'audioduration' => { 117 => 0x99 },
	'audiomimetype' => { 406 => 'Mime' },
	'audiomoddate' => { 444 => 'audioModDate' },
	'audiooutcue' => { 117 => 0x9a },
	'audiosamplerate' => { 60 => 0x6e, 444 => 'audioSampleRate' },
	'audiosampletype' => { 444 => 'audioSampleType' },
	'audiosamplingrate' => { 117 => 0x97 },
	'audiosamplingresolution' => { 117 => 0x98 },
	'audiotype' => { 117 => 0x96 },
	'author' => { 140 => 'Author', 270 => 'Author', 274 => 'Author', 332 => 'Author', 414 => 'author', 431 => 'Author', 442 => 'Author' },
	'authorsposition' => { 432 => 'AuthorsPosition' },
	'autoafpointcolortracking' => { 75 => 0x51c },
	'autoafpointseleositraf' => { 2 => 0xa },
	'autoaperture' => { 307 => '0.1' },
	'autobracket' => { 351 => 0x19 },
	'autobracketing' => { 114 => 0x1100, 316 => 0x18, 341 => 0x1007 },
	'autobracketingmode' => { 257 => '12.3' },
	'autobracketingset' => { 257 => '12.1' },
	'autobracketmodem' => { 245 => '21.2', 246 => '13.3', 248 => '13.2', 249 => '13.2', 254 => '26.2', 258 => '13.3' },
	'autobracketorder' => { 166 => 0x43, 245 => '21.3', 246 => '13.2', 248 => '13.1', 249 => '13.1', 254 => '26.3', 255 => '12.2', 256 => '2.2', 257 => '12.2', 258 => '13.2', 259 => '13.2' },
	'autobracketset' => { 245 => '21.1', 246 => '13.1', 250 => '11.1', 251 => '12.1', 252 => '12.1', 254 => '26.1', 255 => '12.1', 256 => '2.1', 258 => '13.1', 259 => '13.1' },
	'autobrightness' => { 420 => 'AutoBrightness' },
	'autocontrast' => { 420 => 'AutoContrast' },
	'autodistortioncontrol' => { 185 => 0x4 },
	'autodynamicrange' => { 114 => 0x140b },
	'autoexposure' => { 420 => 'AutoExposure' },
	'autoexposurebracketing' => { 69 => 0x10 },
	'autoflashisosensitivity' => { 248 => '38.5', 249 => '38.5' },
	'autofocus' => { 264 => 0x209 },
	'autofp' => { 256 => '7.3', 259 => '31.4' },
	'autoiso' => { 69 => 0x1, 104 => 0x3008, 247 => '1.1', 256 => '1.1' },
	'autoisomax' => { 247 => '1.2', 256 => '1.2' },
	'autoisominshutterspeed' => { 247 => '1.3', 256 => '1.3' },
	'autolateralca' => { 420 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 15 => 0xbe, 16 => 0xbf, 19 => 0xbf, 56 => 0x2, 75 => 0x204, 94 => 0x20500, 100 => 0x6f },
	'autolightingoptimizeron' => { 94 => '0x20500.0', 100 => 0x6e },
	'autoportraitframed' => { 371 => 0x2016 },
	'autoredeye' => { 238 => 0xfe28a44f },
	'autorotate' => { 69 => 0x1b },
	'autoshadows' => { 420 => 'AutoShadows' },
	'autowhiteversion' => { 420 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 200 => 0x82 },
	'avaperturesetting' => { 297 => 0x13 },
	'averageblacklevel' => { 40 => 0xe7, 42 => 0xfb, 43 => 0x114, 44 => 0x146 },
	'averagelv' => { 169 => 0x38 },
	'avsettingwithoutlens' => { 75 => 0x707 },
	'azimuth' => { 148 => 'Azimuth' },
	'babyage' => { 282 => [0x8010,0x33] },
	'babyname' => { 282 => 0x66 },
	'backgroundalpha' => { 439 => 'bgalpha' },
	'baseexposurecompensation' => { 297 => 0x15 },
	'baseiso' => { 69 => 0x2, 88 => 0x101c, 123 => 0x903, 284 => 0x312a, 398 => 0x6 },
	'baselineexposure' => { 109 => 0xc62a },
	'baselineexposureoffset' => { 109 => 0xc7a5 },
	'baselinenoise' => { 109 => 0xc62b },
	'baselinesharpness' => { 109 => 0xc62c },
	'baseurl' => { 442 => 'BaseURL' },
	'batterylevel' => { 359 => 0x51, 363 => 0xc, 364 => 0x4, 365 => 0x4, 399 => 0x7 },
	'batterylevelgrip1' => { 399 => 0x6 },
	'batterylevelgrip2' => { 399 => 0x8 },
	'batteryorder' => { 245 => '12.5', 254 => '13.2', 255 => '2.1', 258 => '3.1' },
	'batterystate' => { 166 => 0x60, 359 => 0x50, 365 => 0x14 },
	'batterytemperature' => { 363 => 0x1, 365 => 0x2, 399 => 0x5 },
	'batteryunknown' => { 363 => 0x2, 365 => 0x0 },
	'batteryvoltage' => { 123 => 0x408, 337 => 0x2a, 363 => 0x8 },
	'batteryvoltage1' => { 365 => 0x6 },
	'batteryvoltage2' => { 365 => 0x8 },
	'bayergreensplit' => { 109 => 0xc62d },
	'bayerpattern' => { 122 => 0xf902, 170 => 0x17 },
	'beatspliceparams' => { 444 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 444 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 444 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 444 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 444 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 444 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 245 => '13.1', 246 => '5.4', 247 => '0.1', 250 => '2.1', 251 => '3.1', 252 => '3.1', 254 => '10.1', 256 => '0.1', 258 => '5.5', 259 => '4.1' },
	'beeppitch' => { 255 => '3.1' },
	'beepvolume' => { 255 => '4.5' },
	'bestqualityscale' => { 109 => 0xc65c },
	'bestshotmode' => { 104 => 0x3007 },
	'bitdepth' => { 145 => 'BitDepth', 170 => 0x11, 207 => 0x41 },
	'bitspercomponent' => { 119 => 0x87 },
	'bitspersample' => { 109 => 0x102, 440 => 'BitsPerSample' },
	'blacklevel' => { 109 => 0xc61a, 200 => 0x3d, 266 => [0x401,0x1012], 325 => 0x21d },
	'blacklevel1' => { 286 => 0x8 },
	'blacklevel2' => { 265 => 0x600, 269 => 0x600, 286 => 0x9 },
	'blacklevel3' => { 286 => 0xa },
	'blacklevelblue' => { 286 => 0x1e },
	'blackleveldata' => { 325 => 0x223 },
	'blackleveldeltah' => { 109 => 0xc61b },
	'blackleveldeltav' => { 109 => 0xc61c },
	'blacklevelgreen' => { 286 => 0x1d },
	'blacklevelred' => { 286 => 0x1c },
	'blacklevelrepeatdim' => { 109 => 0xc619 },
	'blackpoint' => { 316 => 0x200 },
	'blacks2012' => { 420 => 'Blacks2012' },
	'bleachbypasstoning' => { 316 => 0x7f },
	'blockshotafresponse' => { 248 => '1.5', 249 => '1.5' },
	'blogtitle' => { 434 => 'blogTitle' },
	'blogurl' => { 434 => 'blogURL' },
	'bluebalance' => { 183 => 0x271, 266 => 0x1018, 286 => 0x12, 316 => 0x1b },
	'bluecurvelimits' => { 99 => 0x1fe },
	'bluecurvepoints' => { 98 => 0x79, 99 => 0x1d4 },
	'bluehsl' => { 94 => [0x20914,0x20915] },
	'bluehue' => { 420 => 'BlueHue' },
	'bluesaturation' => { 420 => 'BlueSaturation' },
	'blurcontrol' => { 316 => 0x82 },
	'blurwarning' => { 114 => 0x1300 },
	'bodybatteryadload' => { 295 => 0x3 },
	'bodybatteryadnoload' => { 295 => 0x2 },
	'bodybatterystate' => { 295 => '1.1' },
	'bodybatteryvoltage1' => { 295 => 0x2 },
	'bodybatteryvoltage2' => { 295 => 0x4 },
	'bodybatteryvoltage3' => { 295 => 0x6 },
	'bodybatteryvoltage4' => { 295 => 0x8 },
	'bodyfirmware' => { 342 => 0x0 },
	'bodyfirmwareversion' => { 262 => 0x104, 263 => 0x100, 266 => 0x104 },
	'bodyserialnumber' => { 342 => 0x10 },
	'bookedition' => { 434 => 'bookEdition' },
	'bracketmode' => { 51 => 0x3 },
	'bracketsequence' => { 104 => 0x301d },
	'bracketsettings' => { 282 => 0x45 },
	'bracketshotnumber' => { 51 => 0x5, 297 => 0x9, 370 => 0x2b },
	'bracketshotnumber2' => { 370 => 0x2d },
	'bracketstep' => { 163 => 0xe },
	'bracketvalue' => { 51 => 0x4 },
	'brightness' => { 109 => 0xfe53, 139 => 'Brightness', 159 => 'Brightness', 163 => 0x2c, 202 => 0x34, 203 => 0x39, 337 => 0x25, 359 => 0x22, 371 => 0x2007, 420 => 'Brightness' },
	'brightnessadj' => { 99 => 0x114, 231 => 0x0, 241 => 0x2d, 402 => 0x8018 },
	'brightnessvalue' => { 109 => 0x9203, 169 => [0x691,0x49c3], 266 => 0x1003, 375 => 0x1e, 378 => 0x1140, 379 => 0x1140, 380 => 0x111c, 381 => 0x1198, 382 => 0x1174, 383 => 0x102c, 384 => 0x224, 385 => 0x224, 386 => 0x219, 424 => 'BrightnessValue' },
	'bulbduration' => { 69 => 0x18 },
	'burstmode' => { 125 => 0xa, 282 => 0x2a },
	'burstmode2' => { 125 => 0x18 },
	'burstshot' => { 351 => 0x34 },
	'burstspeed' => { 282 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 75 => 0x70a },
	'bwfilter' => { 163 => 0x2a, 171 => 0x39 },
	'bwmode' => { 266 => 0x203 },
	'by-line' => { 117 => 0x50 },
	'by-linetitle' => { 117 => 0x55 },
	'bytecount' => { 434 => 'byteCount' },
	'calibration' => { 351 => [0x24,0x30] },
	'calibrationilluminant1' => { 109 => 0xc65a },
	'calibrationilluminant2' => { 109 => 0xc65b },
	'callforimage' => { 410 => 'CallForImage' },
	'cameraangle' => { 444 => 'cameraAngle' },
	'cameracalibration1' => { 109 => 0xc623 },
	'cameracalibration2' => { 109 => 0xc624 },
	'cameracalibrationsig' => { 109 => 0xc6f3 },
	'cameracolorcalibration01' => { 35 => 0x0, 41 => 0xba },
	'cameracolorcalibration02' => { 35 => 0x4, 41 => 0xbf },
	'cameracolorcalibration03' => { 35 => 0x8, 41 => 0xc4 },
	'cameracolorcalibration04' => { 35 => 0xc, 41 => 0xc9 },
	'cameracolorcalibration05' => { 35 => 0x10, 41 => 0xce },
	'cameracolorcalibration06' => { 35 => 0x14, 41 => 0xd3 },
	'cameracolorcalibration07' => { 35 => 0x18, 41 => 0xd8 },
	'cameracolorcalibration08' => { 35 => 0x1c, 41 => 0xdd },
	'cameracolorcalibration09' => { 35 => 0x20, 41 => 0xe2 },
	'cameracolorcalibration10' => { 35 => 0x24, 41 => 0xe7 },
	'cameracolorcalibration11' => { 35 => 0x28, 41 => 0xec },
	'cameracolorcalibration12' => { 35 => 0x2c, 41 => 0xf1 },
	'cameracolorcalibration13' => { 35 => 0x30, 41 => 0xf6 },
	'cameracolorcalibration14' => { 35 => 0x34, 41 => 0xfb },
	'cameracolorcalibration15' => { 35 => 0x38, 41 => 0x100 },
	'camerae-mountversion' => { 401 => 0xb },
	'cameraelevationangle' => { 109 => 0x9405 },
	'camerafilename' => { 410 => 'CameraFilename' },
	'cameraid' => { 266 => 0x209, 350 => 0x209 },
	'cameraiso' => { 33 => 0x10 },
	'cameralabel' => { 109 => 0xc7a1, 444 => 'cameraLabel' },
	'cameramakemodel' => { 410 => 'CameraMakeModel' },
	'cameramodel' => { 325 => 0x410, 444 => 'cameraModel' },
	'cameramodelid' => { 159 => 'CameraModelID' },
	'cameramove' => { 444 => 'cameraMove' },
	'cameraorientation' => { 6 => 0x30, 8 => 0x7d, 10 => 0x30, 12 => 0x35, 13 => 0x30, 14 => 0x30, 15 => 0x31, 16 => 0x31, 17 => 0x35, 18 => 0x27, 19 => 0x31, 20 => 0x7d, 21 => 0x38, 22 => 0x36, 23 => 0x7d, 24 => 0x83, 25 => 0x84, 27 => 0x35, 28 => 0x96, 282 => 0x8f, 320 => 0x1, 325 => 0x100, 365 => [0x16,0x18], 390 => 0x28, 391 => 0x24, 392 => 0x29 },
	'cameraowner' => { 126 => 0xc353 },
	'cameraparameters' => { 266 => 0x2050 },
	'camerapicturestyle' => { 27 => 0xaf },
	'camerapitch' => { 106 => 0x9 },
	'cameraprofile' => { 420 => 'CameraProfile' },
	'cameraprofiledigest' => { 420 => 'CameraProfileDigest' },
	'camerarawcolortone' => { 100 => 0xe1 },
	'camerarawcontrast' => { 100 => 0xe3 },
	'camerarawhighlightpoint' => { 100 => 0xe6 },
	'camerarawlinear' => { 100 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 100 => 0xe8 },
	'camerarawoutputshadowpoint' => { 100 => 0xe9 },
	'camerarawsaturation' => { 100 => 0xe2 },
	'camerarawshadowpoint' => { 100 => 0xe7 },
	'camerarawsharpness' => { 100 => 0xe5 },
	'cameraroll' => { 106 => 0xb },
	'cameraserialnumber' => { 109 => 0xc62f, 161 => 'CameraSerialNumber', 410 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 261 => 0x0 },
	'cameratemperature' => { 6 => 0x18, 8 => 0x1b, 10 => 0x18, 12 => 0x19, 13 => 0x18, 14 => 0x18, 15 => 0x19, 16 => 0x19, 17 => 0x19, 18 => 0x17, 19 => 0x19, 20 => 0x1b, 21 => 0x19, 22 => 0x19, 23 => 0x1b, 24 => 0x1b, 25 => 0x1b, 26 => 0x1b, 27 => 0x19, 28 => 0x1b, 29 => [0x87,0x91], 30 => [0x99,0x9f,0xa4,0xa8,0x105], 32 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 69 => 0xc, 123 => 0x406, 265 => 0x1306, 278 => 0x320, 284 => 0x3402, 316 => 0x47, 348 => 0x43, 394 => 0x5 },
	'cameratemperature4' => { 321 => 0x14 },
	'cameratemperature5' => { 321 => 0x16 },
	'cameratemperaturerangemax' => { 111 => 0x5 },
	'cameratemperaturerangemin' => { 111 => 0x6 },
	'cameratype' => { 69 => 0x1a, 266 => 0x207 },
	'cameratype2' => { 262 => 0x100 },
	'camerayaw' => { 106 => 0xa },
	'canondr4' => { 110 => 'CanonDR4' },
	'canonexposuremode' => { 33 => 0x14 },
	'canonfiledescription' => { 88 => 0x805 },
	'canonfilelength' => { 57 => 0xe },
	'canonfirmwareversion' => { 57 => 0x7, 88 => 0x80b },
	'canonflashinfo' => { 88 => 0x1028 },
	'canonflashmode' => { 33 => 0x4 },
	'canonimagesize' => { 9 => 0x39, 33 => 0xa },
	'canonimagetype' => { 57 => 0x6, 88 => 0x815 },
	'canonmodelid' => { 57 => 0x10, 88 => 0x1834 },
	'canonvrd' => { 110 => 'CanonVRD' },
	'caption' => { 414 => 'caption' },
	'caption-abstract' => { 117 => 0x78 },
	'captionsauthornames' => { 423 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 423 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 432 => 'CaptionWriter' },
	'captureframerate' => { 104 => 0x4001 },
	'capturesoftware' => { 408 => 'CaptureSoftware' },
	'cardshutterlock' => { 166 => 0x49 },
	'casioimagesize' => { 104 => 0x9 },
	'catalogsets' => { 117 => 0xff, 405 => 'CatalogSets', 412 => 'CatalogSets' },
	'categories' => { 57 => 0x23, 414 => 'categories' },
	'category' => { 117 => 0xf, 260 => 0x30, 432 => 'Category' },
	'cbcrgain' => { 348 => 0xa036 },
	'cbcrgaindefault' => { 348 => 0xa035 },
	'cbcrmatrix' => { 348 => 0xa034 },
	'cbcrmatrixdefault' => { 348 => 0xa033 },
	'ccdboardversion' => { 278 => 0x331 },
	'ccdscanmode' => { 266 => 0x1039 },
	'ccdsensitivity' => { 228 => 0x6 },
	'ccdversion' => { 278 => 0x330 },
	'cellglobalid' => { 418 => 'cgi' },
	'celllength' => { 109 => 0x109 },
	'cellr' => { 418 => 'r' },
	'celltowerid' => { 418 => 'cellid' },
	'cellwidth' => { 109 => 0x108 },
	'centerafarea' => { 256 => '15.1' },
	'centerfocuspoint' => { 259 => '2.2' },
	'centerweightedareasize' => { 245 => '7.1', 246 => '8.1', 248 => '8.1', 249 => '8.1', 253 => '7.1', 254 => '5.1', 255 => '7.1', 256 => '6.3', 258 => '8.1', 259 => '8.1' },
	'certificate' => { 448 => 'Certificate' },
	'cfapattern' => { 109 => 0xa302, 424 => 'CFAPattern' },
	'cfapattern2' => { 109 => 0x828e },
	'cfapatterncolumns' => { 424 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 424 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 424 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 109 => 0x828d },
	'channel' => { 434 => 'channel' },
	'channela-lang' => { 434 => [\'channel','channelA-lang'] },
	'channelchannel' => { 434 => [\'channel','channelChannel'] },
	'channels' => { 138 => 'Channels' },
	'channelsubchannel1' => { 434 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 434 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 434 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 434 => [\'channel','channelSubchannel4'] },
	'checkmark' => { 94 => 0x10101, 99 => 0x26a },
	'checkmark2' => { 100 => 0x8e },
	'childfontfiles' => { 449 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 245 => '10.3', 246 => '11.2' },
	'chromablurradius' => { 109 => 0xc631 },
	'chromaticaberration' => { 94 => 0x20703, 100 => 0x66, 348 => 0xa051 },
	'chromaticaberrationb' => { 420 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 94 => 0x20708, 100 => 0x6b },
	'chromaticaberrationcorr' => { 71 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 306 => 0x1 },
	'chromaticaberrationcorrparams' => { 109 => 0x7035, 397 => 0x66a, 398 => [0x37c,0x384,0x39c,0x3b0,0x3b8] },
	'chromaticaberrationon' => { 94 => '0x20703.0', 100 => 0x62 },
	'chromaticaberrationr' => { 420 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 94 => 0x20707, 100 => 0x6a },
	'chromaticaberrationsetting' => { 72 => 0x6 },
	'chrominancenoisereduction' => { 94 => 0x20601, 100 => 0x5e, 351 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 100 => 0x60 },
	'circadatecreated' => { 430 => 'CircaDateCreated' },
	'circgradbasedcorractive' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrbrightness' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrdefringe' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrexposure' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrluminancenoise' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskleft' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmidpoint' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskperimetervalue' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskright' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskx' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrsaturation' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrshadows2012' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtint' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrwhat' => { 420 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circulargradientbasedcorrections' => { 420 => 'CircularGradientBasedCorrections' },
	'city' => { 117 => 0x5a, 144 => 'City', 282 => 0x6d, 432 => 'City' },
	'city2' => { 282 => 0x80 },
	'clarity' => { 203 => 0x35, 420 => 'Clarity' },
	'clarity2012' => { 420 => 'Clarity2012' },
	'claritycontrol' => { 316 => 0x96 },
	'classifystate' => { 117 => 0xe1 },
	'clearretouch' => { 282 => 0x7c },
	'clearretouchvalue' => { 282 => 0xa3 },
	'client' => { 444 => 'client' },
	'clientname' => { 426 => 'ClientName' },
	'clmodeshootingspeed' => { 245 => '10.2', 246 => '11.3', 248 => '11.2', 249 => '11.2', 254 => '11.2', 255 => '10.2', 258 => '11.2', 259 => '11.1' },
	'cmcontrast' => { 269 => 0x2022 },
	'cmexposurecompensation' => { 269 => 0x2000 },
	'cmhue' => { 269 => 0x2021 },
	'cmsaturation' => { 269 => 0x2020 },
	'cmsharpness' => { 269 => 0x2023 },
	'cmwhitebalance' => { 269 => 0x2001 },
	'cmwhitebalancecomp' => { 269 => 0x2002 },
	'cmwhitebalancegraypoint' => { 269 => 0x2010 },
	'codec' => { 152 => 'Codec' },
	'codedcharacterset' => { 118 => 0x5a },
	'collectionname' => { 153 => [\'Collections','CollectionsCollectionName'] },
	'collections' => { 153 => 'Collections', 414 => 'collections' },
	'collectionuri' => { 153 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 433 => 'color' },
	'coloraberrationcontrol' => { 238 => 0xc89224b },
	'coloradjustment' => { 351 => 0x14 },
	'coloradjustmentmode' => { 350 => 0x210 },
	'coloranta' => { 449 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 449 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 449 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 449 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 449 => [\'Colorants','ColorantsCyan'] },
	'colorantgray' => { 449 => [\'Colorants','ColorantsGray'] },
	'colorantgreen' => { 449 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 449 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 449 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 449 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 449 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 449 => 'Colorants' },
	'colorantswatchname' => { 449 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 449 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 449 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 449 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 139 => 'ColorBalance' },
	'colorbalanceadj' => { 238 => 0x76a43202 },
	'colorbalanceblue' => { 163 => 0x1e },
	'colorbalancegreen' => { 163 => 0x1d },
	'colorbalancered' => { 163 => 0x1c },
	'colorbalanceversion' => { 184 => 0x0 },
	'colorblur' => { 100 => 0x65 },
	'colorbluron' => { 94 => 0x20704 },
	'colorbooster' => { 238 => 0x5f0e7d23 },
	'colorboostlevel' => { 232 => 0x1 },
	'colorboosttype' => { 232 => 0x0 },
	'colorclass' => { 327 => 0xde, 328 => 'ColorClass' },
	'colorcompensationfilter' => { 166 => [0x3a,0x5f], 168 => 0x111, 371 => 0xb022 },
	'colorcompensationfiltercustom' => { 359 => 0xd, 360 => 0xc },
	'colorcompensationfilterset' => { 359 => 0x8, 360 => 0x7, 361 => 0x18, 375 => 0xf },
	'colorcontrol' => { 266 => 0x102b },
	'colorcorrection' => { 402 => 0x8015 },
	'colorcreatoreffect' => { 261 => 0x532 },
	'colordataversion' => { 39 => 0x0, 40 => 0x0, 42 => 0x0, 43 => 0x0, 44 => 0x0 },
	'coloreffect' => { 282 => 0x28 },
	'colorfilter' => { 103 => 0x17, 104 => 0x3017, 163 => 0x29, 171 => [0x38,0x4d,0x4f], 323 => 0x17 },
	'colorgain' => { 207 => 0x51 },
	'colorhue' => { 94 => 0x20900, 200 => 0x8d },
	'colorimetricreference' => { 109 => 0xc6bf },
	'colorlabel' => { 423 => 'ColorLabel' },
	'colormatrix' => { 265 => 0x200, 266 => 0x1011, 348 => 0xa030 },
	'colormatrix1' => { 109 => 0xc621, 325 => 0x106 },
	'colormatrix2' => { 109 => 0xc622, 269 => 0x200, 325 => 0x226 },
	'colormatrixa' => { 316 => 0x203 },
	'colormatrixadobergb' => { 348 => 0xa032 },
	'colormatrixb' => { 316 => 0x204 },
	'colormatrixnumber' => { 266 => 0x1019 },
	'colormatrixsrgb' => { 348 => 0xa031 },
	'colormode' => { 104 => 0x3015, 114 => 0x1210, 125 => 0x66, 163 => 0x28, 166 => 0x16, 168 => 0x101, 169 => 0x36, 171 => 0x7, 200 => 0x3, 228 => 0x4, 282 => 0x32, 351 => 0x2c, 371 => 0xb029, 432 => 'ColorMode' },
	'colormoirereduction' => { 239 => 0x15 },
	'colormoirereductionmode' => { 239 => 0x5 },
	'colornoisereduction' => { 402 => 0x8029, 420 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 420 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 239 => 0x18 },
	'colornoisereductionsharpness' => { 239 => 0x1c },
	'colornoisereductionsmoothness' => { 420 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 113 => 0x2 },
	'colorprofile' => { 163 => 0x33 },
	'colorprofilesettings' => { 261 => 0x539 },
	'colorrepresentation' => { 119 => 0x3c },
	'colorsaturationadj' => { 94 => 0x20305 },
	'colorsequence' => { 119 => 0x41 },
	'colorspace' => { 45 => 0x3, 57 => 0xb4, 88 => 0x10b4, 109 => 0xa001, 145 => 'ColorSpace', 164 => 0x2f, 165 => 0x25, 166 => 0x17, 200 => 0x1e, 261 => 0x507, 316 => 0x37, 348 => 0xa011, 351 => 0xb, 359 => 0x1b, 360 => 0x83, 361 => 0xe, 375 => 0x6, 424 => 'ColorSpace' },
	'colortempasshot' => { 36 => 0x4, 37 => 0x1d, 38 => 0x26, 39 => 0x43, 42 => 0x43, 43 => 0x43, 44 => 0x43 },
	'colortempauto' => { 36 => 0x9, 37 => 0x22, 38 => 0x1c, 39 => 0x48, 42 => 0x48, 43 => 0x48, 44 => 0x48 },
	'colortempcloudy' => { 36 => 0x22, 37 => 0x31, 38 => 0x35, 39 => 0x5c, 42 => 0x75, 43 => 0x8e, 44 => 0x93, 316 => 0x55 },
	'colortempcustom' => { 39 => 0x84 },
	'colortempcustom1' => { 37 => 0x45 },
	'colortempcustom2' => { 37 => 0x4a },
	'colortempdaylight' => { 36 => 0x18, 37 => 0x27, 38 => 0x2b, 39 => 0x52, 42 => 0x6b, 43 => 0x84, 44 => 0x89, 316 => 0x53 },
	'colortemperature' => { 6 => 0x73, 7 => [0x48,0x4e], 8 => 0xc0, 9 => 0x37, 10 => 0x62, 11 => 0x37, 12 => 0x7c, 13 => 0x73, 14 => 0x73, 15 => 0x77, 16 => 0x73, 17 => 0x7c, 18 => 0x58, 19 => 0x73, 20 => 0xc0, 21 => 0x7f, 22 => 0x7d, 23 => 0xc0, 24 => 0xc6, 25 => 0xc7, 26 => 0x135, 27 => 0x7b, 28 => 0x13a, 57 => 0xae, 67 => 0x9, 88 => 0x10ae, 114 => 0x1005, 123 => 0x846, 139 => 'ColorTemperature', 164 => [0x6e,0x49], 165 => 0x3f, 166 => [0x39,0x5e], 168 => 0x10b, 171 => [0x3c,0x4c,0x4e], 278 => 0x321, 316 => 0x50, 341 => 0x1308, 371 => 0xb021, 420 => 'Temperature' },
	'colortemperatureadj' => { 402 => 0x8013 },
	'colortemperaturebg' => { 266 => 0x1013 },
	'colortemperaturecustom' => { 359 => 0xc, 360 => 0xb },
	'colortemperaturerg' => { 266 => 0x1014 },
	'colortemperatureset' => { 359 => 0x7, 360 => 0x6 },
	'colortemperaturesetting' => { 166 => 0x25, 361 => 0x17, 375 => 0xe },
	'colortempflash' => { 36 => 0x36, 37 => 0x40, 38 => 0x49, 39 => 0x70, 42 => 0x89, 43 => 0xa2, 44 => 0xa7, 316 => 0x5a },
	'colortempflashdata' => { 39 => 0x24a },
	'colortempfluorescent' => { 36 => 0x2c, 37 => 0x3b, 38 => 0x3f, 39 => 0x66, 42 => 0x7f, 43 => 0x98, 44 => 0x9d },
	'colortempfluorescentd' => { 316 => 0x57 },
	'colortempfluorescentn' => { 316 => 0x58 },
	'colortempfluorescentw' => { 316 => 0x59 },
	'colortempkelvin' => { 36 => 0x31, 38 => 0x44, 39 => 0x6b, 42 => 0x84, 43 => 0x9d, 44 => 0xa2, 282 => 0x44, 341 => 0x1307 },
	'colortempmeasured' => { 36 => 0xe, 39 => 0x4d, 42 => 0x4d, 43 => 0x4d, 44 => 0x4d },
	'colortemppc1' => { 38 => 0x94, 39 => 0x75 },
	'colortemppc2' => { 38 => 0x99, 39 => 0x7a },
	'colortemppc3' => { 38 => 0x9e, 39 => 0x7f },
	'colortempshade' => { 36 => 0x1d, 37 => 0x2c, 38 => 0x30, 39 => 0x57, 42 => 0x70, 43 => 0x89, 44 => 0x8e, 316 => 0x54 },
	'colortemptungsten' => { 36 => 0x27, 37 => 0x36, 38 => 0x3a, 39 => 0x61, 42 => 0x7a, 43 => 0x93, 44 => 0x98, 316 => 0x56 },
	'colortempunknown' => { 36 => 0x13, 38 => 0x21, 42 => 0x52, 43 => 0x52, 44 => 0x52 },
	'colortempunknown10' => { 36 => 0x63, 38 => 0x76, 42 => 0xa2, 43 => 0x7f, 44 => 0x7f },
	'colortempunknown11' => { 36 => 0x68, 38 => 0x7b, 42 => 0xa7, 43 => 0xa7, 44 => 0x84 },
	'colortempunknown12' => { 36 => 0x6d, 38 => 0x80, 42 => 0xac, 43 => 0xac, 44 => 0xac },
	'colortempunknown13' => { 36 => 0x72, 38 => 0x85, 42 => 0xb1, 43 => 0xb1, 44 => 0xb1 },
	'colortempunknown14' => { 38 => 0x8a, 42 => 0xb6, 43 => 0xb6, 44 => 0xb6 },
	'colortempunknown15' => { 38 => 0x8f, 42 => 0xbb, 43 => 0xbb, 44 => 0xbb },
	'colortempunknown16' => { 38 => 0xa3, 43 => 0xc0, 44 => 0xc0 },
	'colortempunknown17' => { 43 => 0xc5, 44 => 0xc5 },
	'colortempunknown18' => { 43 => 0xca, 44 => 0xca },
	'colortempunknown19' => { 43 => 0xcf, 44 => 0xcf },
	'colortempunknown2' => { 36 => 0x3b, 38 => 0x4e, 42 => 0x57, 43 => 0x57, 44 => 0x57 },
	'colortempunknown20' => { 43 => 0xd4, 44 => 0xd4 },
	'colortempunknown21' => { 44 => 0xd9 },
	'colortempunknown22' => { 44 => 0xde },
	'colortempunknown23' => { 44 => 0xe3 },
	'colortempunknown24' => { 44 => 0xe8 },
	'colortempunknown25' => { 44 => 0xed },
	'colortempunknown26' => { 44 => 0xf2 },
	'colortempunknown27' => { 44 => 0xf7 },
	'colortempunknown28' => { 44 => 0xfc },
	'colortempunknown29' => { 44 => 0x101 },
	'colortempunknown3' => { 36 => 0x40, 38 => 0x53, 42 => 0x5c, 43 => 0x5c, 44 => 0x5c },
	'colortempunknown30' => { 44 => 0x106 },
	'colortempunknown4' => { 36 => 0x45, 38 => 0x58, 42 => 0x61, 43 => 0x61, 44 => 0x61 },
	'colortempunknown5' => { 36 => 0x4a, 38 => 0x5d, 42 => 0x66, 43 => 0x66, 44 => 0x66 },
	'colortempunknown6' => { 36 => 0x4f, 38 => 0x62, 42 => 0x8e, 43 => 0x6b, 44 => 0x6b },
	'colortempunknown7' => { 36 => 0x54, 38 => 0x67, 42 => 0x93, 43 => 0x70, 44 => 0x70 },
	'colortempunknown8' => { 36 => 0x59, 38 => 0x6c, 42 => 0x98, 43 => 0x75, 44 => 0x75 },
	'colortempunknown9' => { 36 => 0x5e, 38 => 0x71, 42 => 0x9d, 43 => 0x7a, 44 => 0x7a },
	'colortone' => { 9 => 0x6f, 11 => 0x77, 33 => 0x2a, 45 => 0x2 },
	'colortoneadj' => { 94 => 0x20304, 99 => 0x11e },
	'colortoneauto' => { 64 => 0x9c },
	'colortonefaithful' => { 18 => 0x107, 63 => 0x6c, 64 => 0x6c },
	'colortonelandscape' => { 18 => 0x105, 63 => 0x3c, 64 => 0x3c },
	'colortonemonochrome' => { 63 => 0x84, 64 => 0x84 },
	'colortoneneutral' => { 18 => 0x106, 63 => 0x54, 64 => 0x54 },
	'colortoneportrait' => { 18 => 0x104, 63 => 0x24, 64 => 0x24 },
	'colortonestandard' => { 18 => 0x103, 63 => 0xc, 64 => 0xc },
	'colortoneuserdef1' => { 18 => 0x109, 63 => 0x9c, 64 => 0xb4 },
	'colortoneuserdef2' => { 18 => 0x10a, 63 => 0xb4, 64 => 0xcc },
	'colortoneuserdef3' => { 18 => 0x10b, 63 => 0xcc, 64 => 0xe4 },
	'commanddials' => { 256 => '5.1' },
	'commanddialsaperturesetting' => { 245 => '17.3', 246 => '18.3', 248 => '18.3', 249 => '18.3', 254 => '33.3', 255 => '17.3', 258 => '18.3' },
	'commanddialschangemainsub' => { 245 => '17.2', 246 => '18.1', 248 => '18.1', 249 => '18.1', 254 => '33.2', 255 => '17.2', 258 => '18.1' },
	'commanddialsmenuandplayback' => { 245 => '17.4', 246 => '18.2', 248 => '18.2', 249 => '18.2', 254 => '33.4', 255 => '17.4', 258 => '18.2' },
	'commanddialsreverserotation' => { 245 => '17.1', 246 => '6.4', 248 => '6.2', 249 => '6.2', 250 => '16.2', 251 => '17.2', 254 => '33.1', 255 => '17.1', 258 => '6.2', 259 => '18.1' },
	'commanderchannel' => { 256 => '10.2', 257 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 256 => '13.1', 257 => '31.1' },
	'commandergroupa_ttlcomp' => { 259 => '32.1' },
	'commandergroupamanualoutput' => { 256 => '13.2', 257 => '28.2' },
	'commandergroupamode' => { 256 => '11.2', 257 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 256 => '14.1', 257 => '32.1' },
	'commandergroupb_ttlcomp' => { 259 => '33.1' },
	'commandergroupbmanualoutput' => { 256 => '14.2', 257 => '29.2' },
	'commandergroupbmode' => { 256 => '11.3', 257 => '29.1' },
	'commanderinternalflash' => { 256 => '11.1', 257 => '27.1' },
	'commanderinternalmanualoutput' => { 256 => '12.2', 257 => '27.2' },
	'commanderinternalttlchannel' => { 254 => '18.2' },
	'commanderinternalttlcomp' => { 256 => '12.1', 257 => '30.2', 259 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 254 => '20.1', 255 => '26.1' },
	'commanderinternalttlcompgroupa' => { 254 => '21.1', 255 => '27.1' },
	'commanderinternalttlcompgroupb' => { 254 => '22.1', 255 => '28.1' },
	'comment' => { 0 => 0x2, 110 => 'Comment', 140 => 'Comment', 274 => 'Comment' },
	'compass' => { 344 => 0x4 },
	'complianceprofile' => { 434 => 'complianceProfile' },
	'componentsconfiguration' => { 109 => 0x9101, 145 => 'Components', 424 => 'ComponentsConfiguration' },
	'componentversion' => { 88 => 0x80c },
	'composer' => { 444 => 'composer' },
	'composition' => { 410 => 'Composition' },
	'compositionadjust' => { 315 => '0.1' },
	'compositionadjustrotation' => { 315 => 0x7 },
	'compositionadjustx' => { 315 => 0x5 },
	'compositionadjusty' => { 315 => 0x6 },
	'compressedbitsperpixel' => { 109 => 0x9102, 424 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 168 => 0x40, 266 => 0x40 },
	'compression' => { 109 => 0x103, 440 => 'Compression' },
	'compressionfactor' => { 261 => 0x50d },
	'compressionratio' => { 145 => 'Compression', 266 => 0x1034 },
	'confidencelevel' => { 415 => 'ConfidenceLevel' },
	'constrainedcropheight' => { 99 => 0x266, 327 => 0xd6 },
	'constrainedcropwidth' => { 99 => 0x262, 327 => 0xd5 },
	'contact' => { 117 => 0x76 },
	'contactinfo' => { 433 => 'contactInfo' },
	'containerformat' => { 430 => 'ContainerFormat' },
	'containerformatidentifier' => { 430 => [\'ContainerFormat','ContainerFormatIdentifier'] },
	'containerformatname' => { 430 => [\'ContainerFormat','ContainerFormatName'] },
	'contentlocationcode' => { 117 => 0x1a },
	'contentlocationname' => { 117 => 0x1b },
	'contenttype' => { 434 => 'contentType' },
	'continuousbracketing' => { 166 => 0x20 },
	'continuousdrive' => { 33 => 0x5 },
	'continuousshootingspeed' => { 75 => 0x610 },
	'continuousshotlimit' => { 75 => 0x611 },
	'contrast' => { 9 => 0x73, 11 => 0x75, 33 => 0xd, 103 => 0xc, 104 => [0x3012,0x20], 109 => [0xa408,0xfe54], 114 => [0x1004,0x1006], 139 => 'Contrast', 159 => 'Contrast', 163 => 0x20, 164 => 0x31, 165 => 0x27, 166 => 0x19, 171 => 0x2, 202 => 0x33, 203 => 0x37, 266 => 0x1029, 282 => 0x39, 284 => 0x300a, 316 => 0x20, 323 => 0xc, 337 => 0x24, 341 => 0x1012, 351 => 0xd, 359 => 0x1d, 360 => 0x1a, 371 => 0x2004, 420 => 'Contrast', 424 => 'Contrast' },
	'contrast2012' => { 420 => 'Contrast2012' },
	'contrastadj' => { 94 => 0x20303, 99 => 0x115, 241 => 0x2c, 402 => 0x8017 },
	'contrastauto' => { 64 => 0x90 },
	'contrastcurve' => { 200 => 0x8c },
	'contrastdetectaf' => { 175 => 0x4 },
	'contrastdetectafarea' => { 316 => 0x231 },
	'contrastdetectafinfocus' => { 175 => 0x1c },
	'contrastfaithful' => { 18 => 0xec, 63 => 0x60, 64 => 0x60 },
	'contrasthighlight' => { 316 => 0x6d },
	'contrasthighlightshadowadj' => { 316 => 0x6f },
	'contrastlandscape' => { 18 => 0xea, 63 => 0x30, 64 => 0x30 },
	'contrastmode' => { 282 => 0x2c },
	'contrastmonochrome' => { 18 => 0xed, 63 => 0x78, 64 => 0x78 },
	'contrastneutral' => { 18 => 0xeb, 63 => 0x48, 64 => 0x48 },
	'contrastportrait' => { 18 => 0xe9, 63 => 0x18, 64 => 0x18 },
	'contrastsetting' => { 261 => 0x505, 269 => 0x1012, 361 => 0x10, 375 => 0x8 },
	'contrastshadow' => { 316 => 0x6e },
	'contraststandard' => { 18 => 0xe8, 63 => 0x0, 64 => 0x0 },
	'contrastuserdef1' => { 18 => 0xee, 63 => 0x90, 64 => 0xa8 },
	'contrastuserdef2' => { 18 => 0xef, 63 => 0xa8, 64 => 0xc0 },
	'contrastuserdef3' => { 18 => 0xf0, 63 => 0xc0, 64 => 0xd8 },
	'contributedmedia' => { 444 => 'contributedMedia' },
	'contributedmediaduration' => { 444 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 444 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 444 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 444 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 444 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 444 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 444 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 444 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 444 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 444 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 421 => 'contributor', 430 => 'Contributor' },
	'contributoridentifier' => { 430 => [\'Contributor','ContributorIdentifier'] },
	'contributorname' => { 430 => [\'Contributor','ContributorName'] },
	'contributorrole' => { 430 => [\'Contributor','ContributorRole'] },
	'contributors' => { 140 => 'Contributors' },
	'controldialset' => { 166 => 0x46 },
	'controlledvocabularyterm' => { 430 => 'CVterm' },
	'controllerboardversion' => { 278 => 0x332 },
	'controlmode' => { 69 => 0x12 },
	'conversionlens' => { 262 => 0x403, 282 => 0x35 },
	'converter' => { 109 => 0xfe4d, 228 => 0xb, 420 => 'Converter' },
	'converttograyscale' => { 420 => 'ConvertToGrayscale' },
	'cookingequipment' => { 436 => 'cookingEquipment' },
	'cookingmethod' => { 436 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 109 => 0x8298, 140 => 'Copyright', 274 => 'Copyright', 316 => 0x22f, 332 => 'Copyright', 431 => 'Copyright', 437 => 'copyright', 440 => 'Copyright', 444 => 'copyright' },
	'copyrightflag' => { 330 => 0x40a },
	'copyrightnotice' => { 117 => 0x74 },
	'copyrightowner' => { 271 => 'CopyrightOwner' },
	'copyrightownerid' => { 271 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 271 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 271 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 271 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 271 => 'CopyrightStatus' },
	'copyrightyear' => { 430 => 'CopyrightYear', 434 => 'copyrightYear' },
	'coringfilter' => { 265 => 0x310, 266 => 0x102d, 269 => 0x310 },
	'coringvalues' => { 265 => 0x311, 269 => 0x311 },
	'corporateentity' => { 434 => 'corporateEntity' },
	'country' => { 144 => 'Country', 282 => 0x69, 432 => 'Country' },
	'country-primarylocationcode' => { 117 => 0x64 },
	'country-primarylocationname' => { 117 => 0x65 },
	'countrycode' => { 199 => 0x5, 328 => 'CountryCode', 429 => 'CountryCode' },
	'course' => { 436 => 'course' },
	'coverage' => { 421 => 'coverage' },
	'coverdate' => { 434 => 'coverDate' },
	'coverdisplaydate' => { 434 => 'coverDisplayDate' },
	'cpufirmwareversion' => { 316 => 0x28 },
	'crc32' => { 422 => 'crc32' },
	'createdate' => { 109 => 0x9004, 140 => 'CreateDate', 270 => 'CreationDate', 274 => 'create-date', 332 => 'CreationDate', 334 => 0x1, 442 => 'CreateDate' },
	'creationdate' => { 431 => 'CreationDate', 434 => 'creationDate' },
	'creationtime' => { 274 => 'Creation Time' },
	'creativestyle' => { 359 => 0x1a, 360 => 0x18, 370 => 0x41, 371 => 0xb020, 398 => 0x4a },
	'creativestylesetting' => { 361 => 0xf, 375 => 0x7 },
	'creativestylewaschanged' => { 402 => 0x8001 },
	'creator' => { 270 => 'Creator', 332 => 'Creator', 421 => 'creator', 430 => 'Creator', 431 => 'Creator' },
	'creatoraddress' => { 429 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 161 => 'CreatorAppId' },
	'creatorcity' => { 429 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 429 => 'CreatorContactInfo' },
	'creatorcountry' => { 429 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoridentifier' => { 430 => [\'Creator','CreatorIdentifier'] },
	'creatorname' => { 430 => [\'Creator','CreatorName'] },
	'creatoropenwithuioptions' => { 161 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 429 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 429 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatorrole' => { 430 => [\'Creator','CreatorRole'] },
	'creatortool' => { 442 => 'CreatorTool' },
	'creatorworkemail' => { 429 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 429 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 429 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 117 => 0x6e, 432 => 'Credit' },
	'creditline' => { 437 => 'creditLine' },
	'creditlinereq' => { 447 => 'CreditLineReq' },
	'creditlinerequired' => { 271 => 'CreditLineRequired' },
	'cropactive' => { 92 => 0x0, 99 => 0x244 },
	'cropangle' => { 420 => 'CropAngle' },
	'cropaspectratio' => { 94 => 0x30101, 99 => 0x260 },
	'cropaspectratiocustom' => { 94 => 0x30102 },
	'cropbottom' => { 113 => 0x9, 233 => 0x36, 286 => 0x31, 327 => 0xdc, 420 => 'CropBottom' },
	'cropbottommargin' => { 47 => 0x3 },
	'cropcircleactive' => { 100 => 0xd6 },
	'cropcircleradius' => { 100 => 0xd9 },
	'cropcirclex' => { 100 => 0xd7 },
	'cropcircley' => { 100 => 0xd8 },
	'cropconstraintowarp' => { 420 => 'CropConstrainToWarp' },
	'croph' => { 413 => 'CropH' },
	'cropheight' => { 92 => 0x6, 99 => 0x24c, 265 => 0x615, 269 => 0x615, 420 => 'CropHeight' },
	'crophispeed' => { 200 => 0x1b },
	'cropleft' => { 99 => 0x246, 113 => 0x6, 233 => 0x1e, 265 => 0x612, 269 => 0x612, 286 => 0x30, 327 => 0xd9, 420 => 'CropLeft' },
	'cropleftmargin' => { 47 => 0x0 },
	'cropmode35mm' => { 341 => 0x1018 },
	'croporiginalheight' => { 92 => 0xb },
	'croporiginalwidth' => { 92 => 0xa },
	'cropoutputheight' => { 233 => 0xce },
	'cropoutputheightinches' => { 233 => 0x96 },
	'cropoutputpixels' => { 233 => 0xd6 },
	'cropoutputresolution' => { 233 => 0xb6 },
	'cropoutputscale' => { 233 => 0xbe },
	'cropoutputwidth' => { 233 => 0xc6 },
	'cropoutputwidthinches' => { 233 => 0x8e },
	'croppedareaimageheightpixels' => { 408 => 'CroppedAreaImageHeightPixels', 409 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 408 => 'CroppedAreaImageWidthPixels', 409 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 408 => 'CroppedAreaLeftPixels', 409 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 408 => 'CroppedAreaTopPixels', 409 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 341 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 341 => 0x1603 },
	'cropright' => { 113 => 0x8, 233 => 0x2e, 286 => 0x32, 327 => 0xdb, 420 => 'CropRight' },
	'croprightmargin' => { 47 => 0x1 },
	'croprotatedoriginalheight' => { 92 => 0x2 },
	'croprotatedoriginalwidth' => { 92 => 0x1 },
	'croprotation' => { 92 => 0x8, 113 => 0xb },
	'cropscaledresolution' => { 233 => 0x9e },
	'cropsourceresolution' => { 233 => 0xae },
	'croptop' => { 99 => 0x248, 113 => 0x7, 233 => 0x26, 265 => 0x613, 269 => 0x613, 286 => 0x2f, 327 => 0xda, 420 => 'CropTop' },
	'croptopmargin' => { 47 => 0x2 },
	'cropunit' => { 420 => 'CropUnit' },
	'cropunits' => { 420 => 'CropUnits' },
	'cropw' => { 413 => 'CropW' },
	'cropwidth' => { 92 => 0x5, 99 => 0x24a, 265 => 0x614, 269 => 0x614, 420 => 'CropWidth' },
	'cropx' => { 92 => 0x3, 413 => 'CropX' },
	'cropy' => { 92 => 0x4, 413 => 'CropY' },
	'crossprocess' => { 316 => 0x7b },
	'crossprocessparams' => { 316 => 0x235 },
	'cuisine' => { 436 => 'cuisine' },
	'currenticcprofile' => { 109 => 0xc691 },
	'currentpreprofilematrix' => { 109 => 0xc692 },
	'currentversion' => { 402 => 0xd000 },
	'curve0x' => { 413 => 'Curve0x' },
	'curve0y' => { 413 => 'Curve0y' },
	'curve1x' => { 413 => 'Curve1x' },
	'curve1y' => { 413 => 'Curve1y' },
	'curve2x' => { 413 => 'Curve2x' },
	'curve2y' => { 413 => 'Curve2y' },
	'curve3x' => { 413 => 'Curve3x' },
	'curve3y' => { 413 => 'Curve3y' },
	'curve4x' => { 413 => 'Curve4x' },
	'curve4y' => { 413 => 'Curve4y' },
	'curves' => { 238 => 0x76a43201 },
	'custom1' => { 271 => 'Custom1' },
	'custom10' => { 271 => 'Custom10' },
	'custom2' => { 271 => 'Custom2' },
	'custom3' => { 271 => 'Custom3' },
	'custom4' => { 271 => 'Custom4' },
	'custom5' => { 271 => 'Custom5' },
	'custom6' => { 271 => 'Custom6' },
	'custom7' => { 271 => 'Custom7' },
	'custom8' => { 271 => 'Custom8' },
	'custom9' => { 271 => 'Custom9' },
	'customcolortone' => { 100 => 0x4c },
	'customcontrast' => { 100 => 0x4e },
	'customcontrols' => { 75 => 0x70c },
	'customdefaultunsharpfineness' => { 100 => 0xbe },
	'customdefaultunsharpstrength' => { 100 => 0xbc },
	'customdefaultunsharpthreshold' => { 100 => 0xc0 },
	'customlinear' => { 100 => 0x4f },
	'customoutputhighlightpoint' => { 100 => 0x53 },
	'customoutputshadowpoint' => { 100 => 0x54 },
	'custompicturestyle' => { 94 => 0x10021 },
	'custompicturestyledata' => { 94 => 0xf0500 },
	'custompicturestylefilename' => { 57 => 0x4010 },
	'customrawhighlight' => { 100 => 0x7c },
	'customrawhighlightpoint' => { 100 => 0x51 },
	'customrawshadow' => { 100 => 0x85 },
	'customrawshadowpoint' => { 100 => 0x52 },
	'customrendered' => { 109 => 0xa401, 424 => 'CustomRendered' },
	'customsaturation' => { 100 => 0x4d, 261 => 0x503 },
	'customsettingsalldefault' => { 245 => '0.2', 254 => '0.2' },
	'customsettingsbank' => { 245 => '0.1', 246 => '0.1', 248 => '0.1', 249 => '0.1', 254 => '0.1', 258 => '0.2' },
	'customsharpness' => { 100 => 0x50 },
	'customunsharpmaskfineness' => { 100 => 0xb8 },
	'customunsharpmaskstrength' => { 100 => 0xb6 },
	'customunsharpmaskthreshold' => { 100 => 0xba },
	'customwb_rblevels' => { 375 => 0x1a },
	'customwb_rgblevels' => { 360 => 0x8, 361 => 0x19 },
	'customwbbluelevel' => { 166 => 0x36 },
	'customwberror' => { 166 => 0x37 },
	'customwbgreenlevel' => { 166 => 0x35 },
	'customwbredlevel' => { 166 => 0x34 },
	'customwbsetting' => { 166 => 0x26 },
	'd-lightinghq' => { 238 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 234 => 0x2 },
	'd-lightinghqhighlight' => { 234 => 0x1 },
	'd-lightinghqselected' => { 238 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 234 => 0x0 },
	'd-lightinghs' => { 238 => 0xce5554aa },
	'd-lightinghsadjustment' => { 235 => 0x0 },
	'd-lightinghscolorboost' => { 235 => 0x1 },
	'd-rangeoptimizerhighlight' => { 402 => 0x8024 },
	'd-rangeoptimizermode' => { 402 => 0x8022 },
	'd-rangeoptimizershadow' => { 402 => 0x802d },
	'd-rangeoptimizervalue' => { 402 => 0x8023 },
	'd810meteringmode' => { 226 => 0x175e },
	'datacompressionmethod' => { 119 => 0x6e },
	'dataimprint' => { 163 => 0x34 },
	'dataonscreen' => { 430 => 'DataOnScreen' },
	'dataonscreenregion' => { 430 => [\'DataOnScreen','DataOnScreenRegion'] },
	'dataonscreenregiond' => { 430 => [\'DataOnScreen','DataOnScreenRegionD'] },
	'dataonscreenregionh' => { 430 => [\'DataOnScreen','DataOnScreenRegionH'] },
	'dataonscreenregiontext' => { 430 => [\'DataOnScreen','DataOnScreenRegionText'] },
	'dataonscreenregionunit' => { 430 => [\'DataOnScreen','DataOnScreenRegionUnit'] },
	'dataonscreenregionw' => { 430 => [\'DataOnScreen','DataOnScreenRegionW'] },
	'dataonscreenregionx' => { 430 => [\'DataOnScreen','DataOnScreenRegionX'] },
	'dataonscreenregiony' => { 430 => [\'DataOnScreen','DataOnScreenRegionY'] },
	'datascaling' => { 316 => 0x3d },
	'date' => { 316 => 0x6, 421 => 'date' },
	'dateacquired' => { 161 => 'DateAcquired' },
	'datecreated' => { 117 => 0x37, 432 => 'DateCreated' },
	'datedisplayformat' => { 230 => 0x3 },
	'dateidentified' => { 108 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 250 => '4.2' },
	'daterecieved' => { 434 => 'dateRecieved' },
	'datesent' => { 118 => 0x46 },
	'datestampmode' => { 57 => 0x1c },
	'datetime' => { 414 => 'datetime', 440 => 'DateTime' },
	'datetimedigitized' => { 424 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 91 => 0x0, 109 => 0x9003, 137 => 0x14, 140 => 'OriginalDate', 337 => 0xb, 424 => 'DateTimeOriginal' },
	'datetimestamp' => { 125 => 0x64 },
	'datetimeutc' => { 261 => 0x908 },
	'daylightsavings' => { 70 => 0x3, 230 => 0x2 },
	'dccontinent' => { 108 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 108 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 108 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 108 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 108 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 108 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 108 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 108 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 108 => 'Event' },
	'dcfootprintspatialfit' => { 108 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 108 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 108 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 108 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 108 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 108 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 108 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 108 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 108 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 108 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 108 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 108 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 108 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 108 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 108 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 108 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 108 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 108 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 108 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 108 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 108 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 108 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 108 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 108 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 108 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 108 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 108 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 108 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 108 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 108 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 108 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 108 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 108 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 108 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 108 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 108 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcwaterbody' => { 108 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 148 => 'Declination' },
	'decposition' => { 163 => 0x32 },
	'defaultautogray' => { 420 => 'DefaultAutoGray' },
	'defaultautotone' => { 420 => 'DefaultAutoTone' },
	'defaultblackrender' => { 109 => 0xc7a6 },
	'defaultcroporigin' => { 109 => 0xc61f },
	'defaultcropsize' => { 109 => 0xc620 },
	'defaulteraseoption' => { 75 => 0x813 },
	'defaultscale' => { 109 => 0xc61e },
	'defaultsspecifictoiso' => { 420 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 420 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 109 => 0xc7b5 },
	'defringe' => { 420 => 'Defringe' },
	'defringegreenamount' => { 420 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 420 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 420 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 420 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 420 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 420 => 'DefringePurpleHueLo' },
	'dehaze' => { 420 => 'Dehaze' },
	'deletedimagecount' => { 200 => 0xa6, 208 => 0x6e },
	'deprecatedon' => { 417 => 'deprecatedOn' },
	'derivedfrom' => { 445 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 445 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 445 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 445 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 445 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 445 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 445 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfromlasturl' => { 445 => [\'DerivedFrom','DerivedFromLastURL'] },
	'derivedfromlinkcategory' => { 445 => [\'DerivedFrom','DerivedFromLinkCategory'] },
	'derivedfromlinkform' => { 445 => [\'DerivedFrom','DerivedFromLinkForm'] },
	'derivedfrommanager' => { 445 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 445 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 445 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 445 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 445 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 445 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 445 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromplacedresolutionunit' => { 445 => [\'DerivedFrom','DerivedFromPlacedResolutionUnit'] },
	'derivedfromplacedxresolution' => { 445 => [\'DerivedFrom','DerivedFromPlacedXResolution'] },
	'derivedfromplacedyresolution' => { 445 => [\'DerivedFrom','DerivedFromPlacedYResolution'] },
	'derivedfromrenditionclass' => { 445 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 445 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 445 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 445 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 274 => 'Description', 421 => 'description', 442 => 'Description' },
	'destination' => { 118 => 0x5 },
	'destinationcity' => { 316 => 0x24, 322 => 0x3 },
	'destinationcitycode' => { 323 => 0x1001 },
	'destinationdst' => { 316 => 0x26, 322 => '0.3' },
	'developmentdynamicrange' => { 114 => 0x1403 },
	'device' => { 434 => 'device' },
	'devicesettingdescription' => { 424 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 424 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 424 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 424 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 348 => 0x2 },
	'dialdirectiontvav' => { 75 => 0x706 },
	'dietaryneeds' => { 436 => 'dietaryNeeds' },
	'diffractioncorrection' => { 306 => 0x3 },
	'digitalcreationdate' => { 117 => 0x3e },
	'digitalcreationtime' => { 117 => 0x3f },
	'digitaldeehighlightadj' => { 207 => 0x202 },
	'digitaldeeshadowadj' => { 207 => 0x200 },
	'digitaldeethreshold' => { 207 => 0x201 },
	'digitalfilter' => { 351 => 0x59 },
	'digitalfilter01' => { 303 => 0x5 },
	'digitalfilter02' => { 303 => 0x16 },
	'digitalfilter03' => { 303 => 0x27 },
	'digitalfilter04' => { 303 => 0x38 },
	'digitalfilter05' => { 303 => 0x49 },
	'digitalfilter06' => { 303 => 0x5a },
	'digitalfilter07' => { 303 => 0x6b },
	'digitalfilter08' => { 303 => 0x7c },
	'digitalfilter09' => { 303 => 0x8d },
	'digitalfilter10' => { 303 => 0x9e },
	'digitalfilter11' => { 303 => 0xaf },
	'digitalfilter12' => { 303 => 0xc0 },
	'digitalfilter13' => { 303 => 0xd1 },
	'digitalfilter14' => { 303 => 0xe2 },
	'digitalfilter15' => { 303 => 0xf3 },
	'digitalfilter16' => { 303 => 0x104 },
	'digitalfilter17' => { 303 => 0x115 },
	'digitalfilter18' => { 303 => 0x126 },
	'digitalfilter19' => { 303 => 0x137 },
	'digitalfilter20' => { 303 => 0x148 },
	'digitalgain' => { 67 => 0xb },
	'digitalgem' => { 192 => 0x0 },
	'digitalice' => { 207 => 0x100 },
	'digitalimageguid' => { 430 => 'DigImageGUID' },
	'digitalroc' => { 205 => 0x0 },
	'digitalsourcefiletype' => { 430 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 430 => 'DigitalSourceType' },
	'digitalzoom' => { 33 => 0xc, 103 => 0xa, 114 => 0x1044, 125 => 0x68, 139 => 'DigitalZoom', 163 => 0xc, 200 => 0x86, 228 => 0xa, 266 => 0x204, 316 => 0x1e, 323 => 0xa, 350 => 0x204, 390 => 0x12, 391 => 0x12 },
	'digitalzoomon' => { 350 => 0x21b },
	'digitalzoomratio' => { 109 => 0xa404, 380 => 0x200, 382 => 0x21c, 424 => 'DigitalZoomRatio' },
	'director' => { 444 => 'director' },
	'directorphotography' => { 444 => 'directorPhotography' },
	'directory' => { 110 => 'Directory' },
	'directoryindex' => { 6 => 0x137, 8 => 0x2dc, 10 => 0x17e, 12 => 0x238, 13 => 0x13f, 14 => 0x133, 15 => 0x1df, 16 => 0x1a7, 17 => 0x1f0, 18 => 0xcc, 19 => 0x1c7, 20 => 0x298, 21 => 0x1e7, 22 => 0x1e5, 23 => [0x27c,0x280], 24 => 0x2b6, 25 => 0x2bf, 27 => 0x1f7, 28 => 0x4ba },
	'directoryindex2' => { 20 => 0x29c },
	'directorynumber' => { 187 => 0x3 },
	'disclaimer' => { 274 => 'Disclaimer' },
	'discnumber' => { 444 => 'discNumber' },
	'dishtype' => { 436 => 'dishType' },
	'displayallafpoints' => { 75 => 0x514 },
	'displayaperture' => { 33 => 0x23 },
	'displayedunitsx' => { 331 => 0x2 },
	'displayedunitsy' => { 331 => 0x6 },
	'displayname' => { 433 => 'displayName' },
	'distance1' => { 125 => 0x28 },
	'distance2' => { 125 => 0x2c },
	'distance3' => { 125 => 0x30 },
	'distance4' => { 125 => 0x34 },
	'distortion' => { 348 => 0xa050 },
	'distortioncontrol' => { 208 => 0x10 },
	'distortioncorrection' => { 94 => 0x20705, 100 => 0x67, 261 => 0x50b, 285 => '7.1', 306 => 0x0, 397 => 0x601, 398 => 0x5b },
	'distortioncorrection2' => { 265 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 416 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 94 => '0x20705.0', 100 => 0x63 },
	'distortioncorrectionsetting' => { 371 => 0x2013 },
	'distortioncorrparams' => { 109 => 0x7037, 379 => 0x1a23, 382 => 0x1870, 384 => 0x189c, 385 => 0x18cc, 386 => 0x17d0, 397 => 0x6ca, 398 => 0x64 },
	'distortioncorrparamsnumber' => { 382 => 0x1899, 384 => 0x18c5, 385 => 0x18f5, 386 => 0x17f9 },
	'distortioncorrparamspresent' => { 382 => 0x1898, 384 => 0x18c4, 385 => 0x18f4, 386 => 0x17f8, 388 => 0x10b, 389 => 0x10b, 397 => 0x600, 398 => 0x5a },
	'distortioneffect' => { 94 => 0x20709 },
	'distortionn' => { 285 => 0xc },
	'distortionparam02' => { 285 => 0x2 },
	'distortionparam04' => { 285 => 0x4 },
	'distortionparam08' => { 285 => 0x8 },
	'distortionparam09' => { 285 => 0x9 },
	'distortionparam11' => { 285 => 0xb },
	'distortionscale' => { 285 => 0x5 },
	'distributor' => { 434 => 'distributor' },
	'distributorproductid' => { 433 => 'distributorProductID' },
	'dloon' => { 94 => '0x20706.0', 100 => 0xdc },
	'dlosetting' => { 94 => 0x20706, 100 => 0xdd },
	'dlosettingapplied' => { 93 => 0x4 },
	'dloshootingdistance' => { 100 => 0xde },
	'dloversion' => { 93 => 0x5 },
	'dmcomment' => { 444 => 'comment' },
	'dngadobedata' => { 109 => 0xc634 },
	'dngbackwardversion' => { 109 => 0xc613 },
	'dngignoresidecars' => { 420 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 109 => 0xc630 },
	'dngprivatedata' => { 109 => 0xc634 },
	'dngversion' => { 109 => 0xc612 },
	'document' => { 274 => 'Document' },
	'documentancestors' => { 432 => 'DocumentAncestors' },
	'documenthistory' => { 117 => 0xe7 },
	'documentid' => { 445 => 'DocumentID' },
	'documentname' => { 109 => 0x10d },
	'documentnotes' => { 117 => 0xe6 },
	'doi' => { 434 => 'doi' },
	'dopesheet' => { 430 => 'Dopesheet' },
	'dopesheetlink' => { 430 => 'DopesheetLink' },
	'dopesheetlinklink' => { 430 => [\'DopesheetLink','DopesheetLinkLink'] },
	'dopesheetlinklinkqualifier' => { 430 => [\'DopesheetLink','DopesheetLinkLinkQualifier'] },
	'dpp' => { 414 => 'dpp' },
	'dr4cameramodel' => { 95 => 0x3 },
	'drivemode' => { 104 => 0x3103, 163 => 0x6, 166 => 0x1e, 169 => 0xe, 261 => 0x600, 316 => 0x34, 341 => 0x1002, 351 => 0x3, 359 => 0x4, 360 => 0x7e, 361 => 0x34 },
	'drivemode2' => { 166 => 0xa, 297 => 0x7, 370 => 0xe, 375 => 0x1 },
	'drivemodesetting' => { 361 => 0x4 },
	'dspfirmwareversion' => { 316 => 0x27 },
	'duration' => { 60 => 0x6a, 138 => 'Duration', 152 => 'Duration', 436 => 'duration', 444 => 'duration' },
	'durationscale' => { 444 => [\'duration','durationScale'] },
	'durationvalue' => { 444 => [\'duration','durationValue'] },
	'dustremovaldata' => { 57 => 0x97 },
	'dynamicafarea' => { 245 => '1.4', 254 => '1.4' },
	'dynamicareaafdisplay' => { 246 => '46.1', 248 => '47.1', 249 => '47.1', 258 => '47.1' },
	'dynamicrange' => { 114 => 0x1400 },
	'dynamicrangeexpansion' => { 316 => 0x69, 341 => 0x100e },
	'dynamicrangemax' => { 99 => 0x7c },
	'dynamicrangemin' => { 99 => 0x7a },
	'dynamicrangeoptimizer' => { 166 => 0x15, 371 => [0xb025,0xb04f], 378 => 0x1144, 379 => [0x1144,0x324], 380 => [0x1120,0x300], 381 => [0x119c,0x37c], 382 => [0x1178,0x328], 383 => [0x1030,0x50], 384 => [0x228,0x50], 385 => [0x228,0x50], 386 => [0x21b,0x4e] },
	'dynamicrangeoptimizerbracket' => { 370 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 359 => 0x19, 360 => 0x17, 361 => 0xd, 370 => 0x79, 375 => 0x5 },
	'dynamicrangeoptimizermode' => { 169 => 0x15, 359 => 0x18, 360 => 0x16, 370 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 166 => 0x27, 361 => 0xc, 375 => 0x4 },
	'dynamicrangesetting' => { 114 => 0x1402 },
	'e-dialinprogram' => { 297 => '1.3' },
	'earliestageorloweststage' => { 108 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 108 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 108 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 108 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 108 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'easyexposurecomp' => { 259 => '6.1' },
	'easyexposurecompensation' => { 245 => '6.4', 246 => '6.5', 248 => '6.3', 249 => '6.3', 253 => '5.1', 254 => '4.4', 255 => '5.2', 258 => '6.3' },
	'easymode' => { 33 => 0xb },
	'edgenoisereduction' => { 239 => 0x4, 402 => 0x8028 },
	'edition' => { 434 => 'edition' },
	'editorialupdate' => { 117 => 0x8 },
	'editstatus' => { 117 => 0x7, 328 => 'EditStatus', 414 => 'EditStatus' },
	'editversionname' => { 238 => 0x3d136244 },
	'effectivelv' => { 316 => 0x2d },
	'effectivemaxaperture' => { 196 => 0x12, 197 => 0x13 },
	'eissn' => { 434 => 'eIssn' },
	'electronicfront-curtainshutter' => { 248 => '5.2', 249 => '5.2', 258 => '5.3' },
	'elevation' => { 148 => 'Elevation' },
	'email' => { 140 => 'EMail' },
	'embargodate' => { 437 => 'embargoDate' },
	'embdencrightsexpr' => { 430 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 430 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 430 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 430 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 432 => 'EmbeddedXMPDigest' },
	'emissivity' => { 111 => 0x3 },
	'encryptionkey' => { 348 => 0xa020 },
	'endingpage' => { 434 => 'endingPage' },
	'enduser' => { 271 => 'EndUser' },
	'enduserid' => { 271 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 271 => [\'EndUser','EndUserEndUserName'] },
	'engineer' => { 444 => 'engineer' },
	'enhancedarktones' => { 231 => 0x8 },
	'enhancement' => { 103 => 0x16, 104 => 0x3016 },
	'enhancer' => { 265 => 0x300 },
	'enhancervalues' => { 265 => 0x301 },
	'envelopenumber' => { 118 => 0x28 },
	'envelopepriority' => { 118 => 0x3c },
	'enveloperecordversion' => { 118 => 0x0 },
	'episode' => { 430 => 'Episode' },
	'episodeidentifier' => { 430 => [\'Episode','EpisodeIdentifier'] },
	'episodename' => { 430 => [\'Episode','EpisodeName'] },
	'episodenumber' => { 430 => [\'Episode','EpisodeNumber'] },
	'epsonimageheight' => { 266 => 0x20c },
	'epsonimagewidth' => { 266 => 0x20b },
	'epsonsoftware' => { 266 => 0x20d },
	'equipmentinstitution' => { 404 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 404 => 'EquipmentManufacturer' },
	'equipmentversion' => { 262 => 0x0 },
	'ettlii' => { 75 => 0x304, 76 => 0xd, 77 => 0xe, 78 => 0x7, 79 => 0x7, 80 => 0xe },
	'event' => { 405 => 'Event', 412 => 'Event', 430 => 'Event', 434 => 'event' },
	'eventalias' => { 433 => 'eventAlias' },
	'eventday' => { 108 => [\'Event','EventDay'] },
	'eventearliestdate' => { 108 => [\'Event','EventEarliestDate'] },
	'eventend' => { 433 => 'eventEnd' },
	'eventenddayofyear' => { 108 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 108 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 108 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 108 => [\'Event','EventHabitat'] },
	'eventid' => { 108 => [\'Event','EventEventID'] },
	'eventlatestdate' => { 108 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 108 => [\'Event','EventMonth'] },
	'eventnumber' => { 337 => 0x9 },
	'eventremarks' => { 108 => [\'Event','EventEventRemarks'] },
	'eventsamplingeffort' => { 108 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 108 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 433 => 'eventStart' },
	'eventstartdayofyear' => { 108 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 433 => 'eventSubtype' },
	'eventtime' => { 108 => [\'Event','EventEventTime'] },
	'eventtype' => { 433 => 'eventType' },
	'eventverbatimeventdate' => { 108 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 108 => [\'Event','EventYear'] },
	'evsteps' => { 297 => '1.2', 299 => 0x0 },
	'evstepsize' => { 250 => '5.1', 251 => '6.1', 252 => '6.1', 256 => '0.7' },
	'exclusivecoverage' => { 410 => 'ExclusiveCoverage' },
	'exclusivityenddate' => { 437 => 'exclusivityEndDate' },
	'excursiontolerance' => { 119 => 0x82 },
	'exif' => { 110 => 'EXIF' },
	'exifbyteorder' => { 110 => 'ExifByteOrder' },
	'exifcamerainfo' => { 117 => 0xe8 },
	'exifimageheight' => { 109 => 0xa003, 424 => 'PixelYDimension' },
	'exifimagewidth' => { 109 => 0xa002, 424 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 110 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 109 => 0x9000, 424 => 'ExifVersion' },
	'exitpupilposition' => { 196 => 0x4, 197 => 0x4 },
	'expirationdate' => { 117 => 0x25, 437 => 'expirationDate' },
	'expirationtime' => { 117 => 0x26 },
	'exposure' => { 109 => 0xfe51, 420 => 'Exposure' },
	'exposure2012' => { 420 => 'Exposure2012' },
	'exposureadj' => { 236 => 0x0 },
	'exposureadj2' => { 236 => 0x12 },
	'exposureadjust' => { 351 => 0xc },
	'exposurebracketingindicatorlast' => { 166 => 0x52 },
	'exposurebracketshotnumber' => { 169 => 0x2d, 370 => 0x2f },
	'exposurebracketstepsize' => { 297 => 0x8 },
	'exposurebracketvalue' => { 200 => 0x19 },
	'exposurecompensation' => { 69 => 0x6, 84 => 0x0, 109 => 0x9204, 125 => 0x24, 139 => 'ExposureComp', 159 => 'ExposureCompensation', 163 => 0xd, 164 => 0x53, 165 => 0x1e, 169 => 0x49c0, 266 => 0x1006, 316 => 0x16, 325 => 0x402, 348 => 0xa013, 351 => [0xc,0x35,0x4d], 378 => 0x114c, 379 => 0x114c, 380 => 0x1128, 382 => 0x1180, 383 => 0x1038, 384 => 0x230, 385 => 0x230, 386 => 0x223, 424 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 375 => [0x24,0x26,0x2a] },
	'exposurecompensationmode' => { 166 => 0x47, 169 => 0x2a },
	'exposurecompensationset' => { 359 => 0x3, 360 => 0x3, 361 => 0x3, 375 => 0x1e },
	'exposurecompensationsetting' => { 166 => 0x1 },
	'exposurecompstepsize' => { 245 => '6.3', 246 => '7.3', 248 => '7.3', 249 => '7.3', 254 => '4.3', 258 => '7.3' },
	'exposurecontrolstep' => { 253 => '6.1', 255 => '6.1' },
	'exposurecontrolstepsize' => { 245 => '6.2', 246 => '7.1', 248 => '7.1', 249 => '7.1', 254 => '4.2', 258 => '7.1', 259 => '7.1' },
	'exposurecount' => { 114 => 0x1032 },
	'exposuredelaymode' => { 245 => '10.1', 246 => '11.1', 248 => '11.1', 249 => '11.1', 250 => '9.1', 251 => '10.1', 252 => '10.1', 254 => '10.4', 255 => '10.1', 256 => '6.4', 258 => '11.1', 259 => '11.2' },
	'exposuredifference' => { 200 => 0xe },
	'exposureindex' => { 109 => 0xa215, 424 => 'ExposureIndex' },
	'exposureindicator' => { 166 => 0x50 },
	'exposurelevelincrements' => { 73 => 0x6, 74 => 0x6, 75 => 0x101, 76 => 0x5, 77 => 0x6, 78 => 0x5, 79 => 0x5, 80 => 0x6, 81 => 0x4, 359 => 0x58, 360 => 0x58 },
	'exposurelockused' => { 408 => 'ExposureLockUsed' },
	'exposuremode' => { 109 => 0xa402, 139 => 'ExposureMode', 163 => 0x1, 164 => 0xa, 165 => 0x0, 166 => 0x0, 169 => 0x34, 261 => 0x200, 280 => 0x40d, 351 => 0x8, 371 => 0xb041, 424 => 'ExposureMode' },
	'exposuremodeinmanual' => { 75 => 0x10b },
	'exposureprogram' => { 109 => 0x8822, 341 => 0x1001, 352 => [0x17e,0x43], 359 => 0x3c, 360 => 0x3c, 361 => 0x5, 365 => 0x14, 370 => 0x3f, 375 => 0x2, 378 => 0x1175, 379 => 0x1179, 380 => 0x1155, 381 => 0x11d1, 382 => 0x11ad, 383 => 0x1065, 384 => 0x25d, 385 => 0x25d, 386 => 0x24c, 398 => 0x48, 424 => 'ExposureProgram' },
	'exposureshift' => { 261 => 0x203 },
	'exposuretime' => { 6 => 0x4, 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x4, 28 => 0x4, 29 => 0x6, 30 => 0x7, 69 => 0x16, 109 => 0x829a, 122 => 0xfd05, 125 => 0x20, 127 => 0xfa24, 129 => 0xf104, 132 => 0x12, 134 => 0x38, 137 => 0x10, 139 => 'ExposureTime', 163 => 0x9, 164 => 0x35, 165 => 0x48, 166 => 0x8, 169 => 0x49b8, 316 => 0x12, 348 => 0xa018, 351 => [0x32,0x4a], 359 => 0x0, 360 => 0x0, 375 => [0x21,0x23,0x27], 398 => 0x10, 424 => 'ExposureTime' },
	'exposuretime2' => { 351 => [0x33,0x4b] },
	'exposuretuning' => { 200 => 0x1c },
	'exposurevalue' => { 123 => 0x3 },
	'exposurewarning' => { 114 => 0x1302 },
	'exrauto' => { 114 => 0x1033 },
	'exrmode' => { 114 => 0x1034 },
	'extendedwbdetect' => { 261 => 0x902 },
	'extender' => { 262 => 0x301 },
	'extenderfirmwareversion' => { 262 => 0x304 },
	'extendermagnification' => { 141 => 'Magnification' },
	'extendermake' => { 141 => 'Make' },
	'extendermodel' => { 141 => 'Model', 262 => 0x303 },
	'extenderserialnumber' => { 141 => 'SerialNumber', 262 => 0x302 },
	'extenderstatus' => { 314 => 0x3 },
	'externalflash' => { 264 => 0x1201 },
	'externalflashae1' => { 266 => 0x101f },
	'externalflashae1_0' => { 266 => 0x101b },
	'externalflashae2' => { 266 => 0x1020 },
	'externalflashae2_0' => { 266 => 0x101c },
	'externalflashbounce' => { 264 => 0x1204, 266 => 0x1026, 304 => 0x1a },
	'externalflashcompensation' => { 190 => 0x1b },
	'externalflashexposurecomp' => { 200 => 0x17, 304 => 0x19 },
	'externalflashfirmware' => { 188 => 0x6, 189 => 0x6, 190 => 0x6, 191 => 0x6 },
	'externalflashflags' => { 188 => 0x8, 189 => 0x8, 190 => 0x8 },
	'externalflashguidenumber' => { 264 => 0x1203, 304 => '24.1' },
	'externalflashgvalue' => { 266 => 0x1025 },
	'externalflashmode' => { 266 => 0x1028, 304 => 0x2 },
	'externalflashreadystate' => { 191 => '9.1' },
	'externalflashstatus' => { 191 => '8.2' },
	'externalflashzoom' => { 264 => 0x1205, 266 => 0x1027 },
	'externalflashzoomoverride' => { 191 => '8.1' },
	'externalmetadatalink' => { 430 => 'ExternalMetadataLink' },
	'externalsensorbrightnessvalue' => { 278 => 0x311, 284 => 0x3408 },
	'extrainfoversion' => { 363 => 0x1a },
	'eyestartaf' => { 166 => 0x40 },
	'face10position' => { 101 => 0x3f4, 102 => 0x1ec, 186 => 0x28, 301 => 0x12 },
	'face10size' => { 302 => 0x12 },
	'face11position' => { 186 => 0x2c, 301 => 0x14 },
	'face11size' => { 302 => 0x14 },
	'face12position' => { 186 => 0x30, 301 => 0x16 },
	'face12size' => { 302 => 0x16 },
	'face13position' => { 301 => 0x18 },
	'face13size' => { 302 => 0x18 },
	'face14position' => { 301 => 0x1a },
	'face14size' => { 302 => 0x1a },
	'face15position' => { 301 => 0x1c },
	'face15size' => { 302 => 0x1c },
	'face16position' => { 301 => 0x1e },
	'face16size' => { 302 => 0x1e },
	'face17position' => { 301 => 0x20 },
	'face17size' => { 302 => 0x20 },
	'face18position' => { 301 => 0x22 },
	'face18size' => { 302 => 0x22 },
	'face19position' => { 301 => 0x24 },
	'face19size' => { 302 => 0x24 },
	'face1position' => { 48 => 0x8, 101 => 0xd, 102 => 0x18, 186 => 0x4, 276 => 0x1, 301 => 0x0, 338 => 0xbc, 366 => 0x1, 367 => 0x0, 368 => 0x0, 369 => 0x5b },
	'face1size' => { 302 => 0x0 },
	'face20position' => { 301 => 0x26 },
	'face20size' => { 302 => 0x26 },
	'face21position' => { 301 => 0x28 },
	'face21size' => { 302 => 0x28 },
	'face22position' => { 301 => 0x2a },
	'face22size' => { 302 => 0x2a },
	'face23position' => { 301 => 0x2c },
	'face23size' => { 302 => 0x2c },
	'face24position' => { 301 => 0x2e },
	'face24size' => { 302 => 0x2e },
	'face25position' => { 301 => 0x30 },
	'face25size' => { 302 => 0x30 },
	'face26position' => { 301 => 0x32 },
	'face26size' => { 302 => 0x32 },
	'face27position' => { 301 => 0x34 },
	'face27size' => { 302 => 0x34 },
	'face28position' => { 301 => 0x36 },
	'face28size' => { 302 => 0x36 },
	'face29position' => { 301 => 0x38 },
	'face29size' => { 302 => 0x38 },
	'face2position' => { 48 => 0xa, 101 => 0x7c, 102 => 0x4c, 186 => 0x8, 276 => 0x5, 301 => 0x2, 338 => 0xc8, 366 => 0x6, 367 => 0x20, 368 => 0x25, 369 => 0x65 },
	'face2size' => { 302 => 0x2 },
	'face30position' => { 301 => 0x3a },
	'face30size' => { 302 => 0x3a },
	'face31position' => { 301 => 0x3c },
	'face31size' => { 302 => 0x3c },
	'face32position' => { 301 => 0x3e },
	'face32size' => { 302 => 0x3e },
	'face3position' => { 48 => 0xc, 101 => 0xeb, 102 => 0x80, 186 => 0xc, 276 => 0x9, 301 => 0x4, 338 => 0xd4, 366 => 0xb, 367 => 0x40, 368 => 0x4a, 369 => 0x6f },
	'face3size' => { 302 => 0x4 },
	'face4position' => { 48 => 0xe, 101 => 0x15a, 102 => 0xb4, 186 => 0x10, 276 => 0xd, 301 => 0x6, 338 => 0xe0, 366 => 0x10, 367 => 0x60, 368 => 0x6f, 369 => 0x79 },
	'face4size' => { 302 => 0x6 },
	'face5position' => { 48 => 0x10, 101 => 0x1c9, 102 => 0xe8, 186 => 0x14, 276 => 0x11, 301 => 0x8, 338 => 0xec, 366 => 0x15, 367 => 0x80, 368 => 0x94 },
	'face5size' => { 302 => 0x8 },
	'face6position' => { 48 => 0x12, 101 => 0x238, 102 => 0x11c, 186 => 0x18, 301 => 0xa, 338 => 0xf8, 366 => 0x1a, 367 => 0xa0, 368 => 0xb9 },
	'face6size' => { 302 => 0xa },
	'face7position' => { 48 => 0x14, 101 => 0x2a7, 102 => 0x150, 186 => 0x1c, 301 => 0xc, 338 => 0x104, 366 => 0x1f, 367 => 0xc0, 368 => 0xde },
	'face7size' => { 302 => 0xc },
	'face8position' => { 48 => 0x16, 101 => 0x316, 102 => 0x184, 186 => 0x20, 301 => 0xe, 338 => 0x110, 366 => 0x24, 367 => 0xe0, 368 => 0x103 },
	'face8size' => { 302 => 0xe },
	'face9position' => { 48 => 0x18, 101 => 0x385, 102 => 0x1b8, 186 => 0x24, 301 => 0x10 },
	'face9size' => { 302 => 0x10 },
	'facebalanceorigi' => { 413 => 'FaceBalanceOrigI' },
	'facebalanceorigq' => { 413 => 'FaceBalanceOrigQ' },
	'facebalancestrength' => { 413 => 'FaceBalanceStrength' },
	'facebalancewarmth' => { 413 => 'FaceBalanceWarmth' },
	'facedetect' => { 316 => 0x76, 348 => 0x100 },
	'facedetectarea' => { 265 => 0x1201 },
	'facedetectframecrop' => { 265 => 0x1207 },
	'facedetectframesize' => { 48 => 0x3, 101 => 0x1, 102 => 0x4, 186 => 0x1, 265 => 0x1203, 316 => 0x77, 338 => 0xb6 },
	'facedetection' => { 361 => 0x30, 375 => 0x19 },
	'faceid' => { 415 => 'FaceID' },
	'faceinfounknown' => { 104 => 0x2089 },
	'facename' => { 348 => 0x123 },
	'faceorientation' => { 102 => 0x8 },
	'faceposition' => { 300 => 0x2, 349 => 0x4 },
	'facepositions' => { 114 => 0x4103 },
	'facerecognition' => { 348 => 0x120 },
	'facesdetected' => { 48 => 0x2, 49 => 0x2, 50 => 0x3, 101 => 0x0, 102 => 0x2, 104 => 0x211c, 114 => 0x4100, 186 => 0x3, 265 => 0x1200, 282 => 0x3f, 300 => 0x0, 338 => 0xb5, 349 => 0x0, 366 => 0x0, 369 => 0x3, 377 => 0x30 },
	'facesrecognized' => { 277 => 0x0 },
	'facewidth' => { 49 => 0x1 },
	'faithfuloutputhighlightpoint' => { 100 => 0x38 },
	'faithfuloutputshadowpoint' => { 100 => 0x39 },
	'faithfulrawcolortone' => { 100 => 0x31 },
	'faithfulrawcontrast' => { 100 => 0x33 },
	'faithfulrawhighlight' => { 100 => 0x79 },
	'faithfulrawhighlightpoint' => { 100 => 0x36 },
	'faithfulrawlinear' => { 100 => 0x34 },
	'faithfulrawsaturation' => { 100 => 0x32 },
	'faithfulrawshadow' => { 100 => 0x82 },
	'faithfulrawshadowpoint' => { 100 => 0x37 },
	'faithfulrawsharpness' => { 100 => 0x35 },
	'faithfulunsharpmaskfineness' => { 100 => 0xac },
	'faithfulunsharpmaskstrength' => { 100 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 100 => 0xae },
	'feedidentifier' => { 430 => 'FeedIdentifier' },
	'femicroadjustment' => { 75 => 0x111 },
	'ffid' => { 422 => 'ffid' },
	'field' => { 433 => 'field' },
	'fieldcount' => { 266 => 0x103f },
	'filecreatedate' => { 110 => 'FileCreateDate' },
	'filedatarate' => { 444 => 'fileDataRate' },
	'fileformat' => { 86 => 0x0, 118 => 0x14, 351 => [0x22,0x26], 371 => 0xb000 },
	'filegroupid' => { 110 => 'FileGroupID' },
	'fileindex' => { 6 => 0x143, 8 => 0x2d0, 10 => 0x172, 12 => 0x22c, 13 => 0x133, 14 => 0x13f, 15 => 0x1d3, 16 => 0x19b, 17 => 0x1e4, 18 => 0xd0, 19 => 0x1bb, 20 => 0x28c, 21 => 0x1db, 22 => 0x1d9, 23 => [0x270,0x274], 24 => 0x2aa, 25 => 0x2b3, 27 => 0x1eb, 28 => 0x4ae, 283 => 0x0 },
	'fileindex2' => { 20 => 0x290 },
	'filemodifydate' => { 110 => 'FileModifyDate' },
	'filename' => { 110 => 'FileName' },
	'filenameasdelivered' => { 271 => 'FileNameAsDelivered' },
	'filenumber' => { 51 => 0x1, 57 => 0x8, 88 => 0x1817, 105 => 'FileNumber', 187 => 0x4 },
	'filenumbermemory' => { 163 => 0x1a },
	'filenumbersequence' => { 245 => '12.2', 250 => '3.1', 251 => '4.1', 252 => '4.1', 254 => '11.1', 255 => '4.3', 259 => '5.2' },
	'filepermissions' => { 110 => 'FilePermissions' },
	'filesource' => { 109 => 0xa300, 114 => 0x8000, 424 => 'FileSource' },
	'fileuserid' => { 110 => 'FileUserID' },
	'fileversion' => { 118 => 0x16 },
	'fillflashautoreduction' => { 73 => 0xe, 74 => 0xe, 81 => 0xa },
	'filllight' => { 420 => 'FillLight' },
	'fillorder' => { 109 => 0x10a },
	'filmgraineffect' => { 261 => 0x538 },
	'filmmode' => { 114 => 0x1401, 280 => 0x412, 282 => 0x42 },
	'filmtype' => { 207 => 0x2 },
	'filtereffect' => { 51 => 0xe, 202 => 0x37, 203 => 0x3f },
	'filtereffectauto' => { 64 => 0xa0 },
	'filtereffectfaithful' => { 63 => 0x70, 64 => 0x70 },
	'filtereffectlandscape' => { 63 => 0x40, 64 => 0x40 },
	'filtereffectmonochrome' => { 18 => 0xff, 63 => 0x88, 64 => 0x88 },
	'filtereffectneutral' => { 63 => 0x58, 64 => 0x58 },
	'filtereffectportrait' => { 63 => 0x28, 64 => 0x28 },
	'filtereffectstandard' => { 63 => 0x10, 64 => 0x10 },
	'filtereffectuserdef1' => { 63 => 0xa0, 64 => 0xb8 },
	'filtereffectuserdef2' => { 63 => 0xb8, 64 => 0xd0 },
	'filtereffectuserdef3' => { 63 => 0xd0, 64 => 0xe8 },
	'finderdisplayduringexposure' => { 74 => 0x1 },
	'finesharpness' => { 316 => 0x70 },
	'finetuneoptcenterweighted' => { 245 => '7.2', 246 => '9.1', 248 => '9.1', 249 => '9.1', 253 => '8.1', 258 => '9.1', 259 => '9.1' },
	'finetuneopthighlightweighted' => { 248 => '46.1', 249 => '46.1', 258 => '46.1' },
	'finetuneoptmatrixmetering' => { 245 => '8.1', 246 => '8.2', 248 => '8.2', 249 => '8.2', 253 => '7.2', 254 => '6.1', 258 => '8.2', 259 => '8.2' },
	'finetuneoptspotmetering' => { 245 => '8.2', 246 => '9.2', 248 => '9.2', 249 => '9.2', 253 => '8.2', 254 => '6.2', 258 => '9.2', 259 => '9.2' },
	'firmware' => { 266 => 0x405, 351 => [0x17,0x3b,0x57], 416 => 'Firmware' },
	'firmwaredate' => { 103 => 0x15, 104 => 0x2001, 337 => 0x4 },
	'firmwareid' => { 170 => 0x0 },
	'firmwarename' => { 348 => 0xa001 },
	'firmwarerevision' => { 18 => 0xa4, 57 => 0x1e, 339 => 0x0 },
	'firmwarerevision2' => { 339 => 0xc },
	'firmwareversion' => { 6 => 0x10b, 10 => 0x136, 13 => 0xff, 14 => 0x107, 123 => 0xce5, 137 => 0x57, 139 => 'FirmwareVersion', 282 => 0x2, 284 => 0x3109, 316 => 0x230, 341 => 0x2 },
	'firmwareversions' => { 325 => 0x301 },
	'firstphotodate' => { 408 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 271 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 117 => 0x16, 414 => 'FixtureIdentifier' },
	'flash' => { 105 => 'Flash', 109 => 0x9209, 164 => 0x1f, 165 => 0x15, 424 => 'Flash' },
	'flashaction' => { 359 => 0x3e, 360 => 0x3e, 371 => 0x2017, 375 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 359 => 0x4c, 360 => 0x4c, 375 => 0x77 },
	'flashactionexternal' => { 375 => [0x78,0x7c] },
	'flashactivity' => { 33 => 0x1c },
	'flashbatterylevel' => { 39 => 0x249 },
	'flashbias' => { 282 => 0x24 },
	'flashbits' => { 33 => 0x1d },
	'flashbuttonfunction' => { 75 => 0x70e },
	'flashchargelevel' => { 266 => 0x1010 },
	'flashcolorfilter' => { 190 => 0x10 },
	'flashcommandermode' => { 188 => '9.1', 189 => '9.1', 190 => '9.1' },
	'flashcompensation' => { 188 => 0xa, 189 => 0xa, 190 => 0xa, 191 => 0xa, 416 => 'FlashCompensation' },
	'flashcontrol' => { 359 => 0x23, 360 => 0x1f, 361 => 0x21 },
	'flashcontrolbuilt-in' => { 254 => '16.1', 255 => '23.1', 257 => '23.1', 258 => '24.1' },
	'flashcontrolmode' => { 188 => '9.2', 189 => '9.2', 190 => '9.2', 261 => 0x404 },
	'flashcurtain' => { 282 => 0x48 },
	'flashdefault' => { 166 => 0x42 },
	'flashdevice' => { 266 => 0x1005 },
	'flashdistance' => { 104 => 0x2034 },
	'flashenergy' => { 109 => 0xa20b, 424 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 200 => 0x18 },
	'flashexposurecomp' => { 69 => 0xf, 114 => 0x1011, 142 => 'ExposureComp', 163 => 0x23, 168 => 0x104, 169 => 0x49c1, 200 => 0x12, 261 => 0x401, 266 => 0x1023, 316 => 0x4d, 341 => 0x100b, 351 => [0x3a,0x56], 371 => 0x104 },
	'flashexposurecomp2' => { 225 => 0x4d2 },
	'flashexposurecomp3' => { 190 => 0x1d },
	'flashexposurecomp4' => { 190 => 0x27 },
	'flashexposurecomparea' => { 246 => '38.4', 248 => '38.4', 249 => '38.4', 258 => '38.4' },
	'flashexposurecompset' => { 166 => 0x10, 289 => 0xe, 359 => 0x14, 360 => 0x12, 361 => 0x23, 375 => 0x1f },
	'flashexposurecompset2' => { 375 => [0x26,0x2c] },
	'flashexposureindicator' => { 166 => 0x54 },
	'flashexposureindicatorlast' => { 166 => 0x56 },
	'flashexposureindicatornext' => { 166 => 0x55 },
	'flashexposurelock' => { 51 => 0x19 },
	'flashfired' => { 125 => 0x5d, 142 => 'Fired', 163 => 0x14, 224 => '590.3', 282 => 0x8007, 424 => [\'Flash','FlashFired'] },
	'flashfiring' => { 75 => 0x306, 76 => 0x6, 77 => 0x7, 80 => 0x7 },
	'flashfirmwareversion' => { 262 => 0x1002 },
	'flashfocallength' => { 188 => 0xb, 189 => 0xc, 190 => 0xc, 191 => 0xc },
	'flashfunction' => { 169 => 0x31, 424 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 188 => 0xe, 189 => 0xf, 190 => 0xf, 191 => 0xf },
	'flashgroupacompensation' => { 188 => 0x11, 189 => 0x12, 190 => 0x13 },
	'flashgroupacontrolmode' => { 188 => 0xf, 189 => '16.1', 190 => '17.1' },
	'flashgroupaoutput' => { 188 => 0x11, 189 => 0x12, 190 => 0x13 },
	'flashgroupbcompensation' => { 188 => 0x12, 189 => 0x13, 190 => 0x14 },
	'flashgroupbcontrolmode' => { 188 => 0x10, 189 => '17.1', 190 => '18.1' },
	'flashgroupboutput' => { 188 => 0x12, 189 => 0x13, 190 => 0x14 },
	'flashgroupccompensation' => { 189 => 0x14, 190 => 0x15 },
	'flashgroupccontrolmode' => { 189 => '17.2', 190 => '18.2' },
	'flashgroupcoutput' => { 189 => 0x14, 190 => 0x15 },
	'flashguidenumber' => { 69 => 0xd, 85 => 0x0, 142 => 'GuideNumber' },
	'flashintensity' => { 103 => [0x19,0x5], 261 => 0x405 },
	'flashlevel' => { 247 => 0x9, 371 => 0xb048 },
	'flashmake' => { 142 => 'Make' },
	'flashmanufacturer' => { 161 => 'FlashManufacturer' },
	'flashmetering' => { 163 => 0x3f, 166 => 0x1c },
	'flashmeteringmode' => { 6 => 0x15, 12 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 19 => 0x15, 21 => 0x15, 27 => 0x15 },
	'flashmeteringsegments' => { 316 => 0x20a },
	'flashmode' => { 103 => 0x4, 125 => 0x5c, 142 => 'Mode', 163 => 0x2, 164 => 0x20, 165 => 0x16, 166 => 0xf, 200 => 0x87, 261 => 0x400, 266 => 0x1004, 316 => 0xc, 323 => 0x4, 340 => 0x20, 341 => 0x100a, 350 => 0x225, 359 => 0x13, 360 => 0x7f, 361 => 0x20, 375 => 0x10, 378 => 0x1138, 379 => 0x1138, 380 => 0x1114, 381 => 0x1190, 382 => 0x116c, 383 => 0x1024, 384 => 0x21c, 385 => 0x21c, 424 => [\'Flash','FlashMode'] },
	'flashmodel' => { 142 => 'Model', 161 => 'FlashModel', 262 => 0x1001 },
	'flashoptions' => { 297 => 0x2 },
	'flashoptions2' => { 297 => 0x10 },
	'flashoutput' => { 39 => 0x248, 69 => 0x21, 188 => 0xa, 189 => 0xa, 190 => 0xa },
	'flashpixversion' => { 109 => 0xa000, 424 => 'FlashpixVersion' },
	'flashredeyemode' => { 424 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 261 => 0x403 },
	'flashreturn' => { 424 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 142 => 'SerialNumber', 262 => 0x1003 },
	'flashsetting' => { 200 => 0x8 },
	'flashshutterspeed' => { 245 => '20.2', 246 => '23.2', 248 => '23.2', 249 => '23.2', 254 => '15.2', 255 => '22.2', 256 => '7.2', 257 => '22.2', 258 => '23.2', 259 => '23.1' },
	'flashsource' => { 188 => 0x4, 189 => 0x4, 190 => 0x4, 191 => 0x4 },
	'flashstatus' => { 304 => 0x0, 375 => [0x82,0x86], 388 => 0x31, 389 => 0x39 },
	'flashstatusbuilt-in' => { 361 => [0x87,0x287] },
	'flashstatusexternal' => { 361 => [0x88,0x288] },
	'flashsyncspeed' => { 245 => '20.1', 246 => '23.1', 248 => '23.1', 249 => '23.1', 254 => '15.1', 255 => '22.1', 257 => '22.1', 258 => '23.1' },
	'flashsyncspeedav' => { 73 => 0x3, 75 => 0x10f, 76 => 0x2, 77 => 0x3, 78 => 0x2, 79 => 0x2, 80 => 0x3, 81 => 0x6 },
	'flashthreshold' => { 85 => 0x1 },
	'flashtype' => { 142 => 'Type', 166 => 0x59, 200 => 0x9, 262 => 0x1000 },
	'flashwarning' => { 255 => '30.1', 256 => '7.1', 259 => '31.1', 282 => 0x62 },
	'flexiblespotposition' => { 371 => 0x201d },
	'flickerreduce' => { 350 => 0x218 },
	'flickerreduction' => { 218 => 0xe84 },
	'flickerreductionindicator' => { 218 => 0x5e2 },
	'fliphorizontal' => { 238 => 0x76a43206 },
	'fnumber' => { 6 => 0x3, 8 => 0x3, 10 => 0x3, 12 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x3, 28 => 0x3, 29 => 0x5, 30 => 0x6, 69 => 0x15, 109 => 0x829d, 122 => 0xfd04, 125 => 0x1e, 127 => 0xfa23, 129 => 0xf103, 132 => 0x13, 134 => 0x3c, 137 => 0xc, 146 => 'FNumber', 163 => 0xa, 164 => 0x36, 165 => 0x47, 166 => 0x9, 169 => 0x49c7, 316 => 0x13, 348 => 0xa019, 351 => [0x31,0x49], 359 => 0x1, 360 => 0x1, 375 => [0x20,0x22,0x26], 424 => 'FNumber' },
	'focallength' => { 6 => 0x1d, 7 => 0xa, 8 => 0x23, 9 => 0x9, 10 => 0x1d, 11 => 0x9, 12 => 0x1e, 13 => 0x1d, 14 => 0x1d, 15 => 0x1e, 16 => 0x1e, 17 => 0x1e, 18 => 0x28, 19 => 0x1e, 20 => 0x23, 21 => 0x1e, 22 => 0x1e, 23 => 0x23, 24 => 0x23, 25 => 0x23, 26 => 0x23, 27 => 0x1e, 28 => 0x23, 53 => 0x1, 104 => 0x1d, 109 => 0x920a, 132 => 0x1d, 146 => 'FocalLength', 163 => 0x12, 196 => 0xa, 197 => 0xb, 316 => 0x1d, 325 => 0x403, 341 => 0x1500, 358 => 0xe, 382 => 0x1278, 383 => 0x1134, 384 => 0x32c, 385 => 0x32c, 386 => 0x30a, 424 => 'FocalLength' },
	'focallength2' => { 375 => [0x23,0x25,0x29] },
	'focallengthin35mmformat' => { 109 => 0xa405, 348 => 0xa01a, 424 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 358 => 0x10 },
	'focalplaneafpointarea' => { 387 => 0x2 },
	'focalplaneafpointlocation1' => { 387 => 0x6 },
	'focalplaneafpointlocation10' => { 387 => 0x2a },
	'focalplaneafpointlocation11' => { 387 => 0x2e },
	'focalplaneafpointlocation12' => { 387 => 0x32 },
	'focalplaneafpointlocation13' => { 387 => 0x36 },
	'focalplaneafpointlocation14' => { 387 => 0x3a },
	'focalplaneafpointlocation15' => { 387 => 0x3e },
	'focalplaneafpointlocation2' => { 387 => 0xa },
	'focalplaneafpointlocation3' => { 387 => 0xe },
	'focalplaneafpointlocation4' => { 387 => 0x12 },
	'focalplaneafpointlocation5' => { 387 => 0x16 },
	'focalplaneafpointlocation6' => { 387 => 0x1a },
	'focalplaneafpointlocation7' => { 387 => 0x1e },
	'focalplaneafpointlocation8' => { 387 => 0x22 },
	'focalplaneafpointlocation9' => { 387 => 0x26 },
	'focalplaneafpointsused' => { 387 => 0x1 },
	'focalplanediagonal' => { 262 => 0x103, 266 => 0x205 },
	'focalplaneresolutionunit' => { 109 => 0xa210, 424 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 109 => 0xa20e, 424 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 53 => 0x2 },
	'focalplanexunknown' => { 53 => 0x2 },
	'focalplaneyresolution' => { 109 => 0xa20f, 424 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 53 => 0x3 },
	'focalplaneyunknown' => { 53 => 0x3 },
	'focaltype' => { 9 => 0x2d, 53 => 0x0 },
	'focalunits' => { 33 => 0x19 },
	'focus' => { 228 => 0x8 },
	'focusarea' => { 163 => 0x31 },
	'focusareaselection' => { 256 => '15.2' },
	'focuscontinuous' => { 33 => 0x20 },
	'focusdisplayaiservoandmf' => { 75 => 0x515 },
	'focusdistance' => { 146 => 'FocusDistance', 163 => 0x13, 169 => 0x49bb, 196 => 0x9, 197 => 0xa, 264 => 0x305 },
	'focusdistancelower' => { 6 => 0x45, 8 => 0x8e, 10 => 0x45, 12 => 0x56, 13 => 0x45, 14 => 0x45, 15 => 0x52, 16 => 0x52, 17 => 0x56, 19 => 0x52, 20 => 0x8e, 21 => 0x59, 22 => 0x57, 23 => 0x8e, 24 => 0x94, 25 => 0x95, 26 => 0xa7, 27 => 0x56, 28 => 0xa7, 51 => 0x15, 69 => 0x14 },
	'focusdistanceupper' => { 6 => 0x43, 8 => 0x8c, 10 => 0x43, 12 => 0x54, 13 => 0x43, 14 => 0x43, 15 => 0x50, 16 => 0x50, 17 => 0x54, 19 => 0x50, 20 => 0x8c, 21 => 0x57, 22 => 0x55, 23 => 0x8c, 24 => 0x92, 25 => 0x93, 26 => 0xa5, 27 => 0x54, 28 => 0xa5, 51 => 0x14, 69 => 0x13 },
	'focusholdbutton' => { 166 => 0x44 },
	'focusinfoversion' => { 264 => 0x0 },
	'focusingscreen' => { 74 => 0x0, 75 => 0x80b, 80 => 0x0 },
	'focuslocation' => { 371 => 0x2027 },
	'focuslocked' => { 162 => 0x14 },
	'focusmode' => { 33 => 0x7, 103 => 0x3, 104 => [0x3003,0xd], 114 => 0x1021, 125 => 0x38, 139 => 'FocusMode', 163 => 0x30, 165 => 0xe, 166 => 0xc, 200 => 0x7, 261 => 0x301, 266 => 0x100b, 282 => 0x7, 316 => 0xd, 323 => 0x3, 341 => 0x1006, 352 => [0xb,0x5], 358 => [0x15,0x1d], 359 => 0x4d, 360 => 0x4d, 371 => [0xb042,0xb04e,0x201b], 375 => 0x13, 393 => 0x16 },
	'focusmode2' => { 297 => '3.1', 375 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 247 => '10.1', 356 => 0x14, 357 => 0x15, 359 => 0x10, 360 => 0xf, 361 => 0x6 },
	'focusmodeswitch' => { 166 => 0x58, 359 => 0x2e },
	'focuspixel' => { 114 => 0x1023 },
	'focuspointwrap' => { 245 => '2.2', 246 => '2.2', 248 => '2.1', 249 => '2.1', 253 => '1.1', 254 => '2.2', 255 => '1.1', 258 => '2.2', 259 => '2.5' },
	'focusposition' => { 196 => 0x8, 197 => 0x8, 316 => 0x10, 370 => 0x9bb },
	'focusposition2' => { 375 => [0x29,0x2b,0x2f], 393 => 0x2d, 396 => 0x20 },
	'focusprocess' => { 261 => 0x302 },
	'focusrange' => { 33 => 0x12, 266 => 0x100a },
	'focusrangeindex' => { 307 => '3.1' },
	'focussetting' => { 351 => 0x6 },
	'focusstatus' => { 358 => 0x19, 359 => 0x53, 360 => 0x53 },
	'focusstepcount' => { 264 => 0x301, 266 => 0x100e },
	'focusstepinfinity' => { 264 => 0x303, 266 => 0x103b },
	'focusstepnear' => { 264 => 0x304, 266 => 0x103c },
	'focustrackinglockon' => { 245 => ['1.5','4.1'], 246 => '1.4', 253 => '0.4', 254 => '3.1', 255 => '0.4', 258 => '1.4' },
	'focuswarning' => { 114 => 0x1301 },
	'foldername' => { 163 => 0x27 },
	'foldernumber' => { 359 => 0x9a, 361 => [0x402,0x114,0x316] },
	'fontcomposite' => { 449 => [\'Fonts','FontsComposite'] },
	'fontface' => { 449 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 449 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 449 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 449 => [\'Fonts','FontsFontName'] },
	'fonts' => { 449 => 'Fonts' },
	'fonttype' => { 449 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 449 => [\'Fonts','FontsVersionString'] },
	'for' => { 332 => 'For' },
	'format' => { 421 => 'format', 442 => 'Format' },
	'forwardlock' => { 439 => 'forwardlock' },
	'forwardmatrix1' => { 109 => 0xc714 },
	'forwardmatrix2' => { 109 => 0xc715 },
	'framecount' => { 60 => [0x2,0x4] },
	'frameheight' => { 114 => 0x3822 },
	'framenum' => { 327 => 0xd7 },
	'framenumber' => { 114 => 0x8003, 169 => 0x3c, 316 => 0x29 },
	'framerate' => { 60 => [0x1,0x6], 109 => 0xc764, 114 => 0x3820 },
	'framewidth' => { 114 => 0x3821 },
	'framing' => { 433 => 'framing' },
	'freebytes' => { 88 => 0x1 },
	'freememorycardimages' => { 164 => [0x37,0x54], 165 => [0x2d,0x4a], 166 => 0x32 },
	'fujiflashmode' => { 114 => 0x1010 },
	'fullimagesize' => { 371 => 0xb02b },
	'fullpanoheightpixels' => { 408 => 'FullPanoHeightPixels', 409 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 408 => 'FullPanoWidthPixels', 409 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 341 => 0x100d },
	'fullsizeimage' => { 145 => 'data' },
	'fullsizeimagename' => { 145 => '1Name' },
	'fullsizeimagetype' => { 145 => '0Type' },
	'func1button' => { 248 => '14.1', 249 => '14.1' },
	'func1buttonplusdials' => { 248 => '42.1', 249 => '42.1' },
	'func2button' => { 248 => '80.1', 249 => '80.1' },
	'func2buttonplusdials' => { 248 => '81.1' },
	'func3button' => { 248 => '83.1' },
	'funcbutton' => { 245 => ['14.1','15.1'], 246 => '14.1', 254 => '28.1', 255 => '13.1', 258 => '14.1', 259 => '14.1' },
	'funcbuttonplusdials' => { 245 => ['14.2','15.2'], 246 => '14.2', 254 => '31.1', 258 => '42.1' },
	'functionbutton' => { 252 => '13.1', 256 => '5.2' },
	'gainbase' => { 265 => 0x610 },
	'gaincontrol' => { 109 => 0xa407, 424 => 'GainControl' },
	'gamma' => { 109 => 0xa500, 425 => 'Gamma' },
	'gammablackpoint' => { 96 => 0xc },
	'gammacolortone' => { 96 => 0x3 },
	'gammacompensatedvalue' => { 119 => 0x91 },
	'gammacontrast' => { 96 => 0x2 },
	'gammacurveoutputrange' => { 96 => 0xf },
	'gammahighlight' => { 96 => 0xa },
	'gammalinear' => { 94 => 0x20200 },
	'gammamidpoint' => { 96 => 0xe },
	'gammasaturation' => { 96 => 0x4 },
	'gammashadow' => { 96 => 0x9 },
	'gammasharpnessstrength' => { 96 => 0x8 },
	'gammaunsharpmaskfineness' => { 96 => 0x6 },
	'gammaunsharpmaskstrength' => { 96 => 0x5 },
	'gammaunsharpmaskthreshold' => { 96 => 0x7 },
	'gammawhitepoint' => { 96 => 0xd },
	'geimagesize' => { 114 => 0x1304 },
	'gemake' => { 115 => 0x300 },
	'gemodel' => { 115 => 0x207 },
	'genre' => { 430 => 'Genre', 434 => 'genre', 444 => 'genre' },
	'genrecvid' => { 430 => [\'Genre','GenreCvId'] },
	'genrecvtermid' => { 430 => [\'Genre','GenreCvTermId'] },
	'genrecvtermname' => { 430 => [\'Genre','GenreCvTermName'] },
	'genrecvtermrefinedabout' => { 430 => [\'Genre','GenreCvTermRefinedAbout'] },
	'geography' => { 435 => 'geography' },
	'geologicalcontext' => { 108 => 'GeologicalContext' },
	'geologicalcontextbed' => { 108 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 108 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 108 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 108 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 108 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 110 => 'Geosync' },
	'geotag' => { 110 => 'Geotag' },
	'geotiffasciiparams' => { 109 => 0x87b1 },
	'geotiffdirectory' => { 109 => 0x87af },
	'geotiffdoubleparams' => { 109 => 0x87b0 },
	'geotime' => { 110 => 'Geotime' },
	'giftftppriority' => { 410 => 'GIFTFtpPriority' },
	'globalaltitude' => { 330 => 0x419 },
	'globalangle' => { 330 => 0x40d },
	'good' => { 444 => 'good' },
	'googleplusuploadcode' => { 109 => 0x9009 },
	'gpsaltitude' => { 116 => 0x6, 143 => 'Altitude', 424 => 'GPSAltitude' },
	'gpsaltituderef' => { 116 => 0x5, 424 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 116 => 0x1c, 424 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 116 => 0x1d },
	'gpsdatetime' => { 143 => 'DateTime', 424 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 116 => 0x18, 143 => 'Bearing', 424 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 116 => 0x17, 424 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 116 => 0x1a, 143 => 'Distance', 424 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 116 => 0x19, 424 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 116 => 0x14, 424 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 116 => 0x13 },
	'gpsdestlongitude' => { 116 => 0x16, 424 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 116 => 0x15 },
	'gpsdifferential' => { 116 => 0x1e, 143 => 'Differential', 424 => 'GPSDifferential' },
	'gpsdop' => { 116 => 0xb, 424 => 'GPSDOP' },
	'gpshpositioningerror' => { 116 => 0x1f, 424 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 116 => 0x11, 424 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 116 => 0x10, 424 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 116 => 0x2, 143 => 'Latitude', 424 => 'GPSLatitude' },
	'gpslatituderef' => { 116 => 0x1 },
	'gpslongitude' => { 116 => 0x4, 143 => 'Longitude', 424 => 'GPSLongitude' },
	'gpslongituderef' => { 116 => 0x3 },
	'gpsmapdatum' => { 116 => 0x12, 143 => 'Datum', 424 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 116 => 0xa, 143 => 'MeasureMode', 424 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 116 => 0x1b, 424 => 'GPSProcessingMethod' },
	'gpssatellites' => { 116 => 0x8, 143 => 'Satellites', 424 => 'GPSSatellites' },
	'gpsspeed' => { 116 => 0xd, 143 => 'Speed', 424 => 'GPSSpeed' },
	'gpsspeedref' => { 116 => 0xc, 424 => 'GPSSpeedRef' },
	'gpsstatus' => { 116 => 0x9, 424 => 'GPSStatus' },
	'gpstimestamp' => { 116 => 0x7 },
	'gpstrack' => { 116 => 0xf, 143 => 'Heading', 424 => 'GPSTrack' },
	'gpstrackref' => { 116 => 0xe, 424 => 'GPSTrackRef' },
	'gpsversionid' => { 116 => 0x0, 424 => 'GPSVersionID' },
	'gradation' => { 261 => 0x50f },
	'gradientbasedcorractive' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrbrightness' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrdefringe' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrections' => { 420 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrluminancenoise' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskleft' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmidpoint' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskperimetervalue' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskright' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskx' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrsaturation' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrshadows2012' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtint' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrwhat' => { 420 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'grainamount' => { 420 => 'GrainAmount' },
	'grainfrequency' => { 420 => 'GrainFrequency' },
	'grainsize' => { 420 => 'GrainSize' },
	'graymixeraqua' => { 420 => 'GrayMixerAqua' },
	'graymixerblue' => { 420 => 'GrayMixerBlue' },
	'graymixergreen' => { 420 => 'GrayMixerGreen' },
	'graymixermagenta' => { 420 => 'GrayMixerMagenta' },
	'graymixerorange' => { 420 => 'GrayMixerOrange' },
	'graymixerpurple' => { 420 => 'GrayMixerPurple' },
	'graymixerred' => { 420 => 'GrayMixerRed' },
	'graymixeryellow' => { 420 => 'GrayMixerYellow' },
	'graypoint' => { 402 => 0x8021 },
	'grayresponseunit' => { 109 => 0x122 },
	'greencurvelimits' => { 99 => 0x1c4 },
	'greencurvepoints' => { 98 => 0x53, 99 => 0x19a },
	'greenhsl' => { 94 => 0x20912 },
	'greenhue' => { 420 => 'GreenHue' },
	'greensaturation' => { 420 => 'GreenSaturation' },
	'griddisplay' => { 245 => '13.3', 246 => '4.3', 248 => '4.2', 249 => '4.2', 250 => '2.2', 254 => '10.5', 255 => '3.4', 256 => '6.1', 258 => '4.4', 259 => '4.2' },
	'gripbatteryadload' => { 295 => 0x5 },
	'gripbatteryadnoload' => { 295 => 0x4 },
	'gripbatterystate' => { 295 => '1.2' },
	'groupareaafillumination' => { 246 => '46.4', 249 => '47.4', 258 => '47.4' },
	'halftonehints' => { 109 => 0x141 },
	'hardlink' => { 110 => 'HardLink' },
	'hasalternative' => { 434 => 'hasAlternative' },
	'hascorrection' => { 434 => 'hasCorrection' },
	'hascorrectiona-lang' => { 434 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 434 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 434 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 420 => 'HasCrop' },
	'hasextendedxmp' => { 446 => 'HasExtendedXMP' },
	'hassettings' => { 420 => 'HasSettings' },
	'hastranslation' => { 434 => 'hasTranslation' },
	'hasvisibleoverprint' => { 449 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 449 => 'HasVisibleTransparency' },
	'hdr' => { 54 => 0x1, 193 => 0x4, 282 => 0x9e, 316 => 0x85, 371 => 0x200a },
	'hdreffect' => { 54 => 0x2 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrinfoversion' => { 193 => 0x0 },
	'hdrlevel' => { 193 => 0x5, 361 => 0x2e, 375 => 0x17 },
	'hdrlevel2' => { 193 => 0x7 },
	'hdrsetting' => { 361 => 0x2d, 375 => 0x16, 378 => 0x1148, 379 => 0x1148, 380 => 0x1124, 381 => 0x11a0, 382 => 0x117c, 383 => 0x1034, 384 => 0x22c, 385 => 0x22c, 386 => 0x21f },
	'hdrsmoothing' => { 193 => 0x6 },
	'headline' => { 117 => 0x69, 430 => 'Headline', 432 => 'Headline' },
	'hierarchicalkeywords' => { 154 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 154 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 154 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 154 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 154 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 154 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 154 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 154 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 154 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 154 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 154 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 154 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 154 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 154 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 154 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 154 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 154 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 154 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 411 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 108 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highisomultiplierblue' => { 286 => 0x1a },
	'highisomultipliergreen' => { 286 => 0x19 },
	'highisomultiplierred' => { 286 => 0x18 },
	'highisonoisereduction' => { 15 => 0xbc, 16 => 0xbd, 19 => 0xbd, 27 => 0xc9, 56 => 0x5, 75 => 0x202, 114 => 0x100e, 200 => 0xb1, 316 => 0x71, 359 => 0x2c, 360 => 0x26, 361 => 0x26, 371 => 0x2009, 375 => 0x12, 398 => 0x42 },
	'highisonoisereduction2' => { 371 => 0xb050 },
	'highlight' => { 351 => 0xf },
	'highlightadj' => { 94 => 0x2030c },
	'highlightcolordistortreduct' => { 402 => 0x8026 },
	'highlightlinearitylimit' => { 348 => 0xa025 },
	'highlightprotection' => { 237 => 0x6 },
	'highlightrecovery' => { 420 => 'HighlightRecovery' },
	'highlights' => { 413 => 'Highlights' },
	'highlights2012' => { 420 => 'Highlights2012' },
	'highlighttone' => { 114 => 0x1041 },
	'highlighttonepriority' => { 12 => 0x7, 15 => 0x7, 16 => 0x7, 17 => 0x7, 19 => 0x7, 21 => 0x7, 27 => 0x7, 56 => 0x3, 75 => 0x203 },
	'highlowkeyadj' => { 316 => 0x6c },
	'highspeedsync' => { 166 => 0x5, 359 => 0x2, 360 => 0x2 },
	'histogramxml' => { 238 => 0x83a1a25 },
	'history' => { 432 => 'History', 445 => 'History' },
	'historyaction' => { 445 => [\'History','HistoryAction'] },
	'historychanged' => { 445 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 445 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 445 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 445 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 445 => [\'History','HistoryWhen'] },
	'hometowncity' => { 104 => 0x3006, 316 => 0x23, 322 => 0x2 },
	'hometowncitycode' => { 323 => 0x1000 },
	'hometowndst' => { 316 => 0x25, 322 => '0.2' },
	'hostcomputer' => { 109 => 0x13c },
	'hue' => { 171 => 0x3b, 203 => 0x3d, 316 => 0x67 },
	'hueadj' => { 241 => 0x2f, 402 => 0x8019 },
	'hueadjust' => { 341 => 0x1016 },
	'hueadjustment' => { 164 => 0x4a, 165 => 0x40, 200 => 0x92, 202 => 0x36 },
	'hueadjustmentaqua' => { 420 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 420 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 420 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 420 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 420 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 420 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 420 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 420 => 'HueAdjustmentYellow' },
	'huesetting' => { 269 => 0x1011 },
	'humidity' => { 109 => 0x9401 },
	'icc_profile' => { 110 => 'ICC_Profile' },
	'iccprofilename' => { 432 => 'ICCProfile' },
	'idccreativestyle' => { 402 => 0x8000 },
	'idcpreviewlength' => { 402 => 0x202 },
	'idcpreviewstart' => { 402 => 0x201 },
	'identification' => { 108 => 'Identification' },
	'identificationid' => { 108 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 108 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 108 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 108 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 108 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 108 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifier' => { 421 => 'identifier', 442 => 'Identifier' },
	'illumination' => { 256 => '0.5' },
	'imageadjustment' => { 200 => 0x80, 228 => 0x5 },
	'imagealterationconstraints' => { 271 => 'ImageAlterationConstraints' },
	'imagearea' => { 212 => 0x10, 215 => 0x10 },
	'imageareaoffset' => { 316 => 0x38 },
	'imageauthentication' => { 200 => 0x20 },
	'imageboundary' => { 200 => 0x16 },
	'imagecount' => { 114 => 0x1438, 200 => 0xa5, 373 => 0x11b, 388 => 0x32, 389 => 0x3a },
	'imagecount2' => { 388 => 0x4c, 389 => 0x58 },
	'imagecount3' => { 388 => [0x1a0,0x1aa,0x1bd], 389 => [0x19f,0x1cb,0x1cd] },
	'imagecreator' => { 271 => 'ImageCreator' },
	'imagecreatorid' => { 271 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 271 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 271 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagedata' => { 407 => 'Data' },
	'imagedatasize' => { 200 => 0xa2 },
	'imagedescription' => { 109 => 0x10e, 440 => 'ImageDescription' },
	'imageduplicationconstraints' => { 271 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 238 => 0xfe443a45 },
	'imageeditcount' => { 316 => 0x41 },
	'imageediting' => { 316 => 0x32 },
	'imageeffects' => { 341 => 0x1010 },
	'imagefileconstraints' => { 271 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 271 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 271 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 114 => 0x1436 },
	'imageheight' => { 109 => 0x101, 170 => 0xc, 325 => 0x10d, 440 => 'ImageLength' },
	'imagehistory' => { 109 => 0x9213, 423 => 'ImageHistory' },
	'imageidnumber' => { 278 => 0x340 },
	'imagemimetype' => { 407 => 'Mime' },
	'imagenumber' => { 109 => 0x9211, 139 => 'ImageNumber', 164 => 0xae, 165 => 0x5e, 325 => 0x113, 359 => 0x9b, 361 => [0x400,'276.1',0x314], 416 => 'ImageNumber' },
	'imagenumber2' => { 165 => 0x62 },
	'imageoptimization' => { 200 => 0xa9 },
	'imageorientation' => { 117 => 0x83 },
	'imageprocessing' => { 200 => 0x1a },
	'imageprocessingversion' => { 265 => 0x0 },
	'imagequality' => { 139 => 'ImageQuality', 214 => '723.2', 215 => '732.2', 224 => '708.1', 282 => 0x1 },
	'imagequality2' => { 261 => 0x603 },
	'imagerank' => { 410 => 'ImageRank' },
	'imageref' => { 428 => 'ImageRef' },
	'imagereview' => { 247 => '0.4', 256 => '0.4' },
	'imagereviewmonitorofftime' => { 246 => '21.1', 248 => '21.1', 249 => '21.1', 253 => '20.1', 258 => '21.1' },
	'imagereviewtime' => { 245 => '25.1', 247 => '2.1', 250 => '19.1', 251 => '20.1', 252 => '20.1', 254 => '9.2', 255 => '20.1', 259 => '21.2' },
	'imagesize' => { 145 => 'ImageSize' },
	'imagesizerestriction' => { 437 => 'imageSizeRestriction' },
	'imagesourcedata' => { 109 => 0x935c },
	'imagestabilization' => { 33 => 0x22, 104 => 0x3020, 114 => 0x1422, 139 => 'ImageStabilization', 164 => 0xbd, 165 => 0x71, 166 => 0x57, 167 => 0x0, 168 => [0x18,0x107,0x113], 169 => 0x49c2, 200 => 0xac, 261 => 0x604, 264 => 0x1600, 282 => 0x1a, 364 => 0x12, 365 => 0x11, 371 => 0xb026 },
	'imagestabilization2' => { 363 => 0xa },
	'imagestabilizationsetting' => { 169 => 0x14, 359 => 0x3d, 360 => 0x3d, 370 => 0x14 },
	'imagestyle' => { 359 => 0x2d, 360 => 0x27 },
	'imagesupplier' => { 271 => 'ImageSupplier' },
	'imagesupplierid' => { 271 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 271 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 271 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 111 => 0x1 },
	'imagetemperaturemin' => { 111 => 0x2 },
	'imagetone' => { 316 => 0x4f },
	'imagetype' => { 117 => 0x82, 271 => 'ImageType' },
	'imageuniqueid' => { 1 => 0x15, 57 => 0x28, 109 => 0xa420, 423 => 'ImageUniqueID', 424 => 'ImageUniqueID' },
	'imagewidth' => { 109 => 0x100, 170 => 0xe, 325 => 0x10c, 440 => 'ImageWidth' },
	'incrementaltemperature' => { 420 => 'IncrementalTemperature' },
	'incrementaltint' => { 420 => 'IncrementalTint' },
	'industry' => { 434 => 'industry', 435 => 'industry' },
	'infobuttonwhenshooting' => { 75 => 0x409 },
	'infraredilluminator' => { 337 => 0x28 },
	'ingredientexclusion' => { 436 => 'ingredientExclusion' },
	'ingredients' => { 445 => 'Ingredients' },
	'ingredientsalternatepaths' => { 445 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 445 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 445 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 445 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 445 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 445 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientslasturl' => { 445 => [\'Ingredients','IngredientsLastURL'] },
	'ingredientslinkcategory' => { 445 => [\'Ingredients','IngredientsLinkCategory'] },
	'ingredientslinkform' => { 445 => [\'Ingredients','IngredientsLinkForm'] },
	'ingredientsmanager' => { 445 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 445 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 445 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 445 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 445 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 445 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 445 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsplacedresolutionunit' => { 445 => [\'Ingredients','IngredientsPlacedResolutionUnit'] },
	'ingredientsplacedxresolution' => { 445 => [\'Ingredients','IngredientsPlacedXResolution'] },
	'ingredientsplacedyresolution' => { 445 => [\'Ingredients','IngredientsPlacedYResolution'] },
	'ingredientsrenditionclass' => { 445 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 445 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 445 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 445 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 75 => 0x51e },
	'initialafpointinservo' => { 2 => 0x13 },
	'initialcameradolly' => { 408 => 'InitialCameraDolly' },
	'initialhorizontalfovdegrees' => { 408 => 'InitialHorizontalFOVDegrees' },
	'initialviewheadingdegrees' => { 408 => 'InitialViewHeadingDegrees', 409 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 408 => 'InitialViewPitchDegrees', 409 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 408 => 'InitialViewRollDegrees', 409 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 245 => '4.4' },
	'initialzoomsetting' => { 245 => '9.3', 254 => '27.3' },
	'inkset' => { 109 => 0x14c },
	'inputprofile' => { 123 => 0x1389 },
	'instanceid' => { 445 => 'InstanceID' },
	'instantplaybacksetup' => { 166 => 0x3e },
	'instantplaybacktime' => { 166 => 0x3d },
	'instructions' => { 432 => 'Instructions' },
	'instrument' => { 444 => 'instrument' },
	'intellectualgenre' => { 429 => 'IntellectualGenre' },
	'intelligentauto' => { 371 => 0xb052 },
	'intelligentcontrast' => { 46 => 0x4 },
	'intelligentd-range' => { 282 => 0x79 },
	'intelligentexposure' => { 282 => 0x5d },
	'intelligentresolution' => { 282 => 0x70 },
	'interchangecolorspace' => { 119 => 0x40 },
	'internalflash' => { 163 => 0x2b, 245 => '23.1', 247 => '8.1', 250 => '22.1', 252 => '23.1', 256 => '8.1', 259 => '24.1', 264 => 0x1208 },
	'internalflashae1' => { 266 => 0x1021 },
	'internalflashae1_0' => { 266 => 0x101d },
	'internalflashae2' => { 266 => 0x1022 },
	'internalflashae2_0' => { 266 => 0x101e },
	'internalflashmode' => { 304 => 0x1 },
	'internalflashstrength' => { 304 => 0x3 },
	'internalflashtable' => { 266 => 0x1024 },
	'internallensserialnumber' => { 348 => 0xa005 },
	'internalndfilter' => { 282 => 0x9d },
	'internalserialnumber' => { 57 => 0x96, 68 => 0x9, 114 => 0x10, 169 => 0x49dc, 260 => 0x18, 262 => 0x102, 282 => 0x25, 296 => 0x4, 341 => 0x5, 388 => [0x7c,0xf0], 389 => 0x88 },
	'interopindex' => { 109 => 0x1, 425 => 'InteroperabilityIndex' },
	'interopversion' => { 109 => 0x2 },
	'intervallength' => { 163 => 0x10 },
	'intervalmode' => { 163 => 0x26 },
	'intervalnumber' => { 163 => 0x11 },
	'intervalshooting' => { 316 => 0x92 },
	'introtime' => { 444 => 'introTime' },
	'introtimescale' => { 444 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 444 => [\'introTime','introTimeValue'] },
	'iptc' => { 110 => 'IPTC' },
	'iptc-naa' => { 109 => 0x83bb, 286 => 0x83bb },
	'iptcbitspersample' => { 119 => 0x56 },
	'iptcdigest' => { 330 => 0x425 },
	'iptcimageheight' => { 119 => 0x1e },
	'iptcimagerotation' => { 119 => 0x66 },
	'iptcimagewidth' => { 119 => 0x14 },
	'iptclastedited' => { 430 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 119 => 0xa },
	'iptcpixelheight' => { 119 => 0x32 },
	'iptcpixelwidth' => { 119 => 0x28 },
	'isalternativeof' => { 434 => 'isAlternativeOf' },
	'isbn' => { 434 => 'isbn' },
	'iscorrectionof' => { 434 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 100 => 0x3 },
	'ismergedhdr' => { 416 => 'IsMergedHDR' },
	'ismergedpanorama' => { 416 => 'IsMergedPanorama' },
	'iso' => { 6 => 0x6, 8 => 0x6, 9 => 0x75, 10 => 0x6, 11 => 0x79, 12 => 0x6, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x6, 28 => 0x6, 29 => 0x0, 30 => 0x1, 103 => 0x14, 104 => [0x3014,0x14], 109 => 0x8827, 122 => 0xfd06, 123 => 0x1784, 125 => 0x60, 127 => [0xfa2e,0xfa46], 128 => [0x27,0x28], 129 => 0xf105, 132 => 0x14, 134 => 0x4e, 137 => 0x34, 139 => 'ISO', 163 => 0x8, 169 => 0x49ba, 194 => 0x0, 200 => 0x2, 286 => 0x17, 316 => [0x8b,0x14], 323 => 0x14, 325 => 0x105, 348 => 0xa014, 370 => 0x6f, 375 => [0x1f,0x21,0x25], 424 => 'ISOSpeedRatings' },
	'iso2' => { 194 => 0x6, 209 => 0x265, 210 => 0x25c, 211 => 0x265, 212 => 0x221, 213 => 0x25d, 214 => 0x256, 215 => 0x25d, 219 => 0x2b5, 222 => 0x265, 227 => 0x2b5 },
	'isoauto' => { 297 => '14.4' },
	'isoautohilimit' => { 217 => 0x18eb, 218 => 0xe82, 226 => 0x185d },
	'isoautoparameters' => { 316 => 0x7a },
	'isoautoshuttertime' => { 217 => 0x18ea, 218 => 0xe81, 226 => 0x185c },
	'isodisplay' => { 248 => '4.1', 249 => '4.1', 250 => '2.3', 251 => '3.3', 252 => '3.3', 255 => '3.3', 258 => '4.3', 259 => '4.3' },
	'isoexpansion' => { 75 => 0x103, 76 => 0x7, 77 => 0x8, 80 => 0x8, 194 => 0x4 },
	'isoexpansion2' => { 194 => 0xa },
	'isofloor' => { 297 => 0x6 },
	'isoselection' => { 200 => 0xf },
	'isosensitivitystep' => { 253 => '6.2', 255 => '6.2' },
	'isosetting' => { 125 => 0x5e, 139 => 'ISOSetting', 163 => 0x24, 164 => 0x26, 165 => 0x1c, 166 => 0x13, 171 => 0x6, 200 => 0x13, 297 => '17.3', 340 => 0x27, 359 => 0x16, 360 => 0x14, 361 => 0x2, 370 => 0x6d },
	'isospeed' => { 109 => 0x8833, 425 => 'ISOSpeed' },
	'isospeedexpansion' => { 74 => 0x3 },
	'isospeedincrements' => { 75 => 0x102 },
	'isospeedlatitudeyyy' => { 109 => 0x8834, 425 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 109 => 0x8835, 425 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 75 => 0x103 },
	'isostepsize' => { 245 => '6.1', 246 => '7.2', 248 => '7.2', 249 => '7.2', 254 => '4.1', 258 => '7.2' },
	'isovalue' => { 266 => 0x1001 },
	'issn' => { 434 => 'issn' },
	'issueidentifier' => { 434 => 'issueIdentifier' },
	'issuename' => { 434 => 'issueName' },
	'issueteaser' => { 434 => 'issueTeaser' },
	'issuetype' => { 434 => 'issueType' },
	'istranslationof' => { 434 => 'isTranslationOf' },
	'jobid' => { 117 => 0xb8 },
	'jobname' => { 426 => 'JobName' },
	'jobref' => { 443 => 'JobRef' },
	'jobrefid' => { 443 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 443 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 443 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 426 => 'JobStatus' },
	'jpeghandling' => { 420 => 'JPEGHandling' },
	'jpegquality' => { 9 => 0x66, 284 => 0x3034, 371 => 0xb047 },
	'jpegsize' => { 284 => 0x303a },
	'jpgcompression' => { 218 => 0x7d4 },
	'jpgfromraw' => { 88 => 0x2007, 105 => 'JpgFromRaw', 286 => 0x2e },
	'jpgfromrawlength' => { 109 => [0x117,0x202] },
	'jpgfromrawstart' => { 109 => [0x111,0x201] },
	'jpgrecordedpixels' => { 297 => '14.1' },
	'jurisdiction' => { 417 => 'jurisdiction' },
	'kelvinwb_01' => { 305 => 0x5 },
	'kelvinwb_02' => { 305 => 0x9 },
	'kelvinwb_03' => { 305 => 0xd },
	'kelvinwb_04' => { 305 => 0x11 },
	'kelvinwb_05' => { 305 => 0x15 },
	'kelvinwb_06' => { 305 => 0x19 },
	'kelvinwb_07' => { 305 => 0x1d },
	'kelvinwb_08' => { 305 => 0x21 },
	'kelvinwb_09' => { 305 => 0x25 },
	'kelvinwb_10' => { 305 => 0x29 },
	'kelvinwb_11' => { 305 => 0x2d },
	'kelvinwb_12' => { 305 => 0x31 },
	'kelvinwb_13' => { 305 => 0x35 },
	'kelvinwb_14' => { 305 => 0x39 },
	'kelvinwb_15' => { 305 => 0x3d },
	'kelvinwb_16' => { 305 => 0x41 },
	'kelvinwb_daylight' => { 305 => 0x1 },
	'key' => { 444 => 'key' },
	'keystonecompensation' => { 265 => 0x1900 },
	'keystonedirection' => { 265 => 0x1901 },
	'keystonevalue' => { 265 => 0x1906 },
	'keyword' => { 434 => 'keyword' },
	'keywordinfo' => { 154 => 'Keywords' },
	'keywords' => { 117 => 0x19, 140 => 'Keywords', 270 => 'Keywords', 332 => 'Keywords', 414 => 'keywords', 431 => 'Keywords', 442 => 'Keywords' },
	'killdate' => { 434 => 'killDate' },
	'killdatea-platform' => { 434 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 434 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 122 => 0xf908, 125 => 0xe, 127 => [0xfa1e,0xfa52], 133 => 0x70 },
	'kodakimagewidth' => { 122 => 0xf907, 125 => 0xc, 127 => [0xfa1d,0xfa51], 133 => 0x6c },
	'kodakinfotype' => { 122 => 0xfa00 },
	'kodaklook' => { 123 => 0xe4c },
	'kodaklookprofile' => { 123 => 0x138a },
	'kodakmaker' => { 133 => 0x8 },
	'kodakmodel' => { 125 => 0x0, 133 => 0x28 },
	'label' => { 274 => 'Label', 442 => 'Label' },
	'labelname1' => { 428 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 428 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 428 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 428 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 428 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 428 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 282 => 0x6f },
	'landscapeoutputhighlightpoint' => { 100 => 0x26 },
	'landscapeoutputshadowpoint' => { 100 => 0x27 },
	'landscaperawcolortone' => { 100 => 0x1f },
	'landscaperawcontrast' => { 100 => 0x21 },
	'landscaperawhighlight' => { 100 => 0x77 },
	'landscaperawhighlightpoint' => { 100 => 0x24 },
	'landscaperawlinear' => { 100 => 0x22 },
	'landscaperawsaturation' => { 100 => 0x20 },
	'landscaperawshadow' => { 100 => 0x80 },
	'landscaperawshadowpoint' => { 100 => 0x25 },
	'landscaperawsharpness' => { 100 => 0x23 },
	'landscapeunsharpmaskfineness' => { 100 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 100 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 100 => 0xa2 },
	'language' => { 421 => 'language' },
	'languageidentifier' => { 117 => 0x87 },
	'largestvalidinteriorrectheight' => { 408 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 408 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 408 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 408 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 163 => 0x1b },
	'lastkeywordiptc' => { 161 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 161 => 'LastKeywordXMP' },
	'lastphotodate' => { 408 => 'LastPhotoDate' },
	'lasturl' => { 445 => 'LastURL' },
	'lateralchromaticaberration' => { 371 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 416 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 108 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 108 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 108 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 108 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 108 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'lc1' => { 307 => 0x2 },
	'lc10' => { 307 => 0xb },
	'lc11' => { 307 => 0xc },
	'lc12' => { 307 => 0xd },
	'lc14' => { 307 => 0xf },
	'lc15' => { 307 => 0x10 },
	'lc3' => { 307 => 0x4 },
	'lc4' => { 307 => 0x5 },
	'lc5' => { 307 => 0x6 },
	'lc6' => { 307 => 0x7 },
	'lc7' => { 307 => 0x8 },
	'lc8' => { 307 => 0x9 },
	'lcddisplayatpoweron' => { 75 => 0x811, 79 => 0xa },
	'lcddisplayreturntoshoot' => { 80 => 0x12 },
	'lcdillumination' => { 245 => '17.5', 246 => '5.2', 248 => '5.1', 249 => '5.1', 254 => '10.3', 255 => '4.2', 258 => '5.2', 259 => '5.4' },
	'lcdilluminationduringbulb' => { 75 => 0x408 },
	'lcdpanels' => { 74 => 0x8 },
	'lcheditor' => { 238 => 0x8ae85e },
	'legacyiptcdigest' => { 432 => 'LegacyIPTCDigest' },
	'legalcode' => { 417 => 'legalcode' },
	'lens' => { 109 => 0xfdea, 200 => 0x84, 416 => 'Lens' },
	'lensafstopbutton' => { 73 => 0x11, 74 => 0x13, 75 => 0x506, 76 => 0x10, 77 => 0x12, 80 => 0x13, 81 => 0x9 },
	'lensaperturerange' => { 351 => [0x30,0x48] },
	'lenscorrectionsettings' => { 423 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 416 => 'LensDistortInfo' },
	'lensdistortionparams' => { 266 => 0x206 },
	'lensdrivenoaf' => { 75 => 0x505 },
	'lensdrivewhenafimpossible' => { 2 => 0xb },
	'lense-mountversion' => { 361 => 0x3f0, 401 => 0xd },
	'lensfirmware' => { 342 => 0x20, 348 => 0xa004 },
	'lensfirmwareversion' => { 262 => 0x204, 282 => 0x60, 361 => 0x3f4, 401 => 0x15 },
	'lensfocallength' => { 94 => 0xf0512, 307 => 0x9 },
	'lensfocalrange' => { 351 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 246 => '55.1', 248 => '52.1', 249 => '52.1', 258 => '52.1' },
	'lensformat' => { 382 => 0x1891, 384 => 0x18bd, 385 => 0x18ed, 386 => 0x17f1, 388 => 0x106, 389 => 0x106, 397 => 0x603, 398 => 0x5d },
	'lensfstops' => { 195 => 0x7, 196 => 0xc, 197 => 0xd, 200 => 0x8b, 307 => '0.3' },
	'lensid' => { 416 => 'LensID' },
	'lensidnumber' => { 195 => 0x6, 196 => 0xb, 197 => 0xc },
	'lensinfo' => { 109 => 0xa432, 313 => 0x2a, 416 => 'LensInfo', 425 => 'LensSpecification' },
	'lenskind' => { 307 => 0x1 },
	'lensmake' => { 109 => 0xa433, 146 => 'Make', 425 => 'LensMake' },
	'lensmanualdistortionamount' => { 420 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 161 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 351 => 0x2b },
	'lensmodel' => { 6 => 0x937, 13 => 0x92b, 14 => 0x933, 57 => 0x95, 109 => 0xa434, 146 => 'Model', 161 => 'LensModel', 198 => 0x18a, 262 => 0x203, 280 => 0x303, 313 => 0xc, 325 => 0x412, 425 => 'LensModel' },
	'lensmount' => { 361 => 0x99, 382 => 0x1892, 384 => 0x18be, 385 => 0x18ee, 386 => 0x17f2, 388 => 0x105, 389 => 0x105, 397 => 0x604, 398 => 0x5e },
	'lensmount2' => { 401 => 0x8 },
	'lensprofilechromaticaberrationscale' => { 420 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 420 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 420 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 420 => 'LensProfileEnable' },
	'lensprofilefilename' => { 420 => 'LensProfileFilename' },
	'lensprofilematchkeycameramodelname' => { 420 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 420 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 420 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 420 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 420 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 420 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 420 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 420 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 420 => 'LensProfileName' },
	'lensprofilesetup' => { 420 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 420 => 'LensProfileVignettingScale' },
	'lensproperties' => { 262 => 0x20b },
	'lensserialnumber' => { 20 => 0x164, 31 => 0x16b, 55 => 0x0, 109 => 0xa435, 146 => 'SerialNumber', 262 => 0x202, 282 => 0x52, 342 => 0x30, 416 => 'LensSerialNumber', 425 => 'LensSerialNumber' },
	'lensshutterlock' => { 166 => 0x4a },
	'lensspec' => { 356 => 0x0, 357 => 0x0, 358 => 0x0, 371 => 0xb02a },
	'lensspecfeatures' => { 388 => [0x115,0x116], 389 => [0x116,0x21c,0x21e] },
	'lenstemperature' => { 266 => 0x1008 },
	'lenstype' => { 6 => 0xe2, 7 => 0xd, 8 => 0x1a7, 9 => 0xc, 10 => 0x111, 11 => 0xc, 12 => 0x14f, 13 => 0xd6, 14 => 0xde, 15 => 0xf6, 16 => 0xea, 17 => 0xff, 18 => [0xc,0x97], 19 => 0xe6, 20 => 0x153, 21 => 0xea, 22 => 0xe8, 23 => 0x127, 24 => 0x161, 25 => 0x166, 26 => 0x184, 27 => 0x112, 28 => 0x189, 33 => 0x16, 168 => 0x10c, 169 => 0x49bd, 200 => 0x83, 262 => 0x201, 275 => 0x16, 278 => 0x310, 281 => 0x303, 282 => 0x51, 284 => 0x3405, 308 => 0x0, 309 => 0x0, 310 => 0x1, 311 => 0x1, 312 => 0x1, 314 => 0x0, 348 => 0xa003, 351 => 0x27, 371 => 0xb027, 382 => 0x1896, 384 => 0x18c2, 385 => 0x18f2, 386 => 0x17f6, 388 => 0x109, 389 => 0x109, 397 => 0x608, 398 => 0x62 },
	'lenstype2' => { 361 => 0x3f7, 382 => 0x1893, 384 => 0x18bf, 385 => 0x18ef, 386 => 0x17f3, 388 => 0x107, 389 => 0x107, 397 => 0x605, 398 => 0x60 },
	'lenstype3' => { 401 => 0x9 },
	'lenszoomposition' => { 395 => 0x19, 396 => 0x1e, 398 => [0x342,0x35a] },
	'levelindicator' => { 289 => 0x15 },
	'levelorientation' => { 315 => 0x0 },
	'license' => { 417 => 'license' },
	'licensee' => { 271 => 'Licensee' },
	'licenseeid' => { 271 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 271 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 271 => 'LicenseeImageNotes' },
	'licenseename' => { 271 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 271 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 271 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 271 => 'LicenseeTransactionID' },
	'licenseid' => { 271 => 'LicenseID' },
	'licensestartdate' => { 271 => 'LicenseStartDate' },
	'licensetransactiondate' => { 271 => 'LicenseTransactionDate' },
	'licensetype' => { 422 => 'licensetype' },
	'licensor' => { 271 => 'Licensor' },
	'licensorcity' => { 271 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 271 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 271 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 271 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 271 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 271 => 'LicensorImageID' },
	'licensorname' => { 271 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 271 => 'LicensorNotes' },
	'licensorpostalcode' => { 271 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 271 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 271 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 271 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 271 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 271 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 271 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 271 => 'LicensorTransactionID' },
	'licensorurl' => { 271 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 266 => 0x1009 },
	'lightingmode' => { 104 => 0x302a },
	'lightreading' => { 316 => 0x15 },
	'lightsource' => { 109 => 0x9208, 200 => 0x90, 269 => 0x1000, 424 => 'LightSource' },
	'lightsourcespecial' => { 350 => 0x21d },
	'lightswitch' => { 258 => '0.1', 259 => '0.1' },
	'lightvaluecenter' => { 266 => 0x103d },
	'lightvalueperiphery' => { 266 => 0x103e },
	'limitafareamodeselection' => { 246 => '51.1', 248 => '49.1', 249 => '49.1', 258 => '49.1' },
	'linearitylimitblue' => { 286 => 0x10 },
	'linearitylimitgreen' => { 286 => 0xf },
	'linearitylimitred' => { 286 => 0xe },
	'linearityuppermargin' => { 40 => [0x2ba,0x2d1,0x2d5], 42 => 0x1e5, 43 => [0x1fe,0x2de], 44 => [0x232,0x310] },
	'linearizationtable' => { 109 => 0xc618 },
	'linearresponselimit' => { 109 => 0xc62e },
	'link' => { 434 => 'link' },
	'linkaetoafpoint' => { 297 => '14.2' },
	'linkedencodedrightsexpr' => { 430 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 430 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 430 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 430 => 'LinkedEncRightsExpr' },
	'lithostratigraphicterms' => { 108 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'liveviewaf' => { 250 => '32.1', 259 => '34.1' },
	'liveviewafareamode' => { 255 => '34.1' },
	'liveviewafmethod' => { 375 => 0x20 },
	'liveviewafmode' => { 255 => '34.2' },
	'liveviewafsetting' => { 361 => 0x36 },
	'liveviewbuttonoptions' => { 246 => '50.2', 248 => '48.2', 249 => '48.2', 258 => '48.2' },
	'liveviewexposuresimulation' => { 75 => 0x810 },
	'liveviewfocusmode' => { 361 => [0x8b,0x28b] },
	'liveviewmetering' => { 361 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 246 => '21.2', 248 => '21.2', 249 => '21.2', 251 => '20.2', 252 => '20.2', 253 => '20.2', 255 => '20.2', 258 => '21.2' },
	'liveviewshooting' => { 51 => 0x13 },
	'localcaption' => { 117 => 0x79 },
	'localizedcameramodel' => { 109 => 0xc615 },
	'locallocationname' => { 348 => 0x30 },
	'location' => { 199 => 0x9, 282 => 0x67, 412 => 'Location', 429 => 'Location', 433 => 'location', 434 => 'location' },
	'locationareacode' => { 418 => 'lac' },
	'locationcreated' => { 430 => 'LocationCreated' },
	'locationcreatedcity' => { 430 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 430 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 430 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedgpsaltitude' => { 430 => [\'LocationCreated','LocationCreatedGPSAltitude'] },
	'locationcreatedgpslatitude' => { 430 => [\'LocationCreated','LocationCreatedGPSLatitude'] },
	'locationcreatedgpslongitude' => { 430 => [\'LocationCreated','LocationCreatedGPSLongitude'] },
	'locationcreatedidentifier' => { 430 => [\'LocationCreated','LocationCreatedIdentifier'] },
	'locationcreatedlocationid' => { 430 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedlocationname' => { 430 => [\'LocationCreated','LocationCreatedLocationName'] },
	'locationcreatedprovincestate' => { 430 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 430 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 430 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationinfoversion' => { 199 => 0x0 },
	'locationname' => { 348 => 0x31 },
	'locationshown' => { 430 => 'LocationShown' },
	'locationshowncity' => { 430 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 430 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 430 => [\'LocationShown','LocationShownCountryName'] },
	'locationshowngpsaltitude' => { 430 => [\'LocationShown','LocationShownGPSAltitude'] },
	'locationshowngpslatitude' => { 430 => [\'LocationShown','LocationShownGPSLatitude'] },
	'locationshowngpslongitude' => { 430 => [\'LocationShown','LocationShownGPSLongitude'] },
	'locationshownidentifier' => { 430 => [\'LocationShown','LocationShownIdentifier'] },
	'locationshownlocationid' => { 430 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownlocationname' => { 430 => [\'LocationShown','LocationShownLocationName'] },
	'locationshownprovincestate' => { 430 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 430 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 430 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 75 => 0x709 },
	'logcomment' => { 444 => 'logComment' },
	'longexposurenoisereduction' => { 56 => 0x4, 75 => 0x201, 76 => 0x1, 77 => 0x2, 78 => 0x1, 79 => 0x1, 80 => 0x2, 81 => 0x1, 282 => 0x49, 359 => 0x2b, 360 => 0x25, 361 => 0x25, 371 => 0x2008, 375 => 0x11, 398 => 0x44 },
	'longexposurenoisereduction2' => { 51 => 0x8 },
	'loop' => { 444 => 'loop' },
	'lowestbiostratigraphiczone' => { 108 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 420 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 420 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 420 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 420 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 420 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 420 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 420 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 420 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 99 => 0x150 },
	'luminancecurvepoints' => { 99 => 0x126 },
	'luminancenoisereduction' => { 94 => 0x20600, 100 => 0x5f, 351 => 0x1b },
	'luminancenoisereductioncontrast' => { 420 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 420 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 100 => 0x6d },
	'luminancesmoothing' => { 420 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 75 => [0x40b,0x40c] },
	'lyrics' => { 444 => 'lyrics' },
	'm16cversion' => { 278 => 0x333 },
	'macatom' => { 419 => 'macAtom' },
	'macatomapplicationcode' => { 419 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 419 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 419 => [\'macAtom','macAtomPosixProjectPath'] },
	'macro' => { 114 => 0x1020, 115 => 0x202, 266 => 0x202, 340 => 0x21, 350 => 0x202, 371 => 0xb040 },
	'macroled' => { 264 => 0x120a },
	'macromagnification' => { 6 => 0x1b, 10 => 0x1b, 13 => 0x1b, 14 => 0x1b, 18 => 0x1b, 19 => 0x1b, 51 => 0x10 },
	'macromode' => { 33 => 0x1, 163 => 0xb, 261 => 0x300, 282 => 0x1c, 341 => 0x1009 },
	'magentahsl' => { 94 => 0x20917 },
	'magicfilter' => { 261 => 0x52c },
	'magnifiedview' => { 77 => 0x11, 79 => 0x9 },
	'maindialexposurecomp' => { 256 => '0.6' },
	'mainingredient' => { 436 => 'mainIngredient' },
	'make' => { 89 => 0x0, 106 => 0x1, 109 => 0x10f, 139 => 'Make', 274 => 'Make', 286 => 0x10f, 433 => 'make', 440 => 'Make' },
	'makernote' => { 424 => 'MakerNote' },
	'makernoteapple' => { 107 => 'MakN', 109 => 0x927c },
	'makernotecanon' => { 107 => 'MakN', 109 => 0x927c },
	'makernotecasio' => { 107 => 'MakN', 109 => 0x927c },
	'makernotecasio2' => { 107 => 'MakN', 109 => 0x927c },
	'makernotedji' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteflir' => { 107 => 'MakN', 109 => 0x927c },
	'makernotefujifilm' => { 107 => 'MakN', 109 => 0x927c },
	'makernotege' => { 107 => 'MakN', 109 => 0x927c },
	'makernotege2' => { 107 => 'MakN', 109 => 0x927c },
	'makernotehasselblad' => { 107 => 'MakN', 109 => 0x927c },
	'makernotehp' => { 107 => 'MakN', 109 => 0x927c },
	'makernotehp2' => { 107 => 'MakN', 109 => 0x927c },
	'makernotehp4' => { 107 => 'MakN', 109 => 0x927c },
	'makernotehp6' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteisl' => { 107 => 'MakN', 109 => 0x927c },
	'makernotejvc' => { 107 => 'MakN', 109 => 0x927c },
	'makernotejvctext' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak10' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak11' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak1a' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak1b' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak2' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak3' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak4' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak5' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak6a' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak6b' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak7' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak8a' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak8b' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak8c' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak9' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodakunknown' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekyocera' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteleica' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteleica2' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteleica3' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteleica4' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteleica5' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteleica6' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteleica7' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteleica8' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteleica9' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteminolta' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteminolta2' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteminolta3' => { 107 => 'MakN', 109 => 0x927c },
	'makernotemotorola' => { 107 => 'MakN', 109 => 0x927c },
	'makernotenikon' => { 107 => 'MakN', 109 => 0x927c },
	'makernotenikon2' => { 107 => 'MakN', 109 => 0x927c },
	'makernotenikon3' => { 107 => 'MakN', 109 => 0x927c },
	'makernotenintendo' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteoffset' => { 350 => 0xff },
	'makernoteolympus' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteolympus2' => { 107 => 'MakN', 109 => 0x927c },
	'makernotepanasonic' => { 107 => 'MakN', 109 => 0x927c },
	'makernotepanasonic2' => { 107 => 'MakN', 109 => 0x927c },
	'makernotepentax' => { 107 => 'MakN', 109 => 0x927c },
	'makernotepentax2' => { 107 => 'MakN', 109 => 0x927c },
	'makernotepentax3' => { 107 => 'MakN', 109 => 0x927c },
	'makernotepentax4' => { 107 => 'MakN', 109 => 0x927c },
	'makernotepentax5' => { 107 => 'MakN', 109 => 0x927c },
	'makernotepentax6' => { 107 => 'MakN', 109 => 0x927c },
	'makernotephaseone' => { 107 => 'MakN', 109 => 0x927c },
	'makernotereconyx' => { 107 => 'MakN', 109 => 0x927c },
	'makernotericoh' => { 107 => 'MakN', 109 => 0x927c },
	'makernotericoh2' => { 107 => 'MakN', 109 => 0x927c },
	'makernotericohtext' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesafety' => { 109 => 0xc635 },
	'makernotesamsung1a' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesamsung1b' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesamsung2' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesanyo' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesanyoc4' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesanyopatch' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesigma' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesony' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesony2' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesony3' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesony4' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesony5' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesonyericsson' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesonysrf' => { 107 => 'MakN', 109 => 0x927c },
	'makernotetype' => { 341 => 0x1 },
	'makernoteunknown' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteunknownbinary' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteunknowntext' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteversion' => { 168 => 0x0, 200 => 0x1, 266 => 0x0, 282 => 0x8000, 345 => 0x0, 348 => 0x1, 351 => [0x1d,0x1f], 362 => 0x2000 },
	'managedfrom' => { 445 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 445 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 445 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 445 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 445 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 445 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 445 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfromlasturl' => { 445 => [\'ManagedFrom','ManagedFromLastURL'] },
	'managedfromlinkcategory' => { 445 => [\'ManagedFrom','ManagedFromLinkCategory'] },
	'managedfromlinkform' => { 445 => [\'ManagedFrom','ManagedFromLinkForm'] },
	'managedfrommanager' => { 445 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 445 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 445 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 445 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 445 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 445 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 445 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromplacedresolutionunit' => { 445 => [\'ManagedFrom','ManagedFromPlacedResolutionUnit'] },
	'managedfromplacedxresolution' => { 445 => [\'ManagedFrom','ManagedFromPlacedXResolution'] },
	'managedfromplacedyresolution' => { 445 => [\'ManagedFrom','ManagedFromPlacedYResolution'] },
	'managedfromrenditionclass' => { 445 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 445 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 445 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 445 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 445 => 'Manager' },
	'managervariant' => { 445 => 'ManagerVariant' },
	'manageto' => { 445 => 'ManageTo' },
	'manageui' => { 445 => 'ManageUI' },
	'manifest' => { 445 => 'Manifest' },
	'manifestlinkform' => { 445 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 445 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 445 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 445 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 445 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 445 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 445 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 445 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 445 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 445 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 445 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencelasturl' => { 445 => [\'Manifest','ManifestReferenceLastURL'] },
	'manifestreferencelinkcategory' => { 445 => [\'Manifest','ManifestReferenceLinkCategory'] },
	'manifestreferencelinkform' => { 445 => [\'Manifest','ManifestReferenceLinkForm'] },
	'manifestreferencemanager' => { 445 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 445 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 445 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 445 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 445 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 445 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 445 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferenceplacedresolutionunit' => { 445 => [\'Manifest','ManifestReferencePlacedResolutionUnit'] },
	'manifestreferenceplacedxresolution' => { 445 => [\'Manifest','ManifestReferencePlacedXResolution'] },
	'manifestreferenceplacedyresolution' => { 445 => [\'Manifest','ManifestReferencePlacedYResolution'] },
	'manifestreferencerenditionclass' => { 445 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 445 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 445 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 445 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 261 => 0x900, 282 => 0x86 },
	'manometerreading' => { 261 => 0x901 },
	'manualafpointselectpattern' => { 75 => 0x513 },
	'manualafpointselpattern' => { 2 => 0xf },
	'manualflash' => { 264 => 0x1209 },
	'manualflashoutput' => { 33 => 0x29, 247 => '8.2', 250 => '22.2', 251 => '23.1', 252 => '23.2', 254 => '16.2', 255 => '23.2', 256 => '8.2', 257 => '23.2', 259 => '24.2', 341 => 0x100c },
	'manualflashstrength' => { 261 => 0x406 },
	'manualfocusdistance' => { 200 => 0x85, 266 => 0x100c, 350 => 0x223 },
	'manualtv' => { 74 => 0x5, 75 => 0x705 },
	'manufacturedate' => { 173 => 0x6705, 296 => 0x1 },
	'manufacturedate1' => { 343 => 0x4 },
	'manufacturedate2' => { 343 => 0x5 },
	'manufacturer' => { 433 => 'manufacturer' },
	'marked' => { 431 => 'Marked', 448 => 'Marked' },
	'markers' => { 444 => 'markers' },
	'markerscomment' => { 444 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 444 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 444 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 444 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 444 => [\'markers','markersCuePointType'] },
	'markersduration' => { 444 => [\'markers','markersDuration'] },
	'markerslocation' => { 444 => [\'markers','markersLocation'] },
	'markersname' => { 444 => [\'markers','markersName'] },
	'markersprobability' => { 444 => [\'markers','markersProbability'] },
	'markersspeaker' => { 444 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 444 => [\'markers','markersStartTime'] },
	'markerstarget' => { 444 => [\'markers','markersTarget'] },
	'markerstype' => { 444 => [\'markers','markersType'] },
	'maskedareas' => { 109 => 0xc68e },
	'masterdocumentid' => { 117 => 0xb9 },
	'mastergain' => { 207 => 0x50 },
	'matrixmetering' => { 246 => '50.1', 248 => '48.1', 249 => '48.1', 258 => '48.1' },
	'maxaperture' => { 33 => 0x1a, 129 => 0x6103, 146 => 'MaxAperture', 163 => 0x17, 169 => 0x49c5, 262 => 0x20a, 307 => '14.1', 388 => 0x0, 389 => 0x0 },
	'maxapertureatmaxfocal' => { 114 => 0x1407, 146 => 'MaxApertureAtMaxFocal', 195 => 0xb, 196 => 0x10, 197 => 0x11, 262 => 0x206 },
	'maxapertureatminfocal' => { 114 => 0x1406, 195 => 0xa, 196 => 0xf, 197 => 0x10, 262 => 0x205 },
	'maxaperturevalue' => { 109 => 0x9205, 325 => 0x414, 424 => 'MaxApertureValue' },
	'maxavailheight' => { 430 => 'MaxAvailHeight' },
	'maxavailwidth' => { 430 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 245 => 0xb, 246 => 0xc, 248 => '12.1', 249 => '12.1', 254 => 0xc, 255 => 0xb, 258 => '12.1' },
	'maxfaces' => { 265 => 0x1202 },
	'maxfocallength' => { 6 => 0xe6, 7 => 0x10, 8 => 0x1ab, 9 => 0x13, 10 => 0x115, 11 => 0x13, 12 => 0x153, 13 => 0xda, 15 => 0xfa, 16 => 0xee, 17 => 0x103, 18 => 0x95, 19 => 0xea, 20 => 0x157, 21 => 0xee, 22 => 0xec, 23 => 0x12b, 24 => 0x165, 25 => 0x16a, 26 => 0x188, 27 => 0x116, 28 => 0x18d, 33 => 0x17, 114 => 0x1405, 146 => 'MaxFocalLength', 195 => 0x9, 196 => 0xe, 197 => 0xf, 262 => 0x208, 382 => 0x127c, 383 => 0x1138, 384 => 0x330, 385 => 0x330, 386 => 0x30e },
	'maximumdensityrange' => { 119 => 0x8c },
	'maxpagesize' => { 449 => 'MaxPageSize' },
	'maxpagesizeh' => { 449 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 449 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 449 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxsamplevalue' => { 109 => 0x119 },
	'maxstorage' => { 439 => 'maxstorage' },
	'mb-d10batteries' => { 245 => '12.6' },
	'mb-d10batterytype' => { 254 => '13.3' },
	'mb-d11batterytype' => { 255 => '2.3' },
	'mb-d12batterytype' => { 258 => '3.2' },
	'mb-d80batteries' => { 256 => '6.5' },
	'mb-d80batterytype' => { 259 => '3.2' },
	'mcuversion' => { 195 => 0xc, 196 => 0x11, 197 => 0x12 },
	'md5digest' => { 147 => 'zmd5' },
	'mditemfindercomment' => { 156 => 'MDItemFinderComment' },
	'mditemfscreationdate' => { 156 => 'MDItemFSCreationDate' },
	'mditemfslabel' => { 156 => 'MDItemFSLabel' },
	'meal' => { 436 => 'meal' },
	'measuredev' => { 27 => 0x9, 69 => 0x3, 88 => 0x1814, 139 => 'MeasuredEV' },
	'measuredev2' => { 12 => 0x8, 27 => 0x8, 69 => 0x17 },
	'measuredev3' => { 12 => 0x9 },
	'measuredlv' => { 169 => 0x690, 278 => 0x312, 284 => 0x3407 },
	'measuredrggb' => { 58 => 0x1 },
	'measuredrggbdata' => { 39 => 0x287 },
	'measurementaccuracy' => { 108 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 108 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 108 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 108 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 108 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 108 => 'MeasurementOrFact' },
	'measurementremarks' => { 108 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 108 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 108 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 108 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'mediaconstraints' => { 271 => 'MediaConstraints' },
	'mediacreatedate' => { 333 => 0x1 },
	'mediaeventiddate' => { 410 => 'MediaEventIdDate' },
	'mediamodifydate' => { 333 => 0x2 },
	'mediasummarycode' => { 271 => 'MediaSummaryCode' },
	'memoaudioquality' => { 75 => 0x812 },
	'memorycardconfiguration' => { 365 => 0x16 },
	'memorycardnumber' => { 187 => 0x2 },
	'menubuttondisplayposition' => { 73 => 0xb, 76 => 0xa, 77 => 0xb, 80 => 0xb },
	'menubuttonreturn' => { 81 => 0xb },
	'menumonitorofftime' => { 245 => '26.1', 246 => '22.1', 248 => '22.1', 249 => '22.1', 253 => '21.1', 254 => '8.2', 255 => '21.1', 258 => '22.1', 259 => '22.1' },
	'metadatadate' => { 442 => 'MetadataDate' },
	'metadatamoddate' => { 444 => 'metadataModDate' },
	'metaversion' => { 377 => 0x34 },
	'meterinfo1row1' => { 372 => 0x0 },
	'meterinfo1row2' => { 372 => 0x6c },
	'meterinfo1row3' => { 372 => 0xd8 },
	'meterinfo1row4' => { 372 => 0x144 },
	'meterinfo1row5' => { 372 => 0x1b0 },
	'meterinfo1row6' => { 372 => 0x21c },
	'meterinfo1row7' => { 372 => 0x288 },
	'meterinfo2row1' => { 372 => 0x2f4 },
	'meterinfo2row2' => { 372 => 0x378 },
	'meterinfo2row3' => { 372 => 0x3fc },
	'meterinfo2row4' => { 372 => 0x480 },
	'meterinfo2row5' => { 372 => 0x504 },
	'meterinfo2row6' => { 372 => 0x588 },
	'meterinfo2row7' => { 372 => 0x60c },
	'meterinfo2row8' => { 372 => 0x690 },
	'meterinfo2row9' => { 372 => 0x714 },
	'metering' => { 247 => '6.1' },
	'meteringmode' => { 33 => 0x11, 109 => 0x9207, 125 => 0x1c, 163 => 0x7, 164 => 0x25, 166 => 0x12, 261 => 0x202, 316 => 0x17, 351 => 0x9, 359 => 0x15, 360 => 0x13, 361 => 0x7, 375 => 0x3, 378 => 0x1174, 379 => 0x1178, 380 => 0x1154, 381 => 0x11d0, 382 => 0x11ac, 383 => 0x1064, 384 => 0x25c, 385 => 0x25c, 386 => 0x24b, 424 => 'MeteringMode' },
	'meteringmode2' => { 297 => '2.1', 371 => 0x202c },
	'meteringmode3' => { 297 => '16.1' },
	'meteringoffscaleindicator' => { 166 => 0x53 },
	'meteringtime' => { 245 => '22.2', 247 => '3.2', 250 => '17.1', 251 => '18.1', 254 => '7.3', 255 => '18.1', 256 => '3.2', 259 => '19.1' },
	'mieversion' => { 147 => '0Vers' },
	'minaperture' => { 33 => 0x1b, 146 => 'MinAperture', 307 => '0.2', 388 => 0x1, 389 => 0x1 },
	'minaperturevalue' => { 325 => 0x415 },
	'minfocallength' => { 6 => 0xe4, 7 => 0xe, 8 => 0x1a9, 9 => 0x11, 10 => 0x113, 11 => 0x11, 12 => 0x151, 13 => 0xd8, 15 => 0xf8, 16 => 0xec, 17 => 0x101, 18 => 0x93, 19 => 0xe8, 20 => 0x155, 21 => 0xec, 22 => 0xea, 23 => 0x129, 24 => 0x163, 25 => 0x168, 26 => 0x186, 27 => 0x114, 28 => 0x18b, 33 => 0x18, 114 => 0x1404, 146 => 'MinFocalLength', 195 => 0x8, 196 => 0xd, 197 => 0xe, 262 => 0x207, 382 => 0x127a, 383 => 0x1136, 384 => 0x32e, 385 => 0x32e, 386 => 0x30c },
	'minfocusdistance' => { 307 => 0x3 },
	'minoltadate' => { 163 => 0x15 },
	'minoltaimagesize' => { 163 => 0x4, 164 => 0xc, 165 => 0x2, 168 => 0x103 },
	'minoltamodelid' => { 163 => 0x25 },
	'minoltaquality' => { 163 => 0x5, 164 => 0xd, 165 => 0x3, 168 => [0x102,0x103] },
	'minoltatime' => { 163 => 0x16 },
	'minormodelagedisclosure' => { 271 => 'MinorModelAgeDisclosure' },
	'minsamplevalue' => { 109 => 0x118 },
	'mirrorlockup' => { 73 => 0xc, 74 => 0xc, 75 => 0x60f, 76 => 0xb, 77 => 0xc, 78 => 0x6, 79 => 0x6, 80 => 0xc, 81 => 0x3 },
	'mobilecountrycode' => { 418 => 'mcc' },
	'mobilenetworkcode' => { 418 => 'mnc' },
	'moddate' => { 274 => 'modify-date', 431 => 'ModDate' },
	'modedialposition' => { 365 => 0x14 },
	'model' => { 89 => 0x6, 109 => 0x110, 139 => 'Model', 274 => 'Model', 286 => 0x110, 316 => 0x23f, 351 => 0x84, 433 => 'model', 440 => 'Model' },
	'modelage' => { 430 => 'ModelAge' },
	'modelid' => { 260 => 0x0 },
	'modelingflash' => { 245 => '21.4', 246 => '31.1', 248 => '31.1', 249 => '31.1', 254 => '26.4', 255 => '30.2', 256 => '7.4', 257 => '30.1', 258 => '31.1', 259 => '31.3' },
	'modelreleaseid' => { 271 => 'ModelReleaseID' },
	'modelreleasestatus' => { 271 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 390 => 0x52, 391 => 0x46, 392 => 0x53 },
	'modelyear' => { 433 => 'modelYear' },
	'modificationdate' => { 434 => 'modificationDate' },
	'modifiedcolortemp' => { 59 => 0x9 },
	'modifieddigitalgain' => { 59 => 0xb },
	'modifiedparamflag' => { 52 => 0x1 },
	'modifiedpicturestyle' => { 59 => 0xa },
	'modifiedsaturation' => { 261 => 0x504 },
	'modifiedsensorbluelevel' => { 59 => 0x5 },
	'modifiedsensorredlevel' => { 59 => 0x4 },
	'modifiedsharpness' => { 59 => 0x2 },
	'modifiedsharpnessfreq' => { 59 => 0x3 },
	'modifiedtonecurve' => { 59 => 0x1 },
	'modifiedwhitebalance' => { 59 => 0x8 },
	'modifiedwhitebalanceblue' => { 59 => 0x7 },
	'modifiedwhitebalancered' => { 59 => 0x6 },
	'modifydate' => { 109 => 0x132, 140 => 'ModifyDate', 270 => 'ModDate', 272 => 'tIME', 332 => 'ModDate', 334 => 0x2, 442 => 'ModifyDate' },
	'moirefilter' => { 109 => 0xfe58, 420 => 'MoireFilter' },
	'monitordisplayoff' => { 166 => 0x4c },
	'monitorofftime' => { 245 => '18.2', 247 => '3.1', 256 => '3.1' },
	'monochromecolor' => { 261 => 0x53b },
	'monochromecontrast' => { 100 => 0x3c },
	'monochromefiltereffect' => { 94 => 0x20307, 100 => 0x3a, 316 => 0x73 },
	'monochromelinear' => { 100 => 0x3d },
	'monochromeoutputhighlightpoint' => { 100 => 0x41 },
	'monochromeoutputshadowpoint' => { 100 => 0x42 },
	'monochromeprofilesettings' => { 261 => 0x537 },
	'monochromerawhighlight' => { 100 => 0x7a },
	'monochromerawhighlightpoint' => { 100 => 0x3f },
	'monochromerawshadow' => { 100 => 0x83 },
	'monochromerawshadowpoint' => { 100 => 0x40 },
	'monochromesharpness' => { 100 => 0x3e },
	'monochrometoning' => { 316 => 0x74 },
	'monochrometoningeffect' => { 94 => 0x20306, 100 => 0x3b },
	'monochromeunsharpmaskfineness' => { 100 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 100 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 100 => 0xb4 },
	'monochromevignetting' => { 261 => 0x53a },
	'monthdaycreated' => { 125 => 0x12, 134 => 0xe },
	'moonphase' => { 337 => 0x12 },
	'morepermissions' => { 417 => 'morePermissions' },
	'motionsensitivity' => { 337 => 0x29 },
	'movieaelockbuttonassignment' => { 258 => '40.1' },
	'moviefunc1button' => { 248 => '41.1', 249 => '41.1' },
	'moviefunctionbutton' => { 246 => '41.1', 258 => '41.1' },
	'moviefunctionbuttonplusdials' => { 246 => '52.1' },
	'moviepreviewbutton' => { 246 => '41.2', 248 => '41.2', 249 => '41.2', 258 => '41.2' },
	'moviepreviewbuttonplusdials' => { 246 => '52.2' },
	'movieshutterbutton' => { 246 => '38.3', 248 => '38.3', 249 => '38.3', 258 => '38.3' },
	'moviesubselectorassignment' => { 246 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 246 => '53.1' },
	'multiburstimageheight' => { 371 => 0x1002 },
	'multiburstimagewidth' => { 371 => 0x1001 },
	'multiburstmode' => { 371 => 0x1000 },
	'multicontrollerwhilemetering' => { 75 => 0x517 },
	'multiexposure' => { 61 => 0x1 },
	'multiexposureautogain' => { 201 => 0x3 },
	'multiexposurecontrol' => { 61 => 0x2 },
	'multiexposuremode' => { 201 => 0x1 },
	'multiexposureshots' => { 61 => 0x3, 201 => 0x2 },
	'multiframenoisereduction' => { 361 => 0x35, 371 => 0x200b, 375 => 0x15 },
	'multifunctionlock' => { 75 => 0x70f },
	'multipleexposuremode' => { 265 => 0x101c },
	'multipleexposureset' => { 297 => '10.1' },
	'multisample' => { 207 => 0x40 },
	'multiselector' => { 245 => '9.4', 246 => '10.3', 248 => '10.3', 249 => '10.3', 254 => '27.4', 258 => '10.3' },
	'multiselectorliveview' => { 245 => '4.3', 248 => '37.1', 249 => '37.1', 258 => '37.1' },
	'multiselectorliveviewmode' => { 217 => 0x18c2 },
	'multiselectorplaybackmode' => { 245 => ['13.5','9.2'], 246 => '10.2', 249 => '10.2', 254 => '27.2', 258 => '10.2' },
	'multiselectorshootmode' => { 245 => '9.1', 246 => '10.1', 248 => '10.1', 249 => '10.1', 254 => '27.1', 258 => '10.1' },
	'mycolormode' => { 62 => 0x2 },
	'nationalcatalognumber' => { 434 => 'nationalCatalogNumber' },
	'nativedigest' => { 424 => 'NativeDigest', 440 => 'NativeDigest' },
	'ncdfileinfo' => { 123 => 0x414 },
	'ndfilter' => { 69 => 0x1c, 261 => 0x204, 341 => 0x1019 },
	'nefbitdepth' => { 200 => 0xe22 },
	'nefcompression' => { 200 => 0x93 },
	'neflinearizationtable' => { 200 => 0x96 },
	'negativecachelargepreviewsize' => { 420 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 420 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 420 => 'NegativeCachePath' },
	'neutraldensityfilter' => { 316 => 0x88 },
	'neutraloutputhighlightpoint' => { 100 => 0x2f },
	'neutraloutputshadowpoint' => { 100 => 0x30 },
	'neutralrawcolortone' => { 100 => 0x28 },
	'neutralrawcontrast' => { 100 => 0x2a },
	'neutralrawhighlight' => { 100 => 0x78 },
	'neutralrawhighlightpoint' => { 100 => 0x2d },
	'neutralrawlinear' => { 100 => 0x2b },
	'neutralrawsaturation' => { 100 => 0x29 },
	'neutralrawshadow' => { 100 => 0x81 },
	'neutralrawshadowpoint' => { 100 => 0x2e },
	'neutralrawsharpness' => { 100 => 0x2c },
	'neutralunsharpmaskfineness' => { 100 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 100 => 0xa8 },
	'neutraunsharpmaskstrength' => { 100 => 0xa4 },
	'newrawimagedigest' => { 109 => 0xc7a7 },
	'newsphotoversion' => { 119 => 0x0 },
	'nickname' => { 442 => 'Nickname' },
	'nikoncapturedata' => { 200 => 0xe01 },
	'nikoncaptureeditversions' => { 200 => 0xe13 },
	'nikoncaptureoutput' => { 200 => 0xe1e },
	'nikoncaptureversion' => { 200 => 0xe09 },
	'nikoniccprofile' => { 200 => 0xe1d },
	'nikonimagesize' => { 214 => '723.1', 215 => '732.1', 224 => 0x2c4 },
	'noisefilter' => { 261 => 0x527 },
	'noiseprofile' => { 109 => 0xc761 },
	'noisereduction' => { 114 => 0x100b, 164 => 0xb0, 165 => 0x60, 166 => 0x3f, 200 => 0x95, 238 => 0x753dcbc0, 239 => 0x17, 261 => 0x50a, 266 => 0x103a, 282 => 0x2d, 316 => 0x49, 341 => 0x100f, 343 => 0x2a },
	'noisereduction2' => { 265 => 0x1010 },
	'noisereductionapplied' => { 109 => 0xc6f7 },
	'noisereductionintensity' => { 239 => 0x9 },
	'noisereductionmethod' => { 239 => 0x11 },
	'noisereductionmode' => { 402 => 0x801e },
	'noisereductionsharpness' => { 239 => 0xd },
	'noisereductionvalue' => { 402 => 0x8027 },
	'nomemorycard' => { 245 => '22.1', 246 => '4.2', 247 => '0.3', 250 => '2.4', 251 => '3.2', 252 => '3.2', 254 => '33.7', 255 => '3.2', 256 => '0.3', 258 => '4.2', 259 => '4.5' },
	'nominalmaxaperture' => { 307 => 0xa },
	'nominalminaperture' => { 307 => '10.1' },
	'normalwhitelevel' => { 40 => [0x2b8,0x2cf,0x2d3], 42 => 0x1e3, 43 => [0x1fc,0x2dc], 44 => [0x230,0x30e] },
	'notes' => { 403 => 'Notes', 414 => 'notes' },
	'npages' => { 449 => 'NPages' },
	'nrwdata' => { 200 => 0x14 },
	'nullrecord' => { 88 => 0x0 },
	'numafpoints' => { 293 => 0x2 },
	'number' => { 434 => 'number' },
	'numberofbeats' => { 444 => 'numberOfBeats' },
	'numberoffocuspoints' => { 248 => '1.2', 249 => '1.2', 252 => '0.2', 253 => '0.3', 255 => '0.3' },
	'numfacepositions' => { 276 => 0x0 },
	'numindexentries' => { 119 => 0x54 },
	'numwbentries' => { 287 => 0x0, 288 => 0x0 },
	'object' => { 434 => 'object' },
	'objectattributereference' => { 117 => 0x4 },
	'objectcycle' => { 117 => 0x4b, 414 => 'ObjectCycle' },
	'objectdescription' => { 433 => 'objectDescription' },
	'objectdistance' => { 103 => 0x6, 104 => 0x2022 },
	'objectname' => { 117 => 0x5 },
	'objectpreviewdata' => { 117 => 0xca },
	'objectpreviewfileformat' => { 117 => 0xc8 },
	'objectpreviewfileversion' => { 117 => 0xc9 },
	'objectsubtype' => { 433 => 'objectSubtype' },
	'objecttype' => { 433 => 'objectType' },
	'objecttypereference' => { 117 => 0x3 },
	'occurrence' => { 108 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 108 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 108 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 108 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 108 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 108 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 108 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 108 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedetails' => { 108 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 108 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 108 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrenceid' => { 108 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 108 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 108 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 108 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceothercatalognumbers' => { 108 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepreparations' => { 108 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 108 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 108 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordnumber' => { 108 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 108 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 108 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 108 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 108 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 424 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 424 => [\'OECF','OECFNames'] },
	'oecfrows' => { 424 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 424 => [\'OECF','OECFValues'] },
	'offsaledate' => { 434 => 'offSaleDate' },
	'offsaledatea-platform' => { 434 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 434 => [\'offSaleDate','offSaleDateDate'] },
	'offsetschema' => { 109 => 0xea1d },
	'offsettime' => { 109 => 0x9010 },
	'offsettimedigitized' => { 109 => 0x9012 },
	'offsettimeoriginal' => { 109 => 0x9011 },
	'okbutton' => { 255 => '15.1', 259 => '16.1' },
	'oldsubfiletype' => { 109 => 0xff },
	'olympusimageheight' => { 266 => 0x102f },
	'olympusimagewidth' => { 266 => 0x102e },
	'oneshotafrelease' => { 2 => 0x9 },
	'onetouchwb' => { 266 => 0x302 },
	'onsaledate' => { 434 => 'onSaleDate' },
	'onsaledatea-platform' => { 434 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 434 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 434 => 'onSaleDay' },
	'onsaledaya-platform' => { 434 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 434 => [\'onSaleDay','onSaleDayDay'] },
	'opcodelist1' => { 109 => 0xc740 },
	'opcodelist2' => { 109 => 0xc741 },
	'opcodelist3' => { 109 => 0xc74e },
	'opticalzoom' => { 127 => 0xfa3d, 129 => [0x6006,0xf006], 130 => 0x1000, 131 => 0xf, 134 => 0x1e, 146 => 'OpticalZoom' },
	'opticalzoomcode' => { 69 => 0xa },
	'opticalzoommode' => { 282 => 0x34 },
	'opticalzoomon' => { 350 => 0x219 },
	'optionenddate' => { 437 => 'optionEndDate' },
	'opto-electricconvfactor' => { 424 => 'OECF' },
	'orangehsl' => { 94 => 0x20911 },
	'ordernumber' => { 114 => 0x8002 },
	'organisationinimagecode' => { 430 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 430 => 'OrganisationInImageName' },
	'organization' => { 434 => 'organization' },
	'orientation' => { 109 => 0x112, 286 => 0x112, 433 => 'orientation', 440 => 'Orientation' },
	'orientation2' => { 375 => [0x28,0x2e] },
	'orientationlinkedaf' => { 2 => 0xe },
	'orientationlinkedafpoint' => { 75 => 0x516 },
	'originalbestqualitysize' => { 109 => 0xc792 },
	'originalcreatedatetime' => { 410 => 'OriginalCreateDateTime' },
	'originaldecisiondata' => { 105 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 57 => 0x83 },
	'originaldefaultcropsize' => { 109 => 0xc793 },
	'originaldefaultfinalsize' => { 109 => 0xc791 },
	'originaldirectory' => { 280 => 0x408 },
	'originaldocumentid' => { 445 => 'OriginalDocumentID' },
	'originalfilename' => { 88 => 0x816, 123 => 0x3e9, 135 => 0x20, 280 => 0x407, 410 => 'OriginalFilename' },
	'originalimageheight' => { 71 => 0xc, 113 => 0x1 },
	'originalimagewidth' => { 71 => 0xb, 113 => 0x0 },
	'originalrawfiledata' => { 109 => 0xc68c },
	'originalrawfiledigest' => { 109 => 0xc71d },
	'originalrawfilename' => { 109 => 0xc68b },
	'originaltransmissionreference' => { 117 => 0x67 },
	'originatingprogram' => { 117 => 0x41, 414 => 'OriginatingProgram' },
	'originplatform' => { 434 => 'originPlatform' },
	'os' => { 422 => 'os' },
	'otherconditions' => { 271 => 'OtherConditions' },
	'otherconstraints' => { 271 => 'OtherConstraints' },
	'otherimage' => { 105 => 'OtherImage' },
	'otherimageinfo' => { 271 => 'OtherImageInfo' },
	'otherimagelength' => { 109 => 0x202 },
	'otherimagestart' => { 109 => 0x201 },
	'otherlicensedocuments' => { 271 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 271 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 271 => 'OtherLicenseRequirements' },
	'outcue' => { 444 => 'outCue' },
	'outcuescale' => { 444 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 444 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 178 => 0x3 },
	'outputimagewidth' => { 178 => 0x2 },
	'outputprofile' => { 123 => 0x138b },
	'outputresolution' => { 178 => 0x4 },
	'owner' => { 448 => 'Owner' },
	'ownerid' => { 117 => 0xbc },
	'ownername' => { 14 => 0x10f, 57 => 0x9, 88 => 0x810, 109 => [0xa430,0xfde8], 139 => 'OwnerName', 416 => 'OwnerName', 425 => 'CameraOwnerName' },
	'padding' => { 109 => 0xea1c },
	'pagecount' => { 434 => 'pageCount' },
	'pageimage' => { 442 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 442 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 442 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 442 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 442 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 442 => 'PageInfo' },
	'pagename' => { 109 => 0x11d },
	'pagenumber' => { 109 => 0x129 },
	'pageprogressiondirection' => { 434 => 'pageProgressionDirection' },
	'pagerange' => { 434 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 420 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionbrightness' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectiondefringe' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectionexposure' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectionluminancenoise' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskleft' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmidpoint' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskperimetervalue' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskright' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskx' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionsaturation' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionshadows2012' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontint' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectionwhat' => { 420 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'panasonicexifversion' => { 282 => 0x26 },
	'panasonicimageheight' => { 282 => 0x4c },
	'panasonicimagewidth' => { 282 => 0x4b },
	'panasonicrawversion' => { 286 => 0x1 },
	'panasonictitle' => { 109 => 0xc6d2 },
	'panasonictitle2' => { 109 => 0xc6d3 },
	'panoramaangle' => { 114 => 0x1153 },
	'panoramacropbottom' => { 376 => 0x7 },
	'panoramacropleft' => { 376 => 0x4 },
	'panoramacropright' => { 376 => 0x6 },
	'panoramacroptop' => { 376 => 0x5 },
	'panoramadirection' => { 65 => 0x5, 114 => 0x1154, 376 => 0x3 },
	'panoramaframeheight' => { 376 => 0x9 },
	'panoramaframenumber' => { 65 => 0x2 },
	'panoramaframewidth' => { 376 => 0x8 },
	'panoramafullheight' => { 376 => 0x2 },
	'panoramafullwidth' => { 376 => 0x1 },
	'panoramamode' => { 125 => 0x3c, 261 => 0x601 },
	'panoramasize3d' => { 361 => 0x38 },
	'panoramasourceheight' => { 376 => 0xb },
	'panoramasourcewidth' => { 376 => 0xa },
	'panoramicstitchcameramotion' => { 159 => 'PanoramicStitchCameraMotion', 160 => 0x1 },
	'panoramicstitchmaptype' => { 159 => 'PanoramicStitchMapType', 160 => 0x2 },
	'panoramicstitchphi0' => { 159 => 'PanoramicStitchPhi0', 160 => 0x5 },
	'panoramicstitchphi1' => { 159 => 'PanoramicStitchPhi1', 160 => 0x6 },
	'panoramicstitchtheta0' => { 159 => 'PanoramicStitchTheta0', 160 => 0x3 },
	'panoramicstitchtheta1' => { 159 => 'PanoramicStitchTheta1', 160 => 0x4 },
	'panoramicstitchversion' => { 160 => 0x0 },
	'pantry' => { 445 => 'Pantry' },
	'parallax' => { 114 => 0xb211, 260 => 0x28 },
	'parametricdarks' => { 420 => 'ParametricDarks' },
	'parametrichighlights' => { 420 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 420 => 'ParametricHighlightSplit' },
	'parametriclights' => { 420 => 'ParametricLights' },
	'parametricmidtonesplit' => { 420 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 420 => 'ParametricShadows' },
	'parametricshadowsplit' => { 420 => 'ParametricShadowSplit' },
	'parentmediaeventid' => { 410 => 'ParentMediaEventID' },
	'parentmeid' => { 410 => 'ParentMEID' },
	'parentreference1' => { 428 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 428 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 428 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 428 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 428 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 428 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'partofcompilation' => { 444 => 'partOfCompilation' },
	'patientbirthdate' => { 404 => 'PatientDOB' },
	'patientid' => { 404 => 'PatientID' },
	'patientname' => { 404 => 'PatientName' },
	'patientsex' => { 404 => 'PatientSex' },
	'pdfversion' => { 431 => 'PDFVersion' },
	'pentaximagesize' => { 316 => 0x9 },
	'pentaxmodelid' => { 296 => 0x0, 316 => 0x5 },
	'pentaxmodeltype' => { 316 => 0x1 },
	'pentaxversion' => { 316 => 0x0 },
	'people' => { 405 => 'People', 412 => 'People' },
	'perchannelblacklevel' => { 39 => 0xc4, 40 => [0x2b4,0x2cb,0x2cf], 41 => 0x108, 42 => 0x1df, 43 => [0x1f8,0x2d8], 44 => [0x22c,0x30a] },
	'peripheralillumcentralradius' => { 402 => 0x8030 },
	'peripheralillumcentralvalue' => { 402 => 0x8031 },
	'peripheralillumination' => { 94 => 0x20702, 100 => 0x68 },
	'peripheralilluminationcorr' => { 56 => 0x1, 306 => 0x2 },
	'peripheralilluminationon' => { 94 => '0x20702.0', 100 => 0x64 },
	'peripheralillumperiphvalue' => { 402 => 0x8032 },
	'peripherallighting' => { 71 => 0x2 },
	'peripherallightingsetting' => { 72 => 0x5 },
	'peripherallightingvalue' => { 71 => 0x6 },
	'permissions' => { 437 => 'permissions' },
	'permits' => { 417 => 'permits' },
	'person' => { 434 => 'person' },
	'personality' => { 410 => 'Personality' },
	'personheard' => { 430 => 'PersonHeard' },
	'personheardidentifier' => { 430 => [\'PersonHeard','PersonHeardIdentifier'] },
	'personheardname' => { 430 => [\'PersonHeard','PersonHeardName'] },
	'personinimage' => { 430 => 'PersonInImage' },
	'personinimagecharacteristic' => { 430 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 430 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 430 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 430 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 430 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 430 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 430 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 430 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 430 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 420 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 420 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 420 => 'PerspectiveRotate' },
	'perspectivescale' => { 420 => 'PerspectiveScale' },
	'perspectiveupright' => { 420 => 'PerspectiveUpright' },
	'perspectivevertical' => { 420 => 'PerspectiveVertical' },
	'perspectivex' => { 420 => 'PerspectiveX' },
	'perspectivey' => { 420 => 'PerspectiveY' },
	'pf0customfuncregistration' => { 83 => 0x1 },
	'pf10retainprogramshift' => { 83 => 0xb },
	'pf13drivepriority' => { 83 => 0xe },
	'pf14disablefocussearch' => { 83 => 0xf },
	'pf15disableafassistbeam' => { 83 => 0x10 },
	'pf16autofocuspointshoot' => { 83 => 0x11 },
	'pf17disableafpointsel' => { 83 => 0x12 },
	'pf18enableautoafpointsel' => { 83 => 0x13 },
	'pf19continuousshootspeed' => { 83 => 0x14 },
	'pf19shootingspeedhigh' => { 82 => 0xa },
	'pf19shootingspeedlow' => { 82 => 0x9 },
	'pf1disableshootingmodes' => { 83 => 0x2 },
	'pf1value' => { 82 => 0x1 },
	'pf20limitcontinousshots' => { 83 => 0x15 },
	'pf20maxcontinousshots' => { 82 => 0xb },
	'pf21enablequietoperation' => { 83 => 0x16 },
	'pf23felocktime' => { 82 => 0xd },
	'pf23postreleasetime' => { 82 => 0xe },
	'pf23settimerlengths' => { 83 => 0x18 },
	'pf23shutterbuttontime' => { 82 => 0xc },
	'pf24lightlcdduringbulb' => { 83 => 0x19 },
	'pf25aemode' => { 82 => 0xf },
	'pf25afmode' => { 82 => 0x12 },
	'pf25afpointsel' => { 82 => 0x13 },
	'pf25colormatrix' => { 82 => 0x17 },
	'pf25defaultclearsettings' => { 83 => 0x1a },
	'pf25drivemode' => { 82 => 0x11 },
	'pf25imagesize' => { 82 => 0x14 },
	'pf25meteringmode' => { 82 => 0x10 },
	'pf25parameters' => { 82 => 0x16 },
	'pf25wbmode' => { 82 => 0x15 },
	'pf26shortenreleaselag' => { 83 => 0x1b },
	'pf27reversedialrotation' => { 83 => 0x1c },
	'pf27value' => { 82 => 0x18 },
	'pf28noquickdialexpcomp' => { 83 => 0x1d },
	'pf29quickdialswitchoff' => { 83 => 0x1e },
	'pf2disablemeteringmodes' => { 83 => 0x3 },
	'pf2value' => { 82 => 0x2 },
	'pf30enlargementmode' => { 83 => 0x1f },
	'pf31originaldecisiondata' => { 83 => 0x20 },
	'pf3manualexposuremetering' => { 83 => 0x4 },
	'pf3value' => { 82 => 0x3 },
	'pf4exposuretimelimits' => { 83 => 0x5 },
	'pf4exposuretimemax' => { 82 => 0x5 },
	'pf4exposuretimemin' => { 82 => 0x4 },
	'pf5aperturelimits' => { 83 => 0x6 },
	'pf5aperturemax' => { 82 => 0x7 },
	'pf5aperturemin' => { 82 => 0x6 },
	'pf6presetshootingmodes' => { 83 => 0x7 },
	'pf7bracketcontinuousshoot' => { 83 => 0x8 },
	'pf8bracketshots' => { 82 => 0x8 },
	'pf8setbracketshots' => { 83 => 0x9 },
	'pf9changebracketsequence' => { 83 => 0xa },
	'phasedetectaf' => { 175 => 0x6 },
	'phonenumber' => { 140 => 'Phone' },
	'photoeffect' => { 33 => 0x28 },
	'photoeffecthistoryxml' => { 238 => 0xe9651831 },
	'photoeffects' => { 238 => 0xab5eca5e },
	'photoeffectsblue' => { 240 => 0x8 },
	'photoeffectsgreen' => { 240 => 0x6 },
	'photoeffectsred' => { 240 => 0x4 },
	'photoeffectstype' => { 240 => 0x0 },
	'photographicsensitivity' => { 425 => 'PhotographicSensitivity' },
	'photoinfoplayback' => { 245 => '17.6', 254 => '33.6' },
	'photometricinterpretation' => { 109 => 0x106, 440 => 'PhotometricInterpretation' },
	'photoshootingmenubank' => { 218 => 0xe7d },
	'photoshootingmenubankimagearea' => { 218 => '3716.1' },
	'photoshopbgrthumbnail' => { 330 => 0x409 },
	'photoshopquality' => { 329 => 0x0 },
	'photoshopthumbnail' => { 330 => 0x40c },
	'photostyle' => { 282 => 0x89 },
	'picklabel' => { 423 => 'PickLabel' },
	'pictinfo' => { 350 => 0x208 },
	'picturecontrol' => { 238 => 0xe2173c47 },
	'picturecontrolactive' => { 241 => 0x0 },
	'picturecontroladjust' => { 202 => 0x30, 203 => 0x30 },
	'picturecontrolbase' => { 202 => 0x18, 203 => 0x18 },
	'picturecontroldata' => { 200 => [0xbd,0x23] },
	'picturecontrolmode' => { 241 => 0x13 },
	'picturecontrolname' => { 202 => 0x4, 203 => 0x4 },
	'picturecontrolquickadjust' => { 202 => 0x31, 203 => 0x31 },
	'pictureeffect' => { 371 => 0x200e },
	'pictureeffect2' => { 378 => 0x1163, 379 => 0x1167, 380 => 0x1143, 381 => 0x11bf, 382 => 0x119b, 383 => 0x1053, 384 => 0x24b, 385 => 0x24b, 386 => 0x23c, 398 => 0x46 },
	'picturefinish' => { 164 => 0x71 },
	'picturemode' => { 114 => 0x1031, 261 => 0x520, 316 => [0xb,0x33], 351 => 0x3d },
	'picturemode2' => { 297 => 0x0 },
	'picturemodebwfilter' => { 261 => 0x525 },
	'picturemodecontrast' => { 261 => 0x523 },
	'picturemodeeffect' => { 261 => 0x52d },
	'picturemodehue' => { 261 => 0x522 },
	'picturemodesaturation' => { 261 => 0x521 },
	'picturemodesharpness' => { 261 => 0x524 },
	'picturemodetone' => { 261 => 0x526 },
	'pictureprofile' => { 378 => [0x115e,0x115f], 379 => [0x1162,0x1163], 380 => [0x113e,0x113f], 381 => [0x11ba,0x11bb], 382 => [0x1196,0x1197], 383 => [0x104e,0x104f], 384 => [0x246,0x247], 385 => [0x246,0x247], 386 => [0x237,0x238] },
	'picturestyle' => { 7 => [0x4b,0x51], 8 => 0xf4, 9 => 0x6c, 10 => 0x86, 11 => 0x73, 15 => 0xab, 16 => 0xa7, 17 => 0xb0, 18 => 0x6c, 19 => 0xa7, 20 => 0xf4, 21 => 0xb3, 23 => 0xf4, 24 => 0xfa, 26 => 0x169, 67 => 0xa, 94 => 0x20301, 100 => 0x2 },
	'picturewizard' => { 348 => 0x21 },
	'picturewizardcolor' => { 347 => 0x1 },
	'picturewizardcontrast' => { 347 => 0x4 },
	'picturewizardmode' => { 347 => 0x0 },
	'picturewizardsaturation' => { 347 => 0x2 },
	'picturewizardsharpness' => { 347 => 0x3 },
	'pipelineversion' => { 159 => 'PipelineVersion' },
	'pitch' => { 106 => 0x6, 246 => '4.1', 258 => '4.1' },
	'pitchangle' => { 217 => 0x350f, 226 => 0x36f8, 261 => 0x904, 282 => 0x91, 315 => 0x2, 346 => 0x1 },
	'pixelshiftresolution' => { 317 => 0x0 },
	'pixelsperunitx' => { 273 => 0x0 },
	'pixelsperunity' => { 273 => 0x4 },
	'pixelunits' => { 273 => 0x8 },
	'planarconfiguration' => { 109 => 0x11c, 440 => 'PlanarConfiguration' },
	'platenames' => { 449 => 'PlateNames' },
	'platform' => { 434 => 'platform' },
	'playbackmenustime' => { 250 => '20.1', 251 => '21.1', 252 => '21.1' },
	'playbackmonitorofftime' => { 245 => '25.2', 246 => '36.1', 248 => '36.1', 249 => '36.1', 253 => '35.1', 254 => '8.1', 255 => '35.1', 258 => '36.1', 259 => '21.1' },
	'playbackzoom' => { 246 => '37.1' },
	'playdisplay' => { 166 => 0x4e },
	'plusversion' => { 271 => 'Version' },
	'pmversion' => { 328 => 'PMVersion' },
	'pngwarning' => { 274 => 'Warning' },
	'poilevel' => { 199 => 0x8 },
	'portraitoutputhighlightpoint' => { 100 => 0x1d },
	'portraitoutputshadowpoint' => { 100 => 0x1e },
	'portraitrawcolortone' => { 100 => 0x16 },
	'portraitrawcontrast' => { 100 => 0x18 },
	'portraitrawhighlight' => { 100 => 0x76 },
	'portraitrawhighlightpoint' => { 100 => 0x1b },
	'portraitrawlinear' => { 100 => 0x19 },
	'portraitrawsaturation' => { 100 => 0x17 },
	'portraitrawshadow' => { 100 => 0x7f },
	'portraitrawshadowpoint' => { 100 => 0x1c },
	'portraitrawsharpness' => { 100 => 0x1a },
	'portraitrefiner' => { 104 => 0x302b },
	'portraitunsharpmaskfineness' => { 100 => 0x9a },
	'portraitunsharpmaskstrength' => { 100 => 0x98 },
	'portraitunsharpmaskthreshold' => { 100 => 0x9c },
	'poseheadingdegrees' => { 408 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 408 => 'PosePitchDegrees' },
	'poserolldegrees' => { 408 => 'PoseRollDegrees' },
	'positiondescriptor' => { 433 => 'positionDescriptor' },
	'postalcode' => { 144 => 'PostalCode' },
	'postcropvignetteamount' => { 420 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 420 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 420 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 420 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 420 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 420 => 'PostCropVignetteStyle' },
	'potentialface1position' => { 369 => 0xb },
	'potentialface2position' => { 369 => 0x15 },
	'potentialface3position' => { 369 => 0x1f },
	'potentialface4position' => { 369 => 0x29 },
	'potentialface5position' => { 369 => 0x33 },
	'potentialface6position' => { 369 => 0x3d },
	'potentialface7position' => { 369 => 0x47 },
	'potentialface8position' => { 369 => 0x51 },
	'powersource' => { 295 => '0.1' },
	'poweruptime' => { 200 => 0xb6 },
	'precaptureframes' => { 266 => 0x300 },
	'predictor' => { 109 => 0x13d },
	'preflashreturnstrength' => { 215 => 0x28a },
	'prefs' => { 117 => 0xdd, 328 => 'Prefs' },
	'preservedfilename' => { 445 => 'PreservedFileName' },
	'presetwhitebalance' => { 166 => 0x24, 402 => 0x8002 },
	'presetwhitebalanceadj' => { 402 => 0x8014 },
	'pressure' => { 109 => 0x9402 },
	'previewapplicationname' => { 109 => 0xc716 },
	'previewapplicationversion' => { 109 => 0xc717 },
	'previewbutton' => { 245 => ['14.1','15.1'], 246 => '15.1', 248 => '15.1', 249 => '15.1', 254 => '29.1', 255 => '14.1', 258 => '15.1' },
	'previewbuttonplusdials' => { 245 => ['14.2','15.2'], 246 => '15.2', 248 => '43.1', 249 => '43.1', 254 => '31.2', 258 => '43.1' },
	'previewcolorspace' => { 109 => 0xc71a },
	'previewcropbottom' => { 327 => 0xef },
	'previewcropleft' => { 327 => 0xec },
	'previewcropright' => { 327 => 0xee },
	'previewcroptop' => { 327 => 0xed },
	'previewdate' => { 335 => 0x0 },
	'previewdatetime' => { 109 => 0xc71b },
	'previewimage' => { 104 => 0x2000, 105 => 'PreviewImage', 110 => 'PreviewImage', 112 => 0x4, 149 => 'data', 168 => 0x81, 266 => 0x280, 281 => 0x300, 371 => 0x2001 },
	'previewimageborders' => { 316 => 0x3e },
	'previewimageheight' => { 66 => 0x4, 127 => 0xfa58 },
	'previewimagelength' => { 66 => 0x2, 104 => 0x3, 109 => [0x117,0x202], 168 => 0x89, 204 => 0x202, 261 => 0x102, 266 => 0x1037, 316 => 0x3, 340 => 0x1e, 345 => 0x3, 351 => [0x1b,0x1d], 362 => 0x202 },
	'previewimagename' => { 149 => '1Name' },
	'previewimagesize' => { 104 => 0x2, 132 => 0x2, 149 => 'ImageSize', 316 => 0x2, 351 => [0x1c,0x1e], 371 => 0xb02c },
	'previewimagestart' => { 66 => 0x5, 104 => 0x4, 109 => [0x111,0x201], 168 => 0x88, 204 => 0x201, 261 => 0x101, 266 => 0x1036, 316 => 0x4, 340 => 0x1c, 345 => 0x2, 351 => [0x1a,0x1c], 362 => 0x201 },
	'previewimagetype' => { 149 => '0Type' },
	'previewimagevalid' => { 261 => 0x100, 266 => 0x1035 },
	'previewimagewidth' => { 66 => 0x3, 127 => 0xfa57 },
	'previewquality' => { 66 => 0x1 },
	'previewsettingsdigest' => { 109 => 0xc719 },
	'previewsettingsname' => { 109 => 0xc718 },
	'primaryafpoint' => { 175 => 0x7 },
	'primarychromaticities' => { 109 => 0x13f, 440 => 'PrimaryChromaticities' },
	'primaryftp' => { 410 => 'PrimaryFTP' },
	'primaryslot' => { 218 => 0xe7f },
	'printim' => { 109 => 0xc4a5 },
	'prioritysetupshutterrelease' => { 166 => 0x1d, 359 => 0x28 },
	'privatertkinfo' => { 411 => 'privateRTKInfo' },
	'processingsoftware' => { 109 => 0xb },
	'processversion' => { 420 => 'ProcessVersion' },
	'producer' => { 270 => 'Producer', 431 => 'Producer' },
	'productcode' => { 434 => 'productCode' },
	'productid' => { 118 => 0x32, 433 => 'productID' },
	'productidtype' => { 433 => 'productIDType' },
	'productinimage' => { 430 => 'ProductInImage' },
	'productinimagedescription' => { 430 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 430 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 430 => [\'ProductInImage','ProductInImageProductName'] },
	'productioncode' => { 296 => 0x2 },
	'productorserviceconstraints' => { 271 => 'ProductOrServiceConstraints' },
	'profession' => { 434 => 'profession' },
	'profilecalibrationsig' => { 109 => 0xc6f4 },
	'profilecopyright' => { 109 => 0xc6fe },
	'profileembedpolicy' => { 109 => 0xc6fd },
	'profilehuesatmapdata1' => { 109 => 0xc6fa },
	'profilehuesatmapdata2' => { 109 => 0xc6fb },
	'profilehuesatmapdims' => { 109 => 0xc6f9 },
	'profilehuesatmapencoding' => { 109 => 0xc7a3 },
	'profilelooktabledata' => { 109 => 0xc726 },
	'profilelooktabledims' => { 109 => 0xc725 },
	'profilelooktableencoding' => { 109 => 0xc7a4 },
	'profilename' => { 109 => 0xc6f8 },
	'profiletonecurve' => { 109 => 0xc6fc },
	'programiso' => { 282 => 0x3c },
	'programline' => { 297 => '1.1' },
	'programmode' => { 171 => 0x5 },
	'programshift' => { 200 => 0xd },
	'programversion' => { 117 => 0x46 },
	'prohibits' => { 417 => 'prohibits' },
	'projectiontype' => { 408 => 'ProjectionType', 409 => 'ProjectionType' },
	'projectname' => { 444 => 'projectName' },
	'projectref' => { 444 => 'projectRef' },
	'projectrefpath' => { 444 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 444 => [\'projectRef','projectRefType'] },
	'propertyreleaseid' => { 271 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 271 => 'PropertyReleaseStatus' },
	'province-state' => { 117 => 0x5f },
	'publicationdate' => { 434 => 'publicationDate' },
	'publicationdatea-platform' => { 434 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 434 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 434 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 434 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 434 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationevent' => { 430 => 'PublicationEvent' },
	'publicationeventdate' => { 430 => [\'PublicationEvent','PublicationEventDate'] },
	'publicationeventidentifier' => { 430 => [\'PublicationEvent','PublicationEventIdentifier'] },
	'publicationeventname' => { 430 => [\'PublicationEvent','PublicationEventName'] },
	'publicationname' => { 434 => 'publicationName' },
	'publisher' => { 421 => 'publisher' },
	'publishingfrequency' => { 434 => 'publishingFrequency' },
	'pulldown' => { 444 => 'pullDown' },
	'purplehsl' => { 94 => 0x20916 },
	'quality' => { 0 => 0x1, 33 => 0x3, 103 => 0x2, 104 => 0x3002, 114 => 0x1000, 125 => 0x9, 200 => 0x4, 228 => 0x3, 266 => 0x201, 278 => 0x300, 316 => 0x8, 323 => 0x2, 351 => 0x16, 359 => 0x56, 360 => 0x56, 361 => 0xb, 371 => 0x102 },
	'quality2' => { 378 => 0x1170, 379 => 0x1174, 380 => 0x1150, 382 => 0x11a8, 383 => 0x1060, 384 => 0x258, 385 => 0x258, 386 => 0x247, 390 => 0x29, 391 => 0x25, 392 => 0x2a },
	'qualitymode' => { 104 => 0x8 },
	'quantizationmethod' => { 119 => 0x78 },
	'quickadjust' => { 241 => 0x2a },
	'quickcontroldialinmeter' => { 75 => 0x703 },
	'quickfix' => { 238 => 0x416391c6 },
	'quickshot' => { 350 => 0x213 },
	'rangefinder' => { 250 => '4.1', 251 => '5.1', 252 => '5.1' },
	'rasterizedcaption' => { 117 => 0x7d },
	'rating' => { 109 => 0x4746, 114 => 0x1431, 327 => 0xdf, 371 => 0x2002, 414 => 'rating', 422 => 'rating', 430 => 'Rating', 434 => 'rating', 442 => 'Rating' },
	'ratingpercent' => { 109 => 0x4749, 161 => 'Rating' },
	'ratingratingregion' => { 430 => [\'Rating','RatingRatingRegion'] },
	'ratingregioncity' => { 430 => [\'Rating','RatingRatingRegionCity'] },
	'ratingregioncountrycode' => { 430 => [\'Rating','RatingRatingRegionCountryCode'] },
	'ratingregioncountryname' => { 430 => [\'Rating','RatingRatingRegionCountryName'] },
	'ratingregiongpsaltitude' => { 430 => [\'Rating','RatingRatingRegionGPSAltitude'] },
	'ratingregiongpslatitude' => { 430 => [\'Rating','RatingRatingRegionGPSLatitude'] },
	'ratingregiongpslongitude' => { 430 => [\'Rating','RatingRatingRegionGPSLongitude'] },
	'ratingregionidentifier' => { 430 => [\'Rating','RatingRatingRegionIdentifier'] },
	'ratingregionlocationid' => { 430 => [\'Rating','RatingRatingRegionLocationId'] },
	'ratingregionlocationname' => { 430 => [\'Rating','RatingRatingRegionLocationName'] },
	'ratingregionprovincestate' => { 430 => [\'Rating','RatingRatingRegionProvinceState'] },
	'ratingregionsublocation' => { 430 => [\'Rating','RatingRatingRegionSublocation'] },
	'ratingregionworldregion' => { 430 => [\'Rating','RatingRatingRegionWorldRegion'] },
	'ratingscalemaxvalue' => { 430 => [\'Rating','RatingRatingScaleMaxValue'] },
	'ratingscaleminvalue' => { 430 => [\'Rating','RatingRatingScaleMinValue'] },
	'ratingsourcelink' => { 430 => [\'Rating','RatingRatingSourceLink'] },
	'ratingvalue' => { 430 => [\'Rating','RatingRatingValue'] },
	'ratingvaluelogolink' => { 430 => [\'Rating','RatingRatingValueLogoLink'] },
	'rawandjpgrecording' => { 73 => 0x8, 168 => 0x109, 297 => 0xd },
	'rawbrightnessadj' => { 94 => 0x20001, 99 => 0x38 },
	'rawcoloradj' => { 99 => 0x2e },
	'rawcropbottom' => { 327 => 0xd4 },
	'rawcropleft' => { 327 => 0xd1 },
	'rawcropright' => { 327 => 0xd3 },
	'rawcroptop' => { 327 => 0xd2 },
	'rawcustomsaturation' => { 99 => 0x30 },
	'rawcustomtone' => { 99 => 0x34 },
	'rawdata' => { 348 => 0xa048 },
	'rawdatabyteorder' => { 348 => 0x40 },
	'rawdatacfapattern' => { 348 => 0x50 },
	'rawdatauniqueid' => { 109 => 0xc65d },
	'rawdepth' => { 170 => 0x10 },
	'rawdevartfilter' => { 268 => 0x121 },
	'rawdevautogradation' => { 268 => 0x119 },
	'rawdevcolorspace' => { 267 => 0x108, 268 => 0x109 },
	'rawdevcontrastvalue' => { 267 => 0x106, 268 => 0x105 },
	'rawdeveditstatus' => { 267 => 0x10b },
	'rawdevelopmentprocess' => { 316 => 0x62 },
	'rawdevengine' => { 267 => 0x109, 268 => 0x10b },
	'rawdevexposurebiasvalue' => { 267 => 0x100, 268 => 0x100 },
	'rawdevgradation' => { 268 => 0x112 },
	'rawdevgraypoint' => { 267 => 0x103, 268 => 0x104 },
	'rawdevmemorycoloremphasis' => { 267 => 0x105, 268 => 0x108 },
	'rawdevnoisereduction' => { 267 => 0x10a, 268 => 0x10a },
	'rawdevpicturemode' => { 268 => 0x10c },
	'rawdevpm_bwfilter' => { 268 => 0x110 },
	'rawdevpmcontrast' => { 268 => 0x10e },
	'rawdevpmnoisefilter' => { 268 => 0x120 },
	'rawdevpmpicturetone' => { 268 => 0x111 },
	'rawdevpmsaturation' => { 268 => 0x10d },
	'rawdevpmsharpness' => { 268 => 0x10f },
	'rawdevsaturation3' => { 268 => 0x113 },
	'rawdevsaturationemphasis' => { 267 => 0x104, 268 => 0x107 },
	'rawdevsettings' => { 267 => 0x10c },
	'rawdevsharpnessvalue' => { 267 => 0x107, 268 => 0x106 },
	'rawdevversion' => { 267 => 0x0, 268 => 0x0 },
	'rawdevwbfineadjustment' => { 267 => 0x102, 268 => 0x103 },
	'rawdevwhitebalance' => { 268 => 0x101 },
	'rawdevwhitebalancevalue' => { 267 => 0x101, 268 => 0x102 },
	'rawfile' => { 109 => 0xfe4c },
	'rawfilename' => { 420 => 'RawFileName' },
	'rawfiletype' => { 371 => 0x2029 },
	'rawformat' => { 325 => 0x10e },
	'rawimagecenter' => { 200 => 0x99 },
	'rawimagedigest' => { 109 => 0xc71c },
	'rawimagesize' => { 316 => 0x39 },
	'rawinfoversion' => { 269 => 0x0 },
	'rawjpgheight' => { 90 => 0x4 },
	'rawjpgquality' => { 51 => 0x6, 90 => 0x1 },
	'rawjpgsize' => { 51 => 0x7, 90 => 0x2 },
	'rawjpgwidth' => { 90 => 0x3 },
	'rawmeasuredrggb' => { 38 => 0x26a, 40 => 0x280, 42 => 0x194, 43 => [0x1ad,0x26b] },
	'rawrppused' => { 414 => 'rawrppused' },
	'rawtopreviewgain' => { 109 => 0xc7a8 },
	'reardisplay' => { 245 => '12.3', 246 => '6.2' },
	'recipeendingpage' => { 436 => 'recipeEndingPage' },
	'recipepagerange' => { 436 => 'recipePageRange' },
	'recipesource' => { 436 => 'recipeSource' },
	'recipestartingpage' => { 436 => 'recipeStartingPage' },
	'recipetitle' => { 436 => 'recipeTitle' },
	'recognizedface1age' => { 277 => 0x20 },
	'recognizedface1name' => { 277 => 0x4 },
	'recognizedface1position' => { 277 => 0x18 },
	'recognizedface2age' => { 277 => 0x50 },
	'recognizedface2name' => { 277 => 0x34 },
	'recognizedface2position' => { 277 => 0x48 },
	'recognizedface3age' => { 277 => 0x80 },
	'recognizedface3name' => { 277 => 0x64 },
	'recognizedface3position' => { 277 => 0x78 },
	'recognizedfaceflags' => { 282 => 0x63 },
	'recommendedexposureindex' => { 109 => 0x8832, 425 => 'RecommendedExposureIndex' },
	'record' => { 108 => 'Record' },
	'recordbasisofrecord' => { 108 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 108 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 108 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 108 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 108 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 108 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 166 => 0x4d },
	'recorddynamicproperties' => { 108 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 88 => 0x1804 },
	'recordinformationwithheld' => { 108 => [\'Record','RecordInformationWithheld'] },
	'recordingformat' => { 341 => 0x1000 },
	'recordingmode' => { 103 => 0x1, 323 => 0x1 },
	'recordinstitutioncode' => { 108 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 108 => [\'Record','RecordInstitutionID'] },
	'recordmode' => { 33 => 0x9, 104 => 0x3000 },
	'recordownerinstitutioncode' => { 108 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 350 => 0x217 },
	'redbalance' => { 183 => 0x270, 266 => 0x1017, 286 => 0x11, 316 => 0x1c },
	'redcurvelimits' => { 99 => 0x18a },
	'redcurvepoints' => { 98 => 0x2d, 99 => 0x160 },
	'redeyecorrection' => { 242 => 0x0 },
	'redeyeinfo' => { 420 => 'RedEyeInfo' },
	'redeyereduction' => { 166 => 0x41, 359 => 0x6a, 361 => 0x28 },
	'redhsl' => { 94 => 0x20910 },
	'redhue' => { 420 => 'RedHue' },
	'redsaturation' => { 420 => 'RedSaturation' },
	'reductionmatrix1' => { 109 => 0xc625 },
	'reductionmatrix2' => { 109 => 0xc626 },
	'reelname' => { 109 => 0xc789 },
	'reference1' => { 428 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 428 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 428 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 428 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 428 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 428 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 109 => 0x214, 440 => 'ReferenceBlackWhite' },
	'referencedate' => { 117 => 0x2f },
	'referencenumber' => { 117 => 0x32 },
	'references' => { 140 => 'References' },
	'referenceservice' => { 117 => 0x2d },
	'regionappliedtodimensions' => { 155 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 155 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 155 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 155 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 155 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 155 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 155 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 155 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 155 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 155 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 155 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 155 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 271 => 'RegionConstraints' },
	'regiondescription' => { 155 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 155 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 155 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 155 => 'Regions' },
	'regioninfodateregionsvalid' => { 158 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 158 => 'RegionInfo' },
	'regioninforegions' => { 158 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 155 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 155 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 158 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 158 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 158 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 158 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 158 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 155 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 155 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 155 => [\'Regions','RegionsRegionListType'] },
	'registryentryrole' => { 430 => [\'RegistryId','RegistryIdRegEntryRole'] },
	'registryid' => { 430 => 'RegistryId' },
	'registryitemid' => { 430 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 430 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 138 => 'data' },
	'relatedaudiofilename' => { 138 => '1Name' },
	'relatedaudiofiletype' => { 138 => '0Type' },
	'relatedimagefileformat' => { 109 => 0x1000 },
	'relatedimageheight' => { 109 => 0x1002 },
	'relatedimagewidth' => { 109 => 0x1001 },
	'relatedresourceid' => { 108 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 109 => 0xa004, 424 => 'RelatedSoundFile' },
	'relatedvideofile' => { 152 => 'data' },
	'relatedvideofilename' => { 152 => '1Name' },
	'relatedvideofiletype' => { 152 => '0Type' },
	'relation' => { 421 => 'relation' },
	'relationshipaccordingto' => { 108 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 108 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 108 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipremarks' => { 108 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativepeakaudiofilepath' => { 444 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 444 => 'relativeTimestamp' },
	'relativetimestampscale' => { 444 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 444 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 245 => '17.8', 246 => '18.5', 248 => '18.4', 249 => '18.4', 254 => '33.8', 255 => '17.6', 258 => '18.5' },
	'releasedate' => { 117 => 0x1e, 414 => 'ReleaseDate', 444 => 'releaseDate' },
	'releasemode' => { 104 => 0x3001, 217 => 0x184d, 371 => 0xb049 },
	'releasemode2' => { 378 => 0x112c, 379 => [0x112c,0x8], 380 => [0x1108,0x8], 381 => [0x1184,0x8], 382 => [0x1160,0x8], 383 => [0x4,0x1018], 384 => [0x4,0x210], 385 => [0x4,0x210], 386 => [0x4,0x208], 388 => [0x67,0x3f], 389 => [0x73,0x4b], 390 => 0x10, 391 => 0x10, 392 => 0x9, 398 => 0x34 },
	'releasemode3' => { 378 => 0x1128, 379 => 0x1128, 380 => 0x1104, 381 => 0x1180, 382 => 0x115c, 383 => 0x1014, 384 => 0x20c, 385 => 0x20c, 386 => 0x204 },
	'releaseready' => { 430 => 'ReleaseReady' },
	'releasesetting' => { 88 => 0x1016 },
	'releasetime' => { 117 => 0x23, 414 => 'ReleaseTime' },
	'remoteonduration' => { 247 => '3.4', 250 => '17.2', 251 => '18.2', 252 => '18.2', 253 => '18.2', 255 => '18.2', 256 => '4.3', 259 => '19.2' },
	'renditionclass' => { 445 => 'RenditionClass' },
	'renditionof' => { 445 => 'RenditionOf' },
	'renditionofalternatepaths' => { 445 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 445 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 445 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 445 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 445 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 445 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionoflasturl' => { 445 => [\'RenditionOf','RenditionOfLastURL'] },
	'renditionoflinkcategory' => { 445 => [\'RenditionOf','RenditionOfLinkCategory'] },
	'renditionoflinkform' => { 445 => [\'RenditionOf','RenditionOfLinkForm'] },
	'renditionofmanager' => { 445 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 445 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 445 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 445 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 445 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 445 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 445 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofplacedresolutionunit' => { 445 => [\'RenditionOf','RenditionOfPlacedResolutionUnit'] },
	'renditionofplacedxresolution' => { 445 => [\'RenditionOf','RenditionOfPlacedXResolution'] },
	'renditionofplacedyresolution' => { 445 => [\'RenditionOf','RenditionOfPlacedYResolution'] },
	'renditionofrenditionclass' => { 445 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 445 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 445 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 445 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 445 => 'RenditionParams' },
	'repeatingflashcount' => { 188 => 0xd, 189 => 0xe, 190 => 0xe, 191 => 0xe, 254 => '17.2', 255 => '24.2', 256 => '9.2', 257 => '24.2', 259 => '25.2' },
	'repeatingflashcountbuilt-in' => { 225 => 0x4db },
	'repeatingflashcountexternal' => { 225 => 0x4c3 },
	'repeatingflashoutput' => { 254 => '17.1', 255 => '24.1', 256 => '9.1', 257 => '24.1', 259 => '25.1' },
	'repeatingflashoutputexternal' => { 225 => 0x4c0 },
	'repeatingflashrate' => { 188 => 0xc, 189 => 0xd, 190 => 0xd, 191 => 0xd, 254 => '18.1', 255 => '25.1', 256 => '10.1', 257 => '25.1', 259 => '26.1' },
	'repeatingflashratebuilt-in' => { 225 => 0x4da },
	'repeatingflashrateexternal' => { 225 => 0x4c2 },
	'requires' => { 417 => 'requires' },
	'resampleparams' => { 444 => 'resampleParams' },
	'resampleparamsquality' => { 444 => [\'resampleParams','resampleParamsQuality'] },
	'resaved' => { 350 => 0x21e },
	'resolution' => { 145 => 'Resolution' },
	'resolutionmode' => { 351 => 0x4 },
	'resolutionunit' => { 109 => 0x128, 120 => 0x2, 440 => 'ResolutionUnit' },
	'resourceid' => { 108 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 108 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 108 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 75 => 0x612 },
	'restrictions' => { 437 => 'restrictions' },
	'retouchareafeather' => { 420 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 420 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 420 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 420 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 420 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 420 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 420 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 420 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 420 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 420 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 420 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 420 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskleft' => { 420 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmidpoint' => { 420 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskperimetervalue' => { 420 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 420 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskright' => { 420 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 420 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 420 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 420 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 420 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 420 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 420 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 420 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 420 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskx' => { 420 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 420 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 420 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 420 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 420 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 420 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 420 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 420 => 'RetouchAreas' },
	'retouchareaseed' => { 420 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 420 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 420 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 420 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 200 => 0x9e },
	'retouchinfo' => { 420 => 'RetouchInfo' },
	'retouchnefprocessing' => { 206 => 0x5 },
	'retractlensonpoweroff' => { 75 => 0x814 },
	'reuse' => { 271 => 'Reuse' },
	'reuseallowed' => { 447 => 'ReuseAllowed' },
	'reuseprohibited' => { 437 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 252 => '5.2' },
	'reverseindicators' => { 245 => '12.1', 246 => '6.1', 248 => '6.1', 249 => '6.1', 250 => '4.3', 251 => '5.2', 252 => '5.4', 254 => '33.5', 255 => '5.1', 258 => '6.1', 259 => '6.2' },
	'reverseshutterspeedaperture' => { 252 => '5.3' },
	'revision' => { 422 => 'revision' },
	'rgbcurvelimits' => { 99 => 0x238 },
	'rgbcurvepoints' => { 98 => 0x7, 99 => 0x20e },
	'richtextcomment' => { 427 => 'RichTextComment' },
	'ricohdate' => { 340 => 0x6 },
	'ricohimageheight' => { 340 => 0x2 },
	'ricohimagewidth' => { 340 => 0x0 },
	'rightascension' => { 148 => 'RightAscension' },
	'rights' => { 421 => 'rights' },
	'rightsagent' => { 437 => 'rightsAgent' },
	'rightsowner' => { 437 => 'rightsOwner' },
	'roll' => { 106 => 0x8 },
	'rollangle' => { 217 => 0x350b, 226 => 0x36f4, 261 => 0x903, 282 => 0x90, 315 => 0x1, 346 => 0x2 },
	'romoperationmode' => { 88 => 0x80d },
	'rotation' => { 29 => 0x17, 30 => 0x18, 87 => 0x3, 94 => 0x10002, 99 => 0x26e, 113 => 0x4, 148 => 'Rotation', 164 => [0x65,0x50], 165 => 0x46, 166 => 0x5a, 169 => 0x10, 217 => 0x3693, 218 => 0xca, 224 => '590.1', 226 => 0x38be, 238 => 0x76a43207, 282 => 0x30, 297 => '17.2', 327 => 0xd8, 359 => 0x3f, 360 => 0x3f, 370 => 0x10 },
	'routedto' => { 426 => 'RoutedTo' },
	'routing' => { 332 => 'Routing' },
	'routingdestinations' => { 410 => 'RoutingDestinations' },
	'routingexclusions' => { 410 => 'RoutingExclusions' },
	'routingnotes' => { 426 => 'RoutingNotes' },
	'rowsperstrip' => { 109 => 0x116 },
	'rpp' => { 414 => 'rpp' },
	'safetyshift' => { 75 => 0x108 },
	'safetyshiftinavortv' => { 73 => 0x10, 74 => 0x10, 76 => 0xf, 77 => 0x10, 80 => 0x10 },
	'sameexposurefornewaperture' => { 75 => 0x112 },
	'samplebits' => { 138 => 'SampleBits' },
	'samplepagerange' => { 434 => 'samplePageRange' },
	'samplerate' => { 138 => 'SampleRate' },
	'samplesperpixel' => { 109 => 0x115, 440 => 'SamplesPerPixel' },
	'samplestructure' => { 119 => 0x5a },
	'samsungmodelid' => { 348 => 0x3 },
	'sanyoquality' => { 350 => 0x201 },
	'sanyothumbnail' => { 350 => 0x100 },
	'saturation' => { 9 => 0x6e, 11 => 0x76, 33 => 0xe, 45 => 0x1, 103 => 0xd, 104 => [0x3013,0x1f], 109 => [0xa409,0xfe55], 114 => 0x1003, 139 => 'Saturation', 163 => 0x1f, 164 => 0x32, 165 => 0x28, 166 => 0x1a, 171 => 0x1, 200 => [0x94,0xaa], 202 => 0x35, 203 => 0x3b, 282 => 0x40, 284 => 0x300d, 316 => 0x1f, 323 => 0xd, 337 => 0x27, 340 => 0x28, 341 => 0x1013, 351 => 0x10, 359 => 0x1e, 360 => 0x1b, 371 => 0x2005, 420 => 'Saturation', 424 => 'Saturation' },
	'saturationadj' => { 94 => 0x20901, 99 => 0x116, 237 => 0x1, 241 => 0x2e, 402 => 0x8016 },
	'saturationadjustmentaqua' => { 420 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 420 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 420 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 420 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 420 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 420 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 420 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 420 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 64 => 0x98 },
	'saturationfaithful' => { 18 => 0xfe, 63 => 0x68, 64 => 0x68 },
	'saturationlandscape' => { 18 => 0xfc, 63 => 0x38, 64 => 0x38 },
	'saturationmonochrome' => { 63 => 0x80, 64 => 0x80 },
	'saturationneutral' => { 18 => 0xfd, 63 => 0x50, 64 => 0x50 },
	'saturationportrait' => { 18 => 0xfb, 63 => 0x20, 64 => 0x20 },
	'saturationsetting' => { 269 => 0x1010, 361 => 0x11, 375 => 0x9 },
	'saturationstandard' => { 18 => 0xfa, 63 => 0x8, 64 => 0x8 },
	'saturationuserdef1' => { 18 => 0x100, 63 => 0x98, 64 => 0xb0 },
	'saturationuserdef2' => { 18 => 0x101, 63 => 0xb0, 64 => 0xc8 },
	'saturationuserdef3' => { 18 => 0x102, 63 => 0xc8, 64 => 0xe0 },
	'saveid' => { 445 => 'SaveID' },
	'scaletype' => { 444 => 'scaleType' },
	'scanimageenhancer' => { 207 => 0x60 },
	'scanningdirection' => { 119 => 0x64 },
	'scene' => { 429 => 'Scene', 444 => 'scene' },
	'scenearea' => { 264 => 0x211, 266 => 0x1031 },
	'sceneassist' => { 200 => 0x9c },
	'scenecapturetype' => { 109 => 0xa406, 424 => 'SceneCaptureType' },
	'scenedetect' => { 264 => 0x210, 266 => 0x1030 },
	'scenedetectdata' => { 264 => 0x212, 266 => 0x1033 },
	'scenemode' => { 127 => 0xfa02, 168 => 0x100, 200 => 0x8f, 261 => 0x509, 266 => 0x403, 282 => 0x8001, 290 => 0xf, 371 => 0xb023 },
	'scenemodeused' => { 129 => [0x6002,0xf002] },
	'sceneselect' => { 350 => 0x21f },
	'scenetype' => { 109 => 0xa301, 424 => 'SceneType' },
	'screentips' => { 245 => '12.7', 246 => '5.3', 254 => '13.1', 255 => '4.4', 258 => '5.4', 259 => '5.1' },
	'season' => { 430 => 'Season', 433 => 'season' },
	'seasonidentifier' => { 430 => [\'Season','SeasonIdentifier'] },
	'seasonname' => { 430 => [\'Season','SeasonName'] },
	'seasonnumber' => { 430 => [\'Season','SeasonNumber'] },
	'secondaryftp' => { 410 => 'SecondaryFTP' },
	'secondaryslotfunction' => { 217 => 0x1d0, 226 => 0x1d0 },
	'section' => { 434 => 'section' },
	'securityclassification' => { 109 => 0x9212 },
	'selectableafpoint' => { 75 => 0x509 },
	'selectafareaselectionmode' => { 2 => 0xc },
	'selectafareaselectmode' => { 75 => 0x512 },
	'selftimer' => { 33 => 0x2, 282 => 0x2e, 350 => 0x214, 378 => 0x1134, 379 => 0x1134, 380 => 0x1110, 381 => 0x118c, 382 => 0x1168, 383 => 0x1020, 384 => 0x218, 385 => 0x218, 386 => 0x210 },
	'selftimer2' => { 69 => 0x1d },
	'selftimerinterval' => { 255 => '19.2' },
	'selftimermode' => { 109 => 0x882b },
	'selftimershotcount' => { 246 => '20.2', 248 => '20.3', 249 => '20.3', 250 => '18.2', 251 => '19.2', 252 => '19.2', 253 => '19.3', 255 => '19.3', 258 => '20.3', 259 => '20.2' },
	'selftimershotinterval' => { 246 => '20.3', 248 => '20.2', 249 => '20.2', 253 => '19.2', 258 => '20.2' },
	'selftimertime' => { 88 => 0x1806, 166 => 0x1f, 245 => '18.1', 246 => '20.1', 247 => '3.3', 248 => '20.1', 249 => '20.1', 250 => '18.1', 251 => '19.1', 252 => '19.1', 253 => '19.1', 254 => '7.2', 255 => '19.1', 256 => '3.3', 258 => '20.1', 259 => '20.1' },
	'sellingagency' => { 434 => 'sellingAgency' },
	'seminfo' => { 109 => 0x8546 },
	'sensingmethod' => { 109 => 0xa217, 424 => 'SensingMethod' },
	'sensitivityadjust' => { 316 => 0x40 },
	'sensitivitysteps' => { 297 => ['14.3','17.4'], 299 => 0x1 },
	'sensitivitytype' => { 109 => 0x8830, 425 => 'SensitivityType' },
	'sensor' => { 173 => 0x665e },
	'sensorareas' => { 348 => 0xa010 },
	'sensorbitdepth' => { 284 => 0x312d },
	'sensorbluelevel' => { 67 => 0x5 },
	'sensorcalibration' => { 265 => 0x805 },
	'sensorcleaning' => { 81 => 0xd },
	'sensorfullheight' => { 122 => 0xf904 },
	'sensorfullwidth' => { 122 => 0xf903 },
	'sensorheight' => { 122 => 0xf901, 127 => 0xfa21, 170 => 0x8, 284 => 0x312c, 325 => 0x109, 341 => 0x1602 },
	'sensorleftmargin' => { 325 => 0x10a },
	'sensorpixelsize' => { 200 => 0x9a },
	'sensorredlevel' => { 67 => 0x4 },
	'sensorserialnumber' => { 123 => 0x9ce },
	'sensorsize' => { 139 => 'SensorSize', 316 => 0x35 },
	'sensortemperature' => { 264 => 0x1500, 266 => 0x1007, 321 => 0xc, 325 => 0x210, 351 => [0x39,0x55] },
	'sensortemperature2' => { 321 => 0xe, 325 => 0x211 },
	'sensortopmargin' => { 325 => 0x10b },
	'sensorwidth' => { 122 => 0xf900, 127 => 0xfa20, 170 => 0xa, 284 => 0x312b, 325 => 0x108, 341 => 0x1601 },
	'sequence' => { 337 => 0x7 },
	'sequencefilenumber' => { 379 => 0x4, 380 => 0x4, 381 => 0x4, 382 => 0x4, 390 => 0xc, 391 => 0xc, 392 => 0x1a },
	'sequenceimagenumber' => { 379 => 0x0, 380 => 0x0, 381 => 0x0, 382 => 0x0, 390 => 0x8, 391 => 0x8, 392 => 0x12, 398 => 0x24 },
	'sequencelength' => { 390 => 0x22, 391 => 0x1e, 392 => [0x16,0x1e] },
	'sequencename' => { 433 => 'sequenceName' },
	'sequencenumber' => { 69 => 0x9, 104 => 0x301c, 114 => 0x1101, 125 => 0x1d, 225 => 0x51c, 282 => 0x2b, 361 => [0x10c,0x30c], 371 => 0xb04a, 433 => 'sequenceNumber' },
	'sequenceshotinterval' => { 350 => 0x224 },
	'sequencetotalnumber' => { 433 => 'sequenceTotalNumber' },
	'sequentialshot' => { 350 => 0x20e },
	'serialnumber' => { 57 => 0xc, 88 => 0x180b, 109 => [0xa431,0xfde9], 122 => 0xfa04, 124 => 0xfa00, 126 => 0xc354, 127 => 0xfa19, 136 => 0x0, 139 => 'SerialNumber', 200 => [0xa0,0x1d], 262 => 0x101, 266 => [0x404,0x101a], 278 => 0x303, 284 => 0x3103, 316 => 0x229, 325 => 0x102, 326 => 0x407, 337 => 0x15, 341 => 0x5, 351 => 0x2, 416 => 'SerialNumber', 425 => 'BodySerialNumber' },
	'serialnumberformat' => { 57 => 0x15, 88 => 0x183b },
	'series' => { 430 => 'Series' },
	'seriesdatetime' => { 404 => 'SeriesDateTime' },
	'seriesdescription' => { 404 => 'SeriesDescription' },
	'seriesidentifier' => { 430 => [\'Series','SeriesIdentifier'] },
	'seriesmodality' => { 404 => 'SeriesModality' },
	'seriesname' => { 430 => [\'Series','SeriesName'] },
	'seriesnumber' => { 404 => 'SeriesNumber', 434 => 'seriesNumber' },
	'seriestitle' => { 434 => 'seriesTitle' },
	'serviceidentifier' => { 118 => 0x1e },
	'servingsize' => { 436 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 78 => 0x0, 79 => 0x0 },
	'setbuttonwhenshooting' => { 73 => 0x1, 75 => 0x704, 81 => 0xc },
	'setfunctionwhenshooting' => { 76 => 0x0, 77 => 0x1, 80 => 0x1 },
	'setting' => { 433 => 'setting' },
	'shadingcompensation' => { 261 => 0x50c, 282 => 0x8a },
	'shadingcompensation2' => { 265 => 0x1012 },
	'shadow' => { 351 => 0xe },
	'shadowadj' => { 94 => 0x2030b },
	'shadowcorrection' => { 316 => 0x79 },
	'shadowprotection' => { 237 => 0x0 },
	'shadows' => { 109 => 0xfe52, 413 => 'Shadows', 420 => 'Shadows' },
	'shadows2012' => { 420 => 'Shadows2012' },
	'shadowscale' => { 109 => 0xc633 },
	'shadowtint' => { 420 => 'ShadowTint' },
	'shadowtone' => { 114 => 0x1040 },
	'shakereduction' => { 318 => 0x1, 319 => 0x1 },
	'sharpendetail' => { 420 => 'SharpenDetail' },
	'sharpenedgemasking' => { 420 => 'SharpenEdgeMasking' },
	'sharpening' => { 284 => 0x300b },
	'sharpeningadj' => { 241 => 0x2b },
	'sharpenradius' => { 420 => 'SharpenRadius' },
	'sharpness' => { 7 => [0x42,0x48], 9 => 0x72, 11 => 0x74, 33 => 0xf, 67 => 0x2, 103 => 0xb, 104 => [0x3011,0x21], 109 => [0xa40a,0xfe56], 114 => 0x1001, 125 => 0x6b, 134 => 0x37, 139 => 'Sharpness', 163 => 0x21, 164 => 0x30, 165 => 0x26, 166 => 0x18, 171 => 0x3, 200 => 0x6, 202 => 0x32, 203 => 0x33, 266 => 0x100f, 282 => 0x41, 316 => 0x21, 323 => 0xb, 337 => 0x26, 340 => 0x22, 341 => [0x1003,0x1014], 351 => 0x11, 359 => 0x1c, 360 => 0x19, 371 => 0x2006, 398 => 0x52, 420 => 'Sharpness', 424 => 'Sharpness' },
	'sharpnessadj' => { 94 => 0x20310, 99 => 0x25a, 402 => 0x801a },
	'sharpnessadjon' => { 94 => '0x20310.0' },
	'sharpnessauto' => { 64 => 0x94 },
	'sharpnessfactor' => { 266 => 0x102a },
	'sharpnessfaithful' => { 18 => 0xf5, 63 => 0x64, 64 => 0x64 },
	'sharpnessfrequency' => { 7 => [0x41,0x47], 67 => 0x3 },
	'sharpnesslandscape' => { 18 => 0xf3, 63 => 0x34, 64 => 0x34 },
	'sharpnessmonochrome' => { 18 => 0xf6, 63 => 0x7c, 64 => 0x7c },
	'sharpnessneutral' => { 18 => 0xf4, 63 => 0x4c, 64 => 0x4c },
	'sharpnessovershoot' => { 402 => 0x801b },
	'sharpnessportrait' => { 18 => 0xf2, 63 => 0x1c, 64 => 0x1c },
	'sharpnesssetting' => { 261 => 0x506, 269 => 0x1013, 361 => 0x12, 375 => 0xa },
	'sharpnessstandard' => { 18 => 0xf1, 63 => 0x4, 64 => 0x4 },
	'sharpnessstrength' => { 94 => 0x20311 },
	'sharpnessthreshold' => { 402 => 0x801d },
	'sharpnessundershoot' => { 402 => 0x801c },
	'sharpnessuserdef1' => { 18 => 0xf7, 63 => 0x94, 64 => 0xac },
	'sharpnessuserdef2' => { 18 => 0xf8, 63 => 0xac, 64 => 0xc4 },
	'sharpnessuserdef3' => { 18 => 0xf9, 63 => 0xc4, 64 => 0xdc },
	'shootid' => { 433 => 'shootID' },
	'shootingdistance' => { 94 => 0x20701 },
	'shootinginfodisplay' => { 245 => '13.2', 246 => '5.1', 254 => '10.2', 255 => '4.1', 258 => '5.1', 259 => '5.3' },
	'shootinginfomonitorofftime' => { 245 => '26.2', 246 => '22.2', 248 => '22.2', 249 => '22.2', 253 => '21.2', 254 => '9.1', 255 => '21.2', 258 => '22.2', 259 => '22.2' },
	'shootingmode' => { 139 => 'ShootingMode', 200 => 0x89, 282 => 0x1f },
	'shootingmodesetting' => { 247 => '5.1' },
	'shortdescription' => { 422 => 'shortdescription' },
	'shortdocumentid' => { 117 => 0xba },
	'shortownername' => { 18 => 0xac },
	'shortreleasetimelag' => { 75 => 0x80d },
	'shotdate' => { 444 => 'shotDate' },
	'shotday' => { 444 => 'shotDay' },
	'shotlocation' => { 444 => 'shotLocation' },
	'shotname' => { 444 => 'shotName' },
	'shotnumber' => { 444 => 'shotNumber' },
	'shotnumbersincepowerup' => { 374 => 0x44e, 390 => 0x1a, 391 => 0x16, 392 => 0xa },
	'shotnumbersincepowerup2' => { 361 => 0x200 },
	'shotsize' => { 444 => 'shotSize' },
	'shownevent' => { 430 => 'EventExt' },
	'showneventidentifier' => { 430 => [\'EventExt','EventExtIdentifier'] },
	'showneventname' => { 430 => [\'EventExt','EventExtName'] },
	'shutter-aelock' => { 73 => 0x4, 75 => 0x701, 76 => 0x3, 77 => 0x4, 78 => 0x3, 79 => 0x3, 80 => 0x4, 81 => 0x2 },
	'shutteraelbutton' => { 74 => 0x4 },
	'shutterbuttonafonbutton' => { 75 => 0x701 },
	'shuttercount' => { 10 => 0x176, 51 => 0x1, 200 => 0xa7, 208 => [0x6a,0x157,0x24d], 209 => 0x286, 210 => 0x279, 211 => 0x284, 212 => 0x242, 213 => 0x280, 214 => 0x276, 215 => [0x27d,0x27f], 216 => 0x246, 219 => 0x2d6, 220 => 0x321, 221 => 0xbd8, 222 => 0x287, 223 => 0x320, 224 => 0x24a, 225 => 0x5fb, 227 => 0x2d5, 316 => 0x5d, 370 => 0x846, 373 => [0x125,0x14a] },
	'shuttercurtainsync' => { 73 => 0xf, 74 => 0xf, 75 => 0x305, 76 => 0xe, 77 => 0xf, 78 => 0x8, 79 => 0x8, 80 => 0xf, 81 => 0x8 },
	'shuttermode' => { 125 => 0x1b },
	'shutterreleasebuttonae-l' => { 245 => '17.7', 246 => '18.4', 248 => '78.4', 249 => '78.4', 250 => '16.1', 251 => '17.1', 252 => '17.1', 253 => '17.1', 254 => '7.1', 255 => '17.5', 258 => '18.4', 259 => '18.2' },
	'shutterreleasemethod' => { 88 => 0x1010 },
	'shutterreleasenocfcard' => { 73 => 0x2, 74 => 0x2, 81 => 0xf },
	'shutterreleasetiming' => { 88 => 0x1011 },
	'shutterreleasewithoutlens' => { 75 => 0x711 },
	'shutterspeedlock' => { 246 => '38.1', 248 => '38.1', 249 => '38.1', 258 => '38.1' },
	'shutterspeedrange' => { 75 => 0x10c },
	'shutterspeedsetting' => { 166 => 0x6, 359 => 0x2f, 360 => 0x28, 361 => 0x0 },
	'shutterspeedvalue' => { 84 => 0x1, 109 => 0x9201, 266 => 0x1000, 325 => 0x400, 424 => 'ShutterSpeedValue' },
	'shuttertype' => { 114 => 0x1050, 282 => 0x9f },
	'sidecarforextension' => { 432 => 'SidecarForExtension' },
	'similarityindex' => { 117 => 0xe4 },
	'singleframebracketing' => { 166 => 0x21 },
	'skilllevel' => { 436 => 'skillLevel' },
	'skintonecorrection' => { 316 => 0x95 },
	'slaveflashmeteringsegments' => { 316 => 0x20b },
	'slideshowname' => { 433 => 'slideshowName' },
	'slideshownumber' => { 433 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 433 => 'slideshowTotalNumber' },
	'slowshutter' => { 69 => 0x8 },
	'slowsync' => { 114 => 0x1030 },
	'smartalbumcolor' => { 348 => 0x20 },
	'smartrange' => { 348 => 0xa012 },
	'smileshutter' => { 361 => 0x31 },
	'smileshuttermode' => { 361 => 0x27 },
	'smoothness' => { 109 => 0xfe57, 420 => 'Smoothness' },
	'snapshots' => { 414 => 'Snapshots' },
	'softskineffect' => { 371 => 0x200f },
	'software' => { 109 => 0x131, 140 => 'Software', 274 => 'Software', 325 => 0x203, 351 => 0x18, 440 => 'Software' },
	'softwareversion' => { 350 => 0x207 },
	'sonydatetime' => { 377 => 0x6, 379 => 0x1b6, 380 => 0x210, 381 => 0x1fe, 382 => 0x22c },
	'sonydatetime2' => { 388 => 0x51 },
	'sonyexposuretime' => { 388 => 0x3a, 389 => 0x46 },
	'sonyexposuretime2' => { 398 => 0xe },
	'sonyfnumber' => { 388 => 0x3c, 389 => 0x48, 398 => 0x14 },
	'sonyimageheight' => { 377 => 0x1a, 390 => 0x44, 391 => 0x3f, 392 => 0x47 },
	'sonyimageheightmax' => { 398 => 0x40 },
	'sonyimagesize' => { 166 => 0x3b, 359 => 0x54, 360 => 0x54, 361 => 0x9 },
	'sonyimagewidth' => { 377 => 0x1c },
	'sonyimagewidthmax' => { 398 => 0x3e },
	'sonyiso' => { 379 => 0x1218, 380 => 0x11f4, 381 => 0x1270, 382 => [0x1254,0x1258,0x1280], 383 => 0x113c, 384 => 0x344, 385 => 0x346, 386 => 0x320, 398 => 0x4 },
	'sonymaxaperturevalue' => { 398 => 0x16 },
	'sonymodelid' => { 371 => 0xb001 },
	'sonyquality' => { 166 => 0x3c },
	'sonytimeminsec' => { 389 => 0x61 },
	'source' => { 117 => 0x73, 274 => 'Source', 421 => 'source', 422 => 'source', 432 => 'Source' },
	'sourcecount' => { 409 => 'SourceCount' },
	'sourcedirectoryindex' => { 303 => 0x0 },
	'sourcefileindex' => { 303 => 0x2 },
	'sourcephotoscount' => { 408 => 'SourcePhotosCount' },
	'spatialfrequencyresponse' => { 424 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 424 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 424 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 424 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 424 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 444 => 'speakerPlacement' },
	'specialeffectlevel' => { 104 => 0x3030 },
	'specialeffectmode' => { 104 => 0x2076 },
	'specialeffectsetting' => { 104 => 0x3031 },
	'specialinstructions' => { 117 => 0x28 },
	'specialmode' => { 266 => 0x200, 350 => 0x200 },
	'specialoccasion' => { 436 => 'specialOccasion' },
	'spectralsensitivity' => { 109 => 0x8824, 424 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 40 => [0x2b9,0x2d0,0x2d4], 42 => 0x1e4, 43 => [0x1fd,0x2dd], 44 => [0x231,0x30f] },
	'speedx' => { 106 => 0x3 },
	'speedy' => { 106 => 0x4 },
	'speedz' => { 106 => 0x5 },
	'spherical' => { 409 => 'Spherical' },
	'splitcolumn' => { 325 => 0x222 },
	'splittoningbalance' => { 420 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 420 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 420 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 420 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 420 => 'SplitToningShadowSaturation' },
	'sport' => { 434 => 'sport' },
	'spotfocuspointx' => { 163 => 0x2d },
	'spotfocuspointy' => { 163 => 0x2e },
	'spotmeteringmode' => { 33 => 0x27 },
	'spotmeterlinktoafpoint' => { 75 => 0x107 },
	'sractive' => { 297 => '17.1' },
	'srawquality' => { 33 => 0x2e },
	'srfocallength' => { 318 => 0x3 },
	'srhalfpresstime' => { 318 => 0x2 },
	'srresult' => { 318 => 0x0, 319 => 0x0 },
	'stackedimage' => { 261 => 0x804 },
	'standardoutputhighlightpoint' => { 100 => 0x14 },
	'standardoutputsensitivity' => { 109 => 0x8831, 425 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 100 => 0x15 },
	'standardrawcolortone' => { 100 => 0xd },
	'standardrawcontrast' => { 100 => 0xf },
	'standardrawhighlight' => { 100 => 0x75 },
	'standardrawhighlightpoint' => { 100 => 0x12 },
	'standardrawlinear' => { 100 => 0x10 },
	'standardrawsaturation' => { 100 => 0xe },
	'standardrawshadow' => { 100 => 0x7e },
	'standardrawshadowpoint' => { 100 => 0x13 },
	'standardrawsharpness' => { 100 => 0x11 },
	'standardunsharpmaskfineness' => { 100 => 0x94 },
	'standardunsharpmaskstrength' => { 100 => 0x92 },
	'standardunsharpmaskthreshold' => { 100 => 0x96 },
	'standbytimer' => { 246 => '19.1', 248 => '19.1', 249 => '19.1', 252 => '18.1', 253 => '18.1', 258 => '19.1' },
	'startingpage' => { 434 => 'startingPage' },
	'startmovieshooting' => { 75 => 0x70d },
	'starttimecode' => { 444 => 'startTimecode' },
	'starttimecodetimeformat' => { 444 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 444 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 444 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 444 => 'startTimeSampleSize' },
	'starttimescale' => { 444 => 'startTimeScale' },
	'state' => { 144 => 'State', 282 => 0x6b, 432 => 'State' },
	'status' => { 405 => 'Status', 412 => 'Status' },
	'stereomode' => { 409 => 'StereoMode' },
	'stitched' => { 409 => 'Stitched' },
	'stitchingsoftware' => { 408 => 'StitchingSoftware', 409 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 378 => 0x113e, 379 => 0x113e, 380 => 0x111a, 381 => 0x1196, 382 => 0x1172, 383 => 0x102a, 384 => 0x222, 385 => 0x222, 386 => 0x217, 398 => 0xa },
	'storagemethod' => { 170 => 0x12 },
	'storebyorientation' => { 246 => '46.3', 248 => '47.3', 249 => '47.3', 258 => '47.3' },
	'storylineidentifier' => { 430 => 'StorylineIdentifier' },
	'straightenangle' => { 238 => 0x2fc08431 },
	'streamready' => { 430 => 'StreamReady' },
	'streamtype' => { 159 => 'StreamType' },
	'stretchmode' => { 444 => 'stretchMode' },
	'studydatetime' => { 404 => 'StudyDateTime' },
	'studydescription' => { 404 => 'StudyDescription' },
	'studyid' => { 404 => 'StudyID' },
	'studyphysician' => { 404 => 'StudyPhysician' },
	'styleperiod' => { 430 => 'StylePeriod' },
	'sub-location' => { 117 => 0x5c },
	'subfiledata' => { 147 => 'data' },
	'subfiledirectory' => { 147 => '1Directory' },
	'subfilemimetype' => { 147 => '2MIME' },
	'subfilename' => { 147 => '1Name' },
	'subfileresource' => { 147 => 'rsrc' },
	'subfiletype' => { 109 => 0xfe, 147 => '0Type' },
	'subject' => { 270 => 'Subject', 332 => 'Subject', 421 => 'subject', 431 => 'Subject', 445 => 'subject' },
	'subjectarea' => { 109 => 0x9214, 424 => 'SubjectArea' },
	'subjectcode' => { 429 => 'SubjectCode' },
	'subjectdistance' => { 109 => 0x9206, 125 => 0x3e, 424 => 'SubjectDistance' },
	'subjectdistancerange' => { 109 => 0xa40c, 424 => 'SubjectDistanceRange' },
	'subjectlocation' => { 109 => 0xa214, 424 => 'SubjectLocation' },
	'subjectmotion' => { 248 => '78.2', 249 => '78.2' },
	'subjectprogram' => { 163 => 0x22 },
	'subjectreference' => { 117 => 0xc },
	'sublabels4' => { 428 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 428 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublables1' => { 428 => [\'TagStructure','TagStructureSubLabels'] },
	'sublables2' => { 428 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublables3' => { 428 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'subseccreatedate' => { 105 => 'SubSecCreateDate' },
	'subsecdatetimeoriginal' => { 105 => 'SubSecDateTimeOriginal' },
	'subsecmodifydate' => { 105 => 'SubSecModifyDate' },
	'subsectime' => { 109 => 0x9290 },
	'subsectimedigitized' => { 109 => 0x9292 },
	'subsectimeoriginal' => { 109 => 0x9291 },
	'subsection1' => { 434 => 'subsection1' },
	'subsection2' => { 434 => 'subsection2' },
	'subsection3' => { 434 => 'subsection3' },
	'subsection4' => { 434 => 'subsection4' },
	'subselector' => { 246 => '49.1', 248 => '71.1', 249 => '71.1' },
	'subselectorassignment' => { 246 => '48.1' },
	'subselectorcenter' => { 248 => '72.1', 249 => '72.1' },
	'subselectorplusdials' => { 246 => '49.2', 248 => '73.1', 249 => '73.1' },
	'subtitle' => { 434 => 'subtitle' },
	'subversionfilename' => { 428 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 428 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 428 => 'SubVersions' },
	'superimposeddisplay' => { 73 => 0xa, 75 => 0x510, 76 => 0x9, 77 => 0xa, 80 => 0xa, 81 => 0xe },
	'supermacro' => { 57 => 0x1a },
	'supplementalcategories' => { 117 => 0x14, 432 => 'SupplementalCategories' },
	'supplementaltype' => { 119 => 0x37 },
	'supplementdisplayid' => { 434 => 'supplementDisplayID' },
	'supplementstartingpage' => { 434 => 'supplementStartingPage' },
	'supplementtitle' => { 434 => 'supplementTitle' },
	'supplychainsource' => { 430 => 'SupplyChainSource' },
	'supplychainsourceidentifier' => { 430 => [\'SupplyChainSource','SupplyChainSourceIdentifier'] },
	'supplychainsourcename' => { 430 => [\'SupplyChainSource','SupplyChainSourceName'] },
	'svisosetting' => { 297 => 0x14 },
	'swatchcoloranta' => { 449 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 449 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 449 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 449 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 449 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgray' => { 449 => [\'SwatchGroups','SwatchGroupsColorantsGray'] },
	'swatchcolorantgreen' => { 449 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 449 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 449 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 449 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 449 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 449 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 449 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 449 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 449 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 449 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 449 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 449 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 449 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 282 => 0x93, 361 => 0x33 },
	'sweeppanoramafieldofview' => { 282 => 0x94 },
	'sweeppanoramasize' => { 361 => 0x32 },
	'switchtoregisteredafpoint' => { 74 => 0x12, 75 => 0x50a },
	'syncreleasemode' => { 248 => '77.1', 249 => '77.1' },
	'system' => { 325 => 0x204 },
	'tagged' => { 327 => 0xdd, 328 => 'Tagged', 414 => 'tagged' },
	'tagslist' => { 423 => 'TagsList' },
	'tagstructure' => { 428 => 'TagStructure' },
	'takenumber' => { 444 => 'takeNumber' },
	'tapename' => { 444 => 'tapeName' },
	'targetaperture' => { 69 => 0x4 },
	'targetcompressionratio' => { 86 => 0x1 },
	'targetdistancesetting' => { 88 => 0x1807 },
	'targetexposuretime' => { 69 => 0x5 },
	'targetimagetype' => { 88 => 0x100a },
	'targetprinter' => { 109 => 0x151 },
	'taxon' => { 108 => 'Taxon' },
	'taxonacceptednameusage' => { 108 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 108 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 108 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 108 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxonfamily' => { 108 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 108 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 108 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 108 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 108 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 108 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 108 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 108 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 108 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 108 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 108 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 108 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 108 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 108 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 108 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 108 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 108 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 108 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 108 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 108 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 108 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 108 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 108 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 108 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 108 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 108 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 108 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 108 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 108 => [\'Taxon','TaxonVernacularName'] },
	'teaser' => { 434 => 'teaser' },
	'teleconverter' => { 168 => 0x105, 371 => 0x105 },
	'tempo' => { 444 => 'tempo' },
	'temporalcoverage' => { 430 => 'TemporalCoverage' },
	'temporalcoveragefrom' => { 430 => [\'TemporalCoverage','TemporalCoverageTempCoverageFrom'] },
	'temporalcoverageto' => { 430 => [\'TemporalCoverage','TemporalCoverageTempCoverageTo'] },
	'termsandconditionstext' => { 271 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 271 => 'TermsAndConditionsURL' },
	'testname' => { 110 => 'TestName' },
	'textencoding' => { 199 => 0x4 },
	'textlayername' => { 432 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 432 => 'TextLayers' },
	'textlayertext' => { 432 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 282 => [0x8008,0x8009,0x3b,0x3e] },
	'three-dtrackingfacedetection' => { 248 => '1.3', 249 => '1.3' },
	'three-dtrackingwatcharea' => { 248 => '78.1', 249 => '78.1' },
	'thresholding' => { 109 => 0x107 },
	'thumbnailfilename' => { 88 => 0x817 },
	'thumbnailformat' => { 442 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 127 => 0xfa55, 442 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 88 => 0x2008, 105 => 'ThumbnailImage', 112 => 0x3, 150 => 'data', 266 => 0x100, 442 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 150 => '1Name' },
	'thumbnailimagesize' => { 150 => 'ImageSize' },
	'thumbnailimagetype' => { 150 => '0Type' },
	'thumbnailimagevalidarea' => { 57 => 0x13 },
	'thumbnaillength' => { 109 => 0x202 },
	'thumbnailoffset' => { 109 => 0x201 },
	'thumbnails' => { 442 => 'Thumbnails' },
	'thumbnailwidth' => { 127 => 0xfa54, 442 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 434 => 'ticker' },
	'tiffhandling' => { 420 => 'TIFFHandling' },
	'tiffmeteringimage' => { 169 => 0x104c, 370 => 0x1110 },
	'tilelength' => { 109 => 0x143 },
	'tilewidth' => { 109 => 0x142 },
	'time' => { 123 => 0x401, 316 => 0x7 },
	'timecodes' => { 109 => 0xc763 },
	'timecreated' => { 117 => 0x3c, 125 => 0x14, 134 => 0x10, 328 => 'TimeCreated' },
	'timeperiod' => { 434 => 'timePeriod' },
	'timerfunctionbutton' => { 247 => '5.2', 250 => '12.1', 251 => '13.1' },
	'timerlength' => { 75 => 0x80c },
	'timerrecording' => { 282 => 0x96 },
	'timescaleparams' => { 444 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 444 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 444 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 444 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 118 => 0x50 },
	'timeshot' => { 410 => 'TimeShot' },
	'timesignature' => { 444 => 'timeSignature' },
	'timesincepoweron' => { 282 => 0x29 },
	'timestamp' => { 10 => 0x45e, 18 => 0x11c, 260 => 0x8, 274 => 'TimeStamp', 282 => 0xaf, 409 => 'Timestamp', 415 => 'Timestamp', 428 => 'TimeStamp' },
	'timestamp1' => { 10 => 0x45a },
	'timezone' => { 70 => 0x1, 230 => 0x0, 344 => 0xa },
	'timezonecity' => { 70 => 0x2 },
	'timezonecode' => { 91 => 0x1 },
	'timezoneinfo' => { 91 => 0x2 },
	'timezoneoffset' => { 109 => 0x882a },
	'tint' => { 420 => 'Tint' },
	'title' => { 140 => 'Title', 270 => 'Title', 274 => 'Title', 282 => 0x65, 332 => 'Title', 421 => 'title', 431 => 'Title', 442 => 'Title' },
	'tonecomp' => { 200 => 0x81 },
	'tonecurve' => { 67 => 0x1, 316 => 0x402, 420 => 'ToneCurve' },
	'tonecurveactive' => { 99 => 0x110 },
	'tonecurveadobergb' => { 348 => 0xa043 },
	'tonecurveadobergbdefault' => { 348 => 0xa041 },
	'tonecurveblue' => { 420 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 402 => 0x9003 },
	'tonecurvebluey' => { 402 => 0x9007 },
	'tonecurvebrightness' => { 94 => 0x20410 },
	'tonecurvebrightnessx' => { 402 => 0x9000 },
	'tonecurvebrightnessy' => { 402 => 0x9004 },
	'tonecurvecolorspace' => { 98 => 0x0 },
	'tonecurvecontrast' => { 94 => 0x20411 },
	'tonecurvefilename' => { 123 => 0x1391 },
	'tonecurvegreen' => { 420 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 402 => 0x9002 },
	'tonecurvegreeny' => { 402 => 0x9006 },
	'tonecurveinputrange' => { 98 => 0x3 },
	'tonecurveinterpolation' => { 99 => 0x159 },
	'tonecurvemode' => { 99 => 0x113 },
	'tonecurvename' => { 420 => 'ToneCurveName' },
	'tonecurvename2012' => { 420 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 94 => '0x20400.1' },
	'tonecurveoutputrange' => { 98 => 0x5 },
	'tonecurveproperty' => { 99 => 0x3c },
	'tonecurvepv2012' => { 420 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 420 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 420 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 420 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 420 => 'ToneCurveRed' },
	'tonecurveredx' => { 402 => 0x9001 },
	'tonecurveredy' => { 402 => 0x9005 },
	'tonecurves' => { 316 => 0x403 },
	'tonecurveshape' => { 98 => 0x1 },
	'tonecurvesrgb' => { 348 => 0xa042 },
	'tonecurvesrgbdefault' => { 348 => 0xa040 },
	'tonecurvex' => { 98 => 0xa },
	'tonecurvey' => { 98 => 0xb },
	'tonelevel' => { 261 => 0x52e },
	'tonemapstrength' => { 420 => 'ToneMapStrength' },
	'toningeffect' => { 51 => 0xf, 200 => 0xb3, 202 => 0x38, 203 => 0x40, 341 => 0x1015 },
	'toningeffectauto' => { 64 => 0xa4 },
	'toningeffectfaithful' => { 63 => 0x74, 64 => 0x74 },
	'toningeffectlandscape' => { 63 => 0x44, 64 => 0x44 },
	'toningeffectmonochrome' => { 18 => 0x108, 63 => 0x8c, 64 => 0x8c },
	'toningeffectneutral' => { 63 => 0x5c, 64 => 0x5c },
	'toningeffectportrait' => { 63 => 0x2c, 64 => 0x2c },
	'toningeffectstandard' => { 63 => 0x14, 64 => 0x14 },
	'toningeffectuserdef1' => { 63 => 0xa4, 64 => 0xbc },
	'toningeffectuserdef2' => { 63 => 0xbc, 64 => 0xd4 },
	'toningeffectuserdef3' => { 63 => 0xd4, 64 => 0xec },
	'toningsaturation' => { 202 => 0x39, 203 => 0x41 },
	'totalzoom' => { 125 => 0x62 },
	'touchae' => { 282 => 0xab },
	'trackcreatedate' => { 336 => 0x1 },
	'trackmodifydate' => { 336 => 0x2 },
	'tracknumber' => { 444 => 'trackNumber' },
	'tracks' => { 444 => 'Tracks' },
	'tracksframerate' => { 444 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 444 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 444 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 444 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 444 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 444 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 444 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 444 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 444 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 444 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 444 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 444 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 444 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 444 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 444 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 444 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 444 => [\'Tracks','TracksTrackType'] },
	'trailersignature' => { 147 => 'zmie' },
	'transcript' => { 430 => 'Transcript' },
	'transcriptlink' => { 430 => 'TranscriptLink' },
	'transcriptlinklink' => { 430 => [\'TranscriptLink','TranscriptLinkLink'] },
	'transcriptlinklinkqualifier' => { 430 => [\'TranscriptLink','TranscriptLinkLinkQualifier'] },
	'transferfunction' => { 109 => 0x12d, 440 => 'TransferFunction' },
	'transform' => { 282 => [0x8012,0x59] },
	'transmissionreference' => { 432 => 'TransmissionReference' },
	'trapped' => { 270 => 'Trapped', 431 => 'Trapped' },
	'trashbuttonfunction' => { 75 => 0x710 },
	'travelday' => { 282 => 0x36 },
	'triggermode' => { 337 => 0x6 },
	'tstop' => { 109 => 0xc772 },
	'ttl_da_adown' => { 304 => 0x5 },
	'ttl_da_aup' => { 304 => 0x4 },
	'ttl_da_bdown' => { 304 => 0x7 },
	'ttl_da_bup' => { 304 => 0x6 },
	'tungstenawb' => { 294 => 0x1 },
	'tvexposuretimesetting' => { 297 => 0x12 },
	'type' => { 421 => 'type', 439 => 'type' },
	'typestatus' => { 108 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 109 => 0xc614 },
	'uniquedocumentid' => { 117 => 0xbb },
	'uniqueobjectname' => { 118 => 0x64 },
	'unknownblock' => { 316 => 0x405 },
	'unknownblock1' => { 265 => 0x635 },
	'unknownblock2' => { 265 => 0x636 },
	'unknownblock3' => { 265 => 0x1103 },
	'unknownblock4' => { 265 => 0x1104 },
	'unknowncontrast' => { 100 => 0x45 },
	'unknowndate' => { 325 => 0x212 },
	'unknownev' => { 123 => 0x1 },
	'unknownlinear' => { 100 => 0x46 },
	'unknownnumber' => { 88 => 0x180b },
	'unknownoutputhighlightpoint' => { 100 => 0x4a },
	'unknownoutputshadowpoint' => { 100 => 0x4b },
	'unknownrawhighlight' => { 100 => 0x7b },
	'unknownrawhighlightpoint' => { 100 => 0x48 },
	'unknownrawshadow' => { 100 => 0x84 },
	'unknownrawshadowpoint' => { 100 => 0x49 },
	'unknownsharpness' => { 100 => 0x47 },
	'unknowntemperature' => { 111 => 0x4 },
	'unsharp1color' => { 243 => 0x13 },
	'unsharp1halowidth' => { 243 => 0x19 },
	'unsharp1intensity' => { 243 => 0x17 },
	'unsharp1threshold' => { 243 => 0x1b },
	'unsharp2color' => { 243 => 0x2e },
	'unsharp2halowidth' => { 243 => 0x34 },
	'unsharp2intensity' => { 243 => 0x32 },
	'unsharp2threshold' => { 243 => 0x36 },
	'unsharp3color' => { 243 => 0x49 },
	'unsharp3halowidth' => { 243 => 0x4f },
	'unsharp3intensity' => { 243 => 0x4d },
	'unsharp3threshold' => { 243 => 0x51 },
	'unsharp4color' => { 243 => 0x64 },
	'unsharp4halowidth' => { 243 => 0x6a },
	'unsharp4intensity' => { 243 => 0x68 },
	'unsharp4threshold' => { 243 => 0x6c },
	'unsharpcount' => { 243 => 0x0 },
	'unsharpmask' => { 100 => 0x90, 238 => 0x76a43200 },
	'unsharpmaskfineness' => { 94 => 0x20309 },
	'unsharpmaskstrength' => { 94 => 0x20308 },
	'unsharpmaskthreshold' => { 94 => 0x2030a },
	'uprightcentermode' => { 420 => 'UprightCenterMode' },
	'uprightcenternormx' => { 420 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 420 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 420 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 420 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 420 => 'UprightFocalMode' },
	'uprightfoursegmentscount' => { 420 => 'UprightFourSegmentsCount' },
	'uprightpreview' => { 420 => 'UprightPreview' },
	'uprighttransform_0' => { 420 => 'UprightTransform_0' },
	'uprighttransform_1' => { 420 => 'UprightTransform_1' },
	'uprighttransform_2' => { 420 => 'UprightTransform_2' },
	'uprighttransform_3' => { 420 => 'UprightTransform_3' },
	'uprighttransform_4' => { 420 => 'UprightTransform_4' },
	'uprighttransform_5' => { 420 => 'UprightTransform_5' },
	'uprighttransformcount' => { 420 => 'UprightTransformCount' },
	'uprightversion' => { 420 => 'UprightVersion' },
	'urgency' => { 117 => 0xa, 432 => 'Urgency' },
	'url' => { 140 => 'URL', 274 => 'URL', 330 => 0x40b, 434 => 'url' },
	'url_list' => { 330 => 0x41e },
	'urla-platform' => { 434 => [\'url','urlA-platform'] },
	'urlurl' => { 434 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 75 => 0x10a },
	'usableshootingmodes' => { 75 => 0x109 },
	'usage' => { 435 => 'usage' },
	'usageterms' => { 448 => 'UsageTerms' },
	'useguidelines' => { 417 => 'useGuidelines' },
	'usepanoramaviewer' => { 408 => 'UsePanoramaViewer' },
	'usercomment' => { 88 => 0x805, 109 => 0x9286, 424 => 'UserComment' },
	'userdef1picturestyle' => { 18 => 0x10c, 63 => 0xd8, 64 => 0xf0 },
	'userdef2picturestyle' => { 18 => 0x10e, 63 => 0xda, 64 => 0xf2 },
	'userdef3picturestyle' => { 18 => 0x110, 63 => 0xdc, 64 => 0xf4 },
	'userfields' => { 412 => 'UserFields' },
	'userlabel' => { 337 => 0x2b },
	'userprofile' => { 278 => 0x302, 284 => 0x3038 },
	'usmlenselectronicmf' => { 2 => 0x7, 74 => 0x7, 75 => 0x501 },
	'uspsnumber' => { 434 => 'uspsNumber' },
	'utmeasting' => { 151 => 'Easting' },
	'utmmapdatum' => { 151 => 'Datum' },
	'utmnorthing' => { 151 => 'Northing' },
	'utmzone' => { 151 => 'Zone' },
	'uv-irfiltercorrection' => { 278 => 0x325 },
	'validbits' => { 265 => 0x611, 266 => 0x102c },
	'validpixeldepth' => { 269 => 0x611 },
	'variablelowpassfilter' => { 371 => 0x2028 },
	'variousmodes' => { 125 => 0x26 },
	'variousmodes2' => { 125 => 0x3a },
	'variprogram' => { 200 => 0xab },
	'version' => { 114 => 0x0, 332 => 'Version', 420 => 'Version' },
	'versioncreatedate' => { 402 => 0xd100 },
	'versionid' => { 445 => 'VersionID' },
	'versionidentifier' => { 434 => 'versionIdentifier' },
	'versionmodifydate' => { 402 => 0xd101 },
	'versions' => { 445 => 'Versions' },
	'versionscomments' => { 445 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 445 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 445 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 445 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 445 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 445 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 445 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 445 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 445 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 445 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 445 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 245 => '3.2', 246 => '47.2', 248 => '79.1' },
	'verticalfuncbutton' => { 246 => '42.2', 248 => '67.1' },
	'verticalfuncbuttonplusdials' => { 246 => '43.1' },
	'verticalfuncplusdials' => { 248 => '68.1' },
	'verticalmultiselector' => { 246 => '42.1', 248 => '66.1', 249 => '66.1' },
	'vfdisplayillumination' => { 2 => 0x11, 75 => [0x510,0x51d] },
	'vibrance' => { 413 => 'Vibrance', 420 => 'Vibrance' },
	'vibrationreduction' => { 208 => [0x75,0x82,0x1ae], 216 => '586.1', 224 => '590.2', 229 => 0x4 },
	'videoalphamode' => { 444 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 444 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 444 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 444 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 444 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 444 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 444 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgray' => { 444 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGray'] },
	'videoalphapremultiplecolorgreen' => { 444 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 444 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 444 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 444 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 444 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 444 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 444 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 444 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 444 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 444 => 'videoAlphaUnityIsTransparent' },
	'videobitrate' => { 430 => 'videoBitRate' },
	'videobitratemode' => { 430 => 'videoBitRateMode' },
	'videocodec' => { 60 => 0x74 },
	'videocolorspace' => { 444 => 'videoColorSpace' },
	'videocompressor' => { 444 => 'videoCompressor' },
	'videodisplayaspectratio' => { 430 => 'videoDisplayAspectRatio' },
	'videoencodingprofile' => { 430 => 'videoEncodingProfile' },
	'videofieldorder' => { 444 => 'videoFieldOrder' },
	'videoframerate' => { 444 => 'videoFrameRate' },
	'videoframesize' => { 444 => 'videoFrameSize' },
	'videoframesizeh' => { 444 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 444 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 444 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 444 => 'videoModDate' },
	'videopixelaspectratio' => { 444 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 444 => 'videoPixelDepth' },
	'videoquality' => { 104 => 0x4003 },
	'videoshottype' => { 430 => 'VideoShotType' },
	'videoshottypeidentifier' => { 430 => [\'VideoShotType','VideoShotTypeIdentifier'] },
	'videoshottypename' => { 430 => [\'VideoShotType','VideoShotTypeName'] },
	'videostreamscount' => { 430 => 'videoStreamsCount' },
	'viewfinder' => { 325 => 0x455 },
	'viewfinderdisplay' => { 245 => '12.4', 246 => '6.3' },
	'viewfinderwarning' => { 245 => '13.4', 255 => '3.5', 256 => '6.2', 259 => '4.4' },
	'viewfinderwarnings' => { 75 => 0x40a },
	'viewinfoduringexposure' => { 75 => 0x407 },
	'viewingmode' => { 361 => 0x2f, 375 => 0x18 },
	'viewingmode2' => { 361 => [0x85,0x285] },
	'viewpoint' => { 433 => 'viewpoint' },
	'vignetteamount' => { 420 => 'VignetteAmount' },
	'vignettecontrol' => { 200 => 0x2a, 238 => 0x76a43205 },
	'vignettecontrolintensity' => { 238 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 416 => 'VignetteCorrectionAlreadyApplied' },
	'vignettemidpoint' => { 420 => 'VignetteMidpoint' },
	'vignetting' => { 341 => 0x1011, 348 => 0xa052 },
	'vignettingcorrection' => { 348 => 0xa053, 371 => 0x2011 },
	'vignettingcorrparams' => { 109 => 0x7032, 397 => 0x64a, 398 => [0x34a,0x350,0x35c,0x368] },
	'vignettingsetting' => { 348 => 0xa054 },
	'visualcolor' => { 430 => 'VisualColour' },
	'visualtechnique' => { 433 => 'visualTechnique' },
	'voicememo' => { 350 => 0x216 },
	'volume' => { 434 => 'volume' },
	'vr_0x66' => { 208 => 0x66 },
	'vrdoffset' => { 57 => 0xd0 },
	'vrmode' => { 229 => 0x6 },
	'waterdepth' => { 109 => 0x9403 },
	'wb_bluelevel3500k' => { 169 => 0x19a },
	'wb_bluelevel6500k' => { 169 => 0x18a },
	'wb_bluelevelcustom' => { 169 => 0x18e },
	'wb_bluelevelscloudy' => { 169 => 0x106 },
	'wb_bluelevelsdaylight' => { 169 => 0xea },
	'wb_bluelevelsflash' => { 169 => 0x122 },
	'wb_bluelevelsfluorescent' => { 169 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 169 => 0x254 },
	'wb_bluelevelsshade' => { 169 => 0x176 },
	'wb_bluelevelstungsten' => { 169 => 0xce },
	'wb_gbrglevels' => { 169 => 0xae, 172 => 0x4 },
	'wb_glevel' => { 265 => 0x11f },
	'wb_glevel3000k' => { 265 => 0x113 },
	'wb_glevel3300k' => { 265 => 0x114 },
	'wb_glevel3600k' => { 265 => 0x115 },
	'wb_glevel3900k' => { 265 => 0x116 },
	'wb_glevel4000k' => { 265 => 0x117 },
	'wb_glevel4300k' => { 265 => 0x118 },
	'wb_glevel4500k' => { 265 => 0x119 },
	'wb_glevel4800k' => { 265 => 0x11a },
	'wb_glevel5300k' => { 265 => 0x11b },
	'wb_glevel6000k' => { 265 => 0x11c },
	'wb_glevel6600k' => { 265 => 0x11d },
	'wb_glevel7500k' => { 265 => 0x11e },
	'wb_grbglevels' => { 182 => 0x0 },
	'wb_rbgglevels' => { 179 => 0x0 },
	'wb_rblevels' => { 200 => 0xc, 265 => 0x100 },
	'wb_rblevels1' => { 287 => 0x2 },
	'wb_rblevels2' => { 287 => 0x5 },
	'wb_rblevels3' => { 287 => 0x8 },
	'wb_rblevels3000k' => { 265 => 0x102 },
	'wb_rblevels3300k' => { 265 => 0x103 },
	'wb_rblevels3500k' => { 169 => 0x430 },
	'wb_rblevels3600k' => { 265 => 0x104 },
	'wb_rblevels3900k' => { 265 => 0x105 },
	'wb_rblevels4' => { 287 => 0xb },
	'wb_rblevels4000k' => { 265 => 0x106 },
	'wb_rblevels4300k' => { 265 => 0x107 },
	'wb_rblevels4500k' => { 265 => 0x108 },
	'wb_rblevels4800k' => { 265 => 0x109 },
	'wb_rblevels5' => { 287 => 0xe },
	'wb_rblevels5300k' => { 265 => 0x10a },
	'wb_rblevels6' => { 287 => 0x11 },
	'wb_rblevels6000k' => { 265 => 0x10b },
	'wb_rblevels6500k' => { 169 => 0x420 },
	'wb_rblevels6600k' => { 265 => 0x10c },
	'wb_rblevels7' => { 287 => 0x14 },
	'wb_rblevels7500k' => { 265 => 0x10d },
	'wb_rblevelsauto' => { 269 => 0x110 },
	'wb_rblevelscloudy' => { 169 => 0x3f0, 171 => 0x10, 269 => 0x121 },
	'wb_rblevelscoolwhitef' => { 169 => 0x308, 171 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 269 => 0x132 },
	'wb_rblevelscustom' => { 169 => 0x424 },
	'wb_rblevelscwb1' => { 265 => 0x10e },
	'wb_rblevelscwb2' => { 265 => 0x10f },
	'wb_rblevelscwb3' => { 265 => 0x110 },
	'wb_rblevelscwb4' => { 265 => 0x111 },
	'wb_rblevelsdaylight' => { 169 => [0x3ec,0x528], 171 => 0xc },
	'wb_rblevelsdaylightf' => { 171 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 269 => 0x130 },
	'wb_rblevelsdaywhitef' => { 171 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 269 => 0x131 },
	'wb_rblevelseveningsunlight' => { 269 => 0x124 },
	'wb_rblevelsfineweather' => { 269 => 0x122 },
	'wb_rblevelsflash' => { 169 => [0x3f4,0x304], 171 => 0x18 },
	'wb_rblevelsshade' => { 169 => 0x418, 171 => 0x20, 269 => 0x120 },
	'wb_rblevelstungsten' => { 169 => 0x3e8, 171 => 0x8, 269 => 0x123 },
	'wb_rblevelsunknown' => { 171 => 0x1c },
	'wb_rblevelsused' => { 269 => 0x100 },
	'wb_rblevelswhitef' => { 171 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 269 => 0x133 },
	'wb_redlevel3500k' => { 169 => 0x198 },
	'wb_redlevel6500k' => { 169 => 0x188 },
	'wb_redlevelcustom' => { 169 => 0x18c },
	'wb_redlevelscloudy' => { 169 => 0xf8 },
	'wb_redlevelsdaylight' => { 169 => 0xdc },
	'wb_redlevelsflash' => { 169 => 0x114 },
	'wb_redlevelsfluorescent' => { 169 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 169 => 0x1be },
	'wb_redlevelsshade' => { 169 => 0x168 },
	'wb_redlevelstungsten' => { 169 => 0xc0 },
	'wb_rgbglevels' => { 181 => 0x0 },
	'wb_rgblevels' => { 169 => [0x546,0x96], 279 => 0xd, 280 => 0x413, 284 => 0x3036, 325 => 0x107, 378 => 0x117c, 379 => 0x1180, 380 => 0x115c, 381 => 0x11d8, 382 => 0x11b4, 383 => 0x106c, 384 => 0x264, 385 => 0x264, 386 => 0x252 },
	'wb_rgblevels1' => { 288 => 0x2 },
	'wb_rgblevels2' => { 288 => 0x6 },
	'wb_rgblevels3' => { 288 => 0xa },
	'wb_rgblevels4' => { 288 => 0xe },
	'wb_rgblevels5' => { 288 => 0x12 },
	'wb_rgblevels6' => { 288 => 0x16 },
	'wb_rgblevels7' => { 288 => 0x1a },
	'wb_rggbblacklevels' => { 34 => 0x25 },
	'wb_rggblevels' => { 172 => 0x4, 180 => 0x0 },
	'wb_rggblevelsasshot' => { 36 => 0x0, 37 => 0x19, 38 => 0x22, 39 => 0x3f, 42 => 0x3f, 43 => 0x3f, 44 => 0x3f },
	'wb_rggblevelsauto' => { 34 => 0x1, 36 => 0x5, 37 => 0x1e, 38 => 0x18, 39 => 0x44, 42 => 0x44, 43 => 0x44, 44 => 0x44, 348 => 0xa022 },
	'wb_rggblevelsblack' => { 348 => 0xa028 },
	'wb_rggblevelscloudy' => { 34 => 0xd, 36 => 0x1e, 37 => 0x2d, 38 => 0x31, 39 => 0x58, 42 => 0x71, 43 => 0x8a, 44 => 0x8f, 316 => 0x20f, 324 => 0x14 },
	'wb_rggblevelscustom' => { 34 => 0x1d, 39 => 0x80 },
	'wb_rggblevelscustom1' => { 37 => 0x41 },
	'wb_rggblevelscustom2' => { 37 => 0x46 },
	'wb_rggblevelsdaylight' => { 34 => 0x5, 36 => 0x14, 37 => 0x23, 38 => 0x27, 39 => 0x4e, 42 => 0x67, 43 => 0x80, 44 => 0x85, 316 => 0x20d, 324 => 0x2 },
	'wb_rggblevelsflash' => { 34 => 0x19, 36 => 0x32, 37 => 0x3c, 38 => 0x45, 39 => 0x6c, 42 => 0x85, 43 => 0x9e, 44 => 0xa3, 316 => 0x214, 324 => 0x41 },
	'wb_rggblevelsfluorescent' => { 34 => 0x15, 36 => 0x28, 37 => 0x37, 38 => 0x3b, 39 => 0x62, 42 => 0x7b, 43 => 0x94, 44 => 0x99 },
	'wb_rggblevelsfluorescentd' => { 316 => 0x211, 324 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 324 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 316 => 0x212, 324 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 316 => 0x213, 324 => 0x38 },
	'wb_rggblevelsilluminator1' => { 348 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 348 => 0xa024 },
	'wb_rggblevelskelvin' => { 34 => 0x21, 36 => 0x2d, 38 => 0x40, 39 => 0x67, 42 => 0x80, 43 => 0x99, 44 => 0x9e },
	'wb_rggblevelsmeasured' => { 36 => 0xa, 39 => 0x49, 42 => 0x49, 43 => 0x49, 44 => 0x49 },
	'wb_rggblevelspc1' => { 38 => 0x90, 39 => 0x71 },
	'wb_rggblevelspc2' => { 38 => 0x95, 39 => 0x76 },
	'wb_rggblevelspc3' => { 38 => 0x9a, 39 => 0x7b },
	'wb_rggblevelsshade' => { 34 => 0x9, 36 => 0x19, 37 => 0x28, 38 => 0x2c, 39 => 0x53, 42 => 0x6c, 43 => 0x85, 44 => 0x8a, 316 => 0x20e, 324 => 0xb },
	'wb_rggblevelstungsten' => { 34 => 0x11, 36 => 0x23, 37 => 0x32, 38 => 0x36, 39 => 0x5d, 42 => 0x76, 43 => 0x8f, 44 => 0x94, 316 => 0x210, 324 => 0x1d },
	'wb_rggblevelsuncorrected' => { 348 => 0xa021 },
	'wb_rggblevelsunknown' => { 36 => 0xf, 38 => 0x1d, 42 => 0x4e, 43 => 0x4e, 44 => 0x4e, 324 => 0x53 },
	'wb_rggblevelsunknown10' => { 36 => 0x5f, 38 => 0x72, 42 => 0x9e, 43 => 0x7b, 44 => 0x7b },
	'wb_rggblevelsunknown11' => { 36 => 0x64, 38 => 0x77, 42 => 0xa3, 43 => 0xa3, 44 => 0x80 },
	'wb_rggblevelsunknown12' => { 36 => 0x69, 38 => 0x7c, 42 => 0xa8, 43 => 0xa8, 44 => 0xa8 },
	'wb_rggblevelsunknown13' => { 36 => 0x6e, 38 => 0x81, 42 => 0xad, 43 => 0xad, 44 => 0xad },
	'wb_rggblevelsunknown14' => { 38 => 0x86, 42 => 0xb2, 43 => 0xb2, 44 => 0xb2 },
	'wb_rggblevelsunknown15' => { 38 => 0x8b, 42 => 0xb7, 43 => 0xb7, 44 => 0xb7 },
	'wb_rggblevelsunknown16' => { 38 => 0x9f, 43 => 0xbc, 44 => 0xbc },
	'wb_rggblevelsunknown17' => { 43 => 0xc1, 44 => 0xc1 },
	'wb_rggblevelsunknown18' => { 43 => 0xc6, 44 => 0xc6 },
	'wb_rggblevelsunknown19' => { 43 => 0xcb, 44 => 0xcb },
	'wb_rggblevelsunknown2' => { 36 => 0x37, 38 => 0x4a, 42 => 0x53, 43 => 0x53, 44 => 0x53 },
	'wb_rggblevelsunknown20' => { 43 => 0xd0, 44 => 0xd0 },
	'wb_rggblevelsunknown21' => { 44 => 0xd5 },
	'wb_rggblevelsunknown22' => { 44 => 0xda },
	'wb_rggblevelsunknown23' => { 44 => 0xdf },
	'wb_rggblevelsunknown24' => { 44 => 0xe4 },
	'wb_rggblevelsunknown25' => { 44 => 0xe9 },
	'wb_rggblevelsunknown26' => { 44 => 0xee },
	'wb_rggblevelsunknown27' => { 44 => 0xf3 },
	'wb_rggblevelsunknown28' => { 44 => 0xf8 },
	'wb_rggblevelsunknown29' => { 44 => 0xfd },
	'wb_rggblevelsunknown3' => { 36 => 0x3c, 38 => 0x4f, 42 => 0x58, 43 => 0x58, 44 => 0x58 },
	'wb_rggblevelsunknown30' => { 44 => 0x102 },
	'wb_rggblevelsunknown4' => { 36 => 0x41, 38 => 0x54, 42 => 0x5d, 43 => 0x5d, 44 => 0x5d },
	'wb_rggblevelsunknown5' => { 36 => 0x46, 38 => 0x59, 42 => 0x62, 43 => 0x62, 44 => 0x62 },
	'wb_rggblevelsunknown6' => { 36 => 0x4b, 38 => 0x5e, 42 => 0x8a, 43 => 0x67, 44 => 0x67 },
	'wb_rggblevelsunknown7' => { 36 => 0x50, 38 => 0x63, 42 => 0x8f, 43 => 0x6c, 44 => 0x6c },
	'wb_rggblevelsunknown8' => { 36 => 0x55, 38 => 0x68, 42 => 0x94, 43 => 0x71, 44 => 0x71 },
	'wb_rggblevelsunknown9' => { 36 => 0x5a, 38 => 0x6d, 42 => 0x99, 43 => 0x76, 44 => 0x76 },
	'wb_rggblevelsuserselected' => { 324 => 0x5c },
	'wbadjblueamber' => { 94 => 0x20106 },
	'wbadjbluebalance' => { 244 => 0x8 },
	'wbadjcolortemp' => { 94 => 0x20102, 99 => 0x1a },
	'wbadjlighting' => { 244 => 0x14 },
	'wbadjmagentagreen' => { 94 => 0x20105 },
	'wbadjmode' => { 244 => 0x10 },
	'wbadjredbalance' => { 244 => 0x0 },
	'wbadjrggblevels' => { 94 => 0x20125, 99 => 0x6 },
	'wbadjtemperature' => { 244 => 0x18 },
	'wbadjtint' => { 244 => 0x25 },
	'wbbluelevel' => { 278 => 0x324, 282 => 0x8006, 286 => 0x26 },
	'wbbracketingsteps' => { 217 => 0x174d, 218 => 0x87c, 226 => 0x1757 },
	'wbbracketmode' => { 51 => 0x9 },
	'wbbracketshotnumber' => { 169 => 0x2b, 341 => 0x101a },
	'wbbracketvalueab' => { 51 => 0xc },
	'wbbracketvaluegm' => { 51 => 0xd },
	'wbfinetuneactive' => { 99 => 0x24 },
	'wbfinetunesaturation' => { 99 => 0x28 },
	'wbfinetunetone' => { 99 => 0x2c },
	'wbgreenlevel' => { 278 => 0x323, 282 => 0x8005, 286 => 0x25 },
	'wbmediaimagesizesetting' => { 75 => 0x708 },
	'wbmode' => { 171 => 0x4, 266 => 0x1015 },
	'wbredlevel' => { 278 => 0x322, 282 => 0x8004, 286 => 0x24 },
	'wbscale' => { 172 => 0x0 },
	'wbshiftab' => { 67 => 0xc, 282 => 0x46, 298 => 0x10 },
	'wbshiftab_gm' => { 371 => 0x2014 },
	'wbshiftab_gm_precise' => { 371 => 0x2026 },
	'wbshiftgm' => { 67 => 0xd, 282 => 0x47, 298 => 0x11 },
	'wbtype1' => { 287 => 0x1, 288 => 0x1 },
	'wbtype2' => { 287 => 0x4, 288 => 0x5 },
	'wbtype3' => { 287 => 0x7, 288 => 0x9 },
	'wbtype4' => { 287 => 0xa, 288 => 0xd },
	'wbtype5' => { 287 => 0xd, 288 => 0x11 },
	'wbtype6' => { 287 => 0x10, 288 => 0x15 },
	'wbtype7' => { 287 => 0x13, 288 => 0x19 },
	'webstatement' => { 448 => 'WebStatement' },
	'what' => { 420 => 'What' },
	'whitebalance' => { 6 => 0x6f, 7 => [0x44,0x4a], 8 => 0xbc, 9 => 0x36, 10 => 0x5e, 11 => 0x36, 12 => 0x78, 13 => 0x6f, 14 => 0x6f, 15 => 0x73, 16 => 0x6f, 17 => 0x78, 18 => 0x54, 19 => 0x6f, 20 => 0xbc, 21 => 0x7b, 23 => 0xbc, 24 => 0xc2, 26 => 0x131, 27 => 0x77, 67 => 0x8, 69 => 0x7, 103 => 0x7, 104 => [0x19,0x2012], 109 => [0xa403,0xfe4e], 114 => 0x1002, 123 => 0x3fc, 124 => 0xfa0d, 125 => 0x40, 163 => 0x3, 164 => 0xe, 165 => 0x4, 166 => 0xb, 168 => 0x115, 200 => 0x5, 228 => 0x7, 278 => 0x304, 282 => 0x3, 284 => 0x3033, 316 => 0x19, 323 => 0x7, 340 => 0x26, 341 => 0x1003, 351 => [0x3c,0x7,0x58], 359 => 0xf, 360 => 0xe, 371 => [0x115,0xb054], 420 => 'WhiteBalance', 424 => 'WhiteBalance' },
	'whitebalance0' => { 159 => 'WhiteBalance0' },
	'whitebalance1' => { 159 => 'WhiteBalance1' },
	'whitebalance2' => { 159 => 'WhiteBalance2', 261 => 0x500 },
	'whitebalanceadj' => { 94 => 0x20101, 99 => 0x18, 238 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 294 => 0x0 },
	'whitebalancebias' => { 104 => 0x2011, 266 => 0x304, 282 => 0x23 },
	'whitebalanceblue' => { 67 => 0x7 },
	'whitebalancebracket' => { 261 => 0x502, 266 => 0x303 },
	'whitebalancebracketing' => { 166 => 0x22, 169 => 0x2c, 370 => 0x2c },
	'whitebalancecomp' => { 269 => 0x1001 },
	'whitebalancefinetune' => { 114 => 0x100a, 166 => 0x38, 168 => 0x112, 200 => 0xb, 341 => 0x1004, 359 => 0x6, 360 => 0x5, 371 => 0x112 },
	'whitebalancemode' => { 316 => 0x1a },
	'whitebalancered' => { 67 => 0x6 },
	'whitebalanceset' => { 297 => 0xa },
	'whitebalancesetting' => { 166 => 0x23, 359 => 0x5, 360 => 0x4, 361 => 0x16, 375 => 0xd },
	'whitebalancesetup' => { 348 => 0x41 },
	'whitebalancetemperature' => { 261 => 0x501 },
	'whiteboard' => { 266 => 0x301 },
	'whitelevel' => { 109 => 0xc61d, 316 => 0x7e },
	'whitepoint' => { 109 => 0x13e, 316 => 0x201, 440 => 'WhitePoint' },
	'whites2012' => { 420 => 'Whites2012' },
	'wideadapter' => { 341 => 0x1017 },
	'widefocuszone' => { 163 => 0x2f },
	'widerange' => { 350 => 0x20f },
	'windowsatom' => { 419 => 'windowsAtom' },
	'windowsatomextension' => { 419 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 419 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 419 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 434 => 'wordCount' },
	'workcolorspace' => { 94 => 0x10200, 99 => 0x270 },
	'workflowtag' => { 430 => 'WorkflowTag' },
	'workflowtagcvid' => { 430 => [\'WorkflowTag','WorkflowTagCvId'] },
	'workflowtagcvtermid' => { 430 => [\'WorkflowTag','WorkflowTagCvTermId'] },
	'workflowtagcvtermname' => { 430 => [\'WorkflowTag','WorkflowTagCvTermName'] },
	'workflowtagcvtermrefinedabout' => { 430 => [\'WorkflowTag','WorkflowTagCvTermRefinedAbout'] },
	'worktodo' => { 426 => 'WorkToDo' },
	'worldtimelocation' => { 282 => 0x3a, 316 => 0x22, 322 => '0.1' },
	'writer-editor' => { 117 => 0x7a },
	'x3filllight' => { 351 => 0x12 },
	'xattrquarantine' => { 157 => 'com.apple.quarantine' },
	'xml' => { 121 => 'xml ' },
	'xmp' => { 97 => 0xffff00f6, 110 => 'XMP' },
	'xmptoolkit' => { 441 => 'xmptk' },
	'xpauthor' => { 109 => 0x9c9d },
	'xpcomment' => { 109 => 0x9c9c },
	'xpkeywords' => { 109 => 0x9c9e },
	'xposition' => { 109 => 0x11e },
	'xpsubject' => { 109 => 0x9c9f },
	'xptitle' => { 109 => 0x9c9b },
	'xresolution' => { 109 => 0x11a, 120 => 0x3, 331 => 0x0, 440 => 'XResolution' },
	'xyresolution' => { 113 => 0x3 },
	'yaw' => { 106 => 0x7 },
	'yawangle' => { 217 => 0x3513, 226 => 0x36fc, 346 => 0x0 },
	'ycbcrcoefficients' => { 109 => 0x211, 440 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 109 => 0x213, 440 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 109 => 0x212, 440 => 'YCbCrSubSampling' },
	'yearcreated' => { 125 => 0x10, 134 => 0xc },
	'yield' => { 436 => 'yield' },
	'yposition' => { 109 => 0x11f },
	'yresolution' => { 109 => 0x11b, 120 => 0x5, 331 => 0x4, 440 => 'YResolution' },
	'zonematching' => { 168 => 0x10a, 171 => [0x3a,0x4a], 371 => 0xb024 },
	'zonematchingmode' => { 166 => 0x14 },
	'zonematchingon' => { 165 => 0x75 },
	'zonematchingvalue' => { 359 => 0x1f },
	'zoomedpreviewlength' => { 266 => 0xf05 },
	'zoomedpreviewsize' => { 266 => 0xf06 },
	'zoomedpreviewstart' => { 266 => 0xf04 },
	'zoomsourcewidth' => { 33 => 0x24 },
	'zoomstepcount' => { 264 => 0x300, 266 => 0x100d },
	'zoomtargetwidth' => { 33 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'accelerometertime' => 1,
	'accessdate' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeflags' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointinfo' => 1,
	'afpointsinfocus1d' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aimetadata' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'album2' => 1,
	'albumartist' => 1,
	'albumartistsortorder' => 1,
	'albumcoverurl' => 1,
	'albumid' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'albumtitleid' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphamask' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'ambienceinfo' => 1,
	'anim' => 1,
	'animation' => 1,
	'animationcontrol' => 1,
	'animationframes' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'animationplays' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'aperturemode' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'applestoreaccount' => 1,
	'applestoreaccounttype' => 1,
	'applestorecatalogid' => 1,
	'applestorecountry' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'arranger' => 1,
	'arrangerkeywords' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'artwork' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'attachments' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobitspersample' => 1,
	'audiobytes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'authorurl' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'averagebitrate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balance' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'battery' => 1,
	'batteryinfo' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats-per-minute' => 1,
	'beatsperminute' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'billinginformation' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'birthday' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'blueendpoint' => 1,
	'bluegain' => 1,
	'bluemask' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'bmpversion' => 1,
	'boardtemperature' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketinginfooffset' => 1,
	'bracketshot' => 1,
	'breakchar' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'camcore' => 1,
	'camera' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameradirection' => 1,
	'cameraidentifier' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameramotion' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'cameratemperaturemaxclip' => 1,
	'cameratemperaturemaxsaturated' => 1,
	'cameratemperaturemaxwarn' => 1,
	'cameratemperatureminclip' => 1,
	'cameratemperatureminsaturated' => 1,
	'cameratemperatureminwarn' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1200d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo700d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo750d' => 1,
	'canoncamerainfo760d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfo80d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelusage' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlist' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'children' => 1,
	'chmversion' => 1,
	'chromaticaberrationparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipfilename' => 1,
	'clipid' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codeversion' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown02' => 1,
	'colorbalanceunknown04' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorprimaries' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecapproximation' => 1,
	'colorspecdata' => 1,
	'colorspecification' => 1,
	'colorspecmethod' => 1,
	'colorspecprecedence' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'compilation' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'composerkeywords' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositinglayerheader' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'compressorversion' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentcreatedate' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentdistributorduration' => 1,
	'contentdistributorid' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentid' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coveruri' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'cr2cfapattern' => 1,
	'crcdevelparams' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs1' => 1,
	'cubemapproj' => 1,
	'cuepoint' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd610' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd810' => 1,
	'customsettingsd90' => 1,
	'customsettingsoffset' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datainformation' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'delaytime' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dialect' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directors' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'docclass' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit4data' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'eighthlanguage' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedjpg' => 1,
	'embeddedpng' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encodedwith' => 1,
	'encoder' => 1,
	'encoderoptions' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'episodeglobaluniqueid' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'equirectangularproj' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'evalstate' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureinfo' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'facepos' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldofview' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalframeblocks' => 1,
	'firmwareinfo' => 1,
	'firstchar' => 1,
	'firstlanguage' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0107' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspos' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framereadouttime' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gammablue' => 1,
	'gammagreen' => 1,
	'gammainfo' => 1,
	'gammared' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gaudio' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geometricdistortionparams' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gimage' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'googlehostheader' => 1,
	'googlepingmessage' => 1,
	'googlepingurl' => 1,
	'googlesourcedata' => 1,
	'googlestarttime' => 1,
	'googletrackduration' => 1,
	'goprotype' => 1,
	'gpano' => 1,
	'gps' => 1,
	'gpscoordinates' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greenendpoint' => 1,
	'greengain' => 1,
	'greenmask' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'group' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gspherical' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'guid' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdrinfo' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'hdvideo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hiddenslides' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'hintversion' => 1,
	'historybuffersize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huffmantable' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'iconuri' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedatadiscard' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imagefields' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixelformat' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresolution' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imageworkstationmake' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolortablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'information' => 1,
	'infourl' => 1,
	'ingrreserved' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'int16u' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrccode' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemprotection' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunesu' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jpginfooffset' => 1,
	'jplcartoifd' => 1,
	'jsonmetadata' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'kelvinwb' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf8coveruri' => 1,
	'kids' => 1,
	'kinds' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'layerblendmodes' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layout' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkedprofilename' => 1,
	'linkerversion' => 1,
	'linkinfo' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'lit' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'locationbody' => 1,
	'locationdate' => 1,
	'locationinfo' => 1,
	'locationinformation' => 1,
	'locationnote' => 1,
	'locationrole' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'longdescription' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'lslv' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'lyricsuri' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotepentaxunknown' => 1,
	'makernotes' => 1,
	'makerurl' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'matrixstructure' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mcdi' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemacquisitionmake' => 1,
	'mditemacquisitionmodel' => 1,
	'mditemaltitude' => 1,
	'mditemaperture' => 1,
	'mditemauthors' => 1,
	'mditembitspersample' => 1,
	'mditemcolorspace' => 1,
	'mditemcomment' => 1,
	'mditemcontentcreationdate' => 1,
	'mditemcontentmodificationdate' => 1,
	'mditemcontenttype' => 1,
	'mditemcontenttypetree' => 1,
	'mditemcreator' => 1,
	'mditemdateadded' => 1,
	'mditemdescription' => 1,
	'mditemdisplayname' => 1,
	'mditemdownloadeddate' => 1,
	'mditemencodingapplications' => 1,
	'mditemexifgpsversion' => 1,
	'mditemexifversion' => 1,
	'mditemexposuremode' => 1,
	'mditemexposureprogram' => 1,
	'mditemexposuretimeseconds' => 1,
	'mditemflashonoff' => 1,
	'mditemfnumber' => 1,
	'mditemfocallength' => 1,
	'mditemfscontentchangedate' => 1,
	'mditemfscreatorcode' => 1,
	'mditemfsfinderflags' => 1,
	'mditemfshascustomicon' => 1,
	'mditemfsinvisible' => 1,
	'mditemfsisextensionhidden' => 1,
	'mditemfsisstationery' => 1,
	'mditemfsname' => 1,
	'mditemfsnodecount' => 1,
	'mditemfsownergroupid' => 1,
	'mditemfsowneruserid' => 1,
	'mditemfssize' => 1,
	'mditemfstypecode' => 1,
	'mditemgpsdatestamp' => 1,
	'mditemgpsstatus' => 1,
	'mditemgpstrack' => 1,
	'mditemhasalphachannel' => 1,
	'mditemimagedirection' => 1,
	'mditemisospeed' => 1,
	'mditemkeywords' => 1,
	'mditemkind' => 1,
	'mditemlastuseddate' => 1,
	'mditemlatitude' => 1,
	'mditemlogicalsize' => 1,
	'mditemlongitude' => 1,
	'mditemnumberofpages' => 1,
	'mditemorientation' => 1,
	'mditemoriginapplicationidentifier' => 1,
	'mditemoriginmessageid' => 1,
	'mditemoriginsenderdisplayname' => 1,
	'mditemoriginsenderhandle' => 1,
	'mditemoriginsubject' => 1,
	'mditempageheight' => 1,
	'mditempagewidth' => 1,
	'mditemphysicalsize' => 1,
	'mditempixelcount' => 1,
	'mditempixelheight' => 1,
	'mditempixelwidth' => 1,
	'mditemprofilename' => 1,
	'mditemredeyeonoff' => 1,
	'mditemresolutionheightdpi' => 1,
	'mditemresolutionwidthdpi' => 1,
	'mditemsecuritymethod' => 1,
	'mditemspeed' => 1,
	'mditemtimestamp' => 1,
	'mditemtitle' => 1,
	'mditemusecount' => 1,
	'mditemuseddates' => 1,
	'mditemversion' => 1,
	'mditemwherefroms' => 1,
	'mditemwhitebalance' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediatype' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'melodicpolyphony' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metadatasource' => 1,
	'meterinfo' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'midicontrol' => 1,
	'midicontrolversion' => 1,
	'midisong' => 1,
	'mie' => 1,
	'mileage' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minorversion' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviedata' => 1,
	'moviedataoffset' => 1,
	'moviedatasize' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'multiexp' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'nexttrackid' => 1,
	'nikon' => 1,
	'nikoncaptureoffsets' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'opus' => 1,
	'opusversion' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'orientationinfo' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputgain' => 1,
	'outputresponse' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parasites' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'parentproductid' => 1,
	'parentshorttitle' => 1,
	'parenttitle' => 1,
	'part' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'percussivepolyphony' => 1,
	'performer' => 1,
	'performerkeywords' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'performerurl' => 1,
	'period' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturestylepc' => 1,
	'picturestyleuserdef' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelscale' => 1,
	'pixelshiftinfo' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playlistid' => 1,
	'playlistindex' => 1,
	'playmode' => 1,
	'playselection' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcast' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'podcasturl' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'poseyawdegrees' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingtime' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producerkeywords' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversion' => 1,
	'productversionnumber' => 1,
	'profile' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledataoffset' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profiles' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profilesize' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projectionboundsbottom' => 1,
	'projectionboundsleft' => 1,
	'projectionboundsright' => 1,
	'projectionboundstop' => 1,
	'projectionheader' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasedate' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingcopyright' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'recordlabelname' => 1,
	'recordlabelurl' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redendpoint' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmask' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reference' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'relatedimagefile' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'remindertime' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'requirements' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'reserved5' => 1,
	'resolutioninfo' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rotationangle' => 1,
	'rotationinfooffset' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	's2n' => 1,
	'sampledegradationpriority' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungrawbyteorder' => 1,
	'samsungrawpointerslength' => 1,
	'samsungrawpointersoffset' => 1,
	'samsungrawunknown' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'scriptcommand' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensorbottomborder' => 1,
	'sensordefects' => 1,
	'sensorid' => 1,
	'sensorimageheight' => 1,
	'sensorimagewidth' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorrightborder' => 1,
	'sensortopborder' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'serialinfo' => 1,
	'serialnumberhash' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharedwith' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingmenuoffset' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shorttitle' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod5' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod610' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutter' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'songwriter' => 1,
	'songwriterkeywords' => 1,
	'sony' => 1,
	'sonyrawfiletype' => 1,
	'sortalbum' => 1,
	'sortalbumartist' => 1,
	'sortartist' => 1,
	'sortcomposer' => 1,
	'sortname' => 1,
	'sortshow' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcecredits' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'speed' => 1,
	'sphericalvideo' => 1,
	'sphericalvideoxml' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'srgbrendering' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereoscopic3d' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchinfo' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'subtitlekeywords' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag2010i' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050a' => 1,
	'tag9050b' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailbpg' => 1,
	'thumbnailclip' => 1,
	'thumbnailpng' => 1,
	'thumbnailtiff' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'track' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'tracktype' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transferrange' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trebel' => 1,
	'tty-ttdphone' => 1,
	'tvepisode' => 1,
	'tvepisodeid' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'tvshow' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknown_aacr' => 1,
	'unknown_cdek' => 1,
	'unknown_cdet' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntags' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unknownthumbnail' => 1,
	'unsharpdata' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercollection' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userrating' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-canon' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-exif_bad' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'validate' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videocompression' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'vignettingparams' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_grbglevelsauto' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_rgbcoeffs0' => 1,
	'wb_rgbcoeffs1' => 1,
	'wb_rgbcoeffs2' => 1,
	'wb_rgbcoeffs3' => 1,
	'wb_rgblevels2500k' => 1,
	'wb_rgblevels3200k' => 1,
	'wb_rgblevels4500k' => 1,
	'wb_rgblevels6000k' => 1,
	'wb_rgblevels8500k' => 1,
	'wb_rgblevelsauto' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelscustom' => 1,
	'wb_rgblevelsdaylight' => 1,
	'wb_rgblevelsflash' => 1,
	'wb_rgblevelsfluorescent' => 1,
	'wb_rgblevelsfluorescentm1' => 1,
	'wb_rgblevelsfluorescentp1' => 1,
	'wb_rgblevelsfluorescentp2' => 1,
	'wb_rgblevelsshade' => 1,
	'wb_rgblevelstungsten' => 1,
	'wb_rgbmul0' => 1,
	'wb_rgbmul1' => 1,
	'wb_rgbmul2' => 1,
	'wb_rgbmul3' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredtungsten' => 1,
	'wcsprofiles' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wrapmodes' => 1,
	'writer' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xattrfinderinfo' => 1,
	'xattrmditemdownloadeddate' => 1,
	'xattrmditemfindercomment' => 1,
	'xattrmditemwherefroms' => 1,
	'xattrmdlabel' => 1,
	'xattrresourcefork' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
	'zxif' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'subseccreatedate' => 'Image::ExifTool::Exif',
	'subsecdatetimeoriginal' => 'Image::ExifTool::Exif',
	'subsecmodifydate' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
    GROUPS      => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level stucture
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '$strName'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        $flatName or ($flatName = $field) =~ tr/-_a-zA-Z0-9//dc;    # remove illegal characters
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                AddFields($tagTablePtr, $tagID, $lcTag, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2017, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
