#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: vector
version: 0.12.0.1
id: vector-0.12.0.1-692PQMDMB6pIQ1uGwefDcQ
key: vector-0.12.0.1-692PQMDMB6pIQ1uGwefDcQ
license: BSD3
copyright: (c) Roman Leshchinskiy 2008-2012
maintainer: Haskell Libraries Team <libraries@haskell.org>
homepage: https://github.com/haskell/vector
synopsis: Efficient Arrays
description:
    .
    An efficient implementation of Int-indexed arrays (both mutable
    and immutable), with a powerful loop optimisation framework .
    .
    It is structured as follows:
    .
    ["Data.Vector"] Boxed vectors of arbitrary types.
    .
    ["Data.Vector.Unboxed"] Unboxed vectors with an adaptive
    representation based on data type families.
    .
    ["Data.Vector.Storable"] Unboxed vectors of '\''Storable'\'' types.
    .
    ["Data.Vector.Primitive"] Unboxed vectors of primitive types as
    defined by the @primitive@ package. "Data.Vector.Unboxed" is more
    flexible at no performance cost.
    .
    ["Data.Vector.Generic"] Generic interface to the vector types.
    .
    There is also a (draft) tutorial on common uses of vector.
    .
    * <http://haskell.org/haskellwiki/Numeric_Haskell:_A_Vector_Tutorial>
category: Data, Data Structures
author: Roman Leshchinskiy <rl@cse.unsw.edu.au>
exposed: True
exposed-modules:
    Data.Vector.Internal.Check Data.Vector.Fusion.Util
    Data.Vector.Fusion.Stream.Monadic Data.Vector.Fusion.Bundle.Size
    Data.Vector.Fusion.Bundle.Monadic Data.Vector.Fusion.Bundle
    Data.Vector.Generic.Mutable.Base Data.Vector.Generic.Mutable
    Data.Vector.Generic.Base Data.Vector.Generic.New
    Data.Vector.Generic Data.Vector.Primitive.Mutable
    Data.Vector.Primitive Data.Vector.Storable.Internal
    Data.Vector.Storable.Mutable Data.Vector.Storable
    Data.Vector.Unboxed.Base Data.Vector.Unboxed.Mutable
    Data.Vector.Unboxed Data.Vector.Mutable Data.Vector
abi: fa6fdce47978807e9d49ec6c1d6815e0
trusted: False
import-dirs: /usr/lib/ghc-8.0.2/site-local/vector-0.12.0.1
library-dirs: /usr/lib/ghc-8.0.2/site-local/vector-0.12.0.1
dynamic-library-dirs: /usr/lib/arm-linux-ghc-8.0.2
data-dir: /usr/share/arm-linux-ghc-8.0.2/vector-0.12.0.1
hs-libraries: HSvector-0.12.0.1-692PQMDMB6pIQ1uGwefDcQ
include-dirs: /usr/lib/ghc-8.0.2/site-local/vector-0.12.0.1/include
depends:
    base-4.9.1.0 deepseq-1.4.2.0 ghc-prim-0.5.0.0
    primitive-0.6.2.0-4578caNkWQ54Gt1mxLF2Yh
haddock-interfaces: /usr/share/doc/haskell-vector/html/vector.haddock
haddock-html: /usr/share/doc/haskell-vector/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
