{
  This file is in the public domain.
}

{
  This codepage information is based on what is documented at
    1. http://wiki.whatwg.org/wiki/Web_Encodings
    2. http://msdn.microsoft.com/en-us/library/windows/desktop/dd317756(v=vs.85).aspx

    This file only uses bare facts and API information from the above pages
    rather than descriptions or code, neither of which are copyrightable.
}

type
  TCodePageHashEntry = record
    hash: LongWord;
    cp: TSystemCodePage;
    name: PAnsiChar;
  end;
const
  { this array contains many labels for the same codepage. 
    all labels are stored in lowercase and each record has a 
    hash value for the fast search. hash value was get using 
    SysUtils.HashName() function }
  CodePageHashes: array[0..415] of TCodePageHashEntry = (
    (hash: $00000310; cp: 28591; name: 'l1'),
    (hash: $00000320; cp: 28592; name: 'l2'),
    (hash: $00000330; cp: 28593; name: 'l3'),
    (hash: $00000340; cp: 28594; name: 'l4'),
    (hash: $00000350; cp: 28599; name: 'l5'),
    (hash: $00000390; cp: 28605; name: 'l9'),
    (hash: $00000530; cp: 20127; name: 'us'),
    (hash: $00003670; cp: 437; name: '437'),
    (hash: $000046B0; cp: 936; name: 'gbk'),
    (hash: $00005390; cp: 20866; name: 'koi'),
    (hash: $00005760; cp: 20105; name: 'irv'),
    (hash: $0004DA50; cp: 950; name: 'big5'),
    (hash: $0004EE30; cp: 932; name: 'sjis'),
    (hash: $00053C80; cp: 20866; name: 'koi8'),
    (hash: $000CB080; cp: 50931; name: 'x-ebcdic-japaneseanduscanada'),
    (hash: $0014F3C0; cp: 10010; name: 'x-mac-romanian'),
    (hash: $001B2E30; cp: 1141; name: 'ebcdic-de-273+euro'),
    (hash: $0028C1E0; cp: 20838; name: 'ibm-thai'),
    (hash: $0031A930; cp: 51932; name: 'x-euc'),
    (hash: $0031D450; cp: 20105; name: 'x-ia5'),
    (hash: $0033BCF0; cp: 858; name: 'ibm00858'),
    (hash: $0033C130; cp: 20924; name: 'ibm00924'),
    (hash: $00343300; cp: 1047; name: 'ibm01047'),
    (hash: $00344300; cp: 1147; name: 'ibm01147'),
    (hash: $00344310; cp: 1146; name: 'ibm01146'),
    (hash: $00344320; cp: 1145; name: 'ibm01145'),
    (hash: $00344330; cp: 1144; name: 'ibm01144'),
    (hash: $00344340; cp: 1143; name: 'ibm01143'),
    (hash: $00344350; cp: 1142; name: 'ibm01142'),
    (hash: $00344360; cp: 1141; name: 'ibm01141'),
    (hash: $00344370; cp: 1140; name: 'ibm01140'),
    (hash: $003443E0; cp: 1149; name: 'ibm01149'),
    (hash: $003443F0; cp: 1148; name: 'ibm01148'),
    (hash: $003F4900; cp: 28594; name: 'csisolatin4'),
    (hash: $003F4910; cp: 28599; name: 'csisolatin5'),
    (hash: $003F4950; cp: 28591; name: 'csisolatin1'),
    (hash: $003F4960; cp: 28592; name: 'csisolatin2'),
    (hash: $003F4970; cp: 28593; name: 'csisolatin3'),
    (hash: $003F49D0; cp: 28605; name: 'csisolatin9'),
    (hash: $00486020; cp: 1200; name: 'ucs-2'),
    (hash: $00511B20; cp: 936; name: 'cn-gb'),
    (hash: $00533670; cp: 37; name: 'cp037'),
    (hash: $00535A30; cp: 20273; name: 'cp273'),
    (hash: $00535A80; cp: 20278; name: 'cp278'),
    (hash: $00535B00; cp: 20280; name: 'cp280'),
    (hash: $00535B40; cp: 20284; name: 'cp284'),
    (hash: $00535B50; cp: 20285; name: 'cp285'),
    (hash: $00535C00; cp: 20290; name: 'cp290'),
    (hash: $00535C70; cp: 20297; name: 'cp297'),
    (hash: $00536970; cp: 20127; name: 'cp367'),
    (hash: $00537500; cp: 20420; name: 'cp420'),
    (hash: $00537530; cp: 20423; name: 'cp423'),
    (hash: $00537540; cp: 20424; name: 'cp424'),
    (hash: $00537670; cp: 437; name: 'cp437'),
    (hash: $00538300; cp: 500; name: 'cp500'),
    (hash: $0053B490; cp: 28591; name: 'cp819'),
    (hash: $0053B800; cp: 850; name: 'cp850'),
    (hash: $0053B820; cp: 852; name: 'cp852'),
    (hash: $0053B850; cp: 855; name: 'cp855'),
    (hash: $0053B870; cp: 857; name: 'cp857'),
    (hash: $0053B880; cp: 858; name: 'cp858'),
    (hash: $0053B900; cp: 860; name: 'cp860'),
    (hash: $0053B910; cp: 861; name: 'cp861'),
    (hash: $0053B920; cp: 862; name: 'cp862'),
    (hash: $0053B930; cp: 863; name: 'cp863'),
    (hash: $0053B940; cp: 864; name: 'cp864'),
    (hash: $0053B950; cp: 865; name: 'cp865'),
    (hash: $0053B960; cp: 866; name: 'cp866'),
    (hash: $0053B990; cp: 869; name: 'cp869'),
    (hash: $0053BA00; cp: 870; name: 'cp870'),
    (hash: $0053BA10; cp: 20871; name: 'cp871'),
    (hash: $0053BA50; cp: 875; name: 'cp875'),
    (hash: $0053BB00; cp: 20880; name: 'cp880'),
    (hash: $0053C350; cp: 20905; name: 'cp905'),
    (hash: $0053C520; cp: 1361; name: 'johab'),
    (hash: $0053C600; cp: 50930; name: 'cp930'),
    (hash: $0053C630; cp: 50933; name: 'cp933'),
    (hash: $0053C650; cp: 50935; name: 'cp935'),
    (hash: $0053C670; cp: 50937; name: 'cp937'),
    (hash: $0053C690; cp: 50939; name: 'cp939'),
    (hash: $0053CD20; cp: 20866; name: 'koi8r'),
    (hash: $005699B0; cp: 28597; name: 'greek'),
    (hash: $00577D90; cp: 20127; name: 'ascii'),
    (hash: $00589070; cp: 65000; name: 'utf-7'),
    (hash: $00589080; cp: 65001; name: 'utf-8'),
    (hash: $00AA6740; cp: 20127; name: 'iso_646.irv:1991'),
    (hash: $00C06790; cp: 10017; name: 'x-mac-ukrainian'),
    (hash: $0116DA00; cp: 950; name: 'cn-big5'),
    (hash: $013CBF20; cp: 28598; name: 'iso-8859-8 visual'),
    (hash: $01404000; cp: 28597; name: 'ecma-118'),
    (hash: $014040C0; cp: 28596; name: 'ecma-114'),
    (hash: $014D8730; cp: 932; name: 'cswindows31j'),
    (hash: $01561470; cp: 10029; name: 'x-mac-ce'),
    (hash: $016778F0; cp: 20127; name: 'us-ascii'),
    (hash: $01689670; cp: 949; name: 'ks-c5601'),
    (hash: $0180E440; cp: 932; name: 'x-ms-cp932'),
    (hash: $01964730; cp: 949; name: 'ks_c_5601-1989'),
    (hash: $019647D0; cp: 949; name: 'ks_c_5601-1987'),
    (hash: $01D4A080; cp: 20002; name: 'x-chinese-eten'),
    (hash: $01D4A2B0; cp: 950; name: 'big5-hkscs'),
    (hash: $01D4A5A0; cp: 20002; name: 'x_chinese-eten'),
    (hash: $01DF6090; cp: 1148; name: 'ebcdic-international-500+euro'),
    (hash: $01E550A0; cp: 936; name: 'iso-ir-58'),
    (hash: $01F48CD0; cp: 10006; name: 'x-mac-greek'),
    (hash: $021E55E0; cp: 20127; name: 'iso-ir-6'),
    (hash: $0220A600; cp: 708; name: 'asmo-708'),
    (hash: $022E2E20; cp: 1146; name: 'ebcdic-gb-285+euro'),
    (hash: $023BBA40; cp: 50225; name: 'iso-2022-kr-7bit'),
    (hash: $023CBA40; cp: 51949; name: 'iso-2022-kr-8bit'),
    (hash: $023ECEB0; cp: 10082; name: 'x-mac-croatian'),
    (hash: $02669990; cp: 28596; name: 'csisolatinarabic'),
    (hash: $02997D70; cp: 20106; name: 'din_66003'),
    (hash: $02D83800; cp: 1200; name: 'unicode'),
    (hash: $02DBAF90; cp: 1200; name: 'iso-10646-ucs-2'),
    (hash: $02E6CC40; cp: 1258; name: 'windows-1258'),
    (hash: $02E6CC80; cp: 1254; name: 'windows-1254'),
    (hash: $02E6CC90; cp: 1255; name: 'windows-1255'),
    (hash: $02E6CCA0; cp: 1256; name: 'windows-1256'),
    (hash: $02E6CCB0; cp: 1257; name: 'windows-1257'),
    (hash: $02E6CCC0; cp: 1250; name: 'windows-1250'),
    (hash: $02E6CCD0; cp: 1251; name: 'windows-1251'),
    (hash: $02E6CCE0; cp: 1252; name: 'windows-1252'),
    (hash: $02E6CCF0; cp: 1253; name: 'windows-1253'),
    (hash: $02F078A0; cp: 20127; name: 'ansi_x3.4-1968'),
    (hash: $02F07A40; cp: 20127; name: 'ansi_x3.4-1986'),
    (hash: $030D3F50; cp: 50220; name: 'iso-2022-jp'),
    (hash: $030D3F50; cp: 50222; name: 'iso-2022-jp'),
    (hash: $030D4070; cp: 50225; name: 'iso-2022-kr'),
    (hash: $03163790; cp: 1252; name: 'x-ansi'),
    (hash: $0327EE30; cp: 932; name: 'x-sjis'),
    (hash: $0333B8D0; cp: 858; name: 'cp00858'),
    (hash: $0333C510; cp: 20924; name: 'cp00924'),
    (hash: $03344700; cp: 1145; name: 'cp01145'),
    (hash: $03344710; cp: 1144; name: 'cp01144'),
    (hash: $03344720; cp: 1147; name: 'cp01147'),
    (hash: $03344730; cp: 1146; name: 'cp01146'),
    (hash: $03344740; cp: 1141; name: 'cp01141'),
    (hash: $03344750; cp: 1140; name: 'cp01140'),
    (hash: $03344760; cp: 1143; name: 'cp01143'),
    (hash: $03344770; cp: 1142; name: 'cp01142'),
    (hash: $033447C0; cp: 1149; name: 'cp01149'),
    (hash: $033447D0; cp: 1148; name: 'cp01148'),
    (hash: $03392E20; cp: 1145; name: 'ebcdic-es-284+euro'),
    (hash: $03530290; cp: 20001; name: 'x-cp20001'),
    (hash: $035302B0; cp: 20003; name: 'x-cp20003'),
    (hash: $035302C0; cp: 20004; name: 'x-cp20004'),
    (hash: $035302D0; cp: 20005; name: 'x-cp20005'),
    (hash: $03536810; cp: 20269; name: 'x-cp20269'),
    (hash: $03536890; cp: 20261; name: 'x-cp20261'),
    (hash: $0353F610; cp: 20949; name: 'x-cp20949'),
    (hash: $0353F7E0; cp: 20936; name: 'x-cp20936'),
    (hash: $035404F0; cp: 21027; name: 'x-cp21027'),
    (hash: $03836410; cp: 50229; name: 'x-cp50229'),
    (hash: $038364F0; cp: 50227; name: 'x-cp50227'),
    (hash: $03BD7590; cp: 28598; name: 'logical'),
    (hash: $03CB2700; cp: 21866; name: 'koi8-ru'),
    (hash: $03F199E0; cp: 51932; name: 'iso-2022-jpeuc'),
    (hash: $03F62B00; cp: 932; name: 'ms_kanji'),
    (hash: $04556420; cp: 936; name: 'gb2312'),
    (hash: $0460A550; cp: 720; name: 'dos-720'),
    (hash: $0460B970; cp: 862; name: 'dos-862'),
    (hash: $0460BA10; cp: 874; name: 'dos-874'),
    (hash: $0468E110; cp: 28591; name: 'latin1'),
    (hash: $0468E120; cp: 28592; name: 'latin2'),
    (hash: $0468E130; cp: 28593; name: 'latin3'),
    (hash: $0468E140; cp: 28594; name: 'latin4'),
    (hash: $0468E150; cp: 28599; name: 'latin5'),
    (hash: $0468E190; cp: 28605; name: 'latin9'),
    (hash: $046F1FD0; cp: 28593; name: 'iso_8859-3:1988'),
    (hash: $04703670; cp: 37; name: 'ibm037'),
    (hash: $04705A30; cp: 20273; name: 'ibm273'),
    (hash: $04705A70; cp: 20277; name: 'ibm277'),
    (hash: $04705A80; cp: 20278; name: 'ibm278'),
    (hash: $04705B00; cp: 20280; name: 'ibm280'),
    (hash: $04705B40; cp: 20284; name: 'ibm284'),
    (hash: $04705B50; cp: 20285; name: 'ibm285'),
    (hash: $04705C00; cp: 20290; name: 'ibm290'),
    (hash: $04705C70; cp: 20297; name: 'ibm297'),
    (hash: $04706970; cp: 20127; name: 'ibm367'),
    (hash: $04707500; cp: 20420; name: 'ibm420'),
    (hash: $04707530; cp: 20423; name: 'ibm423'),
    (hash: $04707540; cp: 20424; name: 'ibm424'),
    (hash: $04707670; cp: 437; name: 'ibm437'),
    (hash: $04708300; cp: 500; name: 'ibm500'),
    (hash: $0470A670; cp: 737; name: 'ibm737'),
    (hash: $0470AA50; cp: 775; name: 'ibm775'),
    (hash: $0470B490; cp: 28591; name: 'ibm819'),
    (hash: $0470B800; cp: 850; name: 'ibm850'),
    (hash: $0470B820; cp: 852; name: 'ibm852'),
    (hash: $0470B850; cp: 855; name: 'ibm855'),
    (hash: $0470B870; cp: 857; name: 'ibm857'),
    (hash: $0470B900; cp: 860; name: 'ibm860'),
    (hash: $0470B910; cp: 861; name: 'ibm861'),
    (hash: $0470B920; cp: 862; name: 'ibm862'),
    (hash: $0470B930; cp: 863; name: 'ibm863'),
    (hash: $0470B940; cp: 864; name: 'ibm864'),
    (hash: $0470B950; cp: 865; name: 'ibm865'),
    (hash: $0470B960; cp: 866; name: 'ibm866'),
    (hash: $0470B990; cp: 869; name: 'ibm869'),
    (hash: $0470BA00; cp: 870; name: 'ibm870'),
    (hash: $0470BA10; cp: 20871; name: 'ibm871'),
    (hash: $0470BB00; cp: 20880; name: 'ibm880'),
    (hash: $0470C350; cp: 20905; name: 'ibm905'),
    (hash: $04976A70; cp: 28598; name: 'hebrew'),
    (hash: $04A2C090; cp: 28597; name: 'elot_928'),
    (hash: $04A715E0; cp: 20106; name: 'german'),
    (hash: $04E895C0; cp: 28598; name: 'visual'),
    (hash: $0500B590; cp: 52936; name: 'hz-gb-2312'),
    (hash: $0514BA10; cp: 10001; name: 'x-mac-japanese'),
    (hash: $05343550; cp: 21025; name: 'cp1025'),
    (hash: $05343560; cp: 1026; name: 'cp1026'),
    (hash: $05345860; cp: 1256; name: 'cp1256'),
    (hash: $0535A1D0; cp: 28595; name: 'csisolatincyrillic'),
    (hash: $053CB220; cp: 20866; name: 'koi8-r'),
    (hash: $053CB250; cp: 21866; name: 'koi8-u'),
    (hash: $054368A0; cp: 10079; name: 'x-mac-icelandic'),
    (hash: $05443B20; cp: 10004; name: 'x-mac-arabic'),
    (hash: $054695E0; cp: 949; name: 'korean'),
    (hash: $054B3640; cp: 54936; name: 'gb18030'),
    (hash: $05612050; cp: 936; name: 'csgb231280'),
    (hash: $05628720; cp: 50221; name: 'csiso2022jp'),
    (hash: $05629800; cp: 50225; name: 'csiso2022kr'),
    (hash: $05645F50; cp: 936; name: 'gb231280'),
    (hash: $05656D30; cp: 28596; name: 'arabic'),
    (hash: $05699E80; cp: 28597; name: 'greek8'),
    (hash: $056F1FD0; cp: 28594; name: 'iso_8859-4:1988'),
    (hash: $0576DA50; cp: 950; name: 'csbig5'),
    (hash: $05890460; cp: 1200; name: 'utf-16'),
    (hash: $05890620; cp: 12000; name: 'utf-32'),
    (hash: $059617E0; cp: 51936; name: 'euc-cn'),
    (hash: $05961F00; cp: 20932; name: 'euc-jp'),
    (hash: $05961F00; cp: 51932; name: 'euc-jp'),
    (hash: $05962020; cp: 51949; name: 'euc-kr'),
    (hash: $05E69130; cp: 20424; name: 'ebcdic-cp-he'),
    (hash: $05E69140; cp: 20423; name: 'ebcdic-cp-gr'),
    (hash: $05E69320; cp: 20280; name: 'ebcdic-cp-it'),
    (hash: $05E69350; cp: 20871; name: 'ebcdic-cp-is'),
    (hash: $05E695D0; cp: 20277; name: 'ebcdic-cp-dk'),
    (hash: $05E69640; cp: 20285; name: 'ebcdic-cp-gb'),
    (hash: $05E69640; cp: 20297; name: 'ebcdic-cp-fr'),
    (hash: $05E69750; cp: 20284; name: 'ebcdic-cp-es'),
    (hash: $05E697F0; cp: 20278; name: 'ebcdic-cp-fi'),
    (hash: $05E69A70; cp: 37; name: 'ebcdic-cp-ca'),
    (hash: $05E69AE0; cp: 500; name: 'ebcdic-cp-ch'),
    (hash: $05E69B30; cp: 500; name: 'ebcdic-cp-be'),
    (hash: $05E6A120; cp: 37; name: 'ebcdic-cp-wt'),
    (hash: $05E6A330; cp: 870; name: 'ebcdic-cp-yu'),
    (hash: $05E6A440; cp: 20905; name: 'ebcdic-cp-tr'),
    (hash: $05E6A750; cp: 37; name: 'ebcdic-cp-us'),
    (hash: $05E6AA30; cp: 20278; name: 'ebcdic-cp-se'),
    (hash: $05E6AF90; cp: 20277; name: 'ebcdic-cp-no'),
    (hash: $05E6AFA0; cp: 37; name: 'ebcdic-cp-nl'),
    (hash: $0608C500; cp: 949; name: 'ks-c-5601'),
    (hash: $061DA1A0; cp: 20000; name: 'x-chinese-cns'),
    (hash: $062BE4C0; cp: 10021; name: 'x-mac-thai'),
    (hash: $06418950; cp: 936; name: 'gb_2312-80'),
    (hash: $06454E50; cp: 936; name: 'gb2312-80'),
    (hash: $066F1F20; cp: 28591; name: 'iso_8859-1:1987'),
    (hash: $06792030; cp: 1149; name: 'ebcdic-is-871+euro'),
    (hash: $06924780; cp: 20290; name: 'ebcdic-jp-kana'),
    (hash: $06B2E950; cp: 65000; name: 'csunicode11utf7'),
    (hash: $06B647D0; cp: 949; name: 'ks_c_5601_1987'),
    (hash: $06E108D0; cp: 28595; name: 'cyrillic'),
    (hash: $06E7B280; cp: 10002; name: 'x-mac-chinesetrad'),
    (hash: $06E915C0; cp: 10008; name: 'x-mac-chinesesimp'),
    (hash: $06EFA1A0; cp: 20000; name: 'x-chinese_cns'),
    (hash: $06F329A0; cp: 20833; name: 'x-ebcdic-koreanextended'),
    (hash: $07043520; cp: 1026; name: 'ibm1026'),
    (hash: $070462B0; cp: 1026; name: 'csibm1026'),
    (hash: $07289240; cp: 20838; name: 'csibmthai'),
    (hash: $0730C040; cp: 1149; name: 'ccsid01149'),
    (hash: $0730C050; cp: 1148; name: 'ccsid01148'),
    (hash: $0730C080; cp: 1145; name: 'ccsid01145'),
    (hash: $0730C090; cp: 1144; name: 'ccsid01144'),
    (hash: $0730C0A0; cp: 1147; name: 'ccsid01147'),
    (hash: $0730C0B0; cp: 1146; name: 'ccsid01146'),
    (hash: $0730C0C0; cp: 1141; name: 'ccsid01141'),
    (hash: $0730C0D0; cp: 1140; name: 'ccsid01140'),
    (hash: $0730C0E0; cp: 1143; name: 'ccsid01143'),
    (hash: $0730C0F0; cp: 1142; name: 'ccsid01142'),
    (hash: $07373F50; cp: 858; name: 'ccsid00858'),
    (hash: $07374290; cp: 20924; name: 'ccsid00924'),
    (hash: $0764A5A0; cp: 858; name: 'pc-multilingual-850+euro'),
    (hash: $07677DC0; cp: 20127; name: 'csascii'),
    (hash: $07689340; cp: 949; name: 'ksc5601'),
    (hash: $076F1F20; cp: 28592; name: 'iso_8859-2:1987'),
    (hash: $07782E20; cp: 1144; name: 'ebcdic-it-280+euro'),
    (hash: $07887930; cp: 20108; name: 'ns_4551-1'),
    (hash: $079716F0; cp: 10007; name: 'x-mac-cyrillic'),
    (hash: $07A98070; cp: 51949; name: 'cseuckr'),
    (hash: $07D90160; cp: 57008; name: 'x-iscii-ka'),
    (hash: $07D90220; cp: 57010; name: 'x-iscii-gu'),
    (hash: $07D90620; cp: 57002; name: 'x-iscii-de'),
    (hash: $07D90820; cp: 57003; name: 'x-iscii-be'),
    (hash: $07D90840; cp: 57006; name: 'x-iscii-as'),
    (hash: $07D91A50; cp: 57007; name: 'x-iscii-or'),
    (hash: $07D91F60; cp: 57009; name: 'x-iscii-ma'),
    (hash: $07D93620; cp: 57005; name: 'x-iscii-te'),
    (hash: $07D93660; cp: 57004; name: 'x-iscii-ta'),
    (hash: $07D93A60; cp: 57011; name: 'x-iscii-pa'),
    (hash: $07F788A0; cp: 20107; name: 'sen_850200_b'),
    (hash: $0803CD70; cp: 20866; name: 'cskoi8r'),
    (hash: $08345B00; cp: 1251; name: 'x-cp1251'),
    (hash: $08345B10; cp: 1250; name: 'x-cp1250'),
    (hash: $084A3840; cp: 65000; name: 'x-unicode-2-0-utf-7'),
    (hash: $084A38B0; cp: 65001; name: 'x-unicode-2-0-utf-8'),
    (hash: $084A8830; cp: 65000; name: 'x-unicode-1-1-utf-7'),
    (hash: $084A88C0; cp: 65001; name: 'x-unicode-1-1-utf-8'),
    (hash: $086F1F20; cp: 28597; name: 'iso_8859-7:1987'),
    (hash: $087A8520; cp: 10081; name: 'x-mac-turkish'),
    (hash: $08949ED0; cp: 28598; name: 'csisolatinhebrew'),
    (hash: $08BC5DF0; cp: 20106; name: 'x-ia5-german'),
    (hash: $08C87260; cp: 1201; name: 'unicodefffe'),
    (hash: $0904A3D0; cp: 1201; name: 'utf-16be'),
    (hash: $0904B5D0; cp: 1200; name: 'utf-16le'),
    (hash: $090663D0; cp: 12001; name: 'utf-32be'),
    (hash: $09289660; cp: 949; name: 'ksc_5601'),
    (hash: $0928CA20; cp: 949; name: 'ks_c_5601'),
    (hash: $093E7850; cp: 437; name: 'cspc8codepage437'),
    (hash: $096F1FD0; cp: 28598; name: 'iso_8859-8:1988'),
    (hash: $09797210; cp: 20127; name: 'iso646-us'),
    (hash: $0A0AB120; cp: 20924; name: 'ebcdic-latin9--euro'),
    (hash: $0A4C6530; cp: 20107; name: 'x-ia5-swedish'),
    (hash: $0A6F1FD0; cp: 28595; name: 'iso_8859-5:1988'),
    (hash: $0A86A6F0; cp: 28597; name: 'csisolatingreek'),
    (hash: $0A9614F0; cp: 51936; name: 'x-euc-cn'),
    (hash: $0A961C10; cp: 51932; name: 'x-euc-jp'),
    (hash: $0A9A3850; cp: 65000; name: 'unicode-2-0-utf-7'),
    (hash: $0A9A38A0; cp: 65001; name: 'unicode-2-0-utf-8'),
    (hash: $0A9A8860; cp: 65000; name: 'unicode-1-1-utf-7'),
    (hash: $0A9A8890; cp: 65001; name: 'unicode-1-1-utf-8'),
    (hash: $0AA74700; cp: 29001; name: 'x-europa'),
    (hash: $0AC5C930; cp: 870; name: 'ebcdic-cp-roece'),
    (hash: $0B16D970; cp: 950; name: 'x-x-big5'),
    (hash: $0B43A3B0; cp: 949; name: 'csksc56011987'),
    (hash: $0B46F040; cp: 51932; name: 'extended_unix_code_packed_format_for_japanese'),
    (hash: $0B556150; cp: 936; name: 'csgb2312'),
    (hash: $0B59AD90; cp: 51932; name: 'cseucpkdfmtjapanese'),
    (hash: $0B6F1F20; cp: 28596; name: 'iso_8859-6:1987'),
    (hash: $0B71A2E0; cp: 932; name: 'shift-jis'),
    (hash: $0B98E7D0; cp: 20107; name: 'swedish'),
    (hash: $0B9B8190; cp: 20108; name: 'norwegian'),
    (hash: $0BA3A2E0; cp: 932; name: 'shift_jis'),
    (hash: $0BB8F800; cp: 28592; name: 'iso8859-2'),
    (hash: $0BB8F830; cp: 28591; name: 'iso8859-1'),
    (hash: $0BBD4210; cp: 28591; name: 'iso-8859-1'),
    (hash: $0BBD4220; cp: 28592; name: 'iso-8859-2'),
    (hash: $0BBD4230; cp: 28593; name: 'iso-8859-3'),
    (hash: $0BBD4240; cp: 28594; name: 'iso-8859-4'),
    (hash: $0BBD4250; cp: 28595; name: 'iso-8859-5'),
    (hash: $0BBD4260; cp: 28596; name: 'iso-8859-6'),
    (hash: $0BBD4270; cp: 28597; name: 'iso-8859-7'),
    (hash: $0BBD4280; cp: 28598; name: 'iso-8859-8'),
    (hash: $0BBD4290; cp: 28599; name: 'iso-8859-9'),
    (hash: $0BBD4500; cp: 28592; name: 'iso_8859-2'),
    (hash: $0BBD4510; cp: 28593; name: 'iso_8859-3'),
    (hash: $0BBD4530; cp: 28591; name: 'iso_8859-1'),
    (hash: $0BBD4540; cp: 28596; name: 'iso_8859-6'),
    (hash: $0BBD4550; cp: 28597; name: 'iso_8859-7'),
    (hash: $0BBD4560; cp: 28594; name: 'iso_8859-4'),
    (hash: $0BBD4570; cp: 28595; name: 'iso_8859-5'),
    (hash: $0BBD45A0; cp: 28598; name: 'iso_8859-8'),
    (hash: $0BBD45B0; cp: 28599; name: 'iso_8859-9'),
    (hash: $0BD42480; cp: 28603; name: 'iso-8859-13'),
    (hash: $0BD424A0; cp: 874; name: 'iso-8859-11'),
    (hash: $0BD424E0; cp: 28605; name: 'iso-8859-15'),
    (hash: $0BD456E0; cp: 28605; name: 'iso_8859-15'),
    (hash: $0C112E30; cp: 1142; name: 'ebcdic-dk-277+euro'),
    (hash: $0C2E2E50; cp: 1147; name: 'ebcdic-fr-297+euro'),
    (hash: $0C2E4CE0; cp: 932; name: 'windows-31j'),
    (hash: $0C2E9300; cp: 874; name: 'windows-874'),
    (hash: $0CE2A710; cp: 936; name: 'chinese'),
    (hash: $0CEB2E30; cp: 1143; name: 'ebcdic-se-278+euro'),
    (hash: $0D402370; cp: 50225; name: 'iso-2022-kr-7'),
    (hash: $0D402380; cp: 51949; name: 'iso-2022-kr-8'),
    (hash: $0D42BA20; cp: 38598; name: 'iso-8859-8-i'),
    (hash: $0D4CC7B0; cp: 936; name: 'csiso58gb231280'),
    (hash: $0D67C3F0; cp: 10003; name: 'x-mac-korean'),
    (hash: $0D703300; cp: 37; name: 'csibm037'),
    (hash: $0D705900; cp: 20297; name: 'csibm297'),
    (hash: $0D705970; cp: 20290; name: 'csibm290'),
    (hash: $0D705E20; cp: 20285; name: 'csibm285'),
    (hash: $0D705E30; cp: 20284; name: 'csibm284'),
    (hash: $0D705E70; cp: 20280; name: 'csibm280'),
    (hash: $0D705F00; cp: 20277; name: 'csibm277'),
    (hash: $0D705F40; cp: 20273; name: 'csibm273'),
    (hash: $0D705FF0; cp: 20278; name: 'csibm278'),
    (hash: $0D707030; cp: 20424; name: 'csibm424'),
    (hash: $0D707040; cp: 20423; name: 'csibm423'),
    (hash: $0D707070; cp: 20420; name: 'csibm420'),
    (hash: $0D708670; cp: 500; name: 'csibm500'),
    (hash: $0D70BE70; cp: 20880; name: 'csibm880'),
    (hash: $0D70BF60; cp: 20871; name: 'csibm871'),
    (hash: $0D70BF70; cp: 870; name: 'csibm870'),
    (hash: $0D70C620; cp: 20905; name: 'csibm905'),
    (hash: $0DBD69F0; cp: 932; name: 'csshiftjis'),
    (hash: $0E1753A0; cp: 20880; name: 'ebcdic-cyrillic'),
    (hash: $0E3902F0; cp: 10000; name: 'macintosh'),
    (hash: $0E55C100; cp: 28592; name: 'iso-ir-101'),
    (hash: $0E55C110; cp: 28591; name: 'iso-ir-100'),
    (hash: $0E55C180; cp: 28593; name: 'iso-ir-109'),
    (hash: $0E55C490; cp: 28598; name: 'iso-ir-138'),
    (hash: $0E55C550; cp: 28595; name: 'iso-ir-144'),
    (hash: $0E55C580; cp: 949; name: 'iso-ir-149'),
    (hash: $0E55C590; cp: 28599; name: 'iso-ir-148'),
    (hash: $0E55C610; cp: 28594; name: 'iso-ir-110'),
    (hash: $0E55C760; cp: 28596; name: 'iso-ir-127'),
    (hash: $0E55C770; cp: 28597; name: 'iso-ir-126'),
    (hash: $0E609540; cp: 874; name: 'tis-620'),
    (hash: $0E69B340; cp: 20420; name: 'ebcdic-cp-ar1'),
    (hash: $0E6F1FC0; cp: 28599; name: 'iso_8859-9:1989'),
    (hash: $0F19F040; cp: 20108; name: 'x-ia5-norwegian'),
    (hash: $0F372E30; cp: 1143; name: 'ebcdic-fi-278+euro'),
    (hash: $0F969E40; cp: 1140; name: 'ebcdic-us-37+euro'),
    (hash: $0FAD2E30; cp: 1142; name: 'ebcdic-no-277+euro'),
    (hash: $0FB63C60; cp: 10005; name: 'x-mac-hebrew')
  );

type
  TCodePageEntry = record
    cp: TSystemCodePage;
    name: PAnsiChar;
  end;
const
  { this array contains only one name for one codepage. 
    it is stored in codepage order and is used to search
    a codepage name by codepage number }
  CodePageNames: array[0..149] of TCodePageEntry = (
    (cp: 37; name: 'ibm037'),
    (cp: 437; name: 'ibm437'),
    (cp: 500; name: 'IBM500'),
    (cp: 708; name: 'asmo-708'),
    (cp: 720; name: 'DOS-720'),
    (cp: 737; name: 'ibm737'),
    (cp: 775; name: 'ibm775'),
    (cp: 850; name: 'ibm850'),
    (cp: 852; name: 'ibm852'),
    (cp: 855; name: 'IBM855'),
    (cp: 857; name: 'ibm857'),
    (cp: 858; name: 'ibm00858'),
    (cp: 860; name: 'IBM860'),
    (cp: 861; name: 'ibm861'),
    (cp: 862; name: 'DOS-862'),
    (cp: 863; name: 'IBM863'),
    (cp: 864; name: 'IBM864'),
    (cp: 865; name: 'IBM865'),
    (cp: 866; name: 'cp866'),
    (cp: 869; name: 'ibm869'),
    (cp: 870; name: 'IBM870'),
    (cp: 874; name: 'windows-874'),
    (cp: 875; name: 'cp875'),
    (cp: 932; name: 'shift_jis'),
    (cp: 936; name: 'gb2312'),
    (cp: 949; name: 'ks_c_5601-1987'),
    (cp: 950; name: 'big5'),
    (cp: 1026; name: 'ibm1026'),
    (cp: 1047; name: 'ibm01047'),
    (cp: 1140; name: 'ibm01140'),
    (cp: 1141; name: 'IBM01141'),
    (cp: 1142; name: 'IBM01142'),
    (cp: 1143; name: 'IBM01143'),
    (cp: 1144; name: 'IBM01144'),
    (cp: 1145; name: 'ibm01145'),
    (cp: 1146; name: 'ibm01146'),
    (cp: 1147; name: 'ibm01147'),
    (cp: 1148; name: 'IBM01148'),
    (cp: 1149; name: 'IBM01149'),
    (cp: 1200; name: 'utf-16'),
    (cp: 1201; name: 'unicodefffe'),
    (cp: 1250; name: 'windows-1250'),
    (cp: 1251; name: 'windows-1251'),
    (cp: 1252; name: 'windows-1252'),
    (cp: 1253; name: 'windows-1253'),
    (cp: 1254; name: 'windows-1254'),
    (cp: 1255; name: 'windows-1255'),
    (cp: 1256; name: 'windows-1256'),
    (cp: 1257; name: 'windows-1257'),
    (cp: 1258; name: 'windows-1258'),
    (cp: 1361; name: 'Johab'),
    (cp: 10000; name: 'macintosh'),
    (cp: 10001; name: 'x-mac-japanese'),
    (cp: 10002; name: 'x-mac-chinesetrad'),
    (cp: 10003; name: 'x-mac-korean'),
    (cp: 10004; name: 'x-mac-arabic'),
    (cp: 10005; name: 'x-mac-hebrew'),
    (cp: 10006; name: 'x-mac-greek'),
    (cp: 10007; name: 'x-mac-cyrillic'),
    (cp: 10008; name: 'x-mac-chinesesimp'),
    (cp: 10010; name: 'x-mac-romanian'),
    (cp: 10017; name: 'x-mac-ukrainian'),
    (cp: 10021; name: 'x-mac-thai'),
    (cp: 10029; name: 'x-mac-ce'),
    (cp: 10079; name: 'x-mac-icelandic'),
    (cp: 10081; name: 'x-mac-turkish'),
    (cp: 10082; name: 'x-mac-croatian'),
    (cp: 12000; name: 'utf-32'),
    (cp: 12001; name: 'utf-32BE'),
    (cp: 20000; name: 'x-Chinese_CNS'),
    (cp: 20000; name: 'x-chinese-cns'),
    (cp: 20001; name: 'x-cp20001'),
    (cp: 20002; name: 'x_Chinese-Eten'),
    (cp: 20002; name: 'x-chinese-eten'),
    (cp: 20003; name: 'x-cp20003'),
    (cp: 20004; name: 'x-cp20004'),
    (cp: 20005; name: 'x-cp20005'),
    (cp: 20105; name: 'x-IA5'),
    (cp: 20106; name: 'x-ia5-german'),
    (cp: 20107; name: 'x-IA5-Swedish'),
    (cp: 20108; name: 'x-IA5-Norwegian'),
    (cp: 20127; name: 'us-ascii'),
    (cp: 20261; name: 'x-cp20261'),
    (cp: 20269; name: 'x-cp20269'),
    (cp: 20273; name: 'ibm273'),
    (cp: 20277; name: 'ibm277'),
    (cp: 20278; name: 'ibm278'),
    (cp: 20280; name: 'ibm280'),
    (cp: 20284; name: 'ibm284'),
    (cp: 20285; name: 'IBM285'),
    (cp: 20290; name: 'IBM290'),
    (cp: 20297; name: 'IBM297'),
    (cp: 20420; name: 'ibm420'),
    (cp: 20423; name: 'ibm423'),
    (cp: 20424; name: 'IBM424'),
    (cp: 20833; name: 'x-EBCDIC-KoreanExtended'),
    (cp: 20838; name: 'ibm-thai'),
    (cp: 20866; name: 'koi8-r'),
    (cp: 20871; name: 'ibm871'),
    (cp: 20880; name: 'ibm880'),
    (cp: 20905; name: 'ibm905'),
    (cp: 20924; name: 'IBM00924'),
    (cp: 20932; name: 'EUC-JP'),
    (cp: 20936; name: 'x-cp20936'),
    (cp: 20949; name: 'x-cp20949'),
    (cp: 21025; name: 'cp1025'),
    (cp: 21027; name: 'x-cp21027'),
    (cp: 21866; name: 'koi8-u'),
    (cp: 28591; name: 'iso-8859-1'),
    (cp: 28592; name: 'iso-8859-2'),
    (cp: 28593; name: 'iso-8859-3'),
    (cp: 28594; name: 'iso-8859-4'),
    (cp: 28595; name: 'iso-8859-5'),
    (cp: 28596; name: 'iso-8859-6'),
    (cp: 28597; name: 'iso-8859-7'),
    (cp: 28598; name: 'iso-8859-8'),
    (cp: 28599; name: 'iso-8859-9'),
    (cp: 28603; name: 'iso-8859-13'),
    (cp: 28605; name: 'iso-8859-15'),
    (cp: 29001; name: 'x-Europa'),
    (cp: 38598; name: 'iso-8859-8-i'),
    (cp: 50220; name: 'iso-2022-jp'),
    (cp: 50221; name: 'csISO2022JP'),
    (cp: 50222; name: 'iso-2022-jp'),
    (cp: 50225; name: 'iso-2022-kr'),
    (cp: 50227; name: 'x-cp50227'),
    (cp: 50229; name: 'x-cp50229'),
    (cp: 50930; name: 'cp930'),
    (cp: 50931; name: 'x-ebcdic-japaneseanduscanada'),
    (cp: 50933; name: 'cp933'),
    (cp: 50935; name: 'cp935'),
    (cp: 50937; name: 'cp937'),
    (cp: 50939; name: 'cp939'),
    (cp: 51932; name: 'euc-jp'),
    (cp: 51936; name: 'euc-cn'),
    (cp: 51949; name: 'euc-kr'),
    (cp: 52936; name: 'hz-gb-2312'),
    (cp: 54936; name: 'gb18030'),
    (cp: 57002; name: 'x-iscii-de'),
    (cp: 57003; name: 'x-iscii-be'),
    (cp: 57004; name: 'x-iscii-ta'),
    (cp: 57005; name: 'x-iscii-te'),
    (cp: 57006; name: 'x-iscii-as'),
    (cp: 57007; name: 'x-iscii-or'),
    (cp: 57008; name: 'x-iscii-ka'),
    (cp: 57009; name: 'x-iscii-ma'),
    (cp: 57010; name: 'x-iscii-gu'),
    (cp: 57011; name: 'x-iscii-pa'),
    (cp: 65000; name: 'utf-7'),
    (cp: 65001; name: 'utf-8')
  );

function CodePageToCodePageName(cp: TSystemCodePage): AnsiString;
var
  FoundCp: TSystemCodePage;
  L, H, I: Integer;
begin
  L := Low(CodePageNames);
  H := High(CodePageNames);
  while L <= H do
  begin
    I := (L + H) shr 1;
    FoundCp := CodePageNames[I].cp;
    if FoundCp = cp then
    begin
      Exit(CodePageNames[I].name);
      Break;
    end;
    if cp > FoundCp then
      L := I + 1
    else
      H := I - 1;
  end;
  Result := '';
end;

function CodePageNameToCodePage(const cpname: AnsiString): TSystemCodePage;
var
  SearchName: AnsiString;
  SearchHash, FoundHash: LongWord;
  L, H, I: Integer;
begin
  SearchName := LowerCase(cpname);
  SearchHash := HashName(PAnsiChar(SearchName));
  L := Low(CodePageHashes);
  H := High(CodePageHashes);
  while L <= H do
  begin
    I := (L + H) shr 1;
    FoundHash := CodePageHashes[I].hash;
    if FoundHash = SearchHash then
    begin
      // search down since hashes can repeat in table
      while (I > Low(CodePageHashes)) and (CodePageHashes[Pred(I)].hash = FoundHash) do
        Dec(I);
      while (I <= High(CodePageHashes)) and (CodePageHashes[I].hash = FoundHash) do
      begin
        if SearchName = CodePageHashes[I].name then
          Exit(CodePageHashes[I].cp);
        Inc(I);
      end;
      Break;
    end;
    if SearchHash > FoundHash then
      L := I + 1
    else
      H := I - 1;
  end;
  Result := $FFFF;
end;
