/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.AnalyzerCaster;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.Operation;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.painless.node.AExpression;

public final class EBinary
extends AExpression {
    final Operation operation;
    private AExpression left;
    private AExpression right;
    private Definition.Type promote = null;
    private Definition.Type shiftDistance = null;
    boolean cat = false;
    private boolean originallyExplicit = false;

    public EBinary(Location location, Operation operation, AExpression left, AExpression right) {
        super(location);
        this.operation = Objects.requireNonNull(operation);
        this.left = Objects.requireNonNull(left);
        this.right = Objects.requireNonNull(right);
    }

    @Override
    void extractVariables(Set<String> variables) {
        this.left.extractVariables(variables);
        this.right.extractVariables(variables);
    }

    @Override
    void analyze(Locals locals) {
        this.originallyExplicit = this.explicit;
        if (this.operation == Operation.MUL) {
            this.analyzeMul(locals);
        } else if (this.operation == Operation.DIV) {
            this.analyzeDiv(locals);
        } else if (this.operation == Operation.REM) {
            this.analyzeRem(locals);
        } else if (this.operation == Operation.ADD) {
            this.analyzeAdd(locals);
        } else if (this.operation == Operation.SUB) {
            this.analyzeSub(locals);
        } else if (this.operation == Operation.FIND) {
            this.analyzeRegexOp(locals);
        } else if (this.operation == Operation.MATCH) {
            this.analyzeRegexOp(locals);
        } else if (this.operation == Operation.LSH) {
            this.analyzeLSH(locals);
        } else if (this.operation == Operation.RSH) {
            this.analyzeRSH(locals);
        } else if (this.operation == Operation.USH) {
            this.analyzeUSH(locals);
        } else if (this.operation == Operation.BWAND) {
            this.analyzeBWAnd(locals);
        } else if (this.operation == Operation.XOR) {
            this.analyzeXor(locals);
        } else if (this.operation == Operation.BWOR) {
            this.analyzeBWOr(locals);
        } else {
            throw this.createError(new IllegalStateException("Illegal tree structure."));
        }
    }

    private void analyzeMul(Locals variables) {
        this.left.analyze(variables);
        this.right.analyze(variables);
        this.promote = AnalyzerCaster.promoteNumeric(this.left.actual, this.right.actual, true);
        if (this.promote == null) {
            throw this.createError(new ClassCastException("Cannot apply multiply [*] to types [" + this.left.actual.name + "] and [" + this.right.actual.name + "]."));
        }
        this.actual = this.promote;
        if (this.promote.sort == Definition.Sort.DEF) {
            this.left.expected = this.left.actual;
            this.right.expected = this.right.actual;
            if (this.expected != null) {
                this.actual = this.expected;
            }
        } else {
            this.left.expected = this.promote;
            this.right.expected = this.promote;
        }
        this.left = this.left.cast(variables);
        this.right = this.right.cast(variables);
        if (this.left.constant != null && this.right.constant != null) {
            Definition.Sort sort = this.promote.sort;
            if (sort == Definition.Sort.INT) {
                this.constant = (Integer)this.left.constant * (Integer)this.right.constant;
            } else if (sort == Definition.Sort.LONG) {
                this.constant = (Long)this.left.constant * (Long)this.right.constant;
            } else if (sort == Definition.Sort.FLOAT) {
                this.constant = Float.valueOf(((Float)this.left.constant).floatValue() * ((Float)this.right.constant).floatValue());
            } else if (sort == Definition.Sort.DOUBLE) {
                this.constant = (Double)this.left.constant * (Double)this.right.constant;
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
    }

    private void analyzeDiv(Locals variables) {
        block11: {
            this.left.analyze(variables);
            this.right.analyze(variables);
            this.promote = AnalyzerCaster.promoteNumeric(this.left.actual, this.right.actual, true);
            if (this.promote == null) {
                throw this.createError(new ClassCastException("Cannot apply divide [/] to types [" + this.left.actual.name + "] and [" + this.right.actual.name + "]."));
            }
            this.actual = this.promote;
            if (this.promote.sort == Definition.Sort.DEF) {
                this.left.expected = this.left.actual;
                this.right.expected = this.right.actual;
                if (this.expected != null) {
                    this.actual = this.expected;
                }
            } else {
                this.left.expected = this.promote;
                this.right.expected = this.promote;
            }
            this.left = this.left.cast(variables);
            this.right = this.right.cast(variables);
            if (this.left.constant != null && this.right.constant != null) {
                Definition.Sort sort = this.promote.sort;
                try {
                    if (sort == Definition.Sort.INT) {
                        this.constant = (Integer)this.left.constant / (Integer)this.right.constant;
                        break block11;
                    }
                    if (sort == Definition.Sort.LONG) {
                        this.constant = (Long)this.left.constant / (Long)this.right.constant;
                        break block11;
                    }
                    if (sort == Definition.Sort.FLOAT) {
                        this.constant = Float.valueOf(((Float)this.left.constant).floatValue() / ((Float)this.right.constant).floatValue());
                        break block11;
                    }
                    if (sort == Definition.Sort.DOUBLE) {
                        this.constant = (Double)this.left.constant / (Double)this.right.constant;
                        break block11;
                    }
                    throw this.createError(new IllegalStateException("Illegal tree structure."));
                }
                catch (ArithmeticException exception) {
                    throw this.createError(exception);
                }
            }
        }
    }

    private void analyzeRem(Locals variables) {
        block11: {
            this.left.analyze(variables);
            this.right.analyze(variables);
            this.promote = AnalyzerCaster.promoteNumeric(this.left.actual, this.right.actual, true);
            if (this.promote == null) {
                throw this.createError(new ClassCastException("Cannot apply remainder [%] to types [" + this.left.actual.name + "] and [" + this.right.actual.name + "]."));
            }
            this.actual = this.promote;
            if (this.promote.sort == Definition.Sort.DEF) {
                this.left.expected = this.left.actual;
                this.right.expected = this.right.actual;
                if (this.expected != null) {
                    this.actual = this.expected;
                }
            } else {
                this.left.expected = this.promote;
                this.right.expected = this.promote;
            }
            this.left = this.left.cast(variables);
            this.right = this.right.cast(variables);
            if (this.left.constant != null && this.right.constant != null) {
                Definition.Sort sort = this.promote.sort;
                try {
                    if (sort == Definition.Sort.INT) {
                        this.constant = (Integer)this.left.constant % (Integer)this.right.constant;
                        break block11;
                    }
                    if (sort == Definition.Sort.LONG) {
                        this.constant = (Long)this.left.constant % (Long)this.right.constant;
                        break block11;
                    }
                    if (sort == Definition.Sort.FLOAT) {
                        this.constant = Float.valueOf(((Float)this.left.constant).floatValue() % ((Float)this.right.constant).floatValue());
                        break block11;
                    }
                    if (sort == Definition.Sort.DOUBLE) {
                        this.constant = (Double)this.left.constant % (Double)this.right.constant;
                        break block11;
                    }
                    throw this.createError(new IllegalStateException("Illegal tree structure."));
                }
                catch (ArithmeticException exception) {
                    throw this.createError(exception);
                }
            }
        }
    }

    private void analyzeAdd(Locals variables) {
        this.left.analyze(variables);
        this.right.analyze(variables);
        this.promote = AnalyzerCaster.promoteAdd(this.left.actual, this.right.actual);
        if (this.promote == null) {
            throw this.createError(new ClassCastException("Cannot apply add [+] to types [" + this.left.actual.name + "] and [" + this.right.actual.name + "]."));
        }
        Definition.Sort sort = this.promote.sort;
        this.actual = this.promote;
        if (sort == Definition.Sort.STRING) {
            this.left.expected = this.left.actual;
            if (this.left instanceof EBinary && ((EBinary)this.left).operation == Operation.ADD && this.left.actual.sort == Definition.Sort.STRING) {
                ((EBinary)this.left).cat = true;
            }
            this.right.expected = this.right.actual;
            if (this.right instanceof EBinary && ((EBinary)this.right).operation == Operation.ADD && this.right.actual.sort == Definition.Sort.STRING) {
                ((EBinary)this.right).cat = true;
            }
        } else if (sort == Definition.Sort.DEF) {
            this.left.expected = this.left.actual;
            this.right.expected = this.right.actual;
            if (this.expected != null) {
                this.actual = this.expected;
            }
        } else {
            this.left.expected = this.promote;
            this.right.expected = this.promote;
        }
        this.left = this.left.cast(variables);
        this.right = this.right.cast(variables);
        if (this.left.constant != null && this.right.constant != null) {
            if (sort == Definition.Sort.INT) {
                this.constant = (Integer)this.left.constant + (Integer)this.right.constant;
            } else if (sort == Definition.Sort.LONG) {
                this.constant = (Long)this.left.constant + (Long)this.right.constant;
            } else if (sort == Definition.Sort.FLOAT) {
                this.constant = Float.valueOf(((Float)this.left.constant).floatValue() + ((Float)this.right.constant).floatValue());
            } else if (sort == Definition.Sort.DOUBLE) {
                this.constant = (Double)this.left.constant + (Double)this.right.constant;
            } else if (sort == Definition.Sort.STRING) {
                this.constant = this.left.constant.toString() + this.right.constant.toString();
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
    }

    private void analyzeSub(Locals variables) {
        this.left.analyze(variables);
        this.right.analyze(variables);
        this.promote = AnalyzerCaster.promoteNumeric(this.left.actual, this.right.actual, true);
        if (this.promote == null) {
            throw this.createError(new ClassCastException("Cannot apply subtract [-] to types [" + this.left.actual.name + "] and [" + this.right.actual.name + "]."));
        }
        this.actual = this.promote;
        if (this.promote.sort == Definition.Sort.DEF) {
            this.left.expected = this.left.actual;
            this.right.expected = this.right.actual;
            if (this.expected != null) {
                this.actual = this.expected;
            }
        } else {
            this.left.expected = this.promote;
            this.right.expected = this.promote;
        }
        this.left = this.left.cast(variables);
        this.right = this.right.cast(variables);
        if (this.left.constant != null && this.right.constant != null) {
            Definition.Sort sort = this.promote.sort;
            if (sort == Definition.Sort.INT) {
                this.constant = (Integer)this.left.constant - (Integer)this.right.constant;
            } else if (sort == Definition.Sort.LONG) {
                this.constant = (Long)this.left.constant - (Long)this.right.constant;
            } else if (sort == Definition.Sort.FLOAT) {
                this.constant = Float.valueOf(((Float)this.left.constant).floatValue() - ((Float)this.right.constant).floatValue());
            } else if (sort == Definition.Sort.DOUBLE) {
                this.constant = (Double)this.left.constant - (Double)this.right.constant;
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
    }

    private void analyzeRegexOp(Locals variables) {
        this.left.analyze(variables);
        this.right.analyze(variables);
        this.left.expected = Definition.STRING_TYPE;
        this.right.expected = Definition.PATTERN_TYPE;
        this.left = this.left.cast(variables);
        this.right = this.right.cast(variables);
        this.promote = Definition.BOOLEAN_TYPE;
        this.actual = Definition.BOOLEAN_TYPE;
    }

    private void analyzeLSH(Locals variables) {
        this.left.analyze(variables);
        this.right.analyze(variables);
        Definition.Type lhspromote = AnalyzerCaster.promoteNumeric(this.left.actual, false);
        Definition.Type rhspromote = AnalyzerCaster.promoteNumeric(this.right.actual, false);
        if (lhspromote == null || rhspromote == null) {
            throw this.createError(new ClassCastException("Cannot apply left shift [<<] to types [" + this.left.actual.name + "] and [" + this.right.actual.name + "]."));
        }
        this.actual = this.promote = lhspromote;
        this.shiftDistance = rhspromote;
        if (lhspromote.sort == Definition.Sort.DEF || rhspromote.sort == Definition.Sort.DEF) {
            this.left.expected = this.left.actual;
            this.right.expected = this.right.actual;
            if (this.expected != null) {
                this.actual = this.expected;
            }
        } else {
            this.left.expected = lhspromote;
            if (rhspromote.sort == Definition.Sort.LONG) {
                this.right.expected = Definition.INT_TYPE;
                this.right.explicit = true;
            } else {
                this.right.expected = rhspromote;
            }
        }
        this.left = this.left.cast(variables);
        this.right = this.right.cast(variables);
        if (this.left.constant != null && this.right.constant != null) {
            Definition.Sort sort = lhspromote.sort;
            if (sort == Definition.Sort.INT) {
                this.constant = (Integer)this.left.constant << (Integer)this.right.constant;
            } else if (sort == Definition.Sort.LONG) {
                this.constant = (Long)this.left.constant << (Integer)this.right.constant;
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
    }

    private void analyzeRSH(Locals variables) {
        this.left.analyze(variables);
        this.right.analyze(variables);
        Definition.Type lhspromote = AnalyzerCaster.promoteNumeric(this.left.actual, false);
        Definition.Type rhspromote = AnalyzerCaster.promoteNumeric(this.right.actual, false);
        if (lhspromote == null || rhspromote == null) {
            throw this.createError(new ClassCastException("Cannot apply right shift [>>] to types [" + this.left.actual.name + "] and [" + this.right.actual.name + "]."));
        }
        this.actual = this.promote = lhspromote;
        this.shiftDistance = rhspromote;
        if (lhspromote.sort == Definition.Sort.DEF || rhspromote.sort == Definition.Sort.DEF) {
            this.left.expected = this.left.actual;
            this.right.expected = this.right.actual;
            if (this.expected != null) {
                this.actual = this.expected;
            }
        } else {
            this.left.expected = lhspromote;
            if (rhspromote.sort == Definition.Sort.LONG) {
                this.right.expected = Definition.INT_TYPE;
                this.right.explicit = true;
            } else {
                this.right.expected = rhspromote;
            }
        }
        this.left = this.left.cast(variables);
        this.right = this.right.cast(variables);
        if (this.left.constant != null && this.right.constant != null) {
            Definition.Sort sort = lhspromote.sort;
            if (sort == Definition.Sort.INT) {
                this.constant = (Integer)this.left.constant >> (Integer)this.right.constant;
            } else if (sort == Definition.Sort.LONG) {
                this.constant = (Long)this.left.constant >> (Integer)this.right.constant;
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
    }

    private void analyzeUSH(Locals variables) {
        this.left.analyze(variables);
        this.right.analyze(variables);
        Definition.Type lhspromote = AnalyzerCaster.promoteNumeric(this.left.actual, false);
        Definition.Type rhspromote = AnalyzerCaster.promoteNumeric(this.right.actual, false);
        this.actual = this.promote = lhspromote;
        this.shiftDistance = rhspromote;
        if (lhspromote == null || rhspromote == null) {
            throw this.createError(new ClassCastException("Cannot apply unsigned shift [>>>] to types [" + this.left.actual.name + "] and [" + this.right.actual.name + "]."));
        }
        if (lhspromote.sort == Definition.Sort.DEF || rhspromote.sort == Definition.Sort.DEF) {
            this.left.expected = this.left.actual;
            this.right.expected = this.right.actual;
            if (this.expected != null) {
                this.actual = this.expected;
            }
        } else {
            this.left.expected = lhspromote;
            if (rhspromote.sort == Definition.Sort.LONG) {
                this.right.expected = Definition.INT_TYPE;
                this.right.explicit = true;
            } else {
                this.right.expected = rhspromote;
            }
        }
        this.left = this.left.cast(variables);
        this.right = this.right.cast(variables);
        if (this.left.constant != null && this.right.constant != null) {
            Definition.Sort sort = lhspromote.sort;
            if (sort == Definition.Sort.INT) {
                this.constant = (Integer)this.left.constant >>> (Integer)this.right.constant;
            } else if (sort == Definition.Sort.LONG) {
                this.constant = (Long)this.left.constant >>> (Integer)this.right.constant;
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
    }

    private void analyzeBWAnd(Locals variables) {
        this.left.analyze(variables);
        this.right.analyze(variables);
        this.promote = AnalyzerCaster.promoteNumeric(this.left.actual, this.right.actual, false);
        if (this.promote == null) {
            throw this.createError(new ClassCastException("Cannot apply and [&] to types [" + this.left.actual.name + "] and [" + this.right.actual.name + "]."));
        }
        this.actual = this.promote;
        if (this.promote.sort == Definition.Sort.DEF) {
            this.left.expected = this.left.actual;
            this.right.expected = this.right.actual;
            if (this.expected != null) {
                this.actual = this.expected;
            }
        } else {
            this.left.expected = this.promote;
            this.right.expected = this.promote;
        }
        this.left = this.left.cast(variables);
        this.right = this.right.cast(variables);
        if (this.left.constant != null && this.right.constant != null) {
            Definition.Sort sort = this.promote.sort;
            if (sort == Definition.Sort.INT) {
                this.constant = (Integer)this.left.constant & (Integer)this.right.constant;
            } else if (sort == Definition.Sort.LONG) {
                this.constant = (Long)this.left.constant & (Long)this.right.constant;
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
    }

    private void analyzeXor(Locals variables) {
        this.left.analyze(variables);
        this.right.analyze(variables);
        this.promote = AnalyzerCaster.promoteXor(this.left.actual, this.right.actual);
        if (this.promote == null) {
            throw this.createError(new ClassCastException("Cannot apply xor [^] to types [" + this.left.actual.name + "] and [" + this.right.actual.name + "]."));
        }
        this.actual = this.promote;
        if (this.promote.sort == Definition.Sort.DEF) {
            this.left.expected = this.left.actual;
            this.right.expected = this.right.actual;
            if (this.expected != null) {
                this.actual = this.expected;
            }
        } else {
            this.left.expected = this.promote;
            this.right.expected = this.promote;
        }
        this.left = this.left.cast(variables);
        this.right = this.right.cast(variables);
        if (this.left.constant != null && this.right.constant != null) {
            Definition.Sort sort = this.promote.sort;
            if (sort == Definition.Sort.BOOL) {
                this.constant = (Boolean)this.left.constant ^ (Boolean)this.right.constant;
            } else if (sort == Definition.Sort.INT) {
                this.constant = (Integer)this.left.constant ^ (Integer)this.right.constant;
            } else if (sort == Definition.Sort.LONG) {
                this.constant = (Long)this.left.constant ^ (Long)this.right.constant;
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
    }

    private void analyzeBWOr(Locals variables) {
        this.left.analyze(variables);
        this.right.analyze(variables);
        this.promote = AnalyzerCaster.promoteNumeric(this.left.actual, this.right.actual, false);
        if (this.promote == null) {
            throw this.createError(new ClassCastException("Cannot apply or [|] to types [" + this.left.actual.name + "] and [" + this.right.actual.name + "]."));
        }
        this.actual = this.promote;
        if (this.promote.sort == Definition.Sort.DEF) {
            this.left.expected = this.left.actual;
            this.right.expected = this.right.actual;
            if (this.expected != null) {
                this.actual = this.expected;
            }
        } else {
            this.left.expected = this.promote;
            this.right.expected = this.promote;
        }
        this.left = this.left.cast(variables);
        this.right = this.right.cast(variables);
        if (this.left.constant != null && this.right.constant != null) {
            Definition.Sort sort = this.promote.sort;
            if (sort == Definition.Sort.INT) {
                this.constant = (Integer)this.left.constant | (Integer)this.right.constant;
            } else if (sort == Definition.Sort.LONG) {
                this.constant = (Long)this.left.constant | (Long)this.right.constant;
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void write(MethodWriter writer, Globals globals) {
        writer.writeDebugInfo(this.location);
        if (this.promote.sort == Definition.Sort.STRING && this.operation == Operation.ADD) {
            if (!this.cat) {
                writer.writeNewStrings();
            }
            this.left.write(writer, globals);
            if (!(this.left instanceof EBinary) || !((EBinary)this.left).cat) {
                writer.writeAppendStrings(this.left.actual);
            }
            this.right.write(writer, globals);
            if (!(this.right instanceof EBinary) || !((EBinary)this.right).cat) {
                writer.writeAppendStrings(this.right.actual);
            }
            if (this.cat) return;
            writer.writeToStrings();
            return;
        } else if (this.operation == Operation.FIND || this.operation == Operation.MATCH) {
            this.right.write(writer, globals);
            this.left.write(writer, globals);
            writer.invokeVirtual(Definition.PATTERN_TYPE.type, WriterConstants.PATTERN_MATCHER);
            if (this.operation == Operation.FIND) {
                writer.invokeVirtual(Definition.MATCHER_TYPE.type, WriterConstants.MATCHER_FIND);
                return;
            } else {
                if (this.operation != Operation.MATCH) throw new IllegalStateException("Illegal tree structure.");
                writer.invokeVirtual(Definition.MATCHER_TYPE.type, WriterConstants.MATCHER_MATCHES);
            }
            return;
        } else {
            this.left.write(writer, globals);
            this.right.write(writer, globals);
            if (this.promote.sort == Definition.Sort.DEF || this.shiftDistance != null && this.shiftDistance.sort == Definition.Sort.DEF) {
                int flags = 0;
                if (this.originallyExplicit) {
                    flags |= 4;
                }
                writer.writeDynamicBinaryInstruction(this.location, this.actual, this.left.actual, this.right.actual, this.operation, flags);
                return;
            } else {
                writer.writeBinaryInstruction(this.location, this.actual, this.operation);
            }
        }
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.left, this.operation.symbol, this.right);
    }
}

