/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;

public final class GsubProcessor
extends AbstractProcessor {
    public static final String TYPE = "gsub";
    private final String field;
    private final Pattern pattern;
    private final String replacement;

    GsubProcessor(String tag, String field, Pattern pattern, String replacement) {
        super(tag);
        this.field = field;
        this.pattern = pattern;
        this.replacement = replacement;
    }

    String getField() {
        return this.field;
    }

    Pattern getPattern() {
        return this.pattern;
    }

    String getReplacement() {
        return this.replacement;
    }

    public void execute(IngestDocument document) {
        String oldVal = (String)document.getFieldValue(this.field, String.class);
        if (oldVal == null) {
            throw new IllegalArgumentException("field [" + this.field + "] is null, cannot match pattern.");
        }
        Matcher matcher = this.pattern.matcher(oldVal);
        String newVal = matcher.replaceAll(this.replacement);
        document.setFieldValue(this.field, (Object)newVal);
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements Processor.Factory {
        public GsubProcessor create(Map<String, Processor.Factory> registry, String processorTag, Map<String, Object> config) throws Exception {
            Pattern searchPattern;
            String field = ConfigurationUtils.readStringProperty((String)GsubProcessor.TYPE, (String)processorTag, config, (String)"field");
            String pattern = ConfigurationUtils.readStringProperty((String)GsubProcessor.TYPE, (String)processorTag, config, (String)"pattern");
            String replacement = ConfigurationUtils.readStringProperty((String)GsubProcessor.TYPE, (String)processorTag, config, (String)"replacement");
            try {
                searchPattern = Pattern.compile(pattern);
            }
            catch (Exception e) {
                throw ConfigurationUtils.newConfigurationException((String)GsubProcessor.TYPE, (String)processorTag, (String)"pattern", (String)("Invalid regex pattern. " + e.getMessage()));
            }
            return new GsubProcessor(processorTag, field, searchPattern, replacement);
        }
    }
}

