/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.StringHelper;
import org.elasticsearch.common.lucene.search.function.CombineFunction;
import org.elasticsearch.common.lucene.search.function.LeafScoreFunction;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;

public class RandomScoreFunction
extends ScoreFunction {
    private int originalSeed;
    private int saltedSeed;
    private final IndexFieldData<?> uidFieldData;

    public RandomScoreFunction() {
        super(CombineFunction.MULTIPLY);
        this.uidFieldData = null;
    }

    public RandomScoreFunction(int seed, int salt, IndexFieldData<?> uidFieldData) {
        super(CombineFunction.MULTIPLY);
        this.originalSeed = seed;
        this.saltedSeed = seed ^ salt;
        this.uidFieldData = uidFieldData;
        if (uidFieldData == null) {
            throw new NullPointerException("uid missing");
        }
    }

    @Override
    public LeafScoreFunction getLeafScoreFunction(LeafReaderContext ctx) {
        Object leafData = this.uidFieldData.load(ctx);
        final SortedBinaryDocValues uidByteData = leafData.getBytesValues();
        if (uidByteData == null) {
            throw new NullPointerException("failed to get uid byte data");
        }
        return new LeafScoreFunction(){

            @Override
            public double score(int docId, float subQueryScore) {
                uidByteData.setDocument(docId);
                int hash = StringHelper.murmurhash3_x86_32((BytesRef)uidByteData.valueAt(0), (int)RandomScoreFunction.this.saltedSeed);
                return (float)(hash & 0xFFFFFF) / 1.6777216E7f;
            }

            @Override
            public Explanation explainScore(int docId, Explanation subQueryScore) {
                return Explanation.match((float)CombineFunction.toFloat(this.score(docId, subQueryScore.getValue())), (String)("random score function (seed: " + RandomScoreFunction.this.originalSeed + ")"), (Explanation[])new Explanation[0]);
            }
        };
    }

    @Override
    public boolean needsScores() {
        return false;
    }

    @Override
    protected boolean doEquals(ScoreFunction other) {
        RandomScoreFunction randomScoreFunction = (RandomScoreFunction)other;
        return this.originalSeed == randomScoreFunction.originalSeed && this.saltedSeed == randomScoreFunction.saltedSeed;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.originalSeed, this.saltedSeed);
    }
}

