/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.file;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.ide.util.PsiNavigationSupport;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentation;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentationProviders;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.kotlin.com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.jetbrains.kotlin.com.intellij.openapi.ui.Queryable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.NonPhysicalFileSystem;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VfsBundle;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VfsUtilCore;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiDocumentManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFileSystemItem;
import org.jetbrains.kotlin.com.intellij.psi.PsiInvalidElementAccessException;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.CheckUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiElementBase;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiManagerImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.PsiBinaryFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.UpdateAddedFileProcessor;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ChangeUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.search.PsiElementProcessor;
import org.jetbrains.kotlin.com.intellij.psi.search.PsiFileSystemItemProcessor;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.PlatformIcons;

public class PsiDirectoryImpl
extends PsiElementBase
implements Queryable,
PsiDirectory {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.file.PsiDirectoryImpl");
    private final PsiManagerImpl myManager;
    private final VirtualFile myFile;

    public PsiDirectoryImpl(PsiManagerImpl manager, @NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryImpl", "<init>"));
        }
        this.myManager = manager;
        this.myFile = file2;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryImpl", "getVirtualFile"));
        }
        return virtualFile;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public boolean isValid() {
        return this.myFile.isValid();
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language = Language.ANY;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryImpl", "getLanguage"));
        }
        return language;
    }

    @Override
    public PsiManager getManager() {
        return this.myManager;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myFile.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryImpl", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryImpl", "setName"));
        }
        this.checkSetName(name2);
        try {
            this.myFile.rename(this.myManager, name2);
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e.toString());
        }
        PsiDirectoryImpl psiDirectoryImpl = this;
        if (psiDirectoryImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryImpl", "setName"));
        }
        return psiDirectoryImpl;
    }

    @Override
    public void checkSetName(String name2) throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
        VirtualFile parentFile = this.myFile.getParent();
        if (parentFile == null) {
            throw new IncorrectOperationException(VfsBundle.message("cannot.rename.root.directory", this.myFile.getPath()));
        }
        VirtualFile child = parentFile.findChild(name2);
        if (child != null && !child.equals(this.myFile)) {
            throw new IncorrectOperationException(VfsBundle.message("file.already.exists.error", child.getPresentableUrl()));
        }
    }

    @Override
    public PsiDirectory getParentDirectory() {
        VirtualFile parentFile = this.myFile.getParent();
        if (parentFile == null) {
            return null;
        }
        if (!parentFile.isValid()) {
            LOG.error("Invalid parent: " + parentFile + " of dir " + this.myFile + ", dir.valid=" + this.myFile.isValid());
            return null;
        }
        return this.myManager.findDirectory(parentFile);
    }

    @Override
    @NotNull
    public PsiDirectory[] getSubdirectories() {
        VirtualFile[] files2 = this.myFile.getChildren();
        ArrayList<PsiDirectory> dirs = new ArrayList<PsiDirectory>();
        for (VirtualFile file2 : files2) {
            PsiDirectory dir = this.myManager.findDirectory(file2);
            if (dir == null) continue;
            dirs.add(dir);
        }
        PsiDirectory[] psiDirectoryArray = dirs.toArray(new PsiDirectory[dirs.size()]);
        if (psiDirectoryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryImpl", "getSubdirectories"));
        }
        return psiDirectoryArray;
    }

    @Override
    @NotNull
    public PsiFile[] getFiles() {
        if (!this.myFile.isValid()) {
            throw new InvalidVirtualFileAccessException(this.myFile);
        }
        VirtualFile[] files2 = this.myFile.getChildren();
        ArrayList<PsiFile> psiFiles = new ArrayList<PsiFile>();
        for (VirtualFile file2 : files2) {
            PsiFile psiFile = this.myManager.findFile(file2);
            if (psiFile == null) continue;
            psiFiles.add(psiFile);
        }
        PsiFile[] psiFileArray = PsiUtilCore.toPsiFileArray(psiFiles);
        if (psiFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryImpl", "getFiles"));
        }
        return psiFileArray;
    }

    @Override
    public PsiDirectory findSubdirectory(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryImpl", "findSubdirectory"));
        }
        VirtualFile childVFile = this.myFile.findChild(name2);
        if (childVFile == null) {
            return null;
        }
        return this.myManager.findDirectory(childVFile);
    }

    @Override
    public PsiFile findFile(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryImpl", "findFile"));
        }
        VirtualFile childVFile = this.myFile.findChild(name2);
        if (childVFile == null) {
            return null;
        }
        if (!childVFile.isValid()) {
            LOG.error("Invalid file: " + childVFile + " in dir " + this.myFile + ", dir.valid=" + this.myFile.isValid());
            return null;
        }
        return this.myManager.findFile(childVFile);
    }

    @Override
    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor) {
        this.checkValid();
        ProgressIndicatorProvider.checkCanceled();
        for (VirtualFile vFile : this.myFile.getChildren()) {
            PsiFileSystemItem item;
            boolean isDir = vFile.isDirectory();
            if (processor instanceof PsiFileSystemItemProcessor && !((PsiFileSystemItemProcessor)processor).acceptItem(vFile.getName(), isDir)) continue;
            PsiFileSystemItem psiFileSystemItem = item = isDir ? this.myManager.findDirectory(vFile) : this.myManager.findFile(vFile);
            if (item == null || processor.execute(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        this.checkValid();
        VirtualFile[] files2 = this.myFile.getChildren();
        final ArrayList children = new ArrayList(files2.length);
        this.processChildren(new PsiElementProcessor<PsiFileSystemItem>(){

            @Override
            public boolean execute(@NotNull PsiFileSystemItem element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryImpl$1", "execute"));
                }
                children.add(element);
                return true;
            }
        });
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(children);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryImpl", "getChildren"));
        }
        return psiElementArray;
    }

    private void checkValid() {
        if (!this.isValid()) {
            throw new PsiInvalidElementAccessException(this);
        }
    }

    @Override
    public PsiDirectory getParent() {
        return this.getParentDirectory();
    }

    @Override
    public PsiFile getContainingFile() {
        return null;
    }

    @Override
    public TextRange getTextRange() {
        return null;
    }

    @Override
    public int getStartOffsetInParent() {
        return -1;
    }

    @Override
    public int getTextLength() {
        return -1;
    }

    @Override
    public PsiElement findElementAt(int offset2) {
        return null;
    }

    @Override
    public int getTextOffset() {
        return -1;
    }

    @Override
    public String getText() {
        return "";
    }

    @Override
    @NotNull
    public char[] textToCharArray() {
        if (ArrayUtil.EMPTY_CHAR_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryImpl", "textToCharArray"));
        }
        return ArrayUtil.EMPTY_CHAR_ARRAY;
    }

    @Override
    public boolean textMatches(@NotNull CharSequence text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryImpl", "textMatches"));
        }
        return false;
    }

    @Override
    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryImpl", "textMatches"));
        }
        return false;
    }

    @Override
    public final boolean isWritable() {
        return this.myFile.isWritable();
    }

    @Override
    public boolean isPhysical() {
        return !(this.myFile.getFileSystem() instanceof NonPhysicalFileSystem) && !this.myFile.getFileSystem().getProtocol().equals("temp");
    }

    @Override
    public PsiElement copy() {
        throw new IncorrectOperationException();
    }

    @Override
    @NotNull
    public PsiDirectory createSubdirectory(@NotNull String name2) throws IncorrectOperationException {
        PsiDirectory psiDirectory;
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryImpl", "createSubdirectory"));
        }
        this.checkCreateSubdirectory(name2);
        try {
            VirtualFile file2 = this.getVirtualFile().createChildDirectory(this.myManager, name2);
            PsiDirectory directory = this.myManager.findDirectory(file2);
            if (directory == null) {
                throw new IncorrectOperationException("Cannot find directory in '" + file2.getPresentableUrl() + "'");
            }
            psiDirectory = directory;
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e.toString());
        }
        if (psiDirectory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryImpl", "createSubdirectory"));
        }
        return psiDirectory;
    }

    @Override
    public void checkCreateSubdirectory(@NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryImpl", "checkCreateSubdirectory"));
        }
        VirtualFile existingFile = this.getVirtualFile().findChild(name2);
        if (existingFile != null) {
            throw new IncorrectOperationException(VfsBundle.message("file.already.exists.error", existingFile.getPresentableUrl()));
        }
        CheckUtil.checkWritable(this);
    }

    @Override
    @NotNull
    public PsiFile createFile(@NotNull String name2) throws IncorrectOperationException {
        PsiFile psiFile;
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryImpl", "createFile"));
        }
        this.checkCreateFile(name2);
        try {
            VirtualFile vFile = this.getVirtualFile().createChildData(this.myManager, name2);
            PsiFile psiFile2 = this.myManager.findFile(vFile);
            assert (psiFile2 != null) : vFile.getPath();
            psiFile = psiFile2;
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e.toString());
        }
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryImpl", "createFile"));
        }
        return psiFile;
    }

    @Override
    @NotNull
    public PsiFile copyFileFrom(@NotNull String newName2, @NotNull PsiFile originalFile) throws IncorrectOperationException {
        PsiFile psiFile;
        if (newName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryImpl", "copyFileFrom"));
        }
        if (originalFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFile", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryImpl", "copyFileFrom"));
        }
        this.checkCreateFile(newName2);
        Document document = PsiDocumentManager.getInstance(this.getProject()).getDocument(originalFile);
        if (document != null) {
            FileDocumentManager.getInstance().saveDocument(document);
        }
        VirtualFile parent2 = this.getVirtualFile();
        try {
            VirtualFile copyVFile;
            VirtualFile vFile = originalFile.getVirtualFile();
            if (vFile == null) {
                throw new IncorrectOperationException("Cannot copy non-physical file: " + originalFile);
            }
            if (parent2.getFileSystem() == vFile.getFileSystem()) {
                copyVFile = vFile.copy(this, parent2, newName2);
            } else if (vFile instanceof LightVirtualFile) {
                copyVFile = parent2.createChildData(this, newName2);
                copyVFile.setBinaryContent(originalFile.getText().getBytes(copyVFile.getCharset()));
            } else {
                copyVFile = VfsUtilCore.copyFile(this, vFile, parent2, newName2);
            }
            if (copyVFile == null) {
                throw new IncorrectOperationException("File was not copied: " + vFile);
            }
            PsiFile copyPsi = this.myManager.findFile(copyVFile);
            if (copyPsi == null) {
                throw new IncorrectOperationException("Could not find file " + copyVFile + " after copying " + vFile);
            }
            PsiDirectoryImpl.updateAddedFile(copyPsi);
            psiFile = copyPsi;
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e);
        }
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryImpl", "copyFileFrom"));
        }
        return psiFile;
    }

    private static void updateAddedFile(@NotNull PsiFile copyPsi) throws IncorrectOperationException {
        if (copyPsi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyPsi", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryImpl", "updateAddedFile"));
        }
        UpdateAddedFileProcessor processor = UpdateAddedFileProcessor.forElement(copyPsi);
        if (processor != null) {
            TreeElement tree = (TreeElement)SourceTreeToPsiMap.psiElementToTree(copyPsi);
            if (tree != null) {
                ChangeUtil.encodeInformation(tree);
            }
            processor.update(copyPsi, null);
            if (tree != null) {
                ChangeUtil.decodeInformation(tree);
            }
        }
    }

    @Override
    public void checkCreateFile(@NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryImpl", "checkCreateFile"));
        }
        VirtualFile existingFile = this.getVirtualFile().findChild(name2);
        if (existingFile != null) {
            throw new IncorrectOperationException(VfsBundle.message("file.already.exists.error", existingFile.getPresentableUrl()));
        }
        CheckUtil.checkWritable(this);
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryImpl", "add"));
        }
        this.checkAdd(element);
        if (element instanceof PsiFile) {
            PsiFile originalFile = (PsiFile)element;
            try {
                VirtualFile newVFile;
                PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance(this.myManager.getProject());
                if (originalFile instanceof PsiFileImpl) {
                    newVFile = this.myFile.createChildData(this.myManager, originalFile.getName());
                    String text2 = originalFile.getText();
                    PsiFile psiFile = this.getManager().findFile(newVFile);
                    Document document = psiFile == null ? null : psiDocumentManager.getDocument(psiFile);
                    FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
                    if (document != null) {
                        document.setText(text2);
                        fileDocumentManager.saveDocument(document);
                    } else {
                        String lineSeparator = fileDocumentManager.getLineSeparator(newVFile, this.getProject());
                        if (!lineSeparator.equals("\n")) {
                            text2 = StringUtil.convertLineSeparators(text2, lineSeparator);
                        }
                        LoadTextUtil.write(this.getProject(), newVFile, this.myManager, text2, -1L);
                    }
                } else {
                    byte[] storedContents = ((PsiBinaryFileImpl)originalFile).getStoredContents();
                    if (storedContents != null) {
                        newVFile = this.myFile.createChildData(this.myManager, originalFile.getName());
                        newVFile.setBinaryContent(storedContents);
                    } else {
                        newVFile = VfsUtilCore.copyFile(null, originalFile.getVirtualFile(), this.myFile);
                    }
                }
                psiDocumentManager.commitAllDocuments();
                PsiFile newFile = this.myManager.findFile(newVFile);
                if (newFile == null) {
                    throw new IncorrectOperationException("Could not find file " + newVFile);
                }
                PsiDirectoryImpl.updateAddedFile(newFile);
                return newFile;
            }
            catch (IOException e) {
                throw new IncorrectOperationException(e);
            }
        }
        throw new IncorrectOperationException(element + " (" + element.getClass() + ")");
    }

    @Override
    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryImpl", "checkAdd"));
        }
        CheckUtil.checkWritable(this);
        if (element instanceof PsiDirectory) {
            String name2 = ((PsiDirectory)element).getName();
            this.checkName(name2, this.getSubdirectories(), "dir.already.exists.error");
        } else if (element instanceof PsiFile) {
            String name3 = ((PsiFile)element).getName();
            this.checkName(name3, this.getFiles(), "file.already.exists.error");
        } else {
            throw new IncorrectOperationException(element.getClass().getName());
        }
    }

    private void checkName(String name2, PsiFileSystemItem[] items, String key) {
        boolean caseSensitive = this.getVirtualFile().getFileSystem().isCaseSensitive();
        for (PsiFileSystemItem item : items) {
            if (!Comparing.strEqual(item.getName(), name2, caseSensitive)) continue;
            throw new IncorrectOperationException(VfsBundle.message(key, item.getVirtualFile().getPresentableUrl()));
        }
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor2) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryImpl", "addBefore"));
        }
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor2) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryImpl", "addAfter"));
        }
        throw new IncorrectOperationException();
    }

    @Override
    public void delete() throws IncorrectOperationException {
        this.checkDelete();
        try {
            this.myFile.delete(this.myManager);
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e);
        }
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        CheckUtil.checkDelete(this.myFile);
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryImpl", "replace"));
        }
        throw new IncorrectOperationException();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryImpl", "accept"));
        }
        visitor2.visitDirectory(this);
    }

    @Override
    public String toString() {
        return "PsiDirectory:" + this.myFile.getPresentableUrl();
    }

    @Override
    public ASTNode getNode() {
        return null;
    }

    @Override
    public boolean canNavigateToSource() {
        return false;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public void navigate(boolean requestFocus) {
        PsiNavigationSupport.getInstance().navigateToDirectory(this, requestFocus);
    }

    @Override
    protected Icon getElementIcon(int flags) {
        return PlatformIcons.DIRECTORY_CLOSED_ICON;
    }

    @Override
    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiDirectoryImpl", "putInfo"));
        }
        info.put("fileName", this.getName());
    }
}

