/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize;

import com.google.common.hash.HashCode;
import java.io.IOException;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashCodeSerializer
extends AbstractSerializer<HashCode> {
    @Override
    public HashCode read(Decoder decoder) throws IOException {
        byte hashSize = decoder.readByte();
        byte[] hash = new byte[hashSize];
        decoder.readBytes(hash);
        return HashCode.fromBytes((byte[])hash);
    }

    @Override
    public void write(Encoder encoder, HashCode value) throws IOException {
        byte[] hash = value.asBytes();
        encoder.writeByte((byte)hash.length);
        encoder.writeBytes(hash);
    }
}

