/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations;

import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.MultipleBuildOperationFailures;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.internal.work.WorkerLeaseService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultBuildOperationQueue<T extends BuildOperation>
implements BuildOperationQueue<T> {
    private final WorkerLeaseService workerLeases;
    private final WorkerLeaseRegistry.WorkerLease parentWorkerLease;
    private final Executor executor;
    private final BuildOperationQueue.QueueWorker<T> queueWorker;
    private String logLocation;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition workAvailable = this.lock.newCondition();
    private final Condition workDone = this.lock.newCondition();
    private State state = State.Working;
    private int workers;
    private final Deque<T> workQueue = new LinkedList<T>();
    private final LinkedList<Throwable> failures = new LinkedList();

    DefaultBuildOperationQueue(WorkerLeaseService workerLeases, ExecutorService executor, BuildOperationQueue.QueueWorker<T> queueWorker) {
        this.workerLeases = workerLeases;
        this.parentWorkerLease = workerLeases.getWorkerLease();
        this.executor = executor;
        this.queueWorker = queueWorker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(T operation) {
        this.lock.lock();
        try {
            if (this.state == State.Done) {
                throw new IllegalStateException("BuildOperationQueue cannot be reused once it has completed.");
            }
            if (this.state == State.Cancelled) {
                Object var3_2 = null;
                this.lock.unlock();
                return;
            }
            this.workQueue.add(operation);
            this.workAvailable.signalAll();
            if (this.workers == 0 || this.workers < this.workerLeases.getMaxWorkerCount()) {
                ++this.workers;
                this.executor.execute(new WorkerRunnable());
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.lock.unlock();
            throw throwable;
        }
        Object var3_3 = null;
        this.lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        this.lock.lock();
        try {
            block5: {
                block4: {
                    if (this.state == State.Cancelled) break block4;
                    if (this.state != State.Done) break block5;
                }
                Object var2_1 = null;
                this.lock.unlock();
                return;
            }
            this.state = State.Cancelled;
            this.workQueue.clear();
            this.workAvailable.signalAll();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.lock.unlock();
            throw throwable;
        }
        Object var2_2 = null;
        this.lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForCompletion() throws MultipleBuildOperationFailures {
        this.lock.lock();
        try {
            if (this.state == State.Done) {
                throw new IllegalStateException("Cannot wait for completion more than once.");
            }
            this.state = State.Finishing;
            this.workAvailable.signalAll();
            while (this.workers > 0) {
                try {
                    this.workDone.await();
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                }
            }
            this.state = State.Done;
            if (!this.failures.isEmpty()) {
                throw new MultipleBuildOperationFailures(DefaultBuildOperationQueue.getFailureMessage(this.failures), this.failures, this.logLocation);
            }
            Object var3_2 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    @Override
    public void setLogLocation(String logLocation) {
        this.logLocation = logLocation;
    }

    private static String getFailureMessage(Collection<? extends Throwable> failures) {
        if (failures.size() == 1) {
            return "A build operation failed.";
        }
        return "Multiple build operations failed.";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WorkerRunnable
    implements Runnable {
        private WorkerRunnable() {
        }

        @Override
        public void run() {
            Object operation;
            while ((operation = this.waitForNextOperation()) != null) {
                this.runBatch(operation);
            }
            this.shutDown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private T waitForNextOperation() {
            Object t;
            DefaultBuildOperationQueue.this.lock.lock();
            try {
                while (DefaultBuildOperationQueue.this.state == State.Working && DefaultBuildOperationQueue.this.workQueue.isEmpty()) {
                    try {
                        DefaultBuildOperationQueue.this.workAvailable.await();
                    }
                    catch (InterruptedException e) {
                        throw new UncheckedException(e);
                    }
                }
                t = this.getNextOperation();
                Object var3_3 = null;
                DefaultBuildOperationQueue.this.lock.unlock();
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                DefaultBuildOperationQueue.this.lock.unlock();
                throw throwable;
            }
            return t;
        }

        private void runBatch(T firstOperation) {
            DefaultBuildOperationQueue.this.workerLeases.withLocks(DefaultBuildOperationQueue.this.parentWorkerLease.createChild()).execute(new Runnable((BuildOperation)firstOperation){
                final /* synthetic */ BuildOperation val$firstOperation;
                {
                    this.val$firstOperation = buildOperation;
                }

                public void run() {
                    BuildOperation operation = this.val$firstOperation;
                    while (operation != null) {
                        WorkerRunnable.this.runOperation(operation);
                        operation = WorkerRunnable.this.getNextOperation();
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private T getNextOperation() {
            BuildOperation buildOperation;
            DefaultBuildOperationQueue.this.lock.lock();
            try {
                buildOperation = (BuildOperation)DefaultBuildOperationQueue.this.workQueue.pollFirst();
                Object var3_2 = null;
                DefaultBuildOperationQueue.this.lock.unlock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                DefaultBuildOperationQueue.this.lock.unlock();
                throw throwable;
            }
            return buildOperation;
        }

        private void runOperation(T operation) {
            try {
                DefaultBuildOperationQueue.this.queueWorker.execute(operation);
            }
            catch (Throwable t) {
                this.addFailure(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addFailure(Throwable failure) {
            DefaultBuildOperationQueue.this.lock.lock();
            try {
                DefaultBuildOperationQueue.this.failures.add(failure);
                Object var3_2 = null;
                DefaultBuildOperationQueue.this.lock.unlock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                DefaultBuildOperationQueue.this.lock.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void shutDown() {
            DefaultBuildOperationQueue.this.lock.lock();
            try {
                DefaultBuildOperationQueue.this.workers--;
                DefaultBuildOperationQueue.this.workDone.signalAll();
                Object var2_1 = null;
                DefaultBuildOperationQueue.this.lock.unlock();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                DefaultBuildOperationQueue.this.lock.unlock();
                throw throwable;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        Working,
        Finishing,
        Cancelled,
        Done;

    }
}

