/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.publisher;

import java.io.File;
import java.util.List;
import org.gradle.api.artifacts.PublishException;
import org.gradle.api.internal.artifacts.ModuleVersionPublisher;
import org.gradle.api.internal.artifacts.ivyservice.publisher.IvyDependencyPublisher;
import org.gradle.internal.component.external.model.DefaultIvyModulePublishMetadata;
import org.gradle.internal.component.external.model.IvyModuleArtifactPublishMetadata;
import org.gradle.internal.component.external.model.IvyModulePublishMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIvyDependencyPublisher
implements IvyDependencyPublisher {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultIvyDependencyPublisher.class);

    @Override
    public void publish(List<ModuleVersionPublisher> publishResolvers, IvyModulePublishMetadata publishMetaData) {
        DefaultIvyModulePublishMetadata publication = new DefaultIvyModulePublishMetadata(publishMetaData.getId(), publishMetaData.getModuleDescriptor());
        for (IvyModuleArtifactPublishMetadata artifact : publishMetaData.getArtifacts()) {
            this.addPublishedArtifact(artifact, publication);
        }
        for (ModuleVersionPublisher publisher : publishResolvers) {
            LOGGER.info("Publishing to {}", (Object)publisher);
            publisher.publish(publication);
        }
    }

    private void addPublishedArtifact(IvyModuleArtifactPublishMetadata artifact, DefaultIvyModulePublishMetadata publication) {
        if (this.checkArtifactFileExists(artifact)) {
            publication.addArtifact(artifact);
        }
    }

    private boolean checkArtifactFileExists(IvyModuleArtifactPublishMetadata artifact) {
        File artifactFile = artifact.getFile();
        if (artifactFile.exists()) {
            return true;
        }
        if (!this.isSigningArtifact(artifact.getArtifactName())) {
            throw new PublishException(String.format("Cannot publish artifact '%s' (%s) as it does not exist.", artifact.getId(), artifactFile));
        }
        return false;
    }

    private boolean isSigningArtifact(IvyArtifactName artifact) {
        return artifact.getType().endsWith(".asc") || artifact.getType().endsWith(".sig");
    }
}

