/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.File;
import kotlin.collections.CollectionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.binding.CalculatedClosure;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.FacadePartWithSourceFile;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.context.RootContext;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorPsiUtilsKt;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaPropertyDescriptor;
import org.jetbrains.kotlin.load.kotlin.FileBasedKotlinClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.load.kotlin.ModuleVisibilityUtilsKt;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.codeFragmentUtil.CodeFragmentUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedClassDescriptor;
import org.jetbrains.kotlin.types.KotlinType;

public class JvmCodegenUtil {
    private JvmCodegenUtil() {
    }

    public static boolean isAnnotationOrJvmInterfaceWithoutDefaults(@NotNull DeclarationDescriptor descriptor2, @NotNull GenerationState state2) {
        if (descriptor2 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(0);
        }
        if (state2 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(1);
        }
        return JvmCodegenUtil.isAnnotationOrJvmInterfaceWithoutDefaults(descriptor2, state2.isJvm8Target(), state2.isJvm8TargetWithDefaults());
    }

    private static boolean isAnnotationOrJvmInterfaceWithoutDefaults(@NotNull DeclarationDescriptor descriptor2, boolean isJvm8Target, boolean isJvm8TargetWithDefaults) {
        SourceElement source;
        if (descriptor2 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(2);
        }
        if (!JvmCodegenUtil.isJvmInterface(descriptor2)) {
            return false;
        }
        if (ClassKind.ANNOTATION_CLASS == ((ClassDescriptor)descriptor2).getKind()) {
            return true;
        }
        if (descriptor2 instanceof DeserializedClassDescriptor && (source = ((DeserializedClassDescriptor)descriptor2).getSource()) instanceof KotlinJvmBinarySourceElement) {
            KotlinJvmBinaryClass binaryClass = ((KotlinJvmBinarySourceElement)source).getBinaryClass();
            assert (binaryClass instanceof FileBasedKotlinClass) : "KotlinJvmBinaryClass should be subclass of FileBasedKotlinClass, but " + binaryClass;
            return true;
        }
        return !isJvm8TargetWithDefaults;
    }

    public static boolean isJvm8InterfaceWithDefaults(@NotNull DeclarationDescriptor descriptor2, @NotNull GenerationState state2) {
        if (descriptor2 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(3);
        }
        if (state2 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(4);
        }
        return JvmCodegenUtil.isJvm8InterfaceWithDefaults(descriptor2, state2.isJvm8Target(), state2.isJvm8TargetWithDefaults());
    }

    public static boolean isJvm8InterfaceWithDefaults(@NotNull DeclarationDescriptor descriptor2, boolean isJvm8Target, boolean isJvm8TargetWithDefaults) {
        if (descriptor2 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(5);
        }
        return DescriptorUtils.isInterface(descriptor2) && !JvmCodegenUtil.isAnnotationOrJvmInterfaceWithoutDefaults(descriptor2, isJvm8Target, isJvm8TargetWithDefaults);
    }

    public static boolean isJvm8InterfaceWithDefaultsMember(@NotNull CallableMemberDescriptor descriptor2, @NotNull GenerationState state2) {
        if (descriptor2 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(6);
        }
        if (state2 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(7);
        }
        DeclarationDescriptor declaration = descriptor2.getContainingDeclaration();
        return JvmCodegenUtil.isJvm8InterfaceWithDefaults(declaration, state2);
    }

    public static boolean isNonDefaultInterfaceMember(@NotNull CallableMemberDescriptor descriptor2, @NotNull GenerationState state2) {
        if (descriptor2 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(8);
        }
        if (state2 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(9);
        }
        if (!JvmCodegenUtil.isJvmInterface(descriptor2.getContainingDeclaration())) {
            return false;
        }
        if (descriptor2 instanceof JavaCallableMemberDescriptor) {
            return descriptor2.getModality() == Modality.ABSTRACT;
        }
        return !JvmCodegenUtil.isJvm8InterfaceWithDefaultsMember(descriptor2, state2);
    }

    public static boolean isJvmInterface(DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof ClassDescriptor) {
            ClassKind kind = ((ClassDescriptor)descriptor2).getKind();
            return kind == ClassKind.INTERFACE || kind == ClassKind.ANNOTATION_CLASS;
        }
        return false;
    }

    public static boolean isJvmInterface(KotlinType type2) {
        return JvmCodegenUtil.isJvmInterface(type2.getConstructor().getDeclarationDescriptor());
    }

    public static boolean isConst(@NotNull CalculatedClosure closure) {
        if (closure == null) {
            JvmCodegenUtil.$$$reportNull$$$0(10);
        }
        return closure.getCaptureThis() == null && closure.getCaptureReceiverType() == null && closure.getCaptureVariables().isEmpty() && !closure.isSuspend();
    }

    private static boolean isCallInsideSameClassAsDeclared(@NotNull CallableMemberDescriptor descriptor2, @NotNull CodegenContext context) {
        if (descriptor2 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(11);
        }
        if (context == null) {
            JvmCodegenUtil.$$$reportNull$$$0(12);
        }
        boolean isFakeOverride = descriptor2.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE;
        boolean isDelegate = descriptor2.getKind() == CallableMemberDescriptor.Kind.DELEGATION;
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration().getOriginal();
        return !isFakeOverride && !isDelegate && (context.hasThisDescriptor() && containingDeclaration == context.getThisDescriptor() || context.getParentContext() instanceof FacadePartWithSourceFile && JvmCodegenUtil.isWithinSameFile(((FacadePartWithSourceFile)((Object)context.getParentContext())).getSourceFile(), descriptor2)) && context.getContextKind() != OwnerKind.DEFAULT_IMPLS;
    }

    private static boolean isWithinSameFile(@Nullable KtFile callerFile, @NotNull CallableMemberDescriptor descriptor2) {
        DeclarationDescriptor containingDeclaration;
        if (descriptor2 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(13);
        }
        if ((containingDeclaration = descriptor2.getContainingDeclaration().getOriginal()) instanceof PackageFragmentDescriptor) {
            PsiElement calleeElement = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
            PsiFile calleeFile = calleeElement != null ? calleeElement.getContainingFile() : null;
            return callerFile != null && callerFile != SourceFile.NO_SOURCE_FILE && calleeFile == callerFile;
        }
        return false;
    }

    public static boolean isCallInsideSameModuleAsDeclared(@NotNull CallableMemberDescriptor declarationDescriptor, @NotNull CodegenContext context, @Nullable File outDirectory) {
        if (declarationDescriptor == null) {
            JvmCodegenUtil.$$$reportNull$$$0(14);
        }
        if (context == null) {
            JvmCodegenUtil.$$$reportNull$$$0(15);
        }
        if (context instanceof RootContext) {
            return true;
        }
        Object contextDescriptor = context.getContextDescriptor();
        CallableMemberDescriptor directMember = JvmCodegenUtil.getDirectMember(declarationDescriptor);
        if (directMember instanceof DeserializedCallableMemberDescriptor) {
            return ModuleVisibilityUtilsKt.isContainedByCompiledPartOfOurModule(directMember, outDirectory);
        }
        return DescriptorUtils.areInSameModule(directMember, contextDescriptor);
    }

    public static boolean hasAbstractMembers(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            JvmCodegenUtil.$$$reportNull$$$0(16);
        }
        return CollectionsKt.any(DescriptorUtils.getAllDescriptors(classDescriptor.getDefaultType().getMemberScope()), descriptor2 -> descriptor2 instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)descriptor2).getModality() == Modality.ABSTRACT);
    }

    public static boolean isConstOrHasJvmFieldAnnotation(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            JvmCodegenUtil.$$$reportNull$$$0(17);
        }
        return propertyDescriptor.isConst() || AnnotationUtilKt.hasJvmFieldAnnotation(propertyDescriptor);
    }

    public static boolean couldUseDirectAccessToProperty(@NotNull PropertyDescriptor property, boolean forGetter, boolean isDelegated, @NotNull MethodContext contextBeforeInline, boolean shouldInlineConstVals) {
        PropertyAccessorDescriptor accessor;
        if (property == null) {
            JvmCodegenUtil.$$$reportNull$$$0(18);
        }
        if (contextBeforeInline == null) {
            JvmCodegenUtil.$$$reportNull$$$0(19);
        }
        if (shouldInlineConstVals && property.isConst()) {
            return true;
        }
        if (KotlinTypeMapper.isAccessor(property)) {
            return false;
        }
        CodegenContext context = contextBeforeInline.getFirstCrossInlineOrNonInlineContext();
        if (context.isInlineMethodContext()) {
            return false;
        }
        if (!JvmCodegenUtil.isCallInsideSameClassAsDeclared(property, context)) {
            if (!JvmCodegenUtil.isDebuggerContext(context)) {
                return false;
            }
            for (PropertyAccessorDescriptor accessorDescriptor : property.getAccessors()) {
                if (accessorDescriptor.isDefault() || forGetter != accessorDescriptor instanceof PropertyGetterDescriptor) continue;
                return false;
            }
            if (!property.getOverriddenDescriptors().isEmpty()) {
                return false;
            }
        }
        if (isDelegated || property.getExtensionReceiverParameter() != null) {
            return false;
        }
        if (DescriptorUtils.isCompanionObject(property.getContainingDeclaration())) {
            return false;
        }
        PropertyAccessorDescriptor propertyAccessorDescriptor = accessor = forGetter ? property.getGetter() : property.getSetter();
        if (accessor == null) {
            return true;
        }
        if (DescriptorPsiUtilsKt.hasBody(accessor)) {
            return false;
        }
        return Visibilities.isPrivate(property.getVisibility()) || accessor.getModality() == Modality.FINAL;
    }

    private static boolean isDebuggerContext(@NotNull CodegenContext context) {
        KtFile file2;
        if (context == null) {
            JvmCodegenUtil.$$$reportNull$$$0(20);
        }
        return (file2 = DescriptorToSourceUtils.getContainingFile(context.getContextDescriptor())) != null && CodeFragmentUtilKt.getSuppressDiagnosticsInDebugMode(file2);
    }

    @Nullable
    public static ClassDescriptor getDispatchReceiverParameterForConstructorCall(@NotNull ConstructorDescriptor descriptor2, @Nullable CalculatedClosure closure) {
        ClassDescriptor expectedThisClass;
        if (descriptor2 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(21);
        }
        if (closure != null) {
            return closure.getCaptureThis();
        }
        ReceiverParameterDescriptor dispatchReceiver = descriptor2.getDispatchReceiverParameter();
        if (dispatchReceiver != null && !(expectedThisClass = (ClassDescriptor)dispatchReceiver.getContainingDeclaration()).getKind().isSingleton()) {
            return expectedThisClass;
        }
        return null;
    }

    @NotNull
    public static CallableMemberDescriptor getDirectMember(@NotNull CallableMemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(22);
        }
        CallableMemberDescriptor callableMemberDescriptor = DescriptorUtils.getDirectMember(descriptor2);
        if (callableMemberDescriptor == null) {
            JvmCodegenUtil.$$$reportNull$$$0(23);
        }
        return callableMemberDescriptor;
    }

    public static boolean isArgumentWhichWillBeInlined(@NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor descriptor2) {
        PsiElement declaration;
        if (bindingContext == null) {
            JvmCodegenUtil.$$$reportNull$$$0(24);
        }
        if (descriptor2 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(25);
        }
        return InlineUtil.canBeInlineArgument(declaration = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2)) && InlineUtil.isInlinedArgument((KtFunction)declaration, bindingContext, false);
    }

    @NotNull
    public static String getModuleName(ModuleDescriptor module) {
        String string = StringsKt.removeSurrounding(module.getName().asString(), (CharSequence)"<", (CharSequence)">");
        if (string == null) {
            JvmCodegenUtil.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public static String getMappingFileName(@NotNull String moduleName) {
        if (moduleName == null) {
            JvmCodegenUtil.$$$reportNull$$$0(27);
        }
        String string = "META-INF/" + moduleName + "." + "kotlin_module";
        if (string == null) {
            JvmCodegenUtil.$$$reportNull$$$0(28);
        }
        return string;
    }

    public static boolean isInlinedJavaConstProperty(VariableDescriptor descriptor2) {
        if (!(descriptor2 instanceof JavaPropertyDescriptor)) {
            return false;
        }
        return descriptor2.isConst();
    }

    @Nullable
    public static KotlinType getPropertyDelegateType(@NotNull VariableDescriptorWithAccessors descriptor2, @NotNull BindingContext bindingContext) {
        Call call2;
        VariableAccessorDescriptor getter2;
        if (descriptor2 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(29);
        }
        if (bindingContext == null) {
            JvmCodegenUtil.$$$reportNull$$$0(30);
        }
        if ((getter2 = descriptor2.getGetter()) != null && (call2 = bindingContext.get(BindingContext.DELEGATED_PROPERTY_CALL, getter2)) != null) {
            assert (call2.getExplicitReceiver() != null) : "No explicit receiver for call:" + call2;
            return ((ReceiverValue)call2.getExplicitReceiver()).getType();
        }
        return null;
    }

    public static boolean isDelegatedLocalVariable(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(31);
        }
        return descriptor2 instanceof LocalVariableDescriptor && ((LocalVariableDescriptor)descriptor2).isDelegated();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 23: 
            case 26: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 23: 
            case 26: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
            case 12: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationDescriptor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDescriptor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyDescriptor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextBeforeInline";
                break;
            }
            case 23: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/JvmCodegenUtil";
                break;
            }
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingContext";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/JvmCodegenUtil";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectMember";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleName";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotationOrJvmInterfaceWithoutDefaults";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isJvm8InterfaceWithDefaults";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isJvm8InterfaceWithDefaultsMember";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isNonDefaultInterfaceMember";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isConst";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isCallInsideSameClassAsDeclared";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isWithinSameFile";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isCallInsideSameModuleAsDeclared";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "hasAbstractMembers";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isConstOrHasJvmFieldAnnotation";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "couldUseDirectAccessToProperty";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isDebuggerContext";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDispatchReceiverParameterForConstructorCall";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getDirectMember";
                break;
            }
            case 23: 
            case 26: 
            case 28: {
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isArgumentWhichWillBeInlined";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getMappingFileName";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyDelegateType";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isDelegatedLocalVariable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 23: 
            case 26: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

