#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: darcs
version: 2.12.5
id: darcs-2.12.5-8WzZzVmNi0Z2GV0BogCHQI
key: darcs-2.12.5-8WzZzVmNi0Z2GV0BogCHQI
license: GPL
maintainer: <darcs-devel@darcs.net>
stability: Experimental
homepage: http://darcs.net/
synopsis: a distributed, interactive, smart revision control system
description:
    Darcs is a free, open source revision control
    system. It is:
    .
    * Distributed: Every user has access to the full
    command set, removing boundaries between server and
    client or committer and non-committers.
    .
    * Interactive: Darcs is easy to learn and efficient to
    use because it asks you questions in response to
    simple commands, giving you choices in your work
    flow. You can choose to record one change in a file,
    while ignoring another. As you update from upstream,
    you can review each patch name, even the full "diff"
    for interesting patches.
    .
    * Smart: Originally developed by physicist David
    Roundy, darcs is based on a unique algebra of
    patches.
    .
    This smartness lets you respond to changing demands
    in ways that would otherwise not be possible. Learn
    more about spontaneous branches with darcs.
category: Development
author: David Roundy <droundy@darcs.net>, <darcs-devel@darcs.net>
exposed: True
exposed-modules:
    Darcs.Patch Darcs.Patch.Annotate Darcs.Patch.Apply
    Darcs.Patch.ApplyMonad Darcs.Patch.ApplyPatches
    Darcs.Patch.Bracketed Darcs.Patch.Bracketed.Instances
    Darcs.Patch.Bundle Darcs.Patch.Choices Darcs.Patch.Commute
    Darcs.Patch.CommuteFn Darcs.Patch.Conflict Darcs.Patch.Debug
    Darcs.Patch.Depends Darcs.Patch.Dummy Darcs.Patch.Effect
    Darcs.Patch.FileHunk Darcs.Patch.Index.Monad
    Darcs.Patch.Index.Types Darcs.Patch.Format Darcs.Patch.Info
    Darcs.Patch.Inspect Darcs.Patch.Invert Darcs.Patch.Match
    Darcs.Patch.Matchable Darcs.Patch.Merge Darcs.Patch.MonadProgress
    Darcs.Patch.Named Darcs.Patch.Named.Wrapped Darcs.Patch.OldDate
    Darcs.Patch.PatchInfoAnd Darcs.Patch.Patchy
    Darcs.Patch.Patchy.Instances Darcs.Patch.Permutations
    Darcs.Patch.Prim Darcs.Patch.Prim.Class Darcs.Patch.Prim.V1
    Darcs.Patch.Prim.V1.Apply Darcs.Patch.Prim.V1.Coalesce
    Darcs.Patch.Prim.V1.Commute Darcs.Patch.Prim.V1.Core
    Darcs.Patch.Prim.V1.Details Darcs.Patch.Prim.V1.Read
    Darcs.Patch.Prim.V1.Show Darcs.Patch.Prim.FileUUID
    Darcs.Patch.Prim.FileUUID.ObjectMap Darcs.Patch.Prim.FileUUID.Apply
    Darcs.Patch.Prim.FileUUID.Coalesce
    Darcs.Patch.Prim.FileUUID.Commute Darcs.Patch.Prim.FileUUID.Core
    Darcs.Patch.Prim.FileUUID.Details Darcs.Patch.Prim.FileUUID.Read
    Darcs.Patch.Prim.FileUUID.Show Darcs.Patch.Progress
    Darcs.Patch.Read Darcs.Patch.Rebase Darcs.Patch.Rebase.Container
    Darcs.Patch.Rebase.Fixup Darcs.Patch.Rebase.Item
    Darcs.Patch.Rebase.Name Darcs.Patch.Rebase.Viewing
    Darcs.Patch.ReadMonads Darcs.Patch.RegChars Darcs.Patch.Repair
    Darcs.Patch.RepoPatch Darcs.Patch.RepoType Darcs.Patch.Set
    Darcs.Patch.Show Darcs.Patch.Split Darcs.Patch.Summary
    Darcs.Patch.SummaryData Darcs.Patch.TokenReplace
    Darcs.Patch.TouchesFiles Darcs.Patch.Type Darcs.Patch.Viewing
    Darcs.Patch.V1 Darcs.Patch.V1.Apply Darcs.Patch.V1.Commute
    Darcs.Patch.V1.Core Darcs.Patch.V1.Read Darcs.Patch.V1.Show
    Darcs.Patch.V1.Viewing Darcs.Patch.V2 Darcs.Patch.V2.Non
    Darcs.Patch.V2.RepoPatch Darcs.Patch.Witnesses.Eq
    Darcs.Patch.Witnesses.Ordered Darcs.Patch.Witnesses.Sealed
    Darcs.Patch.Witnesses.Show Darcs.Patch.Witnesses.Unsafe
    Darcs.Patch.Witnesses.WZipper Darcs.Prelude Darcs.Repository
    Darcs.Repository.ApplyPatches Darcs.Repository.Cache
    Darcs.Repository.Clone Darcs.Repository.PatchIndex
    Darcs.Repository.Diff Darcs.Repository.Flags
    Darcs.Repository.Format Darcs.Repository.HashedIO
    Darcs.Repository.HashedRepo Darcs.Repository.Internal
    Darcs.Repository.Job Darcs.Repository.Merge
    Darcs.Repository.InternalTypes Darcs.Repository.Match
    Darcs.Repository.Motd Darcs.Repository.Old Darcs.Repository.Packs
    Darcs.Repository.Pending Darcs.Repository.Prefs
    Darcs.Repository.Rebase Darcs.Repository.Repair
    Darcs.Repository.Resolution Darcs.Repository.State
    Darcs.Repository.Test Darcs.UI.ApplyPatches Darcs.UI.Commands
    Darcs.UI.Commands.Add Darcs.UI.Commands.Amend
    Darcs.UI.Commands.Annotate Darcs.UI.Commands.Apply
    Darcs.UI.CommandsAux Darcs.UI.Commands.Clone
    Darcs.UI.Commands.Convert Darcs.UI.Commands.Diff
    Darcs.UI.Commands.Dist Darcs.UI.Commands.GZCRCs
    Darcs.UI.Commands.Help Darcs.UI.Commands.Init Darcs.UI.Commands.Log
    Darcs.UI.Commands.MarkConflicts Darcs.UI.Commands.Move
    Darcs.UI.Commands.Optimize Darcs.UI.Commands.Pull
    Darcs.UI.Commands.Push Darcs.UI.Commands.Rebase
    Darcs.UI.Commands.Record Darcs.UI.Commands.Remove
    Darcs.UI.Commands.Repair Darcs.UI.Commands.Replace
    Darcs.UI.Commands.Revert Darcs.UI.Commands.Rollback
    Darcs.UI.Commands.Send Darcs.UI.Commands.SetPref
    Darcs.UI.Commands.Show Darcs.UI.Commands.ShowAuthors
    Darcs.UI.Commands.ShowBug Darcs.UI.Commands.ShowContents
    Darcs.UI.Commands.ShowDependencies Darcs.UI.Commands.ShowFiles
    Darcs.UI.Commands.ShowIndex Darcs.UI.Commands.ShowPatchIndex
    Darcs.UI.Commands.ShowRepo Darcs.UI.Commands.ShowTags
    Darcs.UI.Commands.Tag Darcs.UI.Commands.Test
    Darcs.UI.Commands.TransferMode Darcs.UI.Commands.Util
    Darcs.UI.Commands.Util.Tree Darcs.UI.Commands.Unrecord
    Darcs.UI.Commands.Unrevert Darcs.UI.Commands.WhatsNew
    Darcs.UI.Email Darcs.UI.External Darcs.UI.Defaults Darcs.UI.Flags
    Darcs.UI.Options Darcs.UI.Options.All Darcs.UI.Options.Core
    Darcs.UI.Options.Flags Darcs.UI.Options.Iso
    Darcs.UI.Options.Markdown Darcs.UI.Options.Matching
    Darcs.UI.Options.Util Darcs.UI.PatchHeader Darcs.UI.PrintPatch
    Darcs.UI.RunCommand Darcs.UI.SelectChanges Darcs.UI.TheCommands
    Darcs.UI.Usage Darcs.UI.Message.Send Darcs.Util.AtExit
    Darcs.Util.Bug Darcs.Util.ByteString Darcs.Util.CommandLine
    Darcs.Util.Compat Darcs.Util.Crypt.SHA1 Darcs.Util.Crypt.SHA256
    Darcs.Util.DateMatcher Darcs.Util.DateTime Darcs.Util.Diff
    Darcs.Util.Diff.Myers Darcs.Util.Diff.Patience Darcs.Util.Download
    Darcs.Util.Download.Request Darcs.Util.Download.HTTP
    Darcs.Util.English Darcs.Util.Environment Darcs.Util.Exception
    Darcs.Util.Exec Darcs.Util.External Darcs.Util.File
    Darcs.Util.Global Darcs.Util.Hash Darcs.Util.Index
    Darcs.Util.IsoDate Darcs.Util.Lock Darcs.Util.Path
    Darcs.Util.Printer Darcs.Util.Printer.Color Darcs.Util.Progress
    Darcs.Util.Prompt Darcs.Util.Ratified Darcs.Util.Show
    Darcs.Util.SignalHandler Darcs.Util.Ssh Darcs.Util.Text
    Darcs.Util.Tree Darcs.Util.Tree.Hashed Darcs.Util.Tree.Monad
    Darcs.Util.Tree.Plain Darcs.Util.URL Darcs.Util.Workaround
    Bundled.Posix
hidden-modules: Version Darcs.Util.Download.Curl
                Darcs.Util.Encoding Darcs.Util.Encoding.IConv
abi: 0960f566a92a49c9bdce639ca187e694
trusted: False
import-dirs: /usr/lib/ghc-8.0.2/site-local/darcs-2.12.5
library-dirs: /usr/lib/ghc-8.0.2/site-local/darcs-2.12.5
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.0.2/darcs-2.12.5
hs-libraries: HSdarcs-2.12.5-8WzZzVmNi0Z2GV0BogCHQI
extra-libraries:
    curl
depends:
    HTTP-4000.3.7-C67mjM47SfREJVHCgq4Jk3 array-0.5.1.1
    async-2.1.1.1-2GwQEYzLBsdIBCHbNA3HGy
    attoparsec-0.13.1.0-7xLJO1EwFQpJLBzOR8WqkC base-4.9.1.0
    base16-bytestring-0.1.1.6-4E2p94lTx8gIceMhu8Kl9o binary-0.8.3.0
    bytestring-0.10.8.1 containers-0.5.7.1
    cryptohash-0.11.9-nV9PicWnhFKGeRwzGvWXI
    data-ordlist-0.4.7.0-D6ij7F9rr5a9kcQtGict4V directory-1.3.0.0
    fgl-5.5.3.1-6LdDICWL6Ze3rGuqhKrQHQ filepath-1.4.1.1
    graphviz-2999.18.1.2-4gp4faQyYqS9VH3gGXUG5r
    hashable-1.2.6.1-2nPqxcHq7mUGgurrYaLtXr haskeline-0.7.3.0
    html-1.0.1.2-8wVtehjIxUEBYXzRus7033
    mmap-0.5.9-IOUZUUQXpolHbXRgP4hWIu mtl-2.2.1-BLKBelFsPB3BoFeSWSOYj6
    network-2.6.3.2-IsLM4TXcLoRI0fmmBYVyQz
    network-uri-2.6.1.0-GzRvaV3udR3JtWfa3CLYOw
    old-time-1.1.0.3-EZzkBJ4NQxX4hHavrKxgaT
    parsec-3.1.11-1CA7c0vSU7tJHGhveOjoXR process-1.4.3.0
    random-1.1-9tceXaeYIMZ4JrKq20Egog
    regex-applicative-0.3.3-9dbODILokN54la9GS4TJob
    regex-compat-tdfa-0.95.1.4-EogmkzYqmCDHjO3inrUWTV
    sandi-0.4.0-I5O0jNiPZ6m9UdCLz0dCOt
    tar-0.5.0.3-60pC6grTbvG2zWoTgfDWBJ terminfo-0.4.0.2
    text-1.2.2.2-3ENqlljngKa6xj1Go2fVWq time-1.6.0.1
    transformers-0.5.2.0
    transformers-compat-0.5.1.4-IuFogs8HAVUJBWVNMhtssu unix-2.7.2.1
    unix-compat-0.4.3.1-Ausmw6d7KIwA7sl52mzqxC
    utf8-string-1.0.1.1-1DpjxLeTvGg7ttZZojxJR5
    vector-0.12.0.1-692PQMDMB6pIQ1uGwefDcQ
    zip-archive-0.3.1.1-CTnIdx1PD2R28s6Hv1Ft3y
    zlib-0.6.1.2-GcLmGV5PElZD6CJvjR9umm
haddock-interfaces: /usr/share/doc/darcs/html/darcs.haddock
haddock-html: /usr/share/doc/darcs/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
