/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Service;
import javax.mail.Session;
import javax.mail.URLName;
import javax.mail.event.TransportEvent;
import javax.mail.event.TransportListener;

public abstract class Transport
extends Service {
    private ArrayList transportListeners = null;

    public Transport(Session session, URLName url) {
        super(session, url);
    }

    public static void send(Message msg) throws MessagingException {
        msg.saveChanges();
        Transport.doSend(msg, msg.getAllRecipients());
    }

    public static void send(Message msg, Address[] addresses) throws MessagingException {
        msg.saveChanges();
        Transport.doSend(msg, addresses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doSend(Message msg, Address[] addresses) throws MessagingException {
        if (addresses == null || addresses.length == 0) {
            throw new SendFailedException("No recipient addresses");
        }
        HashMap addressesByType = new HashMap();
        for (int i = 0; i < addresses.length; ++i) {
            String type = addresses[i].getType();
            if (addressesByType.containsKey(type)) {
                ((ArrayList)addressesByType.get(type)).add(addresses[i]);
                continue;
            }
            ArrayList<Address> addressList = new ArrayList<Address>();
            addressList.add(addresses[i]);
            addressesByType.put(type, addressList);
        }
        int size = addressesByType.size();
        if (size == 0) {
            throw new SendFailedException("No recipient addresses");
        }
        Session session = msg.session;
        if (session == null) {
            session = Session.getDefaultInstance(System.getProperties(), null);
        }
        MessagingException ex = null;
        boolean error = false;
        ArrayList<Address> validSent = new ArrayList<Address>();
        ArrayList<Address> validUnsent = new ArrayList<Address>();
        ArrayList<Address> invalid = new ArrayList<Address>();
        for (ArrayList addressList : addressesByType.values()) {
            Address[] addressArray = new Address[addressList.size()];
            addressList.toArray(addressArray);
            if (addressArray.length < 1) break;
            Transport transport = session.getTransport(addressArray[0]);
            if (transport == null) {
                invalid.addAll(Arrays.asList(addressArray));
                continue;
            }
            try {
                transport.connect();
                transport.sendMessage(msg, addressArray);
            }
            catch (SendFailedException sfex) {
                error = true;
                if (ex == null) {
                    ex = sfex;
                } else {
                    ex.setNextException(sfex);
                }
                Address[] a = sfex.getValidSentAddresses();
                if (a != null) {
                    validSent.addAll(Arrays.asList(a));
                }
                if ((a = sfex.getValidUnsentAddresses()) != null) {
                    validUnsent.addAll(Arrays.asList(a));
                }
                if ((a = sfex.getInvalidAddresses()) == null) continue;
                invalid.addAll(Arrays.asList(a));
            }
            catch (MessagingException mex) {
                error = true;
                if (ex == null) {
                    ex = mex;
                    continue;
                }
                ex.setNextException(mex);
            }
            finally {
                transport.close();
            }
        }
        if (error || invalid.size() != 0 || validSent.size() != 0) {
            Address[] validSentAddresses = null;
            Address[] validUnsentAddresses = null;
            Address[] invalidAddresses = null;
            if (validSent.size() > 0) {
                validSentAddresses = new Address[validSent.size()];
                validSent.toArray(validSentAddresses);
            }
            if (validUnsent.size() > 0) {
                validUnsentAddresses = new Address[validUnsent.size()];
                validUnsent.toArray(validUnsentAddresses);
            }
            if (invalid.size() > 0) {
                invalidAddresses = new Address[invalid.size()];
                invalid.toArray(invalidAddresses);
            }
            throw new SendFailedException("Send failed", ex, validSentAddresses, validUnsentAddresses, invalidAddresses);
        }
    }

    public abstract void sendMessage(Message var1, Address[] var2) throws MessagingException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransportListener(TransportListener l) {
        if (this.transportListeners == null) {
            this.transportListeners = new ArrayList();
        }
        ArrayList arrayList = this.transportListeners;
        synchronized (arrayList) {
            this.transportListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransportListener(TransportListener l) {
        if (this.transportListeners != null) {
            ArrayList arrayList = this.transportListeners;
            synchronized (arrayList) {
                this.transportListeners.remove(l);
            }
        }
    }

    protected void notifyTransportListeners(int type, Address[] validSent, Address[] validUnsent, Address[] invalid, Message msg) {
        TransportEvent event = new TransportEvent(this, type, validSent, validUnsent, invalid, msg);
        switch (type) {
            case 1: {
                this.fireMessageDelivered(event);
                break;
            }
            case 2: {
                this.fireMessageNotDelivered(event);
                break;
            }
            case 3: {
                this.fireMessagePartiallyDelivered(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireMessageDelivered(TransportEvent event) {
        if (this.transportListeners != null) {
            TransportListener[] l = null;
            ArrayList arrayList = this.transportListeners;
            synchronized (arrayList) {
                l = new TransportListener[this.transportListeners.size()];
                this.transportListeners.toArray(l);
            }
            for (int i = 0; i < l.length; ++i) {
                l[i].messageDelivered(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireMessageNotDelivered(TransportEvent event) {
        if (this.transportListeners != null) {
            TransportListener[] l = null;
            ArrayList arrayList = this.transportListeners;
            synchronized (arrayList) {
                l = new TransportListener[this.transportListeners.size()];
                this.transportListeners.toArray(l);
            }
            for (int i = 0; i < l.length; ++i) {
                l[i].messageNotDelivered(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireMessagePartiallyDelivered(TransportEvent event) {
        if (this.transportListeners != null) {
            TransportListener[] l = null;
            ArrayList arrayList = this.transportListeners;
            synchronized (arrayList) {
                l = new TransportListener[this.transportListeners.size()];
                this.transportListeners.toArray(l);
            }
            for (int i = 0; i < l.length; ++i) {
                l[i].messagePartiallyDelivered(event);
            }
        }
    }
}

