/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.loader;

import java.beans.Introspector;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.catalina.Container;
import org.apache.catalina.Globals;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.loader.ResourceEntry;
import org.apache.catalina.webresources.TomcatURLStreamHandlerFactory;
import org.apache.juli.WebappProperties;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.InstrumentableClassLoader;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.compat.JreVendor;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.security.PermissionCheck;

public abstract class WebappClassLoaderBase
extends URLClassLoader
implements Lifecycle,
InstrumentableClassLoader,
WebappProperties,
PermissionCheck {
    private static final Log log = LogFactory.getLog(WebappClassLoaderBase.class);
    private static final List<String> JVM_THREAD_GROUP_NAMES = new ArrayList<String>();
    private static final String JVM_THREAD_GROUP_SYSTEM = "system";
    private static final String CLASS_FILE_SUFFIX = ".class";
    private static final String SERVICES_PREFIX = "/META-INF/services/";
    protected static final StringManager sm;
    protected WebResourceRoot resources = null;
    protected final Map<String, ResourceEntry> resourceEntries = new ConcurrentHashMap<String, ResourceEntry>();
    protected boolean delegate = false;
    private final HashMap<String, Long> jarModificationTimes = new HashMap();
    protected final ArrayList<Permission> permissionList = new ArrayList();
    protected final HashMap<String, PermissionCollection> loaderPC = new HashMap();
    protected final SecurityManager securityManager;
    protected final ClassLoader parent;
    private ClassLoader javaseClassLoader;
    protected boolean needConvert = false;
    protected final Permission allPermission = new AllPermission();
    private boolean clearReferencesRmiTargets = true;
    @Deprecated
    private boolean clearReferencesStatic = false;
    private boolean clearReferencesStopThreads = false;
    private boolean clearReferencesStopTimerThreads = false;
    private boolean clearReferencesLogFactoryRelease = true;
    private boolean clearReferencesHttpClientKeepAliveThread = true;
    private final List<ClassFileTransformer> transformers = new CopyOnWriteArrayList<ClassFileTransformer>();
    private boolean hasExternalRepositories = false;
    private List<URL> localRepositories = new ArrayList<URL>();
    private volatile LifecycleState state = LifecycleState.NEW;

    protected WebappClassLoaderBase() {
        super(new URL[0]);
        ClassLoader p = this.getParent();
        if (p == null) {
            p = WebappClassLoaderBase.getSystemClassLoader();
        }
        this.parent = p;
        ClassLoader j = String.class.getClassLoader();
        if (j == null) {
            j = WebappClassLoaderBase.getSystemClassLoader();
            while (j.getParent() != null) {
                j = j.getParent();
            }
        }
        this.javaseClassLoader = j;
        this.securityManager = System.getSecurityManager();
        if (this.securityManager != null) {
            this.refreshPolicy();
        }
    }

    protected WebappClassLoaderBase(ClassLoader parent) {
        super(new URL[0], parent);
        ClassLoader p = this.getParent();
        if (p == null) {
            p = WebappClassLoaderBase.getSystemClassLoader();
        }
        this.parent = p;
        ClassLoader j = String.class.getClassLoader();
        if (j == null) {
            j = WebappClassLoaderBase.getSystemClassLoader();
            while (j.getParent() != null) {
                j = j.getParent();
            }
        }
        this.javaseClassLoader = j;
        this.securityManager = System.getSecurityManager();
        if (this.securityManager != null) {
            this.refreshPolicy();
        }
    }

    public WebResourceRoot getResources() {
        return this.resources;
    }

    public void setResources(WebResourceRoot resources) {
        this.resources = resources;
    }

    public String getContextName() {
        if (this.resources == null) {
            return "Unknown";
        }
        return this.resources.getContext().getBaseName();
    }

    public boolean getDelegate() {
        return this.delegate;
    }

    public void setDelegate(boolean delegate) {
        this.delegate = delegate;
    }

    void addPermission(URL url) {
        if (url == null) {
            return;
        }
        if (this.securityManager != null) {
            String protocol = url.getProtocol();
            if ("file".equalsIgnoreCase(protocol)) {
                String path;
                File f;
                try {
                    URI uri = url.toURI();
                    f = new File(uri);
                    path = f.getCanonicalPath();
                }
                catch (IOException | URISyntaxException e) {
                    log.warn((Object)sm.getString("webappClassLoader.addPermisionNoCanonicalFile", new Object[]{url.toExternalForm()}));
                    return;
                }
                if (f.isFile()) {
                    this.addPermission(new FilePermission(path, "read"));
                } else if (f.isDirectory()) {
                    this.addPermission(new FilePermission(path, "read"));
                    this.addPermission(new FilePermission(path + File.separator + "-", "read"));
                }
            } else {
                log.warn((Object)sm.getString("webappClassLoader.addPermisionNoProtocol", new Object[]{protocol, url.toExternalForm()}));
            }
        }
    }

    void addPermission(Permission permission) {
        if (this.securityManager != null && permission != null) {
            this.permissionList.add(permission);
        }
    }

    public boolean getClearReferencesRmiTargets() {
        return this.clearReferencesRmiTargets;
    }

    public void setClearReferencesRmiTargets(boolean clearReferencesRmiTargets) {
        this.clearReferencesRmiTargets = clearReferencesRmiTargets;
    }

    @Deprecated
    public boolean getClearReferencesStatic() {
        return this.clearReferencesStatic;
    }

    @Deprecated
    public void setClearReferencesStatic(boolean clearReferencesStatic) {
        this.clearReferencesStatic = clearReferencesStatic;
    }

    public boolean getClearReferencesStopThreads() {
        return this.clearReferencesStopThreads;
    }

    public void setClearReferencesStopThreads(boolean clearReferencesStopThreads) {
        this.clearReferencesStopThreads = clearReferencesStopThreads;
    }

    public boolean getClearReferencesStopTimerThreads() {
        return this.clearReferencesStopTimerThreads;
    }

    public void setClearReferencesStopTimerThreads(boolean clearReferencesStopTimerThreads) {
        this.clearReferencesStopTimerThreads = clearReferencesStopTimerThreads;
    }

    public boolean getClearReferencesLogFactoryRelease() {
        return this.clearReferencesLogFactoryRelease;
    }

    public void setClearReferencesLogFactoryRelease(boolean clearReferencesLogFactoryRelease) {
        this.clearReferencesLogFactoryRelease = clearReferencesLogFactoryRelease;
    }

    public boolean getClearReferencesHttpClientKeepAliveThread() {
        return this.clearReferencesHttpClientKeepAliveThread;
    }

    public void setClearReferencesHttpClientKeepAliveThread(boolean clearReferencesHttpClientKeepAliveThread) {
        this.clearReferencesHttpClientKeepAliveThread = clearReferencesHttpClientKeepAliveThread;
    }

    public void addTransformer(ClassFileTransformer transformer) {
        if (transformer == null) {
            throw new IllegalArgumentException(sm.getString("webappClassLoader.addTransformer.illegalArgument", new Object[]{this.getContextName()}));
        }
        if (this.transformers.contains(transformer)) {
            log.warn((Object)sm.getString("webappClassLoader.addTransformer.duplicate", new Object[]{transformer, this.getContextName()}));
            return;
        }
        this.transformers.add(transformer);
        log.info((Object)sm.getString("webappClassLoader.addTransformer", new Object[]{transformer, this.getContextName()}));
    }

    public void removeTransformer(ClassFileTransformer transformer) {
        if (transformer == null) {
            return;
        }
        if (this.transformers.remove(transformer)) {
            log.info((Object)sm.getString("webappClassLoader.removeTransformer", new Object[]{transformer, this.getContextName()}));
            return;
        }
    }

    protected void copyStateWithoutTransformers(WebappClassLoaderBase base) {
        base.resources = this.resources;
        base.delegate = this.delegate;
        base.state = LifecycleState.NEW;
        base.needConvert = this.needConvert;
        base.clearReferencesStatic = this.clearReferencesStatic;
        base.clearReferencesStopThreads = this.clearReferencesStopThreads;
        base.clearReferencesStopTimerThreads = this.clearReferencesStopTimerThreads;
        base.clearReferencesLogFactoryRelease = this.clearReferencesLogFactoryRelease;
        base.clearReferencesHttpClientKeepAliveThread = this.clearReferencesHttpClientKeepAliveThread;
        base.jarModificationTimes.putAll(this.jarModificationTimes);
        base.permissionList.addAll(this.permissionList);
        base.loaderPC.putAll(this.loaderPC);
    }

    public boolean modified() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"modified()");
        }
        for (Map.Entry<String, ResourceEntry> entry : this.resourceEntries.entrySet()) {
            long cachedLastModified = entry.getValue().lastModified;
            long lastModified = this.resources.getClassLoaderResource(entry.getKey()).getLastModified();
            if (lastModified == cachedLastModified) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("webappClassLoader.resourceModified", new Object[]{entry.getKey(), new Date(cachedLastModified), new Date(lastModified)}));
            }
            return true;
        }
        WebResource[] jars = this.resources.listResources("/WEB-INF/lib");
        int jarCount = 0;
        for (WebResource jar : jars) {
            if (!jar.getName().endsWith(".jar") || !jar.isFile() || !jar.canRead()) continue;
            ++jarCount;
            Long recordedLastModified = this.jarModificationTimes.get(jar.getName());
            if (recordedLastModified == null) {
                log.info((Object)sm.getString("webappClassLoader.jarsAdded", new Object[]{this.resources.getContext().getName()}));
                return true;
            }
            if (recordedLastModified.longValue() == jar.getLastModified()) continue;
            log.info((Object)sm.getString("webappClassLoader.jarsModified", new Object[]{this.resources.getContext().getName()}));
            return true;
        }
        if (jarCount < this.jarModificationTimes.size()) {
            log.info((Object)sm.getString("webappClassLoader.jarsRemoved", new Object[]{this.resources.getContext().getName()}));
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("\r\n  context: ");
        sb.append(this.getContextName());
        sb.append("\r\n  delegate: ");
        sb.append(this.delegate);
        sb.append("\r\n");
        if (this.parent != null) {
            sb.append("----------> Parent Classloader:\r\n");
            sb.append(this.parent.toString());
            sb.append("\r\n");
        }
        if (this.transformers.size() > 0) {
            sb.append("----------> Class file transformers:\r\n");
            for (ClassFileTransformer transformer : this.transformers) {
                sb.append(transformer).append("\r\n");
            }
        }
        return sb.toString();
    }

    protected final Class<?> doDefineClass(String name, byte[] b, int off, int len, ProtectionDomain protectionDomain) {
        return super.defineClass(name, b, off, len, protectionDomain);
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        int i;
        if (log.isDebugEnabled()) {
            log.debug((Object)("    findClass(" + name + ")"));
        }
        this.checkStateForClassLoading(name);
        if (this.securityManager != null && (i = name.lastIndexOf(46)) >= 0) {
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"      securityManager.checkPackageDefinition");
                }
                this.securityManager.checkPackageDefinition(name.substring(0, i));
            }
            catch (Exception se) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"      -->Exception-->ClassNotFoundException", (Throwable)se);
                }
                throw new ClassNotFoundException(name, se);
            }
        }
        Class<?> clazz = null;
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("      findClassInternal(" + name + ")"));
            }
            try {
                clazz = this.findClassInternal(name);
            }
            catch (AccessControlException ace) {
                log.warn((Object)("WebappClassLoader.findClassInternal(" + name + ") security exception: " + ace.getMessage()), (Throwable)ace);
                throw new ClassNotFoundException(name, ace);
            }
            catch (RuntimeException e) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"      -->RuntimeException Rethrown", (Throwable)e);
                }
                throw e;
            }
            if (clazz == null && this.hasExternalRepositories) {
                try {
                    clazz = super.findClass(name);
                }
                catch (AccessControlException ace) {
                    log.warn((Object)("WebappClassLoader.findClassInternal(" + name + ") security exception: " + ace.getMessage()), (Throwable)ace);
                    throw new ClassNotFoundException(name, ace);
                }
                catch (RuntimeException e) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"      -->RuntimeException Rethrown", (Throwable)e);
                    }
                    throw e;
                }
            }
            if (clazz == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"    --> Returning ClassNotFoundException");
                }
                throw new ClassNotFoundException(name);
            }
        }
        catch (ClassNotFoundException e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"    --> Passing on ClassNotFoundException");
            }
            throw e;
        }
        if (log.isTraceEnabled()) {
            log.debug((Object)("      Returning class " + clazz));
        }
        if (log.isTraceEnabled()) {
            ClassLoader cl = Globals.IS_SECURITY_ENABLED ? AccessController.doPrivileged(new PrivilegedGetClassLoader(clazz)) : clazz.getClassLoader();
            log.debug((Object)("      Loaded by " + cl.toString()));
        }
        return clazz;
    }

    @Override
    public URL findResource(String name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("    findResource(" + name + ")"));
        }
        this.checkStateForResourceLoading(name);
        URL url = null;
        String path = this.nameToPath(name);
        ResourceEntry entry = this.resourceEntries.get(path);
        if (entry == null) {
            if (this.securityManager != null) {
                PrivilegedFindResourceByName dp = new PrivilegedFindResourceByName(name, path);
                entry = AccessController.doPrivileged(dp);
            } else {
                entry = this.findResourceInternal(name, path);
            }
        }
        if (entry != null) {
            url = entry.source;
            entry.webResource = null;
        }
        if (url == null && this.hasExternalRepositories) {
            url = super.findResource(name);
        }
        if (log.isDebugEnabled()) {
            if (url != null) {
                log.debug((Object)("    --> Returning '" + url.toString() + "'"));
            } else {
                log.debug((Object)"    --> Resource not found, returning null");
            }
        }
        return url;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        WebResource[] webResources;
        if (log.isDebugEnabled()) {
            log.debug((Object)("    findResources(" + name + ")"));
        }
        this.checkStateForResourceLoading(name);
        LinkedHashSet<URL> result = new LinkedHashSet<URL>();
        String path = this.nameToPath(name);
        for (WebResource webResource : webResources = this.resources.getClassLoaderResources(path)) {
            if (!webResource.exists()) continue;
            result.add(webResource.getURL());
        }
        if (this.hasExternalRepositories) {
            Enumeration<URL> otherResourcePaths = super.findResources(name);
            while (otherResourcePaths.hasMoreElements()) {
                result.add(otherResourcePaths.nextElement());
            }
        }
        return Collections.enumeration(result);
    }

    @Override
    public URL getResource(String name) {
        boolean delegateFirst;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getResource(" + name + ")"));
        }
        this.checkStateForResourceLoading(name);
        URL url = null;
        boolean bl = delegateFirst = this.delegate || this.filter(name, false);
        if (delegateFirst) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Delegating to parent classloader " + this.parent));
            }
            if ((url = this.parent.getResource(name)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  --> Returning '" + url.toString() + "'"));
                }
                return url;
            }
        }
        if ((url = this.findResource(name)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("  --> Returning '" + url.toString() + "'"));
            }
            return url;
        }
        if (!delegateFirst && (url = this.parent.getResource(name)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("  --> Returning '" + url.toString() + "'"));
            }
            return url;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"  --> Resource not found, returning null");
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        URL url;
        boolean delegateFirst;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getResourceAsStream(" + name + ")"));
        }
        this.checkStateForResourceLoading(name);
        InputStream stream = null;
        stream = this.findLoadedResource(name);
        if (stream != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  --> Returning stream from cache");
            }
            return stream;
        }
        boolean bl = delegateFirst = this.delegate || this.filter(name, false);
        if (delegateFirst) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Delegating to parent classloader " + this.parent));
            }
            if ((stream = this.parent.getResourceAsStream(name)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"  --> Returning stream from parent");
                }
                return stream;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"  Searching local repositories");
        }
        if ((url = this.findResource(name)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  --> Returning stream from local");
            }
            stream = this.findLoadedResource(name);
            try {
                if (this.hasExternalRepositories && stream == null) {
                    stream = url.openStream();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (stream != null) {
                return stream;
            }
        }
        if (!delegateFirst) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Delegating to parent classloader unconditionally " + this.parent));
            }
            if ((stream = this.parent.getResourceAsStream(name)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"  --> Returning stream from parent");
                }
                return stream;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"  --> Resource not found, returning null");
        }
        return null;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            boolean delegateLoad;
            int i;
            boolean tryLoadingFromJavaseLoader;
            if (log.isDebugEnabled()) {
                log.debug((Object)("loadClass(" + name + ", " + resolve + ")"));
            }
            Class<?> clazz = null;
            this.checkStateForClassLoading(name);
            clazz = this.findLoadedClass0(name);
            if (clazz != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"  Returning class from cache");
                }
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            clazz = this.findLoadedClass(name);
            if (clazz != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"  Returning class from cache");
                }
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            String resourceName = this.binaryNameToPath(name, false);
            ClassLoader javaseLoader = this.getJavaseClassLoader();
            try {
                tryLoadingFromJavaseLoader = javaseLoader.getResource(resourceName) != null;
            }
            catch (ClassCircularityError cce) {
                tryLoadingFromJavaseLoader = true;
            }
            if (tryLoadingFromJavaseLoader) {
                try {
                    clazz = javaseLoader.loadClass(name);
                    if (clazz != null) {
                        if (resolve) {
                            this.resolveClass(clazz);
                        }
                        return clazz;
                    }
                }
                catch (ClassNotFoundException cce) {
                    // empty catch block
                }
            }
            if (this.securityManager != null && (i = name.lastIndexOf(46)) >= 0) {
                try {
                    this.securityManager.checkPackageAccess(name.substring(0, i));
                }
                catch (SecurityException se) {
                    String error = "Security Violation, attempt to use Restricted Class: " + name;
                    log.info((Object)error, (Throwable)se);
                    throw new ClassNotFoundException(error, se);
                }
            }
            boolean bl = delegateLoad = this.delegate || this.filter(name, true);
            if (delegateLoad) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  Delegating to parent classloader1 " + this.parent));
                }
                try {
                    clazz = Class.forName(name, false, this.parent);
                    if (clazz != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"  Loading class from parent");
                        }
                        if (resolve) {
                            this.resolveClass(clazz);
                        }
                        return clazz;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"  Searching local repositories");
            }
            try {
                clazz = this.findClass(name);
                if (clazz != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"  Loading class from local repository");
                    }
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (!delegateLoad) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  Delegating to parent classloader at end: " + this.parent));
                }
                try {
                    clazz = Class.forName(name, false, this.parent);
                    if (clazz != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"  Loading class from parent");
                        }
                        if (resolve) {
                            this.resolveClass(clazz);
                        }
                        return clazz;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        throw new ClassNotFoundException(name);
    }

    protected void checkStateForClassLoading(String className) throws ClassNotFoundException {
        try {
            this.checkStateForResourceLoading(className);
        }
        catch (IllegalStateException ise) {
            throw new ClassNotFoundException(ise.getMessage(), ise);
        }
    }

    protected void checkStateForResourceLoading(String resource) throws IllegalStateException {
        if (!this.state.isAvailable()) {
            String msg = sm.getString("webappClassLoader.stopped", new Object[]{resource});
            IllegalStateException ise = new IllegalStateException(msg);
            log.info((Object)msg, (Throwable)ise);
            throw ise;
        }
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codeSource) {
        String codeUrl = codeSource.getLocation().toString();
        PermissionCollection pc = this.loaderPC.get(codeUrl);
        if (pc == null && (pc = super.getPermissions(codeSource)) != null) {
            for (Permission p : this.permissionList) {
                pc.add(p);
            }
            this.loaderPC.put(codeUrl, pc);
        }
        return pc;
    }

    public boolean check(Permission permission) {
        URL contextRootUrl;
        CodeSource cs;
        PermissionCollection pc;
        if (!Globals.IS_SECURITY_ENABLED) {
            return true;
        }
        Policy currentPolicy = Policy.getPolicy();
        return currentPolicy != null && (pc = currentPolicy.getPermissions(cs = new CodeSource(contextRootUrl = this.resources.getResource("/").getCodeBase(), (Certificate[])null))).implies(permission);
    }

    @Override
    public URL[] getURLs() {
        ArrayList<URL> result = new ArrayList<URL>();
        result.addAll(this.localRepositories);
        result.addAll(Arrays.asList(super.getURLs()));
        return result.toArray(new URL[result.size()]);
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
    }

    @Override
    public LifecycleListener[] findLifecycleListeners() {
        return new LifecycleListener[0];
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
    }

    @Override
    public LifecycleState getState() {
        return this.state;
    }

    @Override
    public String getStateName() {
        return this.getState().toString();
    }

    @Override
    public void init() {
        this.state = LifecycleState.INITIALIZED;
    }

    @Override
    public void start() throws LifecycleException {
        WebResource[] jars;
        this.state = LifecycleState.STARTING_PREP;
        WebResource classes = this.resources.getResource("/WEB-INF/classes");
        if (classes.isDirectory() && classes.canRead()) {
            this.localRepositories.add(classes.getURL());
        }
        for (WebResource jar : jars = this.resources.listResources("/WEB-INF/lib")) {
            if (!jar.getName().endsWith(".jar") || !jar.isFile() || !jar.canRead()) continue;
            this.localRepositories.add(jar.getURL());
            this.jarModificationTimes.put(jar.getName(), jar.getLastModified());
        }
        this.state = LifecycleState.STARTING;
        String encoding = null;
        try {
            encoding = System.getProperty("file.encoding");
        }
        catch (SecurityException e) {
            return;
        }
        if (encoding.indexOf("EBCDIC") != -1) {
            this.needConvert = true;
        }
        this.state = LifecycleState.STARTED;
    }

    @Override
    public void stop() throws LifecycleException {
        this.state = LifecycleState.STOPPING_PREP;
        this.clearReferences();
        this.state = LifecycleState.STOPPING;
        this.resourceEntries.clear();
        this.jarModificationTimes.clear();
        this.resources = null;
        this.permissionList.clear();
        this.loaderPC.clear();
        this.state = LifecycleState.STOPPED;
    }

    @Override
    public void destroy() {
        this.state = LifecycleState.DESTROYING;
        try {
            super.close();
        }
        catch (IOException ioe) {
            log.warn((Object)sm.getString("webappClassLoader.superCloseFail"), (Throwable)ioe);
        }
        this.state = LifecycleState.DESTROYED;
    }

    protected ClassLoader getJavaseClassLoader() {
        return this.javaseClassLoader;
    }

    protected void setJavaseClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException(sm.getString("webappClassLoader.javaseClassLoaderNull"));
        }
        this.javaseClassLoader = classLoader;
    }

    protected void clearReferences() {
        this.clearReferencesJdbc();
        this.clearReferencesThreads();
        this.checkThreadLocalsForLeaks();
        if (this.clearReferencesRmiTargets) {
            this.clearReferencesRmiTargets();
        }
        if (this.clearReferencesStatic) {
            this.clearReferencesStaticFinal();
        }
        IntrospectionUtils.clear();
        if (this.clearReferencesLogFactoryRelease) {
            LogFactory.release((ClassLoader)this);
        }
        this.clearReferencesResourceBundles();
        Introspector.flushCaches();
        TomcatURLStreamHandlerFactory.release(this);
    }

    private final void clearReferencesJdbc() {
        byte[] classBytes = new byte[2048];
        int offset = 0;
        try (InputStream is = this.getResourceAsStream("org/apache/catalina/loader/JdbcLeakPrevention.class");){
            int read = is.read(classBytes, offset, classBytes.length - offset);
            while (read > -1) {
                if ((offset += read) == classBytes.length) {
                    byte[] tmp = new byte[classBytes.length * 2];
                    System.arraycopy(classBytes, 0, tmp, 0, classBytes.length);
                    classBytes = tmp;
                }
                read = is.read(classBytes, offset, classBytes.length - offset);
            }
            Class<?> lpClass = this.defineClass("org.apache.catalina.loader.JdbcLeakPrevention", classBytes, 0, offset, this.getClass().getProtectionDomain());
            Object obj = lpClass.newInstance();
            List driverNames = (List)obj.getClass().getMethod("clearJdbcDriverRegistrations", new Class[0]).invoke(obj, new Object[0]);
            for (String name : driverNames) {
                log.warn((Object)sm.getString("webappClassLoader.clearJdbc", new Object[]{this.getContextName(), name}));
            }
        }
        catch (Exception e) {
            Throwable t = ExceptionUtils.unwrapInvocationTargetException((Throwable)e);
            ExceptionUtils.handleThrowable((Throwable)t);
            log.warn((Object)sm.getString("webappClassLoader.jdbcRemoveFailed", new Object[]{this.getContextName()}), t);
        }
    }

    private final void clearReferencesStaticFinal() {
        int i;
        Field[] fields2;
        Class<?> clazz;
        Collection<ResourceEntry> values = this.resourceEntries.values();
        block6: for (ResourceEntry entry : values) {
            if (entry.loadedClass == null) continue;
            clazz = entry.loadedClass;
            try {
                fields2 = clazz.getDeclaredFields();
                for (i = 0; i < fields2.length; ++i) {
                    if (!Modifier.isStatic(fields2[i].getModifiers())) continue;
                    fields2[i].get(null);
                    continue block6;
                }
            }
            catch (Throwable fields2) {
            }
        }
        for (ResourceEntry entry : values) {
            if (entry.loadedClass == null) continue;
            clazz = entry.loadedClass;
            try {
                fields2 = clazz.getDeclaredFields();
                for (i = 0; i < fields2.length; ++i) {
                    Field field = fields2[i];
                    int mods = field.getModifiers();
                    if (field.getType().isPrimitive() || field.getName().indexOf(36) != -1 || !Modifier.isStatic(mods)) continue;
                    try {
                        field.setAccessible(true);
                        if (Modifier.isFinal(mods)) {
                            if (field.getType().getName().startsWith("java.") || field.getType().getName().startsWith("javax.")) continue;
                            this.nullInstance(field.get(null));
                            continue;
                        }
                        field.set(null, null);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Set field " + field.getName() + " to null in class " + clazz.getName()));
                        continue;
                    }
                    catch (Throwable t) {
                        ExceptionUtils.handleThrowable((Throwable)t);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Could not set field " + field.getName() + " to null in class " + clazz.getName()), t);
                    }
                }
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable((Throwable)t);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Could not clean fields for class " + clazz.getName()), t);
            }
        }
    }

    private void nullInstance(Object instance) {
        if (instance == null) {
            return;
        }
        Field[] fields = instance.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            int mods = field.getModifiers();
            if (field.getType().isPrimitive() || field.getName().indexOf(36) != -1) continue;
            try {
                Object value;
                field.setAccessible(true);
                if (Modifier.isStatic(mods) && Modifier.isFinal(mods) || null == (value = field.get(instance))) continue;
                Class<?> valueClass = value.getClass();
                if (!this.loadedByThisOrChild(valueClass)) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Not setting field " + field.getName() + " to null in object of class " + instance.getClass().getName() + " because the referenced object was of type " + valueClass.getName() + " which was not loaded by this web application class loader."));
                    continue;
                }
                field.set(instance, null);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Set field " + field.getName() + " to null in class " + instance.getClass().getName()));
                continue;
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable((Throwable)t);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Could not set field " + field.getName() + " to null in object instance of class " + instance.getClass().getName()), t);
            }
        }
    }

    private void clearReferencesThreads() {
        Thread[] threads = this.getThreads();
        ArrayList<Thread> executorThreadsToStop = new ArrayList<Thread>();
        for (Thread thread : threads) {
            ClassLoader ccl;
            if (thread == null || (ccl = thread.getContextClassLoader()) != this || thread == Thread.currentThread()) continue;
            String threadName = thread.getName();
            ThreadGroup tg = thread.getThreadGroup();
            if (tg != null && JVM_THREAD_GROUP_NAMES.contains(tg.getName())) {
                if (!this.clearReferencesHttpClientKeepAliveThread || !threadName.equals("Keep-Alive-Timer")) continue;
                thread.setContextClassLoader(this.parent);
                log.debug((Object)sm.getString("webappClassLoader.checkThreadsHttpClient"));
                continue;
            }
            if (!thread.isAlive()) continue;
            if (thread.getClass().getName().startsWith("java.util.Timer") && this.clearReferencesStopTimerThreads) {
                this.clearReferencesStopTimerThread(thread);
                continue;
            }
            if (this.isRequestThread(thread)) {
                log.warn((Object)sm.getString("webappClassLoader.stackTraceRequestThread", new Object[]{this.getContextName(), threadName, this.getStackTrace(thread)}));
            } else {
                log.warn((Object)sm.getString("webappClassLoader.stackTrace", new Object[]{this.getContextName(), threadName, this.getStackTrace(thread)}));
            }
            if (!this.clearReferencesStopThreads) continue;
            boolean usingExecutor = false;
            try {
                Object target = null;
                for (String fieldName : new String[]{"target", "runnable", "action"}) {
                    try {
                        Field targetField = thread.getClass().getDeclaredField(fieldName);
                        targetField.setAccessible(true);
                        target = targetField.get(thread);
                        break;
                    }
                    catch (NoSuchFieldException nfe) {
                    }
                }
                if (target != null && target.getClass().getCanonicalName() != null && target.getClass().getCanonicalName().equals("java.util.concurrent.ThreadPoolExecutor.Worker")) {
                    Field executorField = target.getClass().getDeclaredField("this$0");
                    executorField.setAccessible(true);
                    Object executor = executorField.get(target);
                    if (executor instanceof ThreadPoolExecutor) {
                        ((ThreadPoolExecutor)executor).shutdownNow();
                        usingExecutor = true;
                    }
                }
            }
            catch (SecurityException e) {
                log.warn((Object)sm.getString("webappClassLoader.stopThreadFail", new Object[]{thread.getName(), this.getContextName()}), (Throwable)e);
            }
            catch (NoSuchFieldException e) {
                log.warn((Object)sm.getString("webappClassLoader.stopThreadFail", new Object[]{thread.getName(), this.getContextName()}), (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                log.warn((Object)sm.getString("webappClassLoader.stopThreadFail", new Object[]{thread.getName(), this.getContextName()}), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.warn((Object)sm.getString("webappClassLoader.stopThreadFail", new Object[]{thread.getName(), this.getContextName()}), (Throwable)e);
            }
            if (usingExecutor) {
                executorThreadsToStop.add(thread);
                continue;
            }
            thread.stop();
        }
        int count = 0;
        for (Thread t : executorThreadsToStop) {
            while (t.isAlive() && count < 100) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e) {
                    break;
                }
                ++count;
            }
            if (!t.isAlive()) continue;
            t.stop();
        }
    }

    private boolean isRequestThread(Thread thread) {
        StackTraceElement[] elements = thread.getStackTrace();
        if (elements == null || elements.length == 0) {
            return false;
        }
        for (int i = 0; i < elements.length; ++i) {
            StackTraceElement element = elements[elements.length - (i + 1)];
            if (!"org.apache.catalina.connector.CoyoteAdapter".equals(element.getClassName())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearReferencesStopTimerThread(Thread thread) {
        try {
            try {
                Field newTasksMayBeScheduledField = thread.getClass().getDeclaredField("newTasksMayBeScheduled");
                newTasksMayBeScheduledField.setAccessible(true);
                Field queueField = thread.getClass().getDeclaredField("queue");
                queueField.setAccessible(true);
                Object queue = queueField.get(thread);
                Method clearMethod = queue.getClass().getDeclaredMethod("clear", new Class[0]);
                clearMethod.setAccessible(true);
                Object object = queue;
                synchronized (object) {
                    newTasksMayBeScheduledField.setBoolean(thread, false);
                    clearMethod.invoke(queue, new Object[0]);
                    queue.notify();
                }
            }
            catch (NoSuchFieldException nfe) {
                Method cancelMethod = thread.getClass().getDeclaredMethod("cancel", new Class[0]);
                Thread thread2 = thread;
                synchronized (thread2) {
                    cancelMethod.setAccessible(true);
                    cancelMethod.invoke((Object)thread, new Object[0]);
                }
            }
            log.warn((Object)sm.getString("webappClassLoader.warnTimerThread", new Object[]{this.getContextName(), thread.getName()}));
        }
        catch (Exception e) {
            Throwable t = ExceptionUtils.unwrapInvocationTargetException((Throwable)e);
            ExceptionUtils.handleThrowable((Throwable)t);
            log.warn((Object)sm.getString("webappClassLoader.stopTimerThreadFail", new Object[]{thread.getName(), this.getContextName()}), t);
        }
    }

    private void checkThreadLocalsForLeaks() {
        Thread[] threads = this.getThreads();
        try {
            Field threadLocalsField = Thread.class.getDeclaredField("threadLocals");
            threadLocalsField.setAccessible(true);
            Field inheritableThreadLocalsField = Thread.class.getDeclaredField("inheritableThreadLocals");
            inheritableThreadLocalsField.setAccessible(true);
            Class<?> tlmClass = Class.forName("java.lang.ThreadLocal$ThreadLocalMap");
            Field tableField = tlmClass.getDeclaredField("table");
            tableField.setAccessible(true);
            Method expungeStaleEntriesMethod = tlmClass.getDeclaredMethod("expungeStaleEntries", new Class[0]);
            expungeStaleEntriesMethod.setAccessible(true);
            for (int i = 0; i < threads.length; ++i) {
                if (threads[i] == null) continue;
                Object threadLocalMap = threadLocalsField.get(threads[i]);
                if (null != threadLocalMap) {
                    expungeStaleEntriesMethod.invoke(threadLocalMap, new Object[0]);
                    this.checkThreadLocalMapForLeaks(threadLocalMap, tableField);
                }
                if (null == (threadLocalMap = inheritableThreadLocalsField.get(threads[i]))) continue;
                expungeStaleEntriesMethod.invoke(threadLocalMap, new Object[0]);
                this.checkThreadLocalMapForLeaks(threadLocalMap, tableField);
            }
        }
        catch (Throwable t) {
            JreCompat jreCompat = JreCompat.getInstance();
            if (jreCompat.isInstanceOfInaccessibleObjectException(t)) {
                log.warn((Object)sm.getString("webappClassLoader.addExportsThreadLocal"));
            }
            ExceptionUtils.handleThrowable((Throwable)t);
            log.warn((Object)sm.getString("webappClassLoader.checkThreadLocalsForLeaksFail", new Object[]{this.getContextName()}), t);
        }
    }

    private void checkThreadLocalMapForLeaks(Object map, Field internalTableField) throws IllegalAccessException, NoSuchFieldException {
        Object[] table;
        if (map != null && (table = (Object[])internalTableField.get(map)) != null) {
            for (int j = 0; j < table.length; ++j) {
                Object obj = table[j];
                if (obj == null) continue;
                boolean keyLoadedByWebapp = false;
                boolean valueLoadedByWebapp = false;
                Object key = ((Reference)obj).get();
                if (this.equals(key) || this.loadedByThisOrChild(key)) {
                    keyLoadedByWebapp = true;
                }
                Field valueField = obj.getClass().getDeclaredField("value");
                valueField.setAccessible(true);
                Object value = valueField.get(obj);
                if (this.equals(value) || this.loadedByThisOrChild(value)) {
                    valueLoadedByWebapp = true;
                }
                if (!keyLoadedByWebapp && !valueLoadedByWebapp) continue;
                Object[] args = new Object[5];
                args[0] = this.getContextName();
                if (key != null) {
                    args[1] = this.getPrettyClassName(key.getClass());
                    try {
                        args[2] = key.toString();
                    }
                    catch (Exception e) {
                        log.warn((Object)sm.getString("webappClassLoader.checkThreadLocalsForLeaks.badKey", new Object[]{args[1]}), (Throwable)e);
                        args[2] = sm.getString("webappClassLoader.checkThreadLocalsForLeaks.unknown");
                    }
                }
                if (value != null) {
                    args[3] = this.getPrettyClassName(value.getClass());
                    try {
                        args[4] = value.toString();
                    }
                    catch (Exception e) {
                        log.warn((Object)sm.getString("webappClassLoader.checkThreadLocalsForLeaks.badValue", new Object[]{args[3]}), (Throwable)e);
                        args[4] = sm.getString("webappClassLoader.checkThreadLocalsForLeaks.unknown");
                    }
                }
                if (valueLoadedByWebapp) {
                    log.error((Object)sm.getString("webappClassLoader.checkThreadLocalsForLeaks", args));
                    continue;
                }
                if (value == null) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)sm.getString("webappClassLoader.checkThreadLocalsForLeaksNull", args));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)sm.getString("webappClassLoader.checkThreadLocalsForLeaksNone", args));
            }
        }
    }

    private String getPrettyClassName(Class<?> clazz) {
        String name = clazz.getCanonicalName();
        if (name == null) {
            name = clazz.getName();
        }
        return name;
    }

    private String getStackTrace(Thread thread) {
        StringBuilder builder = new StringBuilder();
        for (StackTraceElement ste : thread.getStackTrace()) {
            builder.append("\n ").append(ste);
        }
        return builder.toString();
    }

    private boolean loadedByThisOrChild(Object o) {
        if (o == null) {
            return false;
        }
        Class<?> clazz = o instanceof Class ? (Class<?>)o : o.getClass();
        for (ClassLoader cl = clazz.getClassLoader(); cl != null; cl = cl.getParent()) {
            if (cl != this) continue;
            return true;
        }
        if (o instanceof Collection) {
            Iterator iter = ((Collection)o).iterator();
            try {
                while (iter.hasNext()) {
                    Object entry = iter.next();
                    if (!this.loadedByThisOrChild(entry)) continue;
                    return true;
                }
            }
            catch (ConcurrentModificationException e) {
                log.warn((Object)sm.getString("webappClassLoader.loadedByThisOrChildFail", new Object[]{clazz.getName(), this.getContextName()}), (Throwable)e);
            }
        }
        return false;
    }

    private Thread[] getThreads() {
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        try {
            while (tg.getParent() != null) {
                tg = tg.getParent();
            }
        }
        catch (SecurityException se) {
            String msg = sm.getString("webappClassLoader.getThreadGroupError", new Object[]{tg.getName()});
            if (log.isDebugEnabled()) {
                log.debug((Object)msg, (Throwable)se);
            }
            log.warn((Object)msg);
        }
        int threadCountGuess = tg.activeCount() + 50;
        Thread[] threads = new Thread[threadCountGuess];
        int threadCountActual = tg.enumerate(threads);
        while (threadCountActual == threadCountGuess) {
            threads = new Thread[threadCountGuess *= 2];
            threadCountActual = tg.enumerate(threads);
        }
        return threads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearReferencesRmiTargets() {
        try {
            Class<?> objectTargetClass = Class.forName("sun.rmi.transport.Target");
            Field cclField = objectTargetClass.getDeclaredField("ccl");
            cclField.setAccessible(true);
            Field stubField = objectTargetClass.getDeclaredField("stub");
            stubField.setAccessible(true);
            Class<?> objectTableClass = Class.forName("sun.rmi.transport.ObjectTable");
            Field objTableField = objectTableClass.getDeclaredField("objTable");
            objTableField.setAccessible(true);
            Object objTable = objTableField.get(null);
            if (objTable == null) {
                return;
            }
            Object object = objTable;
            synchronized (object) {
                if (objTable instanceof Map) {
                    Iterator iter = ((Map)objTable).values().iterator();
                    while (iter.hasNext()) {
                        Object obj = iter.next();
                        Object cclObject = cclField.get(obj);
                        if (this != cclObject) continue;
                        iter.remove();
                        Object stubObject = stubField.get(obj);
                        log.error((Object)sm.getString("webappClassLoader.clearRmi", new Object[]{stubObject.getClass().getName(), stubObject}));
                    }
                }
                Field implTableField = objectTableClass.getDeclaredField("implTable");
                implTableField.setAccessible(true);
                Object implTable = implTableField.get(null);
                if (implTable == null) {
                    return;
                }
                if (implTable instanceof Map) {
                    Iterator iter = ((Map)implTable).values().iterator();
                    while (iter.hasNext()) {
                        Object obj = iter.next();
                        Object cclObject = cclField.get(obj);
                        if (this != cclObject) continue;
                        iter.remove();
                    }
                }
            }
        }
        catch (ClassNotFoundException e) {
            log.info((Object)sm.getString("webappClassLoader.clearRmiInfo", new Object[]{this.getContextName()}), (Throwable)e);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            log.warn((Object)sm.getString("webappClassLoader.clearRmiFail", new Object[]{this.getContextName()}), (Throwable)e);
        }
        catch (Exception e) {
            JreCompat jreCompat = JreCompat.getInstance();
            if (jreCompat.isInstanceOfInaccessibleObjectException((Throwable)e)) {
                log.warn((Object)sm.getString("webappClassLoader.addExportsRmi"));
            }
            throw e;
        }
    }

    private void clearReferencesResourceBundles() {
        try {
            Field cacheListField = ResourceBundle.class.getDeclaredField("cacheList");
            cacheListField.setAccessible(true);
            Map cacheList = (Map)cacheListField.get(null);
            Set keys = cacheList.keySet();
            Field loaderRefField = null;
            Iterator keysIter = keys.iterator();
            int countRemoved = 0;
            while (keysIter.hasNext()) {
                ClassLoader loader;
                Object key = keysIter.next();
                if (loaderRefField == null) {
                    loaderRefField = key.getClass().getDeclaredField("loaderRef");
                    loaderRefField.setAccessible(true);
                }
                WeakReference loaderRef = (WeakReference)loaderRefField.get(key);
                for (loader = (ClassLoader)loaderRef.get(); loader != null && loader != this; loader = loader.getParent()) {
                }
                if (loader == null) continue;
                keysIter.remove();
                ++countRemoved;
            }
            if (countRemoved > 0 && log.isDebugEnabled()) {
                log.debug((Object)sm.getString("webappClassLoader.clearReferencesResourceBundlesCount", new Object[]{countRemoved, this.getContextName()}));
            }
        }
        catch (SecurityException e) {
            log.warn((Object)sm.getString("webappClassLoader.clearReferencesResourceBundlesFail", new Object[]{this.getContextName()}), (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            if (JreVendor.IS_ORACLE_JVM) {
                log.warn((Object)sm.getString("webappClassLoader.clearReferencesResourceBundlesFail", new Object[]{this.getContextName()}), (Throwable)e);
            } else {
                log.debug((Object)sm.getString("webappClassLoader.clearReferencesResourceBundlesFail", new Object[]{this.getContextName()}), (Throwable)e);
            }
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)sm.getString("webappClassLoader.clearReferencesResourceBundlesFail", new Object[]{this.getContextName()}), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.warn((Object)sm.getString("webappClassLoader.clearReferencesResourceBundlesFail", new Object[]{this.getContextName()}), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class<?> findClassInternal(String name) {
        String path = this.binaryNameToPath(name, true);
        ResourceEntry entry = null;
        if (this.securityManager != null) {
            PrivilegedFindResourceByName dp = new PrivilegedFindResourceByName(name, path);
            entry = AccessController.doPrivileged(dp);
        } else {
            entry = this.findResourceInternal(name, path);
        }
        if (entry == null) {
            return null;
        }
        Class<?> clazz = entry.loadedClass;
        if (clazz != null) {
            return clazz;
        }
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            clazz = entry.loadedClass;
            if (clazz != null) {
                return clazz;
            }
            WebResource webResource = entry.webResource;
            if (webResource == null) {
                webResource = this.resources.getClassLoaderResource(path);
            } else {
                entry.webResource = null;
            }
            if (!webResource.exists()) {
                return null;
            }
            byte[] binaryContent = webResource.getContent();
            Manifest manifest = webResource.getManifest();
            URL codeBase = webResource.getCodeBase();
            Certificate[] certificates = webResource.getCertificates();
            if (this.transformers.size() > 0) {
                String className = name.endsWith(CLASS_FILE_SUFFIX) ? name.substring(0, name.length() - CLASS_FILE_SUFFIX.length()) : name;
                String internalName = className.replace(".", "/");
                for (ClassFileTransformer transformer : this.transformers) {
                    try {
                        byte[] transformed = transformer.transform(this, internalName, null, null, binaryContent);
                        if (transformed == null) continue;
                        binaryContent = transformed;
                    }
                    catch (IllegalClassFormatException e) {
                        log.error((Object)sm.getString("webappClassLoader.transformError", new Object[]{name}), (Throwable)e);
                        return null;
                    }
                }
            }
            String packageName = null;
            int pos = name.lastIndexOf(46);
            if (pos != -1) {
                packageName = name.substring(0, pos);
            }
            Package pkg = null;
            if (packageName != null && (pkg = this.getPackage(packageName)) == null) {
                try {
                    if (manifest == null) {
                        this.definePackage(packageName, null, null, null, null, null, null, null);
                    } else {
                        this.definePackage(packageName, manifest, codeBase);
                    }
                }
                catch (IllegalArgumentException transformer) {
                    // empty catch block
                }
                pkg = this.getPackage(packageName);
            }
            if (this.securityManager != null && pkg != null) {
                boolean sealCheck = true;
                if (pkg.isSealed()) {
                    sealCheck = pkg.isSealed(codeBase);
                } else {
                    boolean bl = sealCheck = manifest == null || !this.isPackageSealed(packageName, manifest);
                }
                if (!sealCheck) {
                    throw new SecurityException("Sealing violation loading " + name + " : Package " + packageName + " is sealed.");
                }
            }
            try {
                clazz = this.defineClass(name, binaryContent, 0, binaryContent.length, new CodeSource(codeBase, certificates));
            }
            catch (UnsupportedClassVersionError ucve) {
                throw new UnsupportedClassVersionError(ucve.getLocalizedMessage() + " " + sm.getString("webappClassLoader.wrongVersion", new Object[]{name}));
            }
            entry.loadedClass = clazz;
        }
        return clazz;
    }

    private String binaryNameToPath(String binaryName, boolean withLeadingSlash) {
        StringBuilder path = new StringBuilder(7 + binaryName.length());
        if (withLeadingSlash) {
            path.append('/');
        }
        path.append(binaryName.replace('.', '/'));
        path.append(CLASS_FILE_SUFFIX);
        return path.toString();
    }

    private String nameToPath(String name) {
        if (name.startsWith("/")) {
            return name;
        }
        StringBuilder path = new StringBuilder(1 + name.length());
        path.append('/');
        path.append(name);
        return path.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceEntry findResourceInternal(String name, String path) {
        byte[] binaryContent;
        this.checkStateForResourceLoading(name);
        if (name == null || path == null) {
            return null;
        }
        WebResource resource = null;
        ResourceEntry entry = this.resourceEntries.get(path);
        if (entry != null) {
            return entry;
        }
        resource = this.resources.getClassLoaderResource(path);
        if (!resource.exists()) {
            return null;
        }
        entry = new ResourceEntry();
        entry.source = resource.getURL();
        entry.lastModified = resource.getLastModified();
        entry.webResource = resource;
        boolean fileNeedConvert = false;
        if (this.needConvert && path.endsWith(".properties")) {
            fileNeedConvert = true;
        }
        if ((path.startsWith(SERVICES_PREFIX) || fileNeedConvert) && (binaryContent = resource.getContent()) != null) {
            if (fileNeedConvert) {
                String str = new String(binaryContent);
                try {
                    binaryContent = str.getBytes(StandardCharsets.UTF_8);
                }
                catch (Exception e) {
                    return null;
                }
            }
            entry.binaryContent = binaryContent;
        }
        Map<String, ResourceEntry> map = this.resourceEntries;
        synchronized (map) {
            ResourceEntry entry2 = this.resourceEntries.get(path);
            if (entry2 == null) {
                this.resourceEntries.put(path, entry);
            } else {
                entry = entry2;
            }
        }
        return entry;
    }

    protected boolean isPackageSealed(String name, Manifest man) {
        String path = name.replace('.', '/') + '/';
        Attributes attr = man.getAttributes(path);
        String sealed = null;
        if (attr != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if (sealed == null && (attr = man.getMainAttributes()) != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(sealed);
    }

    protected InputStream findLoadedResource(String name) {
        String path = this.nameToPath(name);
        ResourceEntry entry = this.resourceEntries.get(path);
        if (entry != null) {
            if (entry.binaryContent != null) {
                return new ByteArrayInputStream(entry.binaryContent);
            }
            try {
                return entry.source.openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    protected Class<?> findLoadedClass0(String name) {
        String path = this.binaryNameToPath(name, true);
        ResourceEntry entry = this.resourceEntries.get(path);
        if (entry != null) {
            return entry.loadedClass;
        }
        return null;
    }

    protected void refreshPolicy() {
        try {
            Policy policy = Policy.getPolicy();
            policy.refresh();
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    protected boolean filter(String name, boolean isClassName) {
        if (name == null) {
            return false;
        }
        if (name.startsWith("javax")) {
            if (name.length() == 5) {
                return false;
            }
            char ch = name.charAt(5);
            if (isClassName && ch == '.') {
                if (name.startsWith("servlet.jsp.jstl.", 6)) {
                    return false;
                }
                if (name.startsWith("el.", 6) || name.startsWith("servlet.", 6) || name.startsWith("websocket.", 6)) {
                    return true;
                }
            } else if (!isClassName && ch == '/') {
                if (name.startsWith("servlet/jsp/jstl/", 6)) {
                    return false;
                }
                if (name.startsWith("el/", 6) || name.startsWith("servlet/", 6) || name.startsWith("websocket/", 6)) {
                    return true;
                }
            }
        } else if (name.startsWith("org")) {
            if (name.length() == 3) {
                return false;
            }
            char ch = name.charAt(3);
            if (isClassName && ch == '.') {
                if (name.startsWith("apache.", 4)) {
                    if (name.startsWith("tomcat.jdbc.", 11)) {
                        return false;
                    }
                    if (name.startsWith("el.", 11) || name.startsWith("catalina.", 11) || name.startsWith("jasper.", 11) || name.startsWith("juli.", 11) || name.startsWith("tomcat.", 11) || name.startsWith("naming.", 11) || name.startsWith("coyote.", 11)) {
                        return true;
                    }
                }
            } else if (!isClassName && ch == '/' && name.startsWith("apache/", 4)) {
                if (name.startsWith("tomcat/jdbc/", 11)) {
                    return false;
                }
                if (name.startsWith("el/", 11) || name.startsWith("catalina/", 11) || name.startsWith("jasper/", 11) || name.startsWith("juli/", 11) || name.startsWith("tomcat/", 11) || name.startsWith("naming/", 11) || name.startsWith("coyote/", 11)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Deprecated
    protected boolean filter(String name) {
        return this.filter(name, true) || this.filter(name, false);
    }

    @Deprecated
    protected boolean validate(String name) {
        return true;
    }

    @Override
    protected void addURL(URL url) {
        super.addURL(url);
        this.hasExternalRepositories = true;
    }

    public String getWebappName() {
        return this.getContextName();
    }

    public String getHostName() {
        Container host;
        if (this.resources != null && (host = this.resources.getContext().getParent()) != null) {
            return host.getName();
        }
        return null;
    }

    public String getServiceName() {
        Container engine;
        Container host;
        if (this.resources != null && (host = this.resources.getContext().getParent()) != null && (engine = host.getParent()) != null) {
            return engine.getName();
        }
        return null;
    }

    static {
        ClassLoader.registerAsParallelCapable();
        JVM_THREAD_GROUP_NAMES.add(JVM_THREAD_GROUP_SYSTEM);
        JVM_THREAD_GROUP_NAMES.add("RMI Runtime");
        sm = StringManager.getManager((String)"org.apache.catalina.loader");
    }

    protected static final class PrivilegedGetClassLoader
    implements PrivilegedAction<ClassLoader> {
        public final Class<?> clazz;

        public PrivilegedGetClassLoader(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public ClassLoader run() {
            return this.clazz.getClassLoader();
        }
    }

    protected class PrivilegedFindResourceByName
    implements PrivilegedAction<ResourceEntry> {
        protected final String name;
        protected final String path;

        PrivilegedFindResourceByName(String name, String path) {
            this.name = name;
            this.path = path;
        }

        @Override
        public ResourceEntry run() {
            return WebappClassLoaderBase.this.findResourceInternal(this.name, this.path);
        }
    }
}

