/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.model;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.ObjectFieldValue;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerFieldNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerInstanceNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.ObjectNode;

public class ObjectFieldNode
extends ObjectNode
implements HeapWalkerFieldNode {
    private ObjectFieldValue fieldValue;

    public ObjectFieldNode(ObjectFieldValue objectFieldValue, HeapWalkerNode heapWalkerNode) {
        this(objectFieldValue, heapWalkerNode, heapWalkerNode == null ? 1 : heapWalkerNode.getMode());
    }

    public ObjectFieldNode(ObjectFieldValue objectFieldValue, HeapWalkerNode heapWalkerNode, int n) {
        super(n == 1 ? objectFieldValue.getInstance() : objectFieldValue.getDefiningInstance(), objectFieldValue.getField().getName(), heapWalkerNode, n);
        this.fieldValue = objectFieldValue;
        if (!this.isLoop() && this.getMode() == 2 && this.isStatic()) {
            this.loopTo = this.computeClassLoopTo();
        }
    }

    public ObjectFieldValue getFieldValue() {
        return this.fieldValue;
    }

    @Override
    public boolean isStatic() {
        return this.fieldValue.getField().isStatic();
    }

    @Override
    protected Icon computeIcon() {
        ImageIcon imageIcon = BrowserUtils.ICON_INSTANCE;
        if (this.isStatic()) {
            imageIcon = BrowserUtils.createStaticIcon(imageIcon);
        }
        if (this.getMode() == 2 && this.getInstance().isGCRoot()) {
            imageIcon = BrowserUtils.createGCRootIcon(imageIcon);
        }
        return this.processLoopIcon(imageIcon);
    }

    @Override
    protected String computeType() {
        if (this.getMode() == 2 && this.isStatic()) {
            return this.fieldValue.getField().getDeclaringClass().getName();
        }
        return super.computeType();
    }

    @Override
    protected String computeValue() {
        if (this.getMode() == 2 && this.isStatic()) {
            return "class " + BrowserUtils.getSimpleType(this.fieldValue.getField().getDeclaringClass().getName());
        }
        return super.computeValue();
    }

    private HeapWalkerNode computeClassLoopTo() {
        JavaClass javaClass = this.fieldValue.getField().getDeclaringClass();
        for (HeapWalkerNode heapWalkerNode = this.getParent(); heapWalkerNode != null && heapWalkerNode instanceof HeapWalkerInstanceNode; heapWalkerNode = heapWalkerNode.getParent()) {
            HeapWalkerFieldNode heapWalkerFieldNode;
            if (!(heapWalkerNode instanceof HeapWalkerFieldNode) || !(heapWalkerFieldNode = (HeapWalkerFieldNode)heapWalkerNode).isStatic() || !heapWalkerFieldNode.getFieldValue().getField().getDeclaringClass().equals(javaClass)) continue;
            return heapWalkerNode;
        }
        return null;
    }

    @Override
    public Object getNodeID() {
        return this.fieldValue;
    }
}

