/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.daemon;

import java.io.File;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.UncheckedException;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.WorkSpec;
import org.gradle.workers.internal.Worker;
import org.gradle.workers.internal.WorkerFactory;
import org.gradle.workers.internal.WorkerProtocol;

public abstract class AbstractDaemonCompiler<T extends CompileSpec>
implements Compiler<T> {
    private final Compiler<T> delegate;
    private final WorkerFactory workerFactory;
    private final File daemonWorkingDir;

    public AbstractDaemonCompiler(File daemonWorkingDir, Compiler<T> delegate, WorkerFactory workerFactory) {
        this.daemonWorkingDir = daemonWorkingDir;
        this.delegate = delegate;
        this.workerFactory = workerFactory;
    }

    public Compiler<T> getDelegate() {
        return this.delegate;
    }

    public WorkResult execute(T spec) {
        DaemonForkOptions daemonForkOptions = this.toDaemonOptions(spec);
        Worker worker = this.workerFactory.getWorker(CompilerDaemonServer.class, this.daemonWorkingDir, daemonForkOptions);
        DefaultWorkResult result = worker.execute(new WorkerCompileSpec<T>(this.delegate, spec));
        if (result.isSuccess()) {
            return result;
        }
        throw UncheckedException.throwAsUncheckedException((Throwable)result.getException());
    }

    protected abstract DaemonForkOptions toDaemonOptions(T var1);

    public static class CompilerDaemonServer
    implements WorkerProtocol<WorkerCompileSpec<?>> {
        public DefaultWorkResult execute(WorkerCompileSpec<?> spec) {
            try {
                return spec.compile();
            }
            catch (Throwable t) {
                return new DefaultWorkResult(true, t);
            }
        }
    }

    private static class WorkerCompileSpec<T extends CompileSpec>
    implements WorkSpec {
        private final Compiler<T> compiler;
        private final T spec;

        WorkerCompileSpec(Compiler<T> compiler, T spec) {
            this.compiler = compiler;
            this.spec = spec;
        }

        public String getDisplayName() {
            return this.compiler.getClass().getName();
        }

        public DefaultWorkResult compile() {
            return new DefaultWorkResult(this.compiler.execute(this.spec).getDidWork(), null);
        }
    }
}

