/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.btree;

import com.google.common.primitives.Longs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockPointer
implements Comparable<BlockPointer> {
    private static final BlockPointer NULL = new BlockPointer(-1L);
    private final long pos;

    public static BlockPointer start() {
        return NULL;
    }

    public static BlockPointer pos(long pos) {
        if (pos < -1L) {
            throw new IllegalArgumentException("pos must be >= -1");
        }
        if (pos == -1L) {
            return NULL;
        }
        return new BlockPointer(pos);
    }

    private BlockPointer(long pos) {
        this.pos = pos;
    }

    public boolean isNull() {
        return this.pos < 0L;
    }

    public long getPos() {
        return this.pos;
    }

    public String toString() {
        return String.valueOf(this.pos);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BlockPointer other = (BlockPointer)obj;
        return this.pos == other.pos;
    }

    public int hashCode() {
        return Longs.hashCode((long)this.pos);
    }

    @Override
    public int compareTo(BlockPointer o) {
        return Longs.compare((long)this.pos, (long)o.pos);
    }
}

