/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.local.internal;

import java.io.File;
import javax.inject.Inject;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.internal.CacheScopeMapping;
import org.gradle.cache.internal.VersionStrategy;
import org.gradle.caching.BuildCacheService;
import org.gradle.caching.BuildCacheServiceFactory;
import org.gradle.caching.local.DirectoryBuildCache;
import org.gradle.caching.local.internal.DirectoryBuildCacheService;
import org.gradle.internal.operations.BuildOperationExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryBuildCacheServiceFactory
implements BuildCacheServiceFactory<DirectoryBuildCache> {
    private static final String BUILD_CACHE_VERSION = "1";
    private static final String BUILD_CACHE_KEY = "build-cache-1";
    private static final String DIRECTORY_BUILD_CACHE_TYPE = "directory";
    private final CacheRepository cacheRepository;
    private final CacheScopeMapping cacheScopeMapping;
    private final FileResolver resolver;
    private final BuildOperationExecutor buildOperationExecutor;

    @Inject
    public DirectoryBuildCacheServiceFactory(CacheRepository cacheRepository, CacheScopeMapping cacheScopeMapping, FileResolver resolver, BuildOperationExecutor buildOperationExecutor) {
        this.cacheRepository = cacheRepository;
        this.cacheScopeMapping = cacheScopeMapping;
        this.resolver = resolver;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public BuildCacheService createBuildCacheService(DirectoryBuildCache configuration, BuildCacheServiceFactory.Describer describer) {
        Object cacheDirectory = configuration.getDirectory();
        File target = cacheDirectory != null ? this.resolver.resolve(cacheDirectory) : this.cacheScopeMapping.getBaseDirectory(null, BUILD_CACHE_KEY, VersionStrategy.SharedCache);
        describer.type(DIRECTORY_BUILD_CACHE_TYPE).config("location", target.getAbsolutePath());
        return new DirectoryBuildCacheService(this.cacheRepository, this.buildOperationExecutor, target, configuration.getTargetSizeInMB());
    }
}

