/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.Set;
import org.gradle.StartParameter;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.initialization.ConfigurableIncludedBuild;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.composite.internal.DefaultIncludedBuild;
import org.gradle.initialization.GradleLauncher;
import org.gradle.initialization.IncludedBuildFactory;
import org.gradle.initialization.NestedBuildFactory;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.reflect.Instantiator;

public class DefaultIncludedBuildFactory
implements IncludedBuildFactory,
Stoppable {
    private final Instantiator instantiator;
    private final StartParameter startParameter;
    private final NestedBuildFactory nestedBuildFactory;
    private final Set<GradleLauncher> launchers = Sets.newHashSet();
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;

    public DefaultIncludedBuildFactory(Instantiator instantiator, StartParameter startParameter, NestedBuildFactory nestedBuildFactory, ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        this.instantiator = instantiator;
        this.startParameter = startParameter;
        this.nestedBuildFactory = nestedBuildFactory;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
    }

    private void validateBuildDirectory(File dir) {
        if (!dir.exists()) {
            throw new InvalidUserDataException(String.format("Included build '%s' does not exist.", dir));
        }
        if (!dir.isDirectory()) {
            throw new InvalidUserDataException(String.format("Included build '%s' is not a directory.", dir));
        }
    }

    private void validateIncludedBuild(IncludedBuild includedBuild, SettingsInternal settings) {
        if (!new File(settings.getSettingsDir(), "settings.gradle").exists()) {
            throw new InvalidUserDataException(String.format("Included build '%s' must have a '%s' file.", includedBuild.getName(), "settings.gradle"));
        }
        if (!settings.getIncludedBuilds().isEmpty()) {
            throw new InvalidUserDataException(String.format("Included build '%s' cannot have included builds.", includedBuild.getName()));
        }
    }

    public ConfigurableIncludedBuild createBuild(File buildDirectory) {
        this.validateBuildDirectory(buildDirectory);
        ContextualGradleLauncherFactory factory = new ContextualGradleLauncherFactory(buildDirectory, this.nestedBuildFactory, this.startParameter);
        DefaultIncludedBuild includedBuild = (DefaultIncludedBuild)this.instantiator.newInstance(DefaultIncludedBuild.class, new Object[]{buildDirectory, factory, this.moduleIdentifierFactory});
        SettingsInternal settingsInternal = includedBuild.getLoadedSettings();
        this.validateIncludedBuild((IncludedBuild)includedBuild, settingsInternal);
        return includedBuild;
    }

    public void stop() {
        CompositeStoppable.stoppable(this.launchers).stop();
    }

    private class ContextualGradleLauncherFactory
    implements Factory<GradleLauncher> {
        private final File buildDirectory;
        private final NestedBuildFactory nestedBuildFactory;
        private final StartParameter buildStartParam;

        public ContextualGradleLauncherFactory(File buildDirectory, NestedBuildFactory nestedBuildFactory, StartParameter buildStartParam) {
            this.buildDirectory = buildDirectory;
            this.nestedBuildFactory = nestedBuildFactory;
            this.buildStartParam = buildStartParam;
        }

        public GradleLauncher create() {
            StartParameter participantStartParam = this.createStartParameter(this.buildDirectory);
            GradleLauncher gradleLauncher = this.nestedBuildFactory.nestedInstance(participantStartParam);
            DefaultIncludedBuildFactory.this.launchers.add(gradleLauncher);
            return gradleLauncher;
        }

        private StartParameter createStartParameter(File buildDirectory) {
            StartParameter includedBuildStartParam = this.buildStartParam.newBuild();
            includedBuildStartParam.setProjectDir(buildDirectory);
            includedBuildStartParam.setSearchUpwards(false);
            includedBuildStartParam.setConfigureOnDemand(false);
            includedBuildStartParam.setInitScripts(this.buildStartParam.getInitScripts());
            return includedBuildStartParam;
        }
    }
}

