# Basics

## Contents
* [Responsive](#responsive)
* [Typography](#typography)
* [Icons](#icons)
* [Color](#color)
* [Cursors](#cursors)

---

## Responsive
GitLab is a responsive experience that works well across all screen sizes, from mobile devices to large monitors. In order to provide a great user experience, the core functionality (browsing files, creating issues, writing comments, etc.) must be available at all resolutions. However, due to size limitations, some secondary functionality may be hidden on smaller screens. Please keep this functionality limited to rare actions that aren't expected to be needed on small devices.

---

## Typography
### Primary typeface
GitLab's main typeface used throughout the UI is **Source Sans Pro**. We support both the bold and regular weight.

![Source Sans Pro sample](img/sourcesanspro-sample.png)


### Monospace typeface
This is the typeface used for code blocks. GitLab uses the OS default font.
- **Menlo** (Mac)
- **Consolas** (Windows)
- **Liberation Mono** (Linux)

![Monospace font sample](img/monospacefont-sample.png)

---

## Icons
GitLab uses Font Awesome icons throughout our interface.

| | |
| :-----------: | :---- |
| ![Trash icon](img/icon-trash.png) | The trash icon is used for destructive actions that deletes information. |
| ![Edit icon](img/icon-edit.png) | The pencil icon is used for editing content such as comments.|
| ![Notification icon](img/icon-notification.png) | The bell icon is for notifications, such as Todos. |
| ![Subscribe icon](img/icon-subscribe.png) | The eye icon is for subscribing to updates. For example, you can subscribe to a label and get updated on issues with that label. |
| ![RSS icon](img/icon-rss.png) | The standard RSS icon is used for linking to RSS/atom feeds. |
| ![Close icon](img/icon-close.png) | An 'x' is used for closing UI elements such as dropdowns. |
| ![Add icon](img/icon-add.png) | A plus is used when creating new objects, such as issues, projects, etc. |

> TODO: update this section, add more general guidance to icon usage and personality, etc.

---

## Color

| | State | Action |
| :------: | :------- | :------- |
| ![Blue](img/color-blue.png) | Primary and active (such as the current tab) | Organizational, managing, and retry commands|
| ![Green](img/color-green.png) | Opened | Create new objects |
| ![Orange](img/color-orange.png) | Warning | Non destructive action |
| ![Red](img/color-red.png) | Closed | Delete and other destructive commands |
| ![Grey](img/color-grey.png) | Neutral | Neutral secondary commands |

### Text colors

|||
| :---: | :--- |
| ![Text primary](img/color-textprimary.png) | Used for primary body text, such as issue description and comment |
| ![Text secondary](img/color-textsecondary.png) | Used for secondary body text, such as username and date |

> TODO: Establish a perspective for color in terms of our personality and rationalize with Marketing usage.

---

## Cursors
The mouse cursor is key in helping users understand how to interact with elements on the screen.

| | |
| :------: | :------- |
| ![Default cursor](img/cursors-default.png) | Default cursor |
| ![Pointer cursor](img/cursors-pointer.png) | Pointer cursor: used to indicate that you can click on an element to invoke a command or navigate, such as links and buttons |
| ![Move cursor](img/cursors-move.png) | Move cursor: used to indicate that you can move an element around on the screen |
| ![Pan opened cursor](img/cursors-panopened.png) | Pan cursor (opened): indicates that you can grab and move the entire canvas, affecting what is seen in the view port. |
| ![Pan closed cursor](img/cursors-panclosed.png) | Pan cursor (closed): indicates that you are actively panning the canvas. |
| ![I-beam cursor](img/cursors-ibeam.png) | I-beam cursor: indicates that this is either text that you can select and copy, or a text field that you can click into to enter text. |


