#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: vty
version: 5.16
id: vty-5.16-GHXpVj9kyZe5Zina6oitmk
key: vty-5.16-GHXpVj9kyZe5Zina6oitmk
license: BSD3
maintainer: Jonathan Daugherty (cygnus@foobox.com)
homepage: https://github.com/jtdaugherty/vty
synopsis: A simple terminal UI library
description:
    vty is terminal GUI library in the niche of ncurses. It is intended to
    be easy to use, have no confusing corner cases, and good support for
    common terminal types.
    .
    See the @vty-examples@ package as well as the program
    @test/interactive_terminal_test.hs@ included in the @vty@ package for
    examples on how to use the library.
    .
    Import the "Graphics.Vty" convenience module to get access to the core
    parts of the library.
    .
    &#169; 2006-2007 Stefan O'\''Rear; BSD3 license.
    .
    &#169; Corey O'\''Connor; BSD3 license.
    .
    &#169; Jonathan Daugherty; BSD3 license.
category: User Interfaces
author: AUTHORS
exposed: True
exposed-modules:
    Graphics.Vty Graphics.Vty.Attributes Graphics.Vty.Config
    Graphics.Vty.Error Graphics.Vty.Image Graphics.Vty.Inline
    Graphics.Vty.Inline.Unsafe Graphics.Vty.Input
    Graphics.Vty.Input.Events Graphics.Vty.Picture Graphics.Vty.Output
    Graphics.Text.Width Codec.Binary.UTF8.Debug Data.Terminfo.Parse
    Data.Terminfo.Eval Graphics.Vty.Debug
    Graphics.Vty.DisplayAttributes Graphics.Vty.Image.Internal
    Graphics.Vty.Input.Classify Graphics.Vty.Input.Classify.Types
    Graphics.Vty.Input.Classify.Parse Graphics.Vty.Input.Loop
    Graphics.Vty.Input.Mouse Graphics.Vty.Input.Paste
    Graphics.Vty.Input.Terminfo Graphics.Vty.PictureToSpans
    Graphics.Vty.Span Graphics.Vty.Output.Mock
    Graphics.Vty.Output.Interface Graphics.Vty.Output.XTermColor
    Graphics.Vty.Output.TerminfoBased
hidden-modules: Graphics.Vty.Attributes.Color
                Graphics.Vty.Attributes.Color240 Graphics.Vty.Debug.Image
                Graphics.Vty.Input.Terminfo.ANSIVT
abi: e6efb7eed5d5f4d80f8a77cec3d26d8f
trusted: False
import-dirs: /usr/lib/ghc-8.0.2/site-local/vty-5.16
library-dirs: /usr/lib/ghc-8.0.2/site-local/vty-5.16
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.0.2/vty-5.16
hs-libraries: HSvty-5.16-GHXpVj9kyZe5Zina6oitmk
depends:
    base-4.9.1.0 blaze-builder-0.4.0.2-EbETJDFSQ4b6W7B283dutO
    bytestring-0.10.8.1 containers-0.5.7.1 deepseq-1.4.2.0
    directory-1.3.0.0 filepath-1.4.1.1
    hashable-1.2.6.1-2nPqxcHq7mUGgurrYaLtXr
    microlens-0.4.8.0-5PXN9DedWooJg6UJ24ter0
    microlens-mtl-0.1.11.0-JZGlAY1k7Eo2CcDKB6BH2V
    microlens-th-0.4.1.1-DS5mBQOVXPfALmfN2UZZ6b
    mtl-2.2.1-BLKBelFsPB3BoFeSWSOYj6
    parallel-3.2.1.1-KQJHWCcq2Ka569Stb10nhx
    parsec-3.1.11-1CA7c0vSU7tJHGhveOjoXR
    stm-2.4.4.1-iSYwp3RMY11sHCifJ3gtR terminfo-0.4.0.2
    text-1.2.2.2-3ENqlljngKa6xj1Go2fVWq transformers-0.5.2.0
    unix-2.7.2.1 utf8-string-1.0.1.1-1DpjxLeTvGg7ttZZojxJR5
    vector-0.12.0.1-692PQMDMB6pIQ1uGwefDcQ
haddock-interfaces: /usr/share/doc/haskell-vty/html/vty.haddock
haddock-html: /usr/share/doc/haskell-vty/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
