/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.popupswitcher;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.core.windows.view.ui.popupswitcher.Item;
import org.netbeans.core.windows.view.ui.popupswitcher.KeyboardPopupSwitcher;
import org.netbeans.core.windows.view.ui.popupswitcher.Model;
import org.netbeans.core.windows.view.ui.popupswitcher.PopupSwitcher;
import org.openide.awt.HtmlRenderer;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class Table
extends JTable {
    private static final Border rendererBorder = BorderFactory.createEmptyBorder(2, 5, 0, 5);
    private static final Icon NULL_ICON = new NullIcon(16);
    private Color foreground;
    private Color background;
    private Color selForeground;
    private Color selBackground;
    private static final int MAX_VISIBLE_ROWS = 20;
    private static final int MAX_TOP_COLUMN_WIDTH = 450;
    private static final int MAX_SUB_COLUMN_WIDTH = 225;
    private boolean needCalcRowHeight = true;
    private Dimension prefSize = null;
    private final boolean showIcons;
    private final JPanel topItemPanel = new JPanel();
    private final JLabel rightArrowLabel = new JLabel();
    private static SoftReference<BufferedImage> ctx = null;

    public Table(Model model) {
        super(model);
        this.showIcons = model.hasIcons();
        this.init();
    }

    private void init() {
        int n;
        this.setOpaque(false);
        this.getSelectionModel().clearSelection();
        this.getSelectionModel().setAnchorSelectionIndex(-1);
        this.getSelectionModel().setLeadSelectionIndex(-1);
        this.setAutoscrolls(false);
        this.setShowHorizontalLines(false);
        this.setShowVerticalLines(false);
        this.setAutoResizeMode(0);
        this.setTableHeader(null);
        this.calcRowHeight(Table.getOffscreenGraphics());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = Table.this.rowAtPoint(mouseEvent.getPoint());
                int n2 = Table.this.columnAtPoint(mouseEvent.getPoint());
                if (n >= 0 && n2 >= 0 && Table.this.select(n, n2)) {
                    Table.this.performSwitching();
                }
            }
        });
        this.rightArrowLabel.setIcon(new ArrowIcon());
        this.rightArrowLabel.setIconTextGap(2);
        this.rightArrowLabel.setHorizontalTextPosition(2);
        this.topItemPanel.setLayout(new BorderLayout(5, 0));
        this.topItemPanel.add((Component)this.rightArrowLabel, "East");
        this.topItemPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Table.class, (String)"ACD_OTHER_EDITORS"));
        this.topItemPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        for (n = 0; n < this.getColumnCount(); ++n) {
            if (!this.getSwitcherModel().isTopItemColumn(n)) continue;
            this.adjustColumnWidths(n);
        }
        n = this.getSwitcherModel().getMaxRowCount();
        if (n > 20 && this.getRowCount() <= 20) {
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setVerticalScrollBarPolicy(22);
            int n2 = jScrollPane.getVerticalScrollBar().getPreferredSize().width;
            TableColumn tableColumn = this.getColumnModel().getColumn(this.getColumnCount() - 1);
            tableColumn.setMaxWidth(tableColumn.getMaxWidth() + n2);
            tableColumn.setPreferredWidth(tableColumn.getPreferredWidth() + n2);
            tableColumn.setWidth(tableColumn.getWidth() + n2);
        }
    }

    private void adjustColumnWidths(int n) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n2 = 0;
        int n3 = -1;
        for (int i = 0; i < this.getRowCount(); ++i) {
            Item item = (Item)this.getValueAt(i, n);
            Component component = this.prepareRenderer(this.getCellRenderer(i, n), i, n, item, true);
            int n4 = component.getPreferredSize().width;
            n2 = Math.max(n2, n4);
            if (null == item || !item.hasSubItems() || n + 1 >= this.getColumnCount() || this.getSwitcherModel().isTopItemColumn(n + 1)) continue;
            Item[] itemArray = item.getActivatableSubItems();
            for (int j = 0; j < itemArray.length; ++j) {
                component = this.prepareRenderer(this.getCellRenderer(0, n + 1), 0, n + 1, itemArray[j], true);
                n4 = component.getPreferredSize().width;
                n3 = Math.max(n3, n4);
            }
        }
        n2 = Math.min(n2, 450);
        TableColumn tableColumn = tableColumnModel.getColumn(n);
        tableColumn.setPreferredWidth(n2);
        tableColumn.setWidth(n2);
        tableColumn.setMaxWidth(n2);
        if (n3 > 0) {
            n3 = Math.min(n3, 225);
            tableColumn = tableColumnModel.getColumn(n + 1);
            tableColumn.setPreferredWidth(n3);
            tableColumn.setWidth(n3);
            tableColumn.setMaxWidth(n3);
        }
    }

    @Override
    protected TableColumnModel createDefaultColumnModel() {
        return super.createDefaultColumnModel();
    }

    @Override
    public void createDefaultColumnsFromModel() {
        super.createDefaultColumnsFromModel();
    }

    void setInitialSelection(int n, boolean bl) {
        int n2;
        ++n;
        int n3 = bl ? 1 : -1;
        int n4 = this.getSwitcherModel().getInitialColumn();
        int n5 = n2 = bl ? 0 : this.getSwitcherModel().getRowCount(n4) - 1;
        while (n2 > 0 && null == this.getValueAt(n2, n4)) {
            --n2;
        }
        n2 += n * n3;
        n2 = Math.max(0, n2);
        n2 = Math.min(n2, this.getSwitcherModel().getRowCount(n4) - 1);
        this.select(n2, n4);
    }

    boolean select(int n, int n2) {
        if (null == this.getValueAt(n, n2)) {
            return false;
        }
        this.changeSelection(n, n2, false, false);
        return true;
    }

    void performSwitching() {
        int n = this.getSelectedRow();
        int n2 = this.getSelectedColumn();
        if (n < 0 || n2 < 0) {
            return;
        }
        Item item = (Item)this.getSwitcherModel().getValueAt(n, n2);
        if (null != item) {
            item.activate();
            KeyboardPopupSwitcher.hidePopup();
        }
    }

    @Override
    public void updateUI() {
        this.needCalcRowHeight = true;
        super.updateUI();
    }

    @Override
    public void setFont(Font font) {
        this.needCalcRowHeight = true;
        super.setFont(font);
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Item item = (Item)this.getSwitcherModel().getValueAt(n, n2);
        boolean bl = n == this.getSelectedRow() && n2 == this.getSelectedColumn() && item != null;
        return this.prepareRenderer(tableCellRenderer, n, n2, item, bl);
    }

    private Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2, Item item, boolean bl) {
        Component component = tableCellRenderer.getTableCellRendererComponent(this, item, bl, bl, n, n2);
        if (null == item) {
            if (component instanceof JLabel) {
                ((JLabel)component).setOpaque(false);
                ((JLabel)component).setIcon(null);
                ((JLabel)component).getAccessibleContext().setAccessibleDescription(null);
            }
            return component;
        }
        return this.configureRenderer(component, item, bl);
    }

    private Component configureRenderer(Component component, Item item, boolean bl) {
        if (!(component instanceof JLabel)) {
            return component;
        }
        JLabel jLabel = (JLabel)component;
        JLabel jLabel2 = (JLabel)component;
        jLabel = HtmlRenderer.createLabel();
        if (jLabel instanceof HtmlRenderer.Renderer) {
            ((HtmlRenderer.Renderer)jLabel).setRenderStyle(1);
        }
        jLabel.setForeground(jLabel2.getForeground());
        jLabel.setBackground(jLabel2.getBackground());
        jLabel.setFont(jLabel2.getFont());
        component = jLabel;
        jLabel.getAccessibleContext().setAccessibleDescription(null);
        Icon icon = null;
        if (item.isTopItem()) {
            icon = item.getIcon();
            if (this.showIcons && (icon == null || icon.getIconWidth() == 0)) {
                icon = NULL_ICON;
            }
        }
        jLabel.setText(bl ? Table.stripHtml(item.getDisplayName()) : item.getDisplayName());
        jLabel.setBorder(rendererBorder);
        jLabel.setIcon(icon);
        if (null != icon && item.isTopItem()) {
            jLabel.setIconTextGap(26 - icon.getIconWidth());
        }
        jLabel.setOpaque(true);
        if (item.isTopItem() && item.hasSubItems() && (bl || item.isParentOf(this.getSelectedItem()))) {
            component = this.configureTopItemRenderer(jLabel, item);
        }
        return component;
    }

    private Component configureTopItemRenderer(JLabel jLabel, Item item) {
        Item item2 = item.getActiveSubItem();
        if (null != item2) {
            this.rightArrowLabel.setText(Table.truncateSubItemText(item2.getDisplayName()));
            this.rightArrowLabel.setForeground(jLabel.getForeground());
            this.rightArrowLabel.setBackground(jLabel.getBackground());
        } else {
            this.rightArrowLabel.setText(null);
        }
        this.topItemPanel.setBackground(jLabel.getBackground());
        this.topItemPanel.removeAll();
        this.topItemPanel.add((Component)jLabel, "Center");
        this.topItemPanel.add((Component)this.rightArrowLabel, "East");
        return this.topItemPanel;
    }

    static String stripHtml(String string) {
        if (null == string) {
            return null;
        }
        String string2 = string.replaceAll("<[^>]*>", "");
        string2 = string2.replaceAll("&nbsp;", " ");
        string2 = string2.trim();
        return string2;
    }

    private static String truncateSubItemText(String string) {
        string = Table.stripHtml(string);
        StringBuilder stringBuilder = new StringBuilder("[" + string + "]");
        JLabel jLabel = new JLabel(stringBuilder.toString());
        while (jLabel.getPreferredSize().width > 225 && stringBuilder.length() > 3) {
            if (stringBuilder.charAt(stringBuilder.length() - 2) != '\u2026') {
                stringBuilder.insert(stringBuilder.length() - 1, '\u2026');
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 3);
            jLabel.setText(stringBuilder.toString());
        }
        return stringBuilder.toString();
    }

    void nextRow() {
        this.changeRow(1);
    }

    void previousRow() {
        this.changeRow(-1);
    }

    private void changeRow(int n) {
        int n2 = Math.max(this.getSelectedColumn(), 0);
        int n3 = Math.max(this.getSelectedRow(), 0);
        if ((n3 += n) < 0) {
            if (!this.changeColumn(n, false)) {
                this.changeColumn(2 * n, false);
            }
            return;
        }
        if (n3 > this.getRowCount() || null == this.getValueAt(n3, n2)) {
            if (this.getSwitcherModel().isTopItemColumn(n2)) {
                if (!this.getSwitcherModel().isTopItemColumn(n2 + n)) {
                    n *= 2;
                }
                this.changeColumn(n, false);
            } else if (!this.select(n3, n2 - 1)) {
                this.changeColumn(n, false);
            }
            return;
        }
        this.select(n3, n2);
    }

    void nextColumn() {
        if (!this.changeColumn(1, true)) {
            this.changeColumn(2, true);
        }
    }

    void previousColumn() {
        if (!this.changeColumn(-1, true)) {
            this.changeColumn(-2, true);
        }
    }

    private boolean changeColumn(int n, boolean bl) {
        int n2 = Math.max(this.getSelectedColumn(), 0);
        if ((n2 += n) < 0) {
            n2 = this.getColumnCount() - 1;
        }
        if (n2 >= this.getColumnCount()) {
            n2 = 0;
        }
        int n3 = this.getSelectedRow();
        Model model = this.getSwitcherModel();
        if (!bl) {
            n3 = n > 0 ? 0 : this.getRowCount() - 1;
        } else if (n == -1 && !model.isTopItemColumn(this.getSelectedColumn())) {
            Item item;
            Item item2 = this.getSelectedItem();
            while (n3 > 0 && null != (item = (Item)this.getValueAt(n3--, this.getSelectedColumn() - 1)) && !item.isParentOf(item2)) {
            }
        }
        while (n3 > 0 && null == this.getValueAt(n3, n2)) {
            --n3;
        }
        return this.select(n3, n2);
    }

    @Override
    public Color getForeground() {
        if (this.foreground == null) {
            this.foreground = PopupSwitcher.getDefaultForeground();
        }
        return this.foreground != null ? this.foreground : super.getForeground();
    }

    @Override
    public Color getBackground() {
        if (this.background == null) {
            this.background = PopupSwitcher.getDefaultBackground();
        }
        return this.background != null ? this.background : super.getBackground();
    }

    @Override
    public Color getSelectionForeground() {
        if (this.selForeground == null) {
            this.selForeground = PopupSwitcher.getSelectionForeground();
        }
        return this.selForeground != null ? this.selForeground : super.getSelectionForeground();
    }

    @Override
    public Color getSelectionBackground() {
        if (this.selBackground == null) {
            this.selBackground = PopupSwitcher.getSelectionBackground();
        }
        return this.selBackground != null ? this.selBackground : super.getSelectionBackground();
    }

    private void calcRowHeight(Graphics graphics) {
        Font font = this.getFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n = Math.max(fontMetrics.getHeight(), 16) + 4;
        this.needCalcRowHeight = false;
        this.setRowHeight(n);
    }

    private static Graphics2D getOffscreenGraphics() {
        BufferedImage bufferedImage = null;
        if (ctx != null) {
            bufferedImage = ctx.get();
        }
        if (bufferedImage == null) {
            bufferedImage = new BufferedImage(10, 10, 1);
            ctx = new SoftReference<BufferedImage>(bufferedImage);
        }
        return (Graphics2D)bufferedImage.getGraphics();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        if (this.needCalcRowHeight) {
            this.calcRowHeight(Table.getOffscreenGraphics());
            this.prefSize = null;
        }
        if (null == this.prefSize) {
            Serializable serializable;
            int n;
            Dimension dimension = new Dimension();
            for (n = 0; n < this.getColumnCount(); ++n) {
                serializable = this.getColumnModel().getColumn(n);
                dimension.width += serializable.getPreferredWidth();
            }
            n = Math.min(20, this.getRowCount());
            dimension.height = n * this.getRowHeight();
            serializable = Utilities.getUsableScreenBounds();
            dimension.width = Math.min(dimension.width, ((Rectangle)serializable).width - 100);
            dimension.height = Math.min(dimension.height, ((Rectangle)serializable).height - 100);
            this.prefSize = dimension;
        }
        return this.prefSize;
    }

    private Model getSwitcherModel() {
        return (Model)this.getModel();
    }

    public Item getSelectedItem() {
        int n = this.getSelectedRow();
        int n2 = this.getSelectedColumn();
        if (n < 0 || n2 < 0) {
            return null;
        }
        return (Item)this.getValueAt(n, n2);
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.needCalcRowHeight) {
            this.calcRowHeight(graphics);
        }
        super.paint(graphics);
        this.paintVerticalLine(graphics);
    }

    private void paintVerticalLine(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        Rectangle rectangle2 = this.getBounds();
        rectangle2.y = 0;
        rectangle2.x = 0;
        if (this.getRowCount() <= 0 || this.getColumnCount() <= 0 || !rectangle2.intersects(rectangle)) {
            return;
        }
        boolean bl = this.getComponentOrientation().isLeftToRight();
        Point point = rectangle.getLocation();
        if (!bl) {
            ++point.x;
        }
        Point point2 = new Point(rectangle.x + rectangle.width - (bl ? 1 : 0), rectangle.y + rectangle.height);
        int n = this.rowAtPoint(point);
        int n2 = this.rowAtPoint(point2);
        if (n == -1) {
            n = 0;
        }
        if (n2 == -1) {
            n2 = this.getRowCount() - 1;
        }
        int n3 = this.columnAtPoint(bl ? point : point2);
        int n4 = this.columnAtPoint(bl ? point2 : point);
        if (n3 == -1) {
            n3 = 0;
        }
        if (n4 == -1) {
            n4 = this.getColumnCount() - 1;
        }
        graphics.setColor(this.getGridColor());
        Rectangle rectangle3 = this.getCellRect(n, n3, true);
        Rectangle rectangle4 = this.getCellRect(n2, n4, true);
        Rectangle rectangle5 = rectangle3.union(rectangle4);
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n5 = rectangle5.y + rectangle5.height;
        if (this.getComponentOrientation().isLeftToRight()) {
            int n6 = rectangle5.x;
            for (int i = n3; i <= n4; ++i) {
                int n7 = tableColumnModel.getColumn(i).getWidth();
                n6 += n7;
                if (!this.getSwitcherModel().isTopItemColumn(i + 1) || i <= 0) continue;
                graphics.drawLine(n6 - 1, 0, n6 - 1, n5 - 1);
            }
        } else {
            int n8 = rectangle5.x;
            for (int i = n4; i >= n3; --i) {
                int n9 = tableColumnModel.getColumn(i).getWidth();
                n8 += n9;
                if (!this.getSwitcherModel().isTopItemColumn(i + 1) || i <= 0) continue;
                graphics.drawLine(n8 - 1, 0, n8 - 1, n5 - 1);
            }
        }
    }

    @Override
    public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
        if (null == this.getModel().getValueAt(n, n2)) {
            return;
        }
        super.changeSelection(n, n2, false, false);
        this.getSwitcherModel().setCurrentSelection(n, n2);
        Rectangle rectangle = this.getCellRect(n, n2, true);
        Rectangle rectangle2 = new Rectangle();
        this.computeVisibleRect(rectangle2);
        if (rectangle2.width > 0 && rectangle2.height > 0 && !rectangle2.contains(rectangle)) {
            this.scrollRectToVisible(rectangle);
        }
    }

    private static class ArrowIcon
    implements Icon {
        private static final int SIZE = 10;

        private ArrowIcon() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(component.getForeground());
            Polygon polygon = new Polygon();
            polygon.addPoint(n, n2);
            polygon.addPoint(n + 5, n2 + 5);
            polygon.addPoint(n, n2 + 10);
            polygon.addPoint(n, n2);
            graphics.fillPolygon(polygon);
        }

        @Override
        public int getIconWidth() {
            return 10;
        }

        @Override
        public int getIconHeight() {
            return 10;
        }
    }

    private static class NullIcon
    implements Icon {
        private final int size;

        public NullIcon(int n) {
            this.size = n;
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }
    }
}

