/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.join.query;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocValuesTermsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.plain.SortedSetDVOrdinalsIndexFieldData;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ParentFieldMapper;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.InnerHitBuilder;
import org.elasticsearch.index.query.InnerHitContextBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.join.query.HasChildQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.fetch.subphase.InnerHitsContext;
import org.elasticsearch.search.internal.SearchContext;

public class HasParentQueryBuilder
extends AbstractQueryBuilder<HasParentQueryBuilder> {
    public static final String NAME = "has_parent";
    public static final boolean DEFAULT_IGNORE_UNMAPPED = false;
    private static final ParseField QUERY_FIELD = new ParseField("query", new String[]{"filter"});
    private static final ParseField SCORE_MODE_FIELD = new ParseField("score_mode", new String[0]).withAllDeprecated("score");
    private static final ParseField TYPE_FIELD = new ParseField("parent_type", new String[]{"type"});
    private static final ParseField SCORE_FIELD = new ParseField("score", new String[0]);
    private static final ParseField INNER_HITS_FIELD = new ParseField("inner_hits", new String[0]);
    private static final ParseField IGNORE_UNMAPPED_FIELD = new ParseField("ignore_unmapped", new String[0]);
    private final QueryBuilder query;
    private final String type;
    private final boolean score;
    private InnerHitBuilder innerHitBuilder;
    private boolean ignoreUnmapped = false;

    public HasParentQueryBuilder(String type, QueryBuilder query, boolean score) {
        this(type, query, score, null);
    }

    private HasParentQueryBuilder(String type, QueryBuilder query, boolean score, InnerHitBuilder innerHitBuilder) {
        this.type = (String)HasParentQueryBuilder.requireValue((Object)type, (String)"[has_parent] requires 'type' field");
        this.query = (QueryBuilder)HasParentQueryBuilder.requireValue((Object)query, (String)"[has_parent] requires 'query' field");
        this.score = score;
        this.innerHitBuilder = innerHitBuilder;
    }

    public HasParentQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.type = in.readString();
        this.score = in.readBoolean();
        this.query = (QueryBuilder)in.readNamedWriteable(QueryBuilder.class);
        this.innerHitBuilder = (InnerHitBuilder)in.readOptionalWriteable(InnerHitBuilder::new);
        this.ignoreUnmapped = in.readBoolean();
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.type);
        out.writeBoolean(this.score);
        out.writeNamedWriteable((NamedWriteable)this.query);
        if (out.getVersion().before(Version.V_5_5_0)) {
            boolean hasInnerHit = this.innerHitBuilder != null;
            out.writeBoolean(hasInnerHit);
            if (hasInnerHit) {
                this.innerHitBuilder.writeToParentChildBWC(out, this.query, this.type);
            }
        } else {
            out.writeOptionalWriteable((Writeable)this.innerHitBuilder);
        }
        out.writeBoolean(this.ignoreUnmapped);
    }

    public QueryBuilder query() {
        return this.query;
    }

    public boolean score() {
        return this.score;
    }

    public String type() {
        return this.type;
    }

    public InnerHitBuilder innerHit() {
        return this.innerHitBuilder;
    }

    public HasParentQueryBuilder innerHit(InnerHitBuilder innerHit) {
        this.innerHitBuilder = innerHit;
        return this;
    }

    public HasParentQueryBuilder ignoreUnmapped(boolean ignoreUnmapped) {
        this.ignoreUnmapped = ignoreUnmapped;
        return this;
    }

    public boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Query doToQuery(QueryShardContext context) throws IOException {
        Query childrenQuery;
        Query innerQuery;
        String[] previousTypes = context.getTypes();
        context.setTypes(new String[]{this.type});
        try {
            innerQuery = this.query.toQuery(context);
        }
        finally {
            context.setTypes(previousTypes);
        }
        DocumentMapper parentDocMapper = context.documentMapper(this.type);
        if (parentDocMapper == null) {
            if (this.ignoreUnmapped) {
                return new MatchNoDocsQuery();
            }
            throw new QueryShardException(context, "[has_parent] query configured 'parent_type' [" + this.type + "] is not a valid type", new Object[0]);
        }
        HashSet<String> childTypes = new HashSet<String>();
        for (DocumentMapper documentMapper : context.getMapperService().docMappers(false)) {
            ParentFieldMapper parentFieldMapper = documentMapper.parentFieldMapper();
            if (!parentFieldMapper.active() || !this.type.equals(parentFieldMapper.type())) continue;
            childTypes.add(documentMapper.type());
        }
        if (childTypes.isEmpty()) {
            throw new QueryShardException(context, "[has_parent] no child types found for type [" + this.type + "]", new Object[0]);
        }
        if (childTypes.size() == 1) {
            DocumentMapper documentMapper;
            documentMapper = context.getMapperService().documentMapper((String)childTypes.iterator().next());
            childrenQuery = documentMapper.typeFilter(context);
        } else {
            BooleanQuery.Builder childrenFilter = new BooleanQuery.Builder();
            for (String childrenTypeStr : childTypes) {
                DocumentMapper documentMapper = context.getMapperService().documentMapper(childrenTypeStr);
                childrenFilter.add(documentMapper.typeFilter(context), BooleanClause.Occur.SHOULD);
            }
            childrenQuery = childrenFilter.build();
        }
        innerQuery = Queries.filtered((Query)innerQuery, (Query)parentDocMapper.typeFilter(context));
        MappedFieldType parentType = parentDocMapper.parentFieldMapper().getParentJoinFieldType();
        SortedSetDVOrdinalsIndexFieldData fieldData = (SortedSetDVOrdinalsIndexFieldData)context.getForField(parentType);
        return new HasChildQueryBuilder.LateParsingQuery(childrenQuery, innerQuery, 0, Integer.MAX_VALUE, this.type, this.score ? ScoreMode.Max : ScoreMode.None, fieldData, context.getSearchSimilarity());
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(QUERY_FIELD.getPreferredName());
        this.query.toXContent(builder, params);
        builder.field(TYPE_FIELD.getPreferredName(), this.type);
        builder.field(SCORE_FIELD.getPreferredName(), this.score);
        builder.field(IGNORE_UNMAPPED_FIELD.getPreferredName(), this.ignoreUnmapped);
        this.printBoostAndQueryName(builder);
        if (this.innerHitBuilder != null) {
            builder.field(INNER_HITS_FIELD.getPreferredName(), (ToXContent)this.innerHitBuilder, params);
        }
        builder.endObject();
    }

    public static Optional<HasParentQueryBuilder> fromXContent(QueryParseContext parseContext) throws IOException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        float boost = 1.0f;
        String parentType = null;
        boolean score = false;
        String queryName = null;
        InnerHitBuilder innerHits = null;
        boolean ignoreUnmapped = false;
        String currentFieldName = null;
        Optional iqb = Optional.empty();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (QUERY_FIELD.match(currentFieldName)) {
                    iqb = parseContext.parseInnerQueryBuilder();
                    continue;
                }
                if (INNER_HITS_FIELD.match(currentFieldName)) {
                    innerHits = InnerHitBuilder.fromXContent((QueryParseContext)parseContext);
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[has_parent] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (!token.isValue()) continue;
            if (TYPE_FIELD.match(currentFieldName)) {
                parentType = parser.text();
                continue;
            }
            if (SCORE_MODE_FIELD.match(currentFieldName)) {
                String scoreModeValue = parser.text();
                if ("score".equals(scoreModeValue)) {
                    score = true;
                    continue;
                }
                if ("none".equals(scoreModeValue)) {
                    score = false;
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[has_parent] query does not support [" + scoreModeValue + "] as an option for score_mode", new Object[0]);
            }
            if (SCORE_FIELD.match(currentFieldName)) {
                score = parser.booleanValue();
                continue;
            }
            if (IGNORE_UNMAPPED_FIELD.match(currentFieldName)) {
                ignoreUnmapped = parser.booleanValue();
                continue;
            }
            if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName)) {
                queryName = parser.text();
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "[has_parent] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (!iqb.isPresent()) {
            return Optional.empty();
        }
        HasParentQueryBuilder queryBuilder = (HasParentQueryBuilder)((HasParentQueryBuilder)new HasParentQueryBuilder(parentType, (QueryBuilder)iqb.get(), score).ignoreUnmapped(ignoreUnmapped).queryName(queryName)).boost(boost);
        if (innerHits != null) {
            queryBuilder.innerHit(innerHits);
        }
        return Optional.of(queryBuilder);
    }

    public String getWriteableName() {
        return NAME;
    }

    protected boolean doEquals(HasParentQueryBuilder that) {
        return Objects.equals(this.query, that.query) && Objects.equals(this.type, that.type) && Objects.equals(this.score, that.score) && Objects.equals(this.innerHitBuilder, that.innerHitBuilder) && Objects.equals(this.ignoreUnmapped, that.ignoreUnmapped);
    }

    protected int doHashCode() {
        return Objects.hash(this.query, this.type, this.score, this.innerHitBuilder, this.ignoreUnmapped);
    }

    protected QueryBuilder doRewrite(QueryRewriteContext queryShardContext) throws IOException {
        QueryBuilder rewrittenQuery = this.query.rewrite(queryShardContext);
        if (rewrittenQuery != this.query) {
            HasParentQueryBuilder hasParentQueryBuilder = new HasParentQueryBuilder(this.type, rewrittenQuery, this.score, this.innerHitBuilder);
            hasParentQueryBuilder.ignoreUnmapped(this.ignoreUnmapped);
            return hasParentQueryBuilder;
        }
        return this;
    }

    protected void extractInnerHitBuilders(Map<String, InnerHitContextBuilder> innerHits) {
        if (this.innerHitBuilder != null) {
            HashMap<String, InnerHitContextBuilder> children = new HashMap<String, InnerHitContextBuilder>();
            InnerHitContextBuilder.extractInnerHits((QueryBuilder)this.query, children);
            String name = this.innerHitBuilder.getName() != null ? this.innerHitBuilder.getName() : this.type;
            ParentChildInnerHitContextBuilder innerHitContextBuilder = new ParentChildInnerHitContextBuilder(this.type, this.query, this.innerHitBuilder, children);
            innerHits.put(name, innerHitContextBuilder);
        }
    }

    static final class ParentChildInnerHitSubContext
    extends InnerHitsContext.InnerHitSubContext {
        private final MapperService mapperService;
        private final DocumentMapper documentMapper;

        ParentChildInnerHitSubContext(String name, SearchContext context, MapperService mapperService, DocumentMapper documentMapper) {
            super(name, context);
            this.mapperService = mapperService;
            this.documentMapper = documentMapper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TopDocs[] topDocs(SearchHit[] hits) throws IOException {
            Weight innerHitQueryWeight = this.createInnerHitQueryWeight();
            TopDocs[] result = new TopDocs[hits.length];
            for (int i = 0; i < hits.length; ++i) {
                Object hitQuery;
                SearchHit hit = hits[i];
                if (this.isParentHit(hit)) {
                    String field = ParentFieldMapper.joinField((String)hit.getType());
                    hitQuery = new DocValuesTermsQuery(field, new String[]{hit.getId()});
                } else if (this.isChildHit(hit)) {
                    DocumentMapper hitDocumentMapper = this.mapperService.documentMapper(hit.getType());
                    String parentType = hitDocumentMapper.parentFieldMapper().type();
                    SearchHitField parentField = hit.field("_parent");
                    if (parentField == null) {
                        throw new IllegalStateException("All children must have a _parent");
                    }
                    Term uidTerm = this.context.mapperService().createUidTerm(parentType, (String)parentField.getValue());
                    hitQuery = uidTerm == null ? new MatchNoDocsQuery("Missing type: " + parentType) : new TermQuery(uidTerm);
                } else {
                    result[i] = Lucene.EMPTY_TOP_DOCS;
                    continue;
                }
                BooleanQuery q = new BooleanQuery.Builder().add((Query)hitQuery, BooleanClause.Occur.FILTER).add(this.documentMapper.typeFilter(this.context.getQueryShardContext()), BooleanClause.Occur.FILTER).build();
                Weight weight = this.context.searcher().createNormalizedWeight((Query)q, false);
                if (this.size() == 0) {
                    TotalHitCountCollector totalHitCountCollector = new TotalHitCountCollector();
                    for (LeafReaderContext ctx : this.context.searcher().getIndexReader().leaves()) {
                        InnerHitsContext.intersect((Weight)weight, (Weight)innerHitQueryWeight, (Collector)totalHitCountCollector, (LeafReaderContext)ctx);
                    }
                    result[i] = new TopDocs(totalHitCountCollector.getTotalHits(), Lucene.EMPTY_SCORE_DOCS, 0.0f);
                    continue;
                }
                int topN = Math.min(this.from() + this.size(), this.context.searcher().getIndexReader().maxDoc());
                Object topDocsCollector = this.sort() != null ? TopFieldCollector.create((Sort)this.sort().sort, (int)topN, (boolean)true, (boolean)this.trackScores(), (boolean)this.trackScores()) : TopScoreDocCollector.create((int)topN);
                try {
                    for (LeafReaderContext ctx : this.context.searcher().getIndexReader().leaves()) {
                        InnerHitsContext.intersect((Weight)weight, (Weight)innerHitQueryWeight, (Collector)topDocsCollector, (LeafReaderContext)ctx);
                    }
                }
                finally {
                    this.clearReleasables(SearchContext.Lifetime.COLLECTION);
                }
                result[i] = topDocsCollector.topDocs(this.from(), this.size());
            }
            return result;
        }

        private boolean isParentHit(SearchHit hit) {
            return hit.getType().equals(this.documentMapper.parentFieldMapper().type());
        }

        private boolean isChildHit(SearchHit hit) {
            DocumentMapper hitDocumentMapper = this.mapperService.documentMapper(hit.getType());
            return this.documentMapper.type().equals(hitDocumentMapper.parentFieldMapper().type());
        }
    }

    static class ParentChildInnerHitContextBuilder
    extends InnerHitContextBuilder {
        private final String typeName;

        ParentChildInnerHitContextBuilder(String typeName, QueryBuilder query, InnerHitBuilder innerHitBuilder, Map<String, InnerHitContextBuilder> children) {
            super(query, innerHitBuilder, children);
            this.typeName = typeName;
        }

        public void build(SearchContext parentSearchContext, InnerHitsContext innerHitsContext) throws IOException {
            QueryShardContext queryShardContext = parentSearchContext.getQueryShardContext();
            DocumentMapper documentMapper = queryShardContext.documentMapper(this.typeName);
            if (documentMapper == null) {
                if (!this.innerHitBuilder.isIgnoreUnmapped()) {
                    throw new IllegalStateException("[" + this.query.getName() + "] no mapping found for type [" + this.typeName + "]");
                }
                return;
            }
            String name = this.innerHitBuilder.getName() != null ? this.innerHitBuilder.getName() : documentMapper.type();
            ParentChildInnerHitSubContext parentChildInnerHits = new ParentChildInnerHitSubContext(name, parentSearchContext, queryShardContext.getMapperService(), documentMapper);
            this.setupInnerHitsContext(queryShardContext, parentChildInnerHits);
            innerHitsContext.addInnerHitDefinition((InnerHitsContext.InnerHitSubContext)parentChildInnerHits);
        }
    }
}

